/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.oauth.bamboo.MoOAuthPluginConfigurationsHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Base64;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoConfigurePlugin
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoConfigurePlugin.class);
    private MoOAuthSettings settings;
    private MoOAuthPluginConfigurationsHandler pluginConfigurationsHandler;
    private BambooUserManager bambooUserManager;
    private BambooPermissionManager bambooPermissionManager;

    public MoConfigurePlugin(MoOAuthSettings settings, MoOAuthPluginConfigurationsHandler pluginConfigurationsHandler, BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager) {
        this.settings = settings;
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public Boolean decodeAndCheckAdmin(HttpServletRequest request, HttpServletResponse response) {
        Enumeration headerNames = request.getHeaderNames();
        String key = "";
        String value = "";
        String username = "";
        String pwd = "";
        Boolean isAdmin = Boolean.FALSE;
        while (headerNames.hasMoreElements()) {
            try {
                key = (String)headerNames.nextElement();
                if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
                value = request.getHeader(key);
                value = value.split(" ")[1];
                byte[] valueDecoded = Base64.getDecoder().decode(value);
                value = new String(valueDecoded);
                String[] arr = value.split(":");
                username = arr[0];
                pwd = arr[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error((Object)"Something went wrong while fetching username and password.");
                e.printStackTrace();
            }
        }
        BambooUser bambooUser = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username}) || StringUtils.isNotEmpty((CharSequence)username)) {
            bambooUser = this.bambooUserManager.getBambooUser(username);
        }
        if (bambooUser != null) {
            LOGGER.debug((Object)("User exist with username : " + username));
            if (BooleanUtils.toBoolean((Boolean)this.bambooUserManager.authenticate(bambooUser.getUser().getName(), pwd))) {
                isAdmin = this.bambooPermissionManager.isAdmin(username) || this.bambooPermissionManager.isSystemAdmin(username);
            } else {
                this.showErrorMessage(response, "Basic Authentication Failed", "Authentication with the provided credentials failed. It may indicate that the user does not exist or the user's account is inactive or the credentials are incorrect");
                isAdmin = Boolean.FALSE;
            }
        }
        return isAdmin;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block5: {
            LOGGER.info((Object)"Configure Plugin servlet called from doGet");
            Boolean isAdmin = this.decodeAndCheckAdmin(request, response);
            if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
                try {
                    if (this.settings.isLicenseValid().booleanValue()) {
                        String jsonConfigurations = this.pluginConfigurationsHandler.generateConfigurationsJson();
                        response.setHeader("Cache-Control", "max-age=0");
                        response.setHeader("Pragma", "");
                        response.setContentType("application/json");
                        response.getOutputStream().write(jsonConfigurations.getBytes());
                        break block5;
                    }
                    this.showErrorMessage(response, "Your License has expired", "Please renew the license to use the API Call.");
                }
                catch (JSONException e) {
                    LOGGER.error((Object)("An error occurred while fetching the json." + e.getMessage()));
                }
            } else {
                this.showErrorMessage(response, "Access Denied", "App Configurations can be accessed only by administrators.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block19: {
            LOGGER.info((Object)"Configure Plugin servlet called from doPost");
            Boolean isAdmin = this.decodeAndCheckAdmin(request, response);
            if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
                StringBuffer sb = new StringBuffer();
                try (BufferedReader bufferedReader = null;){
                    int bytesRead;
                    bufferedReader = request.getReader();
                    char[] charBuffer = new char[128];
                    while ((bytesRead = bufferedReader.read(charBuffer)) != -1) {
                        sb.append(charBuffer, 0, bytesRead);
                    }
                }
                try {
                    if (this.settings.isLicenseValid().booleanValue()) {
                        this.settings.clearPluginSettings();
                        this.pluginConfigurationsHandler.importPluginConfigurations(sb.toString());
                        this.showSuccessMessage(response, "OAuth settings updated", "OAuth App Configured successfully.");
                        break block19;
                    }
                    this.showErrorMessage(response, "Your License has expired", " Please renew the license to use the API Call.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.showErrorMessage(response, "Access Denied", "App Configurations can be accessed only by administrators.");
            }
        }
    }

    private void showErrorMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(401);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showSuccessMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

