/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoOAuthImportExportAction
extends BambooActionSupport {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthImportExportAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoOAuthSettings settings;
    public Boolean isApplicationConfigured;
    private Boolean importFileSubmitted;
    private String xsrfToken;

    public MoOAuthImportExportAction(UserManager userManager, LoginUriProvider loginUriProvider, MoOAuthSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.isApplicationConfigured = settings.getClientID() == "" ? Boolean.valueOf(false) : Boolean.valueOf(true);
    }

    public Boolean doValidate() {
        LOGGER.info((Object)"MoOAuthImportExportAction: doValidate() called");
        return true;
    }

    public String execute() throws Exception {
        LOGGER.info((Object)"MoOAuthImportExportAction execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                String message = "";
                if (!this.settings.isLicenseValid().booleanValue()) {
                    LOGGER.error((Object)"Invalid License");
                    return "upm";
                }
                if (MoOAuthSettings.isPluginConfigurationFileUploaded.booleanValue()) {
                    MoOAuthSettings.isPluginConfigurationFileUploaded = Boolean.FALSE;
                    if (StringUtils.isNotBlank((CharSequence)this.settings.getConfigurationStatus())) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getConfigurationStatus(), (CharSequence)"success")) {
                            this.addActionMessage(this.getText("oauth.success.config"));
                        } else {
                            this.addActionError(this.settings.getConfigurationStatus());
                        }
                    }
                }
                return "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public Boolean getImportFileSubmitted() {
        return this.importFileSubmitted;
    }

    public void setImportFileSubmitted(Boolean importFileSubmitted) {
        this.importFileSubmitted = importFileSubmitted;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }
}

