/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoOAuthGroupMappingAction
extends BambooActionSupport {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthGroupMappingAction.class);
    private MoOAuthSettings settings;
    private PluginLicenseManager pluginLicenseManager;
    private String defaultGroup;
    private ArrayList<String> existingGroups;
    private Boolean roleMappingSubmitted;
    private String roleAttribute;
    private HashMap<String, String> roleMapping;
    private Boolean createUsersIfRoleMapped;
    private Boolean restrictUserCreation;
    private Boolean keepExistingUserRoles;
    private String xsrfToken;
    private String[] defaultGroups;
    private List<String> defaultGroupsList;
    private String enableDefaultGroupsFor;
    private Boolean assignDirectoryDefaultGroups;
    private Boolean onTheFlyGroupCreation;
    private String[] onTheFlyDoNotRemoveGroups;
    private List<String> onTheFlyDoNotRemoveGroupsList;
    private Boolean onTheFlyAssignNewGroupsOnly;
    private Boolean onTheFlyCreateNewGroups;
    private String lowerBuild;
    private String onTheFlyFilterIDPGroupsOption;
    private String onTheFlyFilterIDPGroupsKey;
    private Boolean groupRegexPatternEnabled = false;
    private String regexPatternForGroup;
    private String regexGroups;
    private String testRegex;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private BambooUserManager bambooUserManager;
    private String regexPatternForExcludeGroups;
    private Boolean excludeGroupsRegexPattern;

    public MoOAuthGroupMappingAction(MoOAuthSettings settings, PluginLicenseManager pluginLicenseManager, UserManager userManager, LoginUriProvider loginUriProvider, BambooUserManager bambooUserManager) {
        this.settings = settings;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.bambooUserManager = bambooUserManager;
    }

    public void validate() {
        LOGGER.info((Object)"Role Mapping Configuration Action validate called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.roleMappingSubmitted)) {
            return;
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeOAuthConfig();
        }
        super.validate();
    }

    public Boolean doValidate() {
        LOGGER.info((Object)"Role Mapping Configuration Action doValidate called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        Boolean isError = Boolean.FALSE;
        if (!BooleanUtils.toBoolean((Boolean)this.roleMappingSubmitted)) {
            return isError;
        }
        List<Object> defaultGroupsList = new ArrayList();
        if (this.defaultGroups != null) {
            defaultGroupsList = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild) ? new ArrayList<String>(Arrays.asList(this.defaultGroups)) : Arrays.asList(StringUtils.split((String)this.defaultGroups[0], (String)","));
            defaultGroupsList.removeAll(Arrays.asList(null, ""));
        }
        if (this.defaultGroup == null && defaultGroupsList.size() == 0) {
            LOGGER.error((Object)"Default group is blank. Please select atleast one default group.");
            this.addActionError("Please select atleast one default group.");
            isError = Boolean.TRUE;
        }
        if (this.onTheFlyGroupCreation.booleanValue() && StringUtils.isBlank((CharSequence)this.roleAttribute)) {
            LOGGER.error((Object)"Group Attribute can't be blank when On The Fly Group Mapping is enabled.");
            this.addActionError("Group Attribute is Required if On the Fly Group Mapping is enabled.");
            isError = Boolean.TRUE;
        }
        if (BooleanUtils.toBoolean((Boolean)this.groupRegexPatternEnabled)) {
            if (StringUtils.isBlank((CharSequence)this.regexPatternForGroup) || StringUtils.isBlank((CharSequence)this.regexGroups)) {
                isError = Boolean.TRUE;
                LOGGER.error((Object)"Regex Pattern is cannot be left blank.");
                this.addActionError("Regex Pattern cannot not be left empty.");
            } else if (!this.isRegexValid(this.regexPatternForGroup).booleanValue()) {
                LOGGER.error((Object)"Regex value for group regex is invalid.");
                this.addActionError("Regex Pattern is invalid");
                isError = Boolean.TRUE;
            }
        }
        if (StringUtils.equals((CharSequence)this.onTheFlyFilterIDPGroupsOption, (CharSequence)"Regex")) {
            if (StringUtils.isBlank((CharSequence)this.onTheFlyFilterIDPGroupsKey)) {
                isError = Boolean.TRUE;
                LOGGER.error((Object)"Regex Pattern is cannot be left blank.");
                this.addActionError("Regex Pattern cannot not be left empty.");
            } else if (!this.isRegexValid(this.onTheFlyFilterIDPGroupsKey).booleanValue()) {
                LOGGER.error((Object)"Regex value for group filtering is invalid.");
                this.addActionError("Invalid regex pattern.");
                isError = Boolean.TRUE;
            }
        }
        if (!StringUtils.equals((CharSequence)this.onTheFlyFilterIDPGroupsOption, (CharSequence)"None") && StringUtils.isBlank((CharSequence)this.onTheFlyFilterIDPGroupsKey)) {
            this.onTheFlyFilterIDPGroupsOption = "None";
        }
        if (BooleanUtils.toBoolean((Boolean)this.excludeGroupsRegexPattern)) {
            LOGGER.debug((Object)"validating Exclude group regex pattern");
            if (StringUtils.isBlank((CharSequence)this.regexPatternForExcludeGroups)) {
                isError = Boolean.TRUE;
                LOGGER.error((Object)"Regex Pattern is cannot be left blank.");
                this.addActionError("Regex Pattern cannot not be left empty.");
            } else {
                try {
                    Pattern.compile(this.regexPatternForExcludeGroups, 2);
                }
                catch (PatternSyntaxException e) {
                    isError = Boolean.TRUE;
                    LOGGER.error((Object)"Invalid regex pattern.");
                    this.addActionError("Invalid regex pattern.");
                }
            }
        }
        if (BooleanUtils.toBoolean((Boolean)isError)) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeOAuthConfig();
        }
        return isError;
    }

    public String execute() throws Exception {
        LOGGER.info((Object)"Role Mapping Configuration Action doExecute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.lowerBuild = this.getLowerBuild();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug((Object)("roleMappingSubmitted : " + this.roleMappingSubmitted));
                if (!this.settings.isLicenseValid().booleanValue()) {
                    try {
                        response.sendRedirect(this.settings.getManageAddOnURL());
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                if (this.roleMappingSubmitted != null && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
                    HashMap<String, String> roleMapping = new HashMap<String, String>();
                    int totalNumberOfRoles = Integer.parseInt(request.getParameter("totalNumberOfRoles"));
                    for (int i = 0; i < totalNumberOfRoles; ++i) {
                        String key = StringUtils.trimToEmpty((String)request.getParameter("userGroupKey_" + i));
                        String value = StringUtils.trimToEmpty((String)request.getParameter("userGroupValue_" + i));
                        if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value) || StringUtils.equalsIgnoreCase((CharSequence)"select-group-to-map", (CharSequence)key) || BooleanUtils.toBoolean((Boolean)roleMapping.containsKey(key))) continue;
                        roleMapping.put(key.trim(), value.trim());
                    }
                    List<Object> defaultGroupsList = new ArrayList<String>();
                    if (this.defaultGroup != null) {
                        defaultGroupsList.add(this.defaultGroup);
                    }
                    if (this.defaultGroups != null) {
                        defaultGroupsList = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild) ? new ArrayList<String>(Arrays.asList(this.defaultGroups)) : Arrays.asList(StringUtils.split((String)this.defaultGroups[0], (String)","));
                        defaultGroupsList.removeAll(Arrays.asList(null, ""));
                    }
                    if (this.onTheFlyDoNotRemoveGroups != null) {
                        this.onTheFlyDoNotRemoveGroupsList = StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild) ? new ArrayList<String>(Arrays.asList(this.onTheFlyDoNotRemoveGroups)) : Arrays.asList(StringUtils.split((String)this.onTheFlyDoNotRemoveGroups[0], (String)","));
                        this.onTheFlyDoNotRemoveGroupsList.removeAll(Arrays.asList(null, ""));
                    }
                    MoOAuthPluginHandler.saveRoleMapping(this.roleAttribute, this.createUsersIfRoleMapped, this.keepExistingUserRoles, roleMapping, this.defaultGroup, defaultGroupsList, this.restrictUserCreation, this.enableDefaultGroupsFor, this.assignDirectoryDefaultGroups, this.onTheFlyGroupCreation, this.onTheFlyDoNotRemoveGroupsList, this.onTheFlyAssignNewGroupsOnly, this.onTheFlyCreateNewGroups, this.onTheFlyFilterIDPGroupsOption, this.onTheFlyFilterIDPGroupsKey, this.groupRegexPatternEnabled, this.regexPatternForGroup, this.regexGroups, this.testRegex, this.excludeGroupsRegexPattern, StringUtils.trimToEmpty((String)this.regexPatternForExcludeGroups));
                    LOGGER.info((Object)"roleMapping saved");
                    this.addActionMessage(this.getText("oauth.success.config"));
                }
                this.initializeOAuthConfig();
                return "success";
            }
            catch (MoOAuthPluginException e) {
                e.printStackTrace();
                LOGGER.error((Object)("error is : " + e));
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error((Object)("error is : " + e));
                this.addActionError("An error occurred.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(MoOAuthPluginHandler.getUri(request)).toASCIIString());
        return null;
    }

    public ArrayList<String> getExistingGroups() {
        try {
            Pager groupObjects = this.bambooUserManager.getGroups();
            this.existingGroups = new ArrayList();
            for (Group group : groupObjects) {
                this.existingGroups.add(group.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.existingGroups;
    }

    private void initializeOAuthConfig() {
        LOGGER.info((Object)"initialize OAuth Config called");
        this.defaultGroup = this.settings.getDefaultGroup();
        this.keepExistingUserRoles = this.settings.getKeepExistingUserRoles();
        this.roleMapping = this.settings.getRoleMapping();
        this.roleAttribute = this.settings.getRoleAttribute();
        this.createUsersIfRoleMapped = this.settings.getCreateUsersIfRoleMapped();
        this.restrictUserCreation = this.settings.getRestrictUserCreation();
        this.defaultGroupsList = this.settings.getDefaultGroupsList();
        this.enableDefaultGroupsFor = this.settings.getEnableDefaultGroupsFor();
        this.assignDirectoryDefaultGroups = this.settings.getAssignDirectoryDefaultGroups();
        this.onTheFlyGroupCreation = this.settings.getOnTheFlyGroupMapping();
        this.onTheFlyDoNotRemoveGroupsList = (List)this.settings.getOnTheFlyDoNotRemoveGroups();
        this.onTheFlyAssignNewGroupsOnly = this.settings.getOnTheFlyAssignNewGroupsOnly();
        this.onTheFlyCreateNewGroups = this.settings.getOnTheFlyCreateNewGroups();
        this.lowerBuild = this.getLowerBuild();
        this.onTheFlyFilterIDPGroupsOption = this.settings.getOnTheFlyFilterIDPGroupsOption();
        this.onTheFlyFilterIDPGroupsKey = this.settings.getOnTheFlyFilterIDPGroupsKey();
        this.groupRegexPatternEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)this.settings.getGroupRegexPatternEnabled(), (boolean)false);
        this.regexPatternForGroup = (String)StringUtils.defaultIfBlank((CharSequence)this.settings.getRegexPatternForGroup(), (CharSequence)"");
        this.regexGroups = StringUtils.defaultString((String)this.settings.getRegexGroups(), (String)"");
        this.testRegex = (String)StringUtils.defaultIfBlank((CharSequence)this.settings.getTestRegex(), (CharSequence)"");
        this.excludeGroupsRegexPattern = this.settings.getExcludeGroupsRegexPattern();
        this.regexPatternForExcludeGroups = (String)StringUtils.defaultIfBlank((CharSequence)this.settings.getRegexPatternForExcludeGroups(), (CharSequence)"");
    }

    private Boolean isRegexValid(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean getAssignDirectoryDefaultGroups() {
        return this.assignDirectoryDefaultGroups;
    }

    public void setAssignDirectoryDefaultGroups(Boolean assignDirectoryDefaultGroups) {
        this.assignDirectoryDefaultGroups = assignDirectoryDefaultGroups;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public void setExistingGroups(ArrayList existingGroups) {
        this.existingGroups = existingGroups;
    }

    public Boolean getRoleMappingSubmitted() {
        return this.roleMappingSubmitted;
    }

    public void setRoleMappingSubmitted(Boolean roleMappingSubmitted) {
        this.roleMappingSubmitted = roleMappingSubmitted;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public void setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
    }

    public String getOnTheFlyFilterIDPGroupsOption() {
        return this.onTheFlyFilterIDPGroupsOption;
    }

    public void setOnTheFlyFilterIDPGroupsOption(String onTheFlyFilterIDPGroupsOption) {
        this.onTheFlyFilterIDPGroupsOption = onTheFlyFilterIDPGroupsOption;
    }

    public String getOnTheFlyFilterIDPGroupsKey() {
        return this.onTheFlyFilterIDPGroupsKey;
    }

    public void setOnTheFlyFilterIDPGroupsKey(String onTheFlyFilterIDPGroupsKey) {
        this.onTheFlyFilterIDPGroupsKey = onTheFlyFilterIDPGroupsKey;
    }

    public List<String> getGroupFilterOptionsList() {
        ArrayList<String> filteredGroups = new ArrayList<String>();
        filteredGroups.add("None");
        filteredGroups.add("Starts with");
        filteredGroups.add("Contains");
        filteredGroups.add("Regex");
        return filteredGroups;
    }

    public String[] getDefaultGroups() {
        return this.defaultGroups;
    }

    public void setDefaultGroups(String[] defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public List<String> getDefaultGroupsList() {
        return this.defaultGroupsList;
    }

    public void setDefaultGroupsList(List<String> defaultGroupsList) {
        this.defaultGroupsList = defaultGroupsList;
    }

    public String getEnableDefaultGroupsFor() {
        return this.enableDefaultGroupsFor;
    }

    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.enableDefaultGroupsFor = enableDefaultGroupsFor;
    }

    public Boolean getOnTheFlyGroupCreation() {
        return this.onTheFlyGroupCreation;
    }

    public void setOnTheFlyGroupCreation(Boolean onTheFlyGroupCreation) {
        this.onTheFlyGroupCreation = onTheFlyGroupCreation;
    }

    public String[] getOnTheFlyDoNotRemoveGroups() {
        return this.onTheFlyDoNotRemoveGroups;
    }

    public void setOnTheFlyDoNotRemoveGroups(String[] onTheFlyDoNotRemoveGroups) {
        this.onTheFlyDoNotRemoveGroups = onTheFlyDoNotRemoveGroups;
    }

    public List<String> getOnTheFlyDoNotRemoveGroupsList() {
        return this.onTheFlyDoNotRemoveGroupsList;
    }

    public void setOnTheFlyDoNotRemoveGroupsList(List<String> onTheFlyDoNotRemoveGroupsList) {
        this.onTheFlyDoNotRemoveGroupsList = onTheFlyDoNotRemoveGroupsList;
    }

    public Boolean getOnTheFlyAssignNewGroupsOnly() {
        return this.onTheFlyAssignNewGroupsOnly;
    }

    public void setOnTheFlyAssignNewGroupsOnly(Boolean onTheFlyAssignNewGroupsOnly) {
        this.onTheFlyAssignNewGroupsOnly = onTheFlyAssignNewGroupsOnly;
    }

    public Boolean getOnTheFlyCreateNewGroups() {
        return this.onTheFlyCreateNewGroups;
    }

    public void setOnTheFlyCreateNewGroups(Boolean onTheFlyCreateNewGroups) {
        this.onTheFlyCreateNewGroups = onTheFlyCreateNewGroups;
    }

    public HashMap<String, String> getRoleMapping() {
        return this.roleMapping;
    }

    public void setRoleMapping(HashMap<String, String> roleMapping) {
        this.roleMapping = roleMapping;
    }

    public Boolean getCreateUsersIfRoleMapped() {
        return this.createUsersIfRoleMapped;
    }

    public void setCreateUsersIfRoleMapped(Boolean createUsersIfRoleMapped) {
        this.createUsersIfRoleMapped = createUsersIfRoleMapped;
    }

    public Boolean getKeepExistingUserRoles() {
        return this.keepExistingUserRoles;
    }

    public void setKeepExistingUserRoles(Boolean keepExistingUserRoles) {
        this.keepExistingUserRoles = keepExistingUserRoles;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getRestrictUserCreation() {
        return this.restrictUserCreation;
    }

    public void setRestrictUserCreation(Boolean restrictUserCreation) {
        this.restrictUserCreation = restrictUserCreation;
    }

    public String getLowerBuild() {
        this.lowerBuild = Boolean.toString(this.settings.isLowerBuild());
        return this.lowerBuild;
    }

    public void setLowerBuild(String lowerBuild) {
        this.lowerBuild = lowerBuild;
    }

    public Boolean getGroupRegexPatternEnabled() {
        return this.groupRegexPatternEnabled;
    }

    public void setGroupRegexPatternEnabled(Boolean groupRegexPatternEnabled) {
        this.groupRegexPatternEnabled = groupRegexPatternEnabled;
    }

    public String getRegexPatternForGroup() {
        return this.regexPatternForGroup;
    }

    public void setRegexPatternForGroup(String regexPatternForGroup) {
        this.regexPatternForGroup = regexPatternForGroup;
    }

    public String getRegexGroups() {
        return this.regexGroups;
    }

    public void setRegexGroups(String regexGroups) {
        this.regexGroups = regexGroups;
    }

    public String getTestRegex() {
        return this.testRegex;
    }

    public void setTestRegex(String testRegex) {
        this.testRegex = testRegex;
    }

    public Boolean getExcludeGroupsRegexPattern() {
        return this.excludeGroupsRegexPattern;
    }

    public void setExcludeGroupsRegexPattern(Boolean excludeGroupsRegexPattern) {
        this.excludeGroupsRegexPattern = excludeGroupsRegexPattern;
    }

    public String getRegexPatternForExcludeGroups() {
        return this.regexPatternForExcludeGroups;
    }

    public void setRegexPatternForExcludeGroups(String regexPatternForExcludeGroups) {
        this.regexPatternForExcludeGroups = regexPatternForExcludeGroups;
    }
}

