/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;

public class MoOAuthUtils {
    private static Log LOGGER = LogFactory.getLog(MoOAuthUtils.class);
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    public boolean checkIfKeyExist(HashMap<String, String> userInfoMap, String keyName) {
        String value = userInfoMap.get(keyName);
        return value != null;
    }

    public String getValue(HashMap<String, String> userInfoMap, String keyName) {
        LOGGER.debug((Object)"Taking Value");
        return userInfoMap.get(keyName);
    }

    public Map<String, JsonElement> jsonToMap(JsonObject getGroupUserInfoResponse) {
        Set<Map.Entry<String, JsonElement>> keys = getGroupUserInfoResponse.entrySet();
        HashMap<String, JsonElement> map = new HashMap<String, JsonElement>();
        for (Map.Entry<String, JsonElement> entry : keys) {
            String key = entry.getKey();
            if (getGroupUserInfoResponse.get(key).isJsonObject()) {
                this.jsonToMap(getGroupUserInfoResponse.get(key).getAsJsonObject());
                continue;
            }
            map.put(key, getGroupUserInfoResponse.get(key));
        }
        return map;
    }

    public HashMap<String, Object> toMap(JsonObject object, HashMap<String, Object> map) {
        Set<Map.Entry<String, JsonElement>> keysItr = object.entrySet();
        for (Map.Entry<String, JsonElement> entry : keysItr) {
            Object valueToPutInMap;
            String key = entry.getKey();
            JsonElement value = object.get(key);
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
                continue;
            }
            if (value.isJsonObject()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
                continue;
            }
            if (value.isJsonNull()) continue;
            valueToPutInMap = value.getAsString();
            map.put(key, valueToPutInMap);
        }
        return map;
    }

    public Map<String, Object> toMap(JsonObject object, Map<String, Object> map) {
        Set<Map.Entry<String, JsonElement>> keysItr = object.entrySet();
        for (Map.Entry<String, JsonElement> entry : keysItr) {
            Object valueToPutInMap;
            String key = entry.getKey();
            JsonElement value = object.get(key);
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
                continue;
            }
            if (value.isJsonObject()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
                continue;
            }
            if (value.isJsonNull()) continue;
            valueToPutInMap = value.getAsString();
            map.put(key, valueToPutInMap);
        }
        return map;
    }

    public List<Object> toList(JsonArray array, HashMap<String, Object> map) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement value = array.get(i);
            Object valueToPutInMap = value;
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
            } else if (value.isJsonObject()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
            }
            if (value.isJsonNull()) continue;
            valueToPutInMap = value.getAsString();
            list.add(valueToPutInMap);
        }
        return list;
    }

    public List<Object> toList(JsonArray array, Map<String, Object> map) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement value = array.get(i);
            Object valueToPutInMap = value;
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
            } else if (value.isJsonObject()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
            }
            if (value.isJsonNull()) continue;
            valueToPutInMap = value.getAsString();
            list.add(valueToPutInMap);
        }
        return list;
    }

    public HashMap<String, String> copyToStringValueMap(HashMap<String, Object> input) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String currValue = "";
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            if (entry.getValue() == null) continue;
            currValue = (String)entry.getValue();
            ret.put(entry.getKey(), currValue);
        }
        return ret;
    }

    public Map<String, String> copyToStringValueMap(Map<String, Object> input) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            ret.put(entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    public String findKey(JsonObject getUserInfoData, String key, String appName) {
        try {
            Set<Map.Entry<String, JsonElement>> x = getUserInfoData.entrySet();
            String multipleValues = "";
            LOGGER.debug((Object)("Fetching Value for Attribute: " + key));
            for (Map.Entry<String, JsonElement> keySet : x) {
                String value;
                String currentKey = keySet.getKey();
                if (getUserInfoData.get(currentKey).isJsonObject() && getUserInfoData != null && !StringUtils.equals((CharSequence)key, (CharSequence)"id")) {
                    LOGGER.debug((Object)("JSONObject: " + getUserInfoData.getAsJsonObject(currentKey)));
                    value = this.findKey(getUserInfoData.getAsJsonObject(currentKey), key, appName);
                    if (value == null) continue;
                    return value;
                }
                if (getUserInfoData.get(currentKey).isJsonArray() && getUserInfoData != null && !StringUtils.equals((CharSequence)key, (CharSequence)"id")) {
                    LOGGER.debug((Object)("JSONArray found.. " + getUserInfoData.getAsJsonArray(currentKey)));
                    JsonArray array = getUserInfoData.getAsJsonArray(currentKey);
                    LOGGER.debug((Object)("Size of this array: " + array.size()));
                    if (StringUtils.equals((CharSequence)appName, (CharSequence)"Meetup")) continue;
                    for (int index = 0; index < array.size(); ++index) {
                        JsonObject object = getUserInfoData.getAsJsonArray(currentKey).get(index).getAsJsonObject();
                        LOGGER.debug((Object)("JSONObject at index " + index + " : " + object));
                        if (index > 0) {
                            multipleValues = multipleValues.concat(";");
                        }
                        if (!object.has(key)) continue;
                        LOGGER.debug((Object)("Found the key: " + key));
                        LOGGER.debug((Object)("value: " + object.get(key).getAsString()));
                        multipleValues = multipleValues.concat(object.get(key).getAsString());
                    }
                    LOGGER.debug((Object)("Multiple Values: " + multipleValues));
                    return multipleValues;
                }
                if (!getUserInfoData.get(currentKey).isJsonPrimitive()) continue;
                value = getUserInfoData.get(currentKey).getAsString();
                if (!StringUtils.equals((CharSequence)currentKey, (CharSequence)key)) continue;
                LOGGER.debug((Object)("Key: " + key + " Value: " + value));
                return value;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An exception occurred while parsing Json", (Throwable)e);
            e.printStackTrace();
        }
        return "";
    }

    public Set<String> findEmails(HashMap<String, String> userInfoMap) {
        HashSet<String> emailSet = new HashSet<String>();
        HashMap<String, String> map = new HashMap<String, String>(userInfoMap);
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> pair = iterator.next();
            String value = pair.getValue();
            if (value != null && this.isEmailId(value)) {
                emailSet.add(value);
            }
            iterator.remove();
        }
        return emailSet;
    }

    public boolean isEmailId(String emailStr) {
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
        return matcher.find();
    }

    public static boolean isOpenIdProtocol(String appName) {
        LOGGER.debug((Object)("isOpenId: " + appName));
        return StringUtils.equals((CharSequence)appName, (CharSequence)"Custom OpenID") || StringUtils.equals((CharSequence)appName, (CharSequence)"AWS Cognito") || StringUtils.equals((CharSequence)appName, (CharSequence)"Keycloak") || StringUtils.equals((CharSequence)appName, (CharSequence)"ADFS") || StringUtils.equals((CharSequence)appName, (CharSequence)"Okta") || StringUtils.equals((CharSequence)appName, (CharSequence)"Azure B2C");
    }

    public HashMap<String, Object> toMapObjects(JsonObject object, HashMap<String, Object> map) throws JsonParseException {
        Set<Map.Entry<String, JsonElement>> keysItr = object.entrySet();
        for (Map.Entry<String, JsonElement> entry : keysItr) {
            String key = entry.getKey();
            JsonElement value = object.get(key);
            if (!value.isJsonNull()) {
                HashMap<String, Object> valueToPutInMap;
                if (value.isJsonArray()) {
                    valueToPutInMap = this.toMapList(value.getAsJsonArray(), key);
                    map.putAll(valueToPutInMap);
                    continue;
                }
                if (value.isJsonObject()) {
                    JsonObject obj = value.getAsJsonObject();
                    if (obj.isJsonNull()) {
                        map.put(key, null);
                        continue;
                    }
                    HashMap<String, Object> newMap = new HashMap<String, Object>();
                    valueToPutInMap = this.mapObjectsWithUpdatedKey(obj, newMap, key);
                    map.putAll(valueToPutInMap);
                    continue;
                }
                try {
                    map.put(key, value.getAsString());
                }
                catch (UnsupportedOperationException e) {
                    map.put(key, value.toString());
                }
                continue;
            }
            map.put(key, "");
        }
        return map;
    }

    public HashMap<String, Object> mapObjectsWithUpdatedKey(JsonObject object, HashMap<String, Object> map, String keyName) throws JsonParseException {
        Set<Map.Entry<String, JsonElement>> keysItr = object.entrySet();
        for (Map.Entry<String, JsonElement> entry : keysItr) {
            HashMap<String, Object> valueToPutInMap;
            String key = entry.getKey();
            JsonElement value = object.get(key);
            key = keyName + '.' + key;
            if (value.isJsonArray()) {
                valueToPutInMap = this.toMapList(value.getAsJsonArray(), key);
                map.putAll(valueToPutInMap);
                continue;
            }
            if (value.isJsonObject()) {
                JsonObject obj = value.getAsJsonObject();
                if (obj.isJsonNull()) {
                    map.put(key, null);
                    continue;
                }
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                valueToPutInMap = this.mapObjectsWithUpdatedKey(obj, newMap, key);
                map.putAll(valueToPutInMap);
                continue;
            }
            map.put(key, value.toString());
        }
        return map;
    }

    public HashMap<String, Object> toMapList(JsonArray array, String key) throws JsonParseException {
        HashMap<String, Object> completeMap = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        if (array.size() == 0) {
            completeMap.put(key, null);
        } else {
            for (int i = 0; i < array.size(); ++i) {
                HashMap<String, Object> valueToPutInMap;
                JsonElement value = array.get(i);
                if (value.isJsonArray()) {
                    valueToPutInMap = this.toMapList(value.getAsJsonArray(), key + '[' + i + ']');
                    completeMap.putAll(valueToPutInMap);
                    continue;
                }
                if (value.isJsonObject()) {
                    JsonObject obj = value.getAsJsonObject();
                    if (obj.isJsonNull()) {
                        completeMap.put(key + '[' + i + ']', null);
                        continue;
                    }
                    HashMap<String, Object> newMap = new HashMap<String, Object>();
                    valueToPutInMap = this.mapObjectsWithUpdatedKey(obj, newMap, key + '[' + i + ']');
                    completeMap.putAll(valueToPutInMap);
                    continue;
                }
                list.add(value.toString());
            }
            if (list.size() > 0) {
                String temp = (String)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    temp = temp + ";" + (String)list.get(i);
                }
                completeMap.put(key, temp);
            }
        }
        return completeMap;
    }

    public static String deserializePublicKey(String publicKey) {
        LOGGER.debug((Object)"Deserializing Public Key");
        String BEGIN_PUBLIC_KEY = "BEGIN PUBLIC KEY";
        String END_PUBLIC_KEY = "END PUBLIC KEY";
        if (StringUtils.isNotBlank((CharSequence)publicKey)) {
            publicKey = StringUtils.remove((String)publicKey, (String)"\r");
            publicKey = StringUtils.remove((String)publicKey, (String)"\n");
            publicKey = StringUtils.remove((String)publicKey, (String)"-");
            publicKey = StringUtils.remove((String)publicKey, (String)BEGIN_PUBLIC_KEY);
            publicKey = StringUtils.remove((String)publicKey, (String)END_PUBLIC_KEY);
            publicKey = StringUtils.remove((String)publicKey, (String)" ");
        }
        return publicKey;
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        LOGGER.debug((Object)("Text before sanitization: " + text));
        text = Jsoup.parse((String)text).text();
        LOGGER.debug((Object)("Text after sanitization: " + text));
        return text;
    }

    public static String sanitizeRegex(String regex) {
        LOGGER.debug((Object)("Original input : " + regex));
        String cleanRegex = StringEscapeUtils.escapeEcmaScript((String)regex);
        LOGGER.debug((Object)("Clean input : " + cleanRegex));
        return cleanRegex;
    }
}

