/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.google.gson.Gson;
import com.miniorange.oauth.MoOAuthConfigAjaxAttributes;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UnrestrictedAccess
public class MoOAuthGetConfigurationServlet
extends HttpServlet {
    private static final Gson gson = new Gson();
    private static final Log LOGGER = LogFactory.getLog(MoOAuthGetConfigurationServlet.class);
    private MoOAuthSettings settings;

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String referer = request.getHeader("referer");
            if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getBaseUrl())) {
                LOGGER.error((Object)"Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
                response.sendError(403, "Access Denied. You are not allowed to access this page.");
                return;
            }
            if (!this.settings.isEvaluationOrSubscriptionLicense().booleanValue() && this.settings.isLicenseDefine().booleanValue()) {
                Boolean isConfigured = StringUtils.isNotBlank((CharSequence)this.settings.getClientID());
                Boolean backdoorEnabled = this.settings.getBackdoorEnabled();
                Boolean disableDefaultLogin = this.settings.getDefaultLoginDisabled();
                Boolean enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
                String autoRedirectDelayInterval = this.settings.getAutoRedirectDelayInterval();
                String ssoButtonLocation = this.settings.getSsoButtonLocation();
                Boolean restrictBackdoor = this.settings.getRestrictBackdoor();
                Boolean enableLoginTemplate = this.settings.getEnableLoginTemplate();
                String loginTemplate = this.settings.getLoginTemplate();
                String backdoorKey = this.settings.getBackdoorKey();
                String backdoorValue = this.settings.getBackdoorValue();
                Boolean allowPasswordReset = this.settings.getAllowPasswordReset();
                Boolean enableForSoftware = this.settings.getEnableForSoftware();
                Boolean enableAutoLogin = this.settings.getEnableAutoLogin();
                Boolean isAutoAttemptSuppProvider = this.settings.getIsAutoAttemptSuppProvider(this.settings.getAppName());
                String autoLoginUrl = this.settings.getAutoLoginUrl();
                MoOAuthConfigAjaxAttributes attrs = new MoOAuthConfigAjaxAttributes(this.settings.getLoginButtonText(), isConfigured, backdoorEnabled, disableDefaultLogin, enableAutoRedirectDelay, autoRedirectDelayInterval, ssoButtonLocation, restrictBackdoor, enableLoginTemplate, loginTemplate, backdoorKey, backdoorValue, allowPasswordReset, enableForSoftware, enableAutoLogin, isAutoAttemptSuppProvider, autoLoginUrl);
                String attrsJSON = gson.toJson(attrs);
                response.setContentType("application/json");
                response.getOutputStream().write(attrsJSON.getBytes());
                response.getOutputStream().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }
}

