/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.miniorange.oauth.bamboo.MoOAuthPluginConfigurationsHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthDownloadConfigurationsServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoOAuthDownloadConfigurationsServlet.class);
    private MoOAuthPluginConfigurationsHandler MoOAuthPluginConfigurationsHandler;
    private MoOAuthSettings settings;

    public MoOAuthDownloadConfigurationsServlet(MoOAuthPluginConfigurationsHandler MoOAuthPluginConfigurationsHandler2, MoOAuthSettings settings) {
        this.MoOAuthPluginConfigurationsHandler = MoOAuthPluginConfigurationsHandler2;
        this.settings = settings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info((Object)"Download app configuration: doGet() called");
        String referer = request.getHeader("referer");
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getBaseUrl())) {
            LOGGER.error((Object)"Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
            response.sendError(403, "Access Denied. You are not allowed to access this page.");
            return;
        }
        try {
            String jsonConfigurations = this.MoOAuthPluginConfigurationsHandler.generateConfigurationsJson();
            LOGGER.info((Object)"Downloading json Configurations file.");
            response.setHeader("Content-Disposition", "attachment; filename=\"app_configurations.json\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("application/json");
            response.getOutputStream().write(jsonConfigurations.getBytes());
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            e.printStackTrace();
            PrintWriter writer = response.getWriter();
            writer.print("An error occurred while generating the configuration file.");
            writer.close();
        }
    }

    public MoOAuthPluginConfigurationsHandler getMoOAuthPluginConfigurationsHandler() {
        return this.MoOAuthPluginConfigurationsHandler;
    }

    public void setMoOAuthPluginConfigurationsHandler(MoOAuthPluginConfigurationsHandler MoOAuthPluginConfigurationsHandler2) {
        this.MoOAuthPluginConfigurationsHandler = MoOAuthPluginConfigurationsHandler2;
    }
}

