/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.bamboo.service.OAuthAuthorizationClientService;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoOAuthAutoLoginServlet
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(MoOAuthAutoLoginServlet.class);
    private MoOAuthSettings moOAuthSettings;

    public MoOAuthAutoLoginServlet(MoOAuthSettings moOAuthSettings) {
        this.moOAuthSettings = moOAuthSettings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String return_to = request.getParameter("return_to");
        this.createAuthenticationRequestAndRedirectForAutoLogin(request, response, return_to);
        this.removeOtherCookies(request, response);
    }

    private void removeOtherCookies(HttpServletRequest request, HttpServletResponse response) {
        MoOAuthHttpUtils.removeCookie("test_configuration_in_use", request, response);
        MoOAuthHttpUtils.removeCookie("verify_credentials_in_use", request, response);
    }

    private void createAuthenticationRequestAndRedirectForAutoLogin(HttpServletRequest request, HttpServletResponse response, String return_to) throws IOException {
        this.saveTheRelayState(response, return_to);
        Cookie sessionCookie = new Cookie("IDPSESSIONEXIST", "NULL");
        sessionCookie.setMaxAge(4000);
        sessionCookie.setPath("/");
        response.addCookie(sessionCookie);
        OAuthAuthorizationClientService oAuthAuthorizationClientService = new OAuthAuthorizationClientService();
        oAuthAuthorizationClientService.buildAuthorizationRequestAndRedirect(request, response, this.moOAuthSettings, true, this.moOAuthSettings.getForceReAuthentication());
    }

    private void saveTheRelayState(HttpServletResponse response, String return_to) {
        try {
            if (return_to == null) {
                return_to = "/";
            }
            if (StringUtils.isNotEmpty((CharSequence)return_to) && !return_to.startsWith("/") && !return_to.startsWith("http")) {
                return_to = "/" + return_to;
            }
            Cookie relayStateCookie = new Cookie("RELAY_STATE", (String)StringUtils.defaultIfBlank((CharSequence)URLEncoder.encode(return_to, "UTF-8"), (CharSequence)this.moOAuthSettings.getBaseUrl()));
            relayStateCookie.setPath("/");
            relayStateCookie.setHttpOnly(true);
            response.addCookie(relayStateCookie);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

