/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.dto;

import com.google.gson.JsonParseException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class JwtIDToken {
    private String header;
    private String payload;
    private String signature;
    private String encodedHeader;
    private String encodedPayload;

    public JwtIDToken(String header, String payload, String signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    public JwtIDToken(String token) throws JsonParseException {
        String[] arr = StringUtils.split((String)token, (String)".");
        this.encodedHeader = arr[0];
        this.payload = arr[1];
        this.signature = arr[2];
        Base64.Decoder base64Decoder = Base64.getDecoder();
        this.header = new String(base64Decoder.decode(arr[0]));
        this.payload = new String(base64Decoder.decode(arr[1]));
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public void setEncodedHeader(String encodedHeader) {
        this.encodedHeader = encodedHeader;
    }

    public String getEncodedPayload() {
        return this.encodedPayload;
    }

    public void setEncodedPayload(String encodedPayload) {
        this.encodedPayload = encodedPayload;
    }

    public String toString() {
        return "JwtIDToken{header='" + this.header + '\'' + ", payload='" + this.payload + '\'' + ", signature='" + this.signature + '\'' + ", encodedHeader='" + this.encodedHeader + '\'' + ", encodedPayload='" + this.encodedPayload + '\'' + '}';
    }
}

