<!-- Contact Us tab of the plugin, lets you send a support query from the plugin -->

<html>
<head>
    <meta name="decorator" content="atl.general"/>

    <script>
        function enableDebugLogs(){
            var enableDebugLogs = document.getElementById("enableDebugLogs").checked;
            var message;
            message = enableDebugLogs?"DEBUG Logs enabled successfully." :  "DEBUG Logs disabled successfully.";
            AJS.$.ajax({
                 url: AJS.contextPath() + "/plugins/servlet/oauth/moapi",
                 timeout: 0,
                 data: {
                     "action": "enableDebugLogs",
                     "enableDebugLogs": enableDebugLogs
                 },
                 type: "POST",
                 success: function (response) {
                     require('aui/flag')({
                          title: 'Success',
                          type: 'success',
                          close: 'auto',
                          body: message
                          });
                         },
                 error: function (response) {
                    if(response.status == 200)
                    {
                         require('aui/flag')({
                         title: 'Success',
                         type: 'success',
                         close: 'auto',
                         body: message
                         });
                    }
                    else
                    {
                       require('aui/flag')({
                             title: 'Error',
                             type: 'error',
                             close: 'auto',
                             body: '<p>Issue with enabling DEBUG Logs. </p>'
                       });
                    }
                },
                async: true
            });
            viewLogs();
        }
        function viewLogs()
        {
            if(document.getElementById("enableDebugLogs").checked)
               AJS.$("#logsDiv").slideDown();
            else
               document.getElementById("logsDiv").style.display = "none";
        }

        function downloadButtonCalled() {
             document.location.href = AJS.contextPath() + "/plugins/servlet/oauth/moapi?action=downloadBambooLogs";
        }
         AJS.$(document).ready(function() {
            viewLogs();
         });
    </script>
    <style>
        .aui-page-panel-content{
            padding: 0px !important;
        }

        .aui-page-panel{
            margin: 0px !important;
        }
    </style>
</head>

<body>
    <#include "*/header.ftl" parse=true>
<div class="tabs-pane active-pane" id="contact-us"  role="tabpanel" style ="min-height: 75px;" >
    <p style="font-size:16pt;">Troubleshooting</p>
    <hr class="header"/><br>

<form id="troubleshoot-sso-form" class="aui long-label" action="" method="POST">
            <div class="troubleshooting-section-div" id="troubleshooting-section-div">
                <div class="tabs-pane active-pane" id="support" aria-labelledby="aui-uid-7" role="tabpanel" >
                    <p>For troubleshooting use,</p>
                    <ul>
                        <li><b>Log File:</b> Any errors or issues  related to the plugin's functionality can be tracked using debug logs. To record debug logs enable the below option,
                            <br><br>
                            <div class="field-group">
                                <label>Enable Debug Logs:</label>
                                <aui-toggle id="enableDebugLogs" label="Enable Debug Logs for plugin"
                                            name="enableDebugLogs" value="true" <#if enableDebugLogs == true> checked </#if> onchange="enableDebugLogs()"></aui-toggle>
                                <div class="description">
                                    <span>Enabling will enable the debug logs for the plugin.</span>
                                </div>
                            </div>
                            <div class="field-group" id= "logsDiv" name = "logsDiv" style="display:none" >
                                <div class="aui-message aui-message-info" id= "debugLogInfoTag">
                                    <p>Debug Logs are now enabled , please reproduce the issue in incognito and then click on Download button.</p>
                                </div>
                                <br>
                                <label>Server Logs:</label>
                                <input type='button' value='Download' id='downloadButton' name="downloadButton" class="aui-button aui-button-primary" style="margin-left:2px" onclick="return downloadButtonCalled()"/>&nbsp;

                                <div class="aui-message aui-message-info" id= "debugLogDownload" style= "margin-top:10px">
                                    <p>Clicking on download will download a copy of the Bamboo Server logs file.</p>
                                </div>
                            </div>


                        </li>
                        <br>

                    </ul>
                    <p> Send us a message, query or feedback attaching above log file using the Support widget (requires Internet) and we will get back to you. Have a lot to say? You can also reach us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a>.</p>

                </div>
            </div>
        </form>

</div>
</section>
</div>
</div>

</body>
</html>