/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.struts2.ServletActionContext;

public class MoOAuthSignInSettingsAction
extends BambooActionSupport {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthSignInSettingsAction.class);
    private String loginButtonText;
    private Boolean signinSettingsSubmitted;
    private String relayState;
    private String allowedDomains;
    private String xsrfToken;
    private Boolean enableBackdoor;
    private Boolean disableDefaultLogin;
    private Boolean enableAutoRedirectDelay;
    private String autoRedirectDelayInterval;
    private String ssoButtonLocation;
    private Boolean enableLoginTemplate;
    private String loginTemplate;
    private Boolean enableLogoutTemplate;
    private String logoutTemplate;
    private String customLogoutURL;
    private Boolean enableErrorMsgTemplate;
    private String errorMsgTemplate;
    private Boolean pluginApiAccessRestriction;
    private Boolean allowPasswordReset;
    private Boolean backdoorSubmitted;
    private Boolean restrictBackdoor;
    private List<String> backdoorGroupsList;
    private String[] backdoorGroups;
    private String lowerBuild;
    private ArrayList existingGroups;
    private PluginLicenseManager pluginLicenseManager;
    private MoOAuthSettings settings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String backdoorKey;
    private String backdoorValue;
    private Boolean enableDebugLogs;
    private Boolean enableForSoftware;
    private Boolean enableAutoLogin;
    private Boolean isAutoAttemptSuppProvider;
    private String autoCallbackUrl;

    public MoOAuthSignInSettingsAction(MoOAuthSettings settings, UserManager userManager, LoginUriProvider loginUriProvider, BambooUserManager bambooUserManager) {
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.bambooUserManager = bambooUserManager;
    }

    public void validate() {
        LOGGER.info((Object)"Sign In Settings Action validate called");
        HttpServletRequest request = ServletActionContext.getRequest();
        if (!BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
            return;
        }
        Boolean error = false;
        ArrayList<String> invalidValues = new ArrayList<String>();
        UrlValidator urlValidator = new UrlValidator(8L);
        if (StringUtils.isNotBlank((CharSequence)this.relayState) && !urlValidator.isValid(this.relayState)) {
            invalidValues.add("relaystate");
        }
        for (String invalidValue : invalidValues) {
            error = true;
            this.addActionError(this.getText("oauth.error.invalid." + invalidValue));
        }
        if (super.hasActionErrors() || error.booleanValue()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeOAuthConfig();
            return;
        }
        super.validate();
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info((Object)"SignIn Settings Action doExecute Submitted: ");
                if (!this.settings.isLicenseValid().booleanValue()) {
                    try {
                        response.sendRedirect(this.settings.getManageAddOnURL());
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.lowerBuild = "false";
                this.lowerBuild = this.getLowerBuild();
                LOGGER.debug((Object)("signinSettingsSubmitted: " + this.signinSettingsSubmitted));
                LOGGER.debug((Object)("backdoorSubmitted: " + this.backdoorSubmitted));
                this.backdoorGroupsList = new ArrayList<String>();
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                if (BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild)) {
                        if (this.backdoorGroups != null) {
                            LOGGER.debug((Object)("Backdoor groups-" + this.backdoorGroups.length));
                            this.backdoorGroupsList = new ArrayList<String>(Arrays.asList(this.backdoorGroups));
                        }
                    } else {
                        this.backdoorGroupsList = this.settings.convertArrayToList(StringUtils.split((String)this.backdoorGroups[0], (String)","));
                    }
                    MoOAuthPluginHandler.saveSigninSettings(this.loginButtonText, this.relayState, this.disableDefaultLogin, this.enableBackdoor, this.enableAutoRedirectDelay, this.autoRedirectDelayInterval, this.allowedDomains, this.ssoButtonLocation, this.enableLoginTemplate, this.loginTemplate, this.enableLogoutTemplate, this.logoutTemplate, this.customLogoutURL, this.enableErrorMsgTemplate, this.errorMsgTemplate, this.pluginApiAccessRestriction, this.restrictBackdoor, this.backdoorGroupsList, this.backdoorKey, this.backdoorValue, this.enableDebugLogs, this.allowPasswordReset, this.enableForSoftware, this.enableAutoLogin);
                    this.addActionMessage(this.getText("oauth.success.config"));
                }
                this.initializeOAuthConfig();
                return "success";
            }
            catch (MoOAuthPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(MoOAuthPluginHandler.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeOAuthConfig() {
        LOGGER.info((Object)"initialize OAuth Config called");
        this.loginButtonText = this.settings.getLoginButtonText();
        this.relayState = this.settings.getRelayState();
        this.disableDefaultLogin = this.settings.getDefaultLoginDisabled();
        this.enableBackdoor = this.settings.getBackdoorEnabled();
        this.enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
        this.autoRedirectDelayInterval = this.settings.getAutoRedirectDelayInterval();
        this.allowedDomains = this.settings.getAllowedDomains();
        this.ssoButtonLocation = this.settings.getSsoButtonLocation();
        this.enableLoginTemplate = this.settings.getEnableLoginTemplate();
        this.loginTemplate = this.settings.getLoginTemplate();
        this.enableLogoutTemplate = this.settings.getEnableLogoutTemplate();
        this.logoutTemplate = this.settings.getLogoutTemplate();
        this.customLogoutURL = this.settings.getCustomLogoutURL();
        this.enableErrorMsgTemplate = this.settings.getEnableErrorMsgTemplate();
        this.errorMsgTemplate = this.settings.getErrorMsgTemplate();
        this.pluginApiAccessRestriction = this.settings.getPluginApiAccessRestriction();
        this.restrictBackdoor = this.settings.getRestrictBackdoor();
        this.backdoorGroupsList = this.settings.getBackdoorGroups();
        this.lowerBuild = this.getLowerBuild();
        ArrayList existingGroup = this.getExistingGroups();
        this.backdoorKey = this.settings.getBackdoorKey();
        this.backdoorValue = this.settings.getBackdoorValue();
        this.allowPasswordReset = this.settings.getAllowPasswordReset();
        this.enableDebugLogs = this.settings.getEnableDebugLogs();
        this.enableForSoftware = this.settings.getEnableForSoftware();
        this.isAutoAttemptSuppProvider = this.settings.getIsAutoAttemptSuppProvider(this.settings.getAppName());
        this.enableAutoLogin = this.isAutoAttemptSuppProvider != false ? this.settings.getEnableAutoLogin() : false;
        this.autoCallbackUrl = this.settings.getAutoCallBackUrl();
    }

    public String getBaseUrl() {
        return this.settings.getBaseUrl();
    }

    public Boolean getPluginApiAccessRestriction() {
        return this.pluginApiAccessRestriction;
    }

    public void setPluginApiAccessRestriction(Boolean pluginApiAccessRestriction) {
        this.pluginApiAccessRestriction = pluginApiAccessRestriction;
    }

    public String getErrorMsgTemplate() {
        return this.errorMsgTemplate;
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.errorMsgTemplate = errorMsgTemplate;
    }

    public Boolean getEnableErrorMsgTemplate() {
        return this.enableErrorMsgTemplate;
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.enableErrorMsgTemplate = enableErrorMsgTemplate;
    }

    public String getCustomLogoutURL() {
        return this.customLogoutURL;
    }

    public void setCustomLogoutURL(String customLogoutURL) {
        this.customLogoutURL = customLogoutURL;
    }

    public Boolean getEnableLoginTemplate() {
        return this.enableLoginTemplate;
    }

    public void setEnableLoginTemplate(Boolean enableLoginTemplate) {
        this.enableLoginTemplate = enableLoginTemplate;
    }

    public String getLoginTemplate() {
        return this.loginTemplate;
    }

    public void setLoginTemplate(String loginTemplate) {
        this.loginTemplate = loginTemplate;
    }

    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    public Boolean getEnableLogoutTemplate() {
        return this.enableLogoutTemplate;
    }

    public void setEnableLogoutTemplate(Boolean enableLogoutTemplate) {
        this.enableLogoutTemplate = enableLogoutTemplate;
    }

    public String getLoginButtonText() {
        return this.loginButtonText;
    }

    public void setLoginButtonText(String loginButtonText) {
        this.loginButtonText = loginButtonText;
    }

    public Boolean getSigninSettingsSubmitted() {
        return this.signinSettingsSubmitted;
    }

    public void setSigninSettingsSubmitted(Boolean signinSettingsSubmitted) {
        this.signinSettingsSubmitted = signinSettingsSubmitted;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getBackdoorKey() {
        return this.backdoorKey;
    }

    public void setBackdoorKey(String backdoorKey) {
        this.backdoorKey = backdoorKey;
    }

    public String getBackdoorValue() {
        return this.backdoorValue;
    }

    public void setBackdoorValue(String backdoorValue) {
        this.backdoorValue = backdoorValue;
    }

    public String getSsoButtonLocation() {
        return this.ssoButtonLocation;
    }

    public void setSsoButtonLocation(String relayState) {
        this.ssoButtonLocation = relayState;
    }

    public Boolean getEnableBackdoor() {
        return this.enableBackdoor;
    }

    public void setEnableBackdoor(Boolean enableBackdoor) {
        this.enableBackdoor = enableBackdoor;
    }

    public Boolean getDisableDefaultLogin() {
        return this.disableDefaultLogin;
    }

    public void setDisableDefaultLogin(Boolean disableDefaultLogin) {
        this.disableDefaultLogin = disableDefaultLogin;
    }

    public Boolean getEnableAutoRedirectDelay() {
        return this.enableAutoRedirectDelay;
    }

    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.enableAutoRedirectDelay = enableAutoRedirectDelay;
    }

    public String getAutoRedirectDelayInterval() {
        return this.autoRedirectDelayInterval;
    }

    public void setAutoRedirectDelayInterval(String autoRedirectDelayInterval) {
        this.autoRedirectDelayInterval = autoRedirectDelayInterval;
    }

    public String getAllowedDomains() {
        return this.allowedDomains;
    }

    public void setAllowedDomains(String allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public Boolean getRestrictBackdoor() {
        return this.restrictBackdoor;
    }

    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.restrictBackdoor = restrictBackdoor;
    }

    public List<String> getBackdoorGroupsList() {
        return this.backdoorGroupsList;
    }

    public void setBackdoorGroupsList(List<String> backdoorGroupsList) {
        this.backdoorGroupsList = backdoorGroupsList;
    }

    public String[] getBackdoorGroups() {
        return this.backdoorGroups;
    }

    public void setBackdoorGroups(String[] backdoorGroups) {
        this.backdoorGroups = backdoorGroups;
    }

    public String getLowerBuild() {
        this.lowerBuild = Boolean.toString(this.settings.isLowerBuild());
        return this.lowerBuild;
    }

    public void setLowerBuild(String lowerBuild) {
        this.lowerBuild = lowerBuild;
    }

    public Boolean getAllowPasswordReset() {
        return this.allowPasswordReset;
    }

    public void setAllowPasswordReset(Boolean allowPasswordReset) {
        this.allowPasswordReset = allowPasswordReset;
    }

    public Boolean getEnableAutoLogin() {
        return this.enableAutoLogin;
    }

    public void setEnableAutoLogin(Boolean enableAutoLogin) {
        this.enableAutoLogin = enableAutoLogin;
    }

    public String getAutoCallbackUrl() {
        return this.autoCallbackUrl;
    }

    public void setAutoCallbackUrl(String autoCallbackUrl) {
        this.autoCallbackUrl = this.settings.getAutoCallBackUrl();
    }

    public Boolean getIsAutoAttemptSuppProvider() {
        return this.isAutoAttemptSuppProvider;
    }

    public ArrayList getExistingGroups() {
        try {
            Pager groupObjects = this.bambooUserManager.getGroups();
            this.existingGroups = new ArrayList();
            for (Group group : groupObjects) {
                if (this.existingGroups.contains(group.getName().trim())) continue;
                this.existingGroups.add(group.getName().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.existingGroups;
    }

    public void setExistingGroups(ArrayList existingGroups) {
        this.existingGroups = existingGroups;
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.enableDebugLogs = enableDebugLogs;
    }

    public Boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    public Boolean getEnableForSoftware() {
        return this.enableForSoftware;
    }

    public void setEnableForSoftware(Boolean enableForSoftware) {
        this.enableForSoftware = enableForSoftware;
    }
}

