/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginConstants;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthPluginConfigurationsHandler {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthPluginConfigurationsHandler.class);
    private MoOAuthSettings settings;

    public MoOAuthPluginConfigurationsHandler(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public String generateConfigurationsJson() throws JSONException {
        LOGGER.info((Object)"Generating configurations JSON string ");
        JSONObject config = new JSONObject();
        config.putOpt("SERVER_VERSION", this.settings.getServerVersion());
        config.putOpt("PLUGIN_NAME", this.settings.getPluginName());
        config.putOpt("PLUGIN_VERSION", this.settings.getPluginVersion());
        this.exportOAuthConfig(config);
        this.exportAttributeMapping(config);
        this.exportGroupMapping(config);
        this.exportSignOnSettings(config);
        return config.toString(2);
    }

    private void exportOAuthConfig(JSONObject config) {
        LOGGER.info((Object)"Inserting OAuth configuration.");
        JSONObject oauthConfig = new JSONObject();
        try {
            for (MoOAuthPluginConstants.OAuthConfiguration constant : MoOAuthPluginConstants.OAuthConfiguration.values()) {
                this.exportConfig(oauthConfig, String.valueOf((Object)constant), constant.getKey());
            }
            config.putOpt("OAuth Configuration", oauthConfig);
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Error occurred while inserting OAuth configuration in JSON " + e.getMessage() + " Cause: " + e.getCause()));
            e.printStackTrace();
        }
    }

    private void exportAttributeMapping(JSONObject config) {
        LOGGER.info((Object)"Inserting User Profile configuration in JSON Object.");
        JSONObject attributeMapping = new JSONObject();
        try {
            for (MoOAuthPluginConstants.AttributeMapping constant : MoOAuthPluginConstants.AttributeMapping.values()) {
                this.exportConfig(attributeMapping, String.valueOf((Object)constant), constant.getKey());
            }
            config.putOpt("Attribute Mapping", attributeMapping);
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Error occurred while inserting Attribute Mapping configuration in JSON " + e.getMessage() + " Cause: " + e.getCause()));
            e.printStackTrace();
        }
    }

    private void exportGroupMapping(JSONObject config) {
        LOGGER.info((Object)"Inserting User Groups configuration in JSON Object.");
        JSONObject groupMapping = new JSONObject();
        try {
            for (MoOAuthPluginConstants.GroupMapping constant : MoOAuthPluginConstants.GroupMapping.values()) {
                this.exportConfig(groupMapping, String.valueOf((Object)constant), constant.getKey());
            }
            config.putOpt("Group Mapping", groupMapping);
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Error occurred while inserting Group Mapping configuration in JSON " + e.getMessage() + " Cause: " + e.getCause()));
            e.printStackTrace();
        }
    }

    private void exportSignOnSettings(JSONObject config) {
        LOGGER.info((Object)"Inserting Sign in settings configuration.");
        JSONObject signInSettings = new JSONObject();
        try {
            for (MoOAuthPluginConstants.SignInSettings constant : MoOAuthPluginConstants.SignInSettings.values()) {
                this.exportConfig(signInSettings, String.valueOf((Object)constant), constant.getKey());
            }
            config.putOpt("Sign In Settings", signInSettings);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOGGER.error((Object)("Error occurred while inserting Sign in settings configuration in JSON " + e.getMessage() + " Cause: " + e.getCause()));
        }
    }

    public void exportConfig(JSONObject jsonObject, String constantName, String constantKey) {
        if (this.settings.getPluginSettings().get(constantKey) instanceof Boolean) {
            jsonObject.putOpt(constantName, BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.settings.getPluginSettings().get(constantKey))), (boolean)false));
        } else if (this.settings.getPluginSettings().get(constantKey) instanceof List) {
            List<String> list = null;
            if (constantName == "DEFAULT_GROUPS") {
                if (this.settings.isLowerBuild().booleanValue()) {
                    return;
                }
                list = this.settings.getDefaultGroupsList();
            } else {
                list = (List<String>)this.settings.getPluginSettings().get(constantKey);
            }
            if (list.isEmpty()) {
                jsonObject.append(constantName, "");
            } else {
                for (String listItem : list) {
                    jsonObject.append(constantName, listItem);
                }
            }
        } else if (this.settings.getPluginSettings().get(constantKey) instanceof HashMap) {
            JSONObject jsonObjectForHasMap = new JSONObject();
            if (this.settings.getRoleMapping() != null) {
                for (String key : this.settings.getRoleMapping().keySet()) {
                    jsonObjectForHasMap.putOpt(key, this.settings.getRoleMapping().get(key));
                }
            }
            jsonObject.putOpt(constantName, jsonObjectForHasMap);
            JSONObject jsonObjectForHasMapAuthorizationAttr = new JSONObject();
            if (StringUtils.equalsIgnoreCase((CharSequence)constantName, (CharSequence)"OAUTH_REQUEST_PARAMETERS") && this.settings.getOauth_request_parameters() != null) {
                for (String key : this.settings.getOauth_request_parameters().keySet()) {
                    jsonObjectForHasMapAuthorizationAttr.putOpt(key, this.settings.getOauth_request_parameters().get(key));
                }
                jsonObject.putOpt(constantName, jsonObjectForHasMapAuthorizationAttr);
            }
        } else {
            if (constantName == "DEFAULT_GROUP" && !this.settings.isLowerBuild().booleanValue()) {
                return;
            }
            jsonObject.putOpt(constantName, StringUtils.defaultIfBlank((CharSequence)((String)this.settings.getPluginSettings().get(constantKey)), (CharSequence)""));
        }
    }

    public void importConfigurations(File configFile) throws MoOAuthPluginException, JSONException, IOException {
        LOGGER.info((Object)"Importing app's configuration from config file");
        String pluginConfigurations = IOUtils.toString(new FileInputStream(configFile));
        this.importPluginConfigurations(pluginConfigurations);
    }

    public void importPluginConfigurations(String pluginConfigurationsJson) throws JSONException, MoOAuthPluginException {
        JSONObject signInSettings;
        JSONObject groupMapping;
        LOGGER.info((Object)"Importing app Configurations in JSON Object ");
        JSONObject pluginConfigObj = new JSONObject(pluginConfigurationsJson);
        JSONObject oauthConfig = pluginConfigObj.optJSONObject("OAuth Configuration");
        if (oauthConfig != null && oauthConfig.length() != 0) {
            String clientId = oauthConfig.optString("CLIENT_ID");
            String clientSecret = oauthConfig.optString("CLIENT_SECRET");
            if (clientId.isEmpty() || clientSecret.isEmpty()) {
                String error = "An error occurred while importing configurations. Please make sure you have selected valid configurations file";
                throw new MoOAuthPluginException(MoOAuthPluginException.PluginErrorCode.SAVING_DETAILS, error);
            }
        } else {
            throw new MoOAuthPluginException(MoOAuthPluginException.PluginErrorCode.SAVING_DETAILS, "No Application Found. Please upload correct file");
        }
        this.settings.setResetSettings(Boolean.TRUE);
        this.clearPluginSettings();
        this.importOAuthConfig(oauthConfig);
        JSONObject attributeMapping = pluginConfigObj.optJSONObject("Attribute Mapping");
        if (attributeMapping != null && attributeMapping.length() != 0) {
            this.importAttributeMapping(attributeMapping);
        }
        if ((groupMapping = pluginConfigObj.optJSONObject("Group Mapping")) != null && groupMapping.length() != 0) {
            this.importGroupMapping(groupMapping);
        }
        if ((signInSettings = pluginConfigObj.optJSONObject("Sign In Settings")) != null && signInSettings.length() != 0) {
            this.importSignInSettings(signInSettings);
        }
    }

    private void importOAuthConfig(JSONObject oAuthConfigObj) throws JSONException {
        for (MoOAuthPluginConstants.OAuthConfiguration constant : MoOAuthPluginConstants.OAuthConfiguration.values()) {
            LOGGER.info((Object)"importOAuthConfig called ");
            this.importConfig(oAuthConfigObj, String.valueOf((Object)constant), constant.getKey());
        }
    }

    private void importAttributeMapping(JSONObject attributeMappingObj) throws JSONException {
        LOGGER.info((Object)"importAttributeMapping called ");
        for (MoOAuthPluginConstants.AttributeMapping constant : MoOAuthPluginConstants.AttributeMapping.values()) {
            this.importConfig(attributeMappingObj, String.valueOf((Object)constant), constant.getKey());
        }
    }

    private void importGroupMapping(JSONObject groupMappingObj) throws JSONException {
        LOGGER.info((Object)"importGroupMapping called ");
        for (MoOAuthPluginConstants.GroupMapping constant : MoOAuthPluginConstants.GroupMapping.values()) {
            this.importConfig(groupMappingObj, String.valueOf((Object)constant), constant.getKey());
        }
    }

    private void importSignInSettings(JSONObject signInSettingsObj) throws JSONException {
        LOGGER.info((Object)"importSignInSettings called ");
        for (MoOAuthPluginConstants.SignInSettings constant : MoOAuthPluginConstants.SignInSettings.values()) {
            this.importConfig(signInSettingsObj, String.valueOf((Object)constant), constant.getKey());
        }
    }

    private void importConfig(JSONObject jsonObject, String constantName, String constantKey) {
        if (this.settings.getPluginSettings().get(constantKey) instanceof Boolean) {
            this.settings.getPluginSettings().put(constantKey, (Object)BooleanUtils.toString((Boolean)jsonObject.optBoolean(constantName), (String)"true", (String)"false", (String)"false"));
        } else if (this.settings.getPluginSettings().get(constantKey) instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            JSONArray jsonArray = jsonObject.optJSONArray(constantName);
            if (jsonArray != null) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    list.add(jsonArray.getString(i));
                }
            }
            this.settings.getPluginSettings().put(constantKey, list);
        } else if (this.settings.getPluginSettings().get(constantKey) instanceof HashMap) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            JSONObject jsonObjectForHashMap = jsonObject.optJSONObject(constantName);
            if (jsonObjectForHashMap != null) {
                Iterator<String> iterator = jsonObjectForHashMap.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    hashMap.put(key, jsonObjectForHashMap.getString(key));
                }
            }
            this.settings.getPluginSettings().put(constantKey, hashMap);
        } else {
            LOGGER.debug((Object)"String");
            this.settings.getPluginSettings().put(constantKey, (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)jsonObject.optString(constantName), (CharSequence)""))));
        }
    }

    public void clearPluginSettings() {
        LOGGER.info((Object)"clearPluginSettings called");
        this.resetOAuthConfig();
        this.resetAttributeMapping();
        this.resetGroupMapping();
        this.resetSignOnSettings();
        LOGGER.info((Object)"Getting default configuration");
        MoOAuthPluginHandler.saveDefaultConfiguration();
    }

    public void resetOAuthConfig() {
        LOGGER.info((Object)"resetOAuthConfig called ");
        for (MoOAuthPluginConstants.OAuthConfiguration constant : MoOAuthPluginConstants.OAuthConfiguration.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetAttributeMapping() {
        LOGGER.info((Object)"resetAttributeMapping called ");
        for (MoOAuthPluginConstants.AttributeMapping constant : MoOAuthPluginConstants.AttributeMapping.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetGroupMapping() {
        LOGGER.info((Object)"resetGroupMapping called ");
        for (MoOAuthPluginConstants.GroupMapping constant : MoOAuthPluginConstants.GroupMapping.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetSignOnSettings() {
        LOGGER.info((Object)"resetSignOnSettings called ");
        for (MoOAuthPluginConstants.SignInSettings constant : MoOAuthPluginConstants.SignInSettings.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetConfig(String constantKey) {
        this.settings.deleteKey(constantKey);
    }
}

