/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.service;

import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthPluginConstants;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationClientService {
    private final Logger LOGGER = LoggerFactory.getLogger(OAuthAuthorizationClientService.class);
    private MoOAuthSettings moOAuthSettings;

    public void buildAuthorizationRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, MoOAuthSettings settings, Boolean isAttemptAutoLoginRequest) throws UnsupportedEncodingException, IOException {
        this.LOGGER.debug("Building Authorization Request");
        try {
            String CLIENT_ID = settings.getClientID();
            String SCOPE = settings.getScope();
            String RESPONSE_TYPE = "code";
            String REDIRECT_URI = isAttemptAutoLoginRequest != false ? settings.getAutoCallBackUrl() : settings.getCallBackUrl() + settings.getCustomizableCallbackURL();
            Boolean nonceCheck = settings.getNonceCheck();
            Boolean acrValueCheck = settings.getACRValueCheck();
            Boolean isPKCESupportEnabled = settings.getEnablePKCESupport();
            Boolean useStateParameter = settings.getUseStateParameter();
            HashMap<String, String> oauth_request_parameters = settings.getOauth_request_parameters();
            HttpSession session = request.getSession();
            Boolean oauthParameterCheck = !oauth_request_parameters.isEmpty();
            StringBuilder AUTHORIZE_ENDPOINT = new StringBuilder(settings.getAuthorizeEndpoint());
            if (StringUtils.equals((CharSequence)settings.getAppName(), (CharSequence)"Keycloak")) {
                SCOPE = "openid";
            }
            if (AUTHORIZE_ENDPOINT.indexOf("?") > -1) {
                AUTHORIZE_ENDPOINT.append("&");
            } else {
                AUTHORIZE_ENDPOINT.append("?");
            }
            AUTHORIZE_ENDPOINT.append("client_id=").append(CLIENT_ID).append("&scope=").append(URLEncoder.encode(SCOPE, "UTF-8")).append("&redirect_uri=").append(URLEncoder.encode(REDIRECT_URI, "UTF-8")).append("&response_type=").append(RESPONSE_TYPE).append("&access_type=offline").append("&include_granted_scopes=true");
            if (isAttemptAutoLoginRequest.booleanValue()) {
                AUTHORIZE_ENDPOINT.append("&prompt=none");
            }
            if (isPKCESupportEnabled.booleanValue()) {
                String codeVerifier = this.generateCodeVerifier();
                String codeChallenge = this.generateCodeChallenge(codeVerifier);
                session.setAttribute(MoOAuthPluginConstants.CODE_VERIFIER, (Object)codeVerifier);
                AUTHORIZE_ENDPOINT.append("&").append(MoOAuthPluginConstants.CODE_CHALLENGE_METHOD).append("=").append("S256").append("&").append(MoOAuthPluginConstants.CODE_CHALLENGE).append("=").append(codeChallenge);
            }
            this.LOGGER.debug("Nonce Check : " + nonceCheck);
            this.LOGGER.debug("ACR Value Check : " + acrValueCheck);
            if (StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OAuth") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OpenID") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Okta") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"miniOrange") || useStateParameter.booleanValue() || nonceCheck.booleanValue() || acrValueCheck.booleanValue() || oauthParameterCheck.booleanValue()) {
                String UrlParameter;
                String sessionParameter;
                if (nonceCheck.booleanValue()) {
                    this.LOGGER.debug("send nonce in the request");
                    sessionParameter = "nonce";
                    UrlParameter = "&nonce=";
                    this.passParameterInRequest(session, sessionParameter, UrlParameter, AUTHORIZE_ENDPOINT);
                }
                if (acrValueCheck.booleanValue()) {
                    this.LOGGER.debug("send acr_values parameter in the request");
                    sessionParameter = "acr_values";
                    UrlParameter = "&acr_values=";
                    this.passParameterInRequest(session, sessionParameter, UrlParameter, AUTHORIZE_ENDPOINT);
                }
                if (useStateParameter.booleanValue() || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"OKTA")) {
                    this.LOGGER.debug("send state parameter in the request");
                    sessionParameter = "state_attribute_parameter";
                    UrlParameter = "&state=";
                    this.passParameterInRequest(session, sessionParameter, UrlParameter, AUTHORIZE_ENDPOINT);
                }
                if (oauthParameterCheck.booleanValue()) {
                    this.LOGGER.debug("send Oauth request parameters in the request");
                    this.passOauthParametersInRequest(request, AUTHORIZE_ENDPOINT, oauth_request_parameters);
                }
            }
            this.LOGGER.debug("OAuth CODE request generated");
            MoOAuthManager.httpRedirect(response, AUTHORIZE_ENDPOINT.toString());
        }
        catch (Exception e) {
            this.LOGGER.error("Error " + e);
        }
    }

    private void passParameterInRequest(HttpSession session, String sessionParameter, String UrlParameter, StringBuilder AUTHORIZE_ENDPOINT) {
        String nonce = this.randomAlphaNumeric(10);
        session.setAttribute(sessionParameter, (Object)nonce);
        AUTHORIZE_ENDPOINT.append(UrlParameter).append(nonce);
    }

    private void passOauthParametersInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT, Map<String, String> oauth_request_parameters) {
        HttpSession httpSession = request.getSession();
        for (Map.Entry<String, String> entry : oauth_request_parameters.entrySet()) {
            httpSession.setAttribute(entry.getKey(), (Object)entry.getValue());
            AUTHORIZE_ENDPOINT.append("&" + entry.getKey() + "=").append(entry.getValue());
        }
    }

    private String randomAlphaNumeric(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public String generateCodeVerifier() {
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[32];
        random.nextBytes(randomBytes);
        String codeVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        return codeVerifier;
    }

    public String generateCodeChallenge(String codeVerifier) {
        try {
            byte[] bytes = codeVerifier.getBytes("US-ASCII");
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(bytes);
            String codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
            return codeChallenge;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate code challenge", e);
        }
    }
}

