/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.oauth.bamboo.MoOAuthPluginConstants;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.bamboo.dto.JwtIDToken;
import com.miniorange.oauth.bamboo.dto.ProtocolType;
import com.miniorange.oauth.bamboo.dto.TokenResponse;
import com.miniorange.oauth.bamboo.factory.IProtocolAction;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class MoOpenIdAction
implements IProtocolAction {
    private static Log LOGGER = LogFactory.getLog(MoOpenIdAction.class);
    private static ProtocolType TYPE = ProtocolType.OPENID;
    private JsonParser parser = new JsonParser();
    private static String algKey = "alg";
    private static String audience = "aud";

    @Override
    public TokenResponse sendTokenRequest(MoOAuthSettings settings, String code, HttpSession session) {
        LOGGER.info((Object)"Create and send OpenID ID Token Request");
        LOGGER.debug((Object)"Within OPEN ID SEND TOKEN REQUEST");
        String redirectURI = settings.getBaseUrl().concat("/plugins/servlet/oauth/callback") + settings.getCustomizableCallbackURL();
        String accessTokenURI = settings.getAccessTokenEndpoint();
        String sendTokenAuthParameterIn = settings.getSendTokenAuthParameterIn();
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", redirectURI));
        postParameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        postParameters.add((NameValuePair)new BasicNameValuePair("code", code));
        if (settings.getEnablePKCESupport().booleanValue()) {
            String token = (String)session.getAttribute(MoOAuthPluginConstants.CODE_VERIFIER);
            postParameters.add((NameValuePair)new BasicNameValuePair(MoOAuthPluginConstants.CODE_VERIFIER, token));
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accept", "application/json");
        if ((StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OAuth") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OpenID")) && StringUtils.equalsIgnoreCase((CharSequence)sendTokenAuthParameterIn, (CharSequence)"HttpHeader")) {
            LOGGER.debug((Object)"Authorization parameters in HTTP Header");
            String authString = settings.getClientID() + ":" + settings.getClientSecret();
            byte[] authEncBytes = Base64.getEncoder().encode(authString.getBytes());
            String authStringEnc = new String(authEncBytes);
            String authorizationValue = "Basic " + authStringEnc;
            header.put("Authorization", authorizationValue);
        } else {
            LOGGER.debug((Object)"Sending Authorization parameters in HTTP Body of the access token request ");
            postParameters.add((NameValuePair)new BasicNameValuePair("client_id", settings.getClientID()));
            postParameters.add((NameValuePair)new BasicNameValuePair("client_secret", settings.getClientSecret()));
        }
        String response = MoOAuthHttpUtils.sendPostRequest(accessTokenURI, postParameters, "application/x-www-form-urlencoded", header);
        return new TokenResponse(response, TYPE);
    }

    @Override
    public TokenResponse sendUserInfoRequest(String accessTokenResponse, MoOAuthSettings settings) throws JsonParseException {
        if (StringUtils.equals((CharSequence)accessTokenResponse, (CharSequence)"error")) {
            return new TokenResponse("invalid_request", TYPE);
        }
        JsonObject endpointResponse = this.parser.parse(accessTokenResponse).getAsJsonObject();
        String idToken = endpointResponse.get("id_token").getAsString();
        LOGGER.debug((Object)("ID Token = " + idToken));
        JwtIDToken jwtIDToken = new JwtIDToken(idToken);
        return this.isValidJWT(jwtIDToken, settings) != false ? new TokenResponse(jwtIDToken.getPayload(), TYPE) : new TokenResponse("invalid_token", TYPE);
    }

    @Override
    public TokenResponse sendGroupInfoRequest(JsonObject userInfodata, HttpServletRequest request, String email, String id, MoOAuthSettings settings, MoOAuthUtils oAuthUtils) throws JsonParseException {
        if (StringUtils.isNotEmpty((CharSequence)settings.getRoleAttribute())) {
            HashMap<Object, Object> userInfoMap = new HashMap();
            userInfoMap = oAuthUtils.copyToStringValueMap(oAuthUtils.toMap(userInfodata, new HashMap<String, Object>()));
            String role = (String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)userInfoMap.get(settings.getRoleAttribute())), (CharSequence)"");
            return new TokenResponse(role.toString(), TYPE);
        }
        return new TokenResponse("", TYPE);
    }

    @Override
    public TokenResponse endpointCallToGetRefreshToken(String code, MoOAuthSettings settings) throws JsonParseException {
        return null;
    }

    @Override
    public ProtocolType getProtocolType() {
        return TYPE;
    }

    private Boolean isValidJWT(JwtIDToken jwtIDToken, MoOAuthSettings settings) throws JsonParseException {
        String encodedHeader = jwtIDToken.getEncodedHeader();
        String encodedPayload = jwtIDToken.getEncodedPayload();
        String signature = jwtIDToken.getSignature();
        String algo = this.getAlgoFromToken(jwtIDToken.getHeader());
        String jwtWithoutSignature = encodedHeader + "." + encodedPayload;
        Boolean validIssuer = this.isValidIssuer(jwtIDToken.getPayload(), settings);
        Boolean validSig = this.isValidSig(algo, signature, settings, jwtWithoutSignature);
        return validIssuer != false && validSig != false;
    }

    private String getAlgoFromToken(String header) throws JsonParseException {
        JsonObject obj = this.parser.parse(header).getAsJsonObject();
        return obj.get(algKey).toString();
    }

    private Boolean isValidIssuer(String payload, MoOAuthSettings settings) throws JsonParseException {
        LOGGER.debug((Object)"OPENID IS valid Issuer");
        if (BooleanUtils.toBoolean((Boolean)settings.getEnableCheckIssuerFor())) {
            String audVal;
            JsonObject obj = this.parser.parse(payload).getAsJsonObject();
            try {
                JsonArray arr = obj.get(audience).getAsJsonArray();
                audVal = arr.get(0).getAsString();
            }
            catch (Exception e) {
                audVal = obj.get(audience).getAsString();
            }
            LOGGER.debug((Object)("Audience : " + audVal));
            if (StringUtils.equalsIgnoreCase((CharSequence)settings.getCheckIssuerFor(), (CharSequence)"Default")) {
                return audVal.equals(settings.getClientID());
            }
            if (StringUtils.isNotBlank((CharSequence)settings.getCustomIssuerValue())) {
                return audVal.equals(settings.getCustomIssuerValue());
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean isValidSig(String algo, String signature, MoOAuthSettings settings, String obj) {
        return Boolean.TRUE;
    }
}

