/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.oauth.bamboo.MoOAuthPluginConstants;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthSettings {
    private static Log LOGGER = LogFactory.getLog(MoOAuthSettings.class);
    private PluginSettings pluginSettings;
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginLicenseManager pluginLicenseManager;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private BambooUserManager bambooUserManager;
    private PluginAccessor pluginAccessor;
    private BambooPermissionManager bambooPermissionManager;
    public static String LOGIN_TEMPLATE = "";
    private static String LOGOUT_TEMPLATE = "";
    private static String ERRORMSG_TEMPLATE = "";
    public static Boolean isPluginConfigurationFileUploaded;

    public MoOAuthSettings(PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory, AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooUserManager bambooUserManager, PluginAccessor pluginAccessor, BambooPermissionManager bambooPermissionManager) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginLicenseManager = pluginLicenseManager;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooUserManager = bambooUserManager;
        this.pluginAccessor = pluginAccessor;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public String getCallBackUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/oauth/callback");
    }

    public String getAutoCallBackUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/oauth/autocallback");
    }

    public String getAutoLoginUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/oauth/autoauth");
    }

    public String getLogoutServletUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/oauth/logout");
    }

    public String getCreateUserUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/oauth/createuser");
    }

    public Boolean isLicenseDefine() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return true;
        }
        return false;
    }

    public Boolean isEvaluationOrSubscriptionLicense() {
        PluginLicense pluginLicense;
        if (!this.isLicenseValid().booleanValue() && ((pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation() || pluginLicense.isSubscription())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getBaseUrl() {
        String baseURL = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        return baseURL;
    }

    public String getLoginPageUrl() {
        return this.getBaseUrl().concat("/userlogin!doDefault.action");
    }

    public String getAdminSessionUrl() {
        return this.getBaseUrl().concat("/authenticate");
    }

    public String getLogoutPageUrl() {
        return this.getBaseUrl().concat("?logout=true");
    }

    public String getDashboardUrl() {
        return this.getBaseUrl().concat("/");
    }

    public int getMaxUsers() {
        int t = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined() && (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined())) {
            LOGGER.debug((Object)"Invalid License");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getManageAddOnURL() {
        return this.getBaseUrl().concat("/plugins/servlet/upm");
    }

    public static String generateRandomAlphaNumericKey(int bytes) {
        String randomString = RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
        return randomString;
    }

    public boolean isVerifyCredentialsInUse(HttpServletRequest request) {
        return MoOAuthHttpUtils.getCookie("verify_credentials_in_use", request) != null;
    }

    public boolean isTestIDPConfigurationInUse(HttpServletRequest request) {
        return MoOAuthHttpUtils.getCookie("test_configuration_in_use", request) != null;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public Integer getCurrentBuildNumber() {
        String buildNumber = BuildUtils.getCurrentBuildNumber();
        return Integer.parseInt(buildNumber);
    }

    public Boolean isLowerBuild() {
        if (this.getCurrentBuildNumber() < 60604) {
            return true;
        }
        return false;
    }

    public String getImportExportPageUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/bamboo-oauth/importexport.action");
    }

    public String getCustomAppName() {
        String appName = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.CUSTOM_APP_NAME.getKey())), (CharSequence)"");
        return appName;
    }

    public void setCustomAppName(String customAppName) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.CUSTOM_APP_NAME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customAppName, (CharSequence)""))));
    }

    public Boolean getRememberMeCookieEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.oauth.REMEMBERME_COOKIE"))), (boolean)false);
    }

    public void setRememberMeCookieEnabled(Boolean isRememberMeCookieEnabled) {
        LOGGER.debug((Object)("is cookie enabled?:" + isRememberMeCookieEnabled));
        this.pluginSettings.put("miniorange.oauth.REMEMBERME_COOKIE", (Object)BooleanUtils.toString((Boolean)isRememberMeCookieEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getAppName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.DEFAULT_APP_NAME.getKey())), (CharSequence)"");
    }

    public String getAppHostedOn() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.APP_HOSTED_ON.getKey())), (CharSequence)"cloud");
    }

    public void setAppHostedOn(String appHostedOn) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.APP_HOSTED_ON.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)appHostedOn, (CharSequence)"cloud"))));
    }

    public void setAppName(String appName) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.DEFAULT_APP_NAME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)appName, (CharSequence)""))));
    }

    public String getClientID() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.CLIENT_ID.getKey())), (CharSequence)"");
    }

    public void setClientID(String clientID) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.CLIENT_ID.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)clientID, (CharSequence)""))));
    }

    public String getClientSecret() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.CLIENT_SECRET.getKey())), (CharSequence)"");
    }

    public void setClientSecret(String clientSecret) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.CLIENT_SECRET.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)clientSecret, (CharSequence)""))));
    }

    public void setCustomizableCallbackURL(String customizableCallbackURL) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.CUSTOMIZABLE_CALLBACK_URL.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customizableCallbackURL, (CharSequence)""))));
    }

    public String getCustomizableCallbackURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.CUSTOMIZABLE_CALLBACK_URL.getKey())), (CharSequence)"");
    }

    public String getScope() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.SCOPE.getKey())), (CharSequence)"");
    }

    public void setScope(String scope) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.SCOPE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)scope, (CharSequence)""))));
    }

    public String getAuthorizeEndpoint() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.AUTHORIZE_END_POINT.getKey())), (CharSequence)"");
    }

    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.AUTHORIZE_END_POINT.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)authorizeEndpoint, (CharSequence)""))));
    }

    public String getAccessTokenEndpoint() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.ACCESS_TOKEN_END_POINT.getKey())), (CharSequence)"");
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.ACCESS_TOKEN_END_POINT.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)accessTokenEndpoint, (CharSequence)""))));
    }

    public String getUserInfoEndpoint() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.USER_INFO_END_POINT.getKey())), (CharSequence)"");
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.USER_INFO_END_POINT.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)userInfoEndpoint, (CharSequence)""))));
    }

    public String getFetchGroupsEndpoint() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.FETCH_GROUPS_ENDPOINT.getKey())), (CharSequence)"");
    }

    public void setOauth_request_parameters(HashMap<String, String> oauth_request_parameters) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.OAUTH_REQUEST_PARAMETERS.getKey(), oauth_request_parameters);
    }

    public HashMap<String, String> getOauth_request_parameters() {
        Object oauth_request_parameters = this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.OAUTH_REQUEST_PARAMETERS.getKey());
        if (oauth_request_parameters != null) {
            return (HashMap)oauth_request_parameters;
        }
        return new HashMap<String, String>();
    }

    public void setFetchGroupsEndpoint(String groupApi) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.FETCH_GROUPS_ENDPOINT.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupApi, (CharSequence)""))));
    }

    public void setDomainName(String domainName) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.DOMAIN_NAME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)domainName, (CharSequence)""))));
    }

    public String getDomainName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.DOMAIN_NAME.getKey())), (CharSequence)"");
    }

    public void setHostName(String hostName) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.HOST_NAME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)hostName, (CharSequence)""))));
    }

    public String getHostName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.HOST_NAME.getKey())), (CharSequence)"");
    }

    public void setRealmName(String realmName) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.REALM_NAME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)realmName, (CharSequence)""))));
    }

    public String getRealmName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.REALM_NAME.getKey())), (CharSequence)"");
    }

    public Boolean getUseStateParameter() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.USE_STATE_PARAMETER.getKey()))), (boolean)false);
    }

    public void setUseStateParameter(Boolean useStateParameter) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.USE_STATE_PARAMETER.getKey(), (Object)BooleanUtils.toString((Boolean)useStateParameter, (String)"true", (String)"false", (String)"false"));
    }

    public String getCheckIssuerFor() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.CHECK_ISSUER_FOR.getKey())), (CharSequence)"Default");
    }

    public void setCheckIssuerFor(String checkIssuerFor) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.CHECK_ISSUER_FOR.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)checkIssuerFor, (CharSequence)"Default"))));
    }

    public String getCustomIssuerValue() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.CUSTOM_ISSUER_VALUE.getKey())), (CharSequence)"");
    }

    public void setCustomIssuerValue(String customIssuerValue) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.CUSTOM_ISSUER_VALUE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customIssuerValue, (CharSequence)""))));
    }

    public Boolean getEnableCheckIssuerFor() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.ENABLE_CHECK_ISSUER_FOR.getKey()))), (boolean)false);
    }

    public void setEnableCheckIssuerFor(Boolean enableCheckIssuerFor) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.ENABLE_CHECK_ISSUER_FOR.getKey(), (Object)BooleanUtils.toString((Boolean)enableCheckIssuerFor, (String)"true", (String)"false", (String)"false"));
    }

    public String getGoogleRefreshToken() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.oauth.GOOGLE_REFRESH_TOKEN")), (CharSequence)"");
    }

    public void setGoogleRefreshToken(String refreshToken) {
        this.pluginSettings.put("miniorange.oauth.GOOGLE_REFRESH_TOKEN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)refreshToken, (CharSequence)""))));
    }

    public Boolean getResetSettings() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.oauth.RESET_SETTINGS"))), (boolean)false);
    }

    public void setResetSettings(Boolean resetSettings) {
        this.pluginSettings.put("miniorange.oauth.RESET_SETTINGS", (Object)BooleanUtils.toString((Boolean)resetSettings, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsTestIDPConfigurationClicked() {
        String isTestIDPConfigurationClicked = (String)this.pluginSettings.get("miniorange.oauth.IS_TEST_CONFIGURATION_CLICKED");
        if (BooleanUtils.toBoolean((String)isTestIDPConfigurationClicked)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setIsTestIDPConfigurationClicked(Boolean isTestIDPConfigurationClicked) {
        this.pluginSettings.put("miniorange.oauth.IS_TEST_CONFIGURATION_CLICKED", (Object)BooleanUtils.toString((Boolean)isTestIDPConfigurationClicked, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsVerifyCredentialsClicked() {
        String isVerifyCredentialsClicked = (String)this.pluginSettings.get("miniorange.oauth.IS_VERIFY_CREDENTIALS_CLICKED");
        if (BooleanUtils.toBoolean((String)isVerifyCredentialsClicked)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setIsVerifyCredentialsClicked(Boolean isVerifyCredentialsClicked) {
        this.pluginSettings.put("miniorange.oauth.IS_VERIFY_CREDENTIALS_CLICKED", (Object)BooleanUtils.toString((Boolean)isVerifyCredentialsClicked, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsCredentialsVerified() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.oauth.IS_CREDENTIALS_VERIFIED"))), (boolean)false);
    }

    public void setIsCredentialsVerified(Boolean isCredentialsVerified) {
        this.pluginSettings.put("miniorange.oauth.IS_CREDENTIALS_VERIFIED", (Object)BooleanUtils.toString((Boolean)isCredentialsVerified, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getKeepExistingUserAttributes() {
        if (this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.DISABLE_ATTRIBUTE_MAPPING.getKey()) == null) {
            return true;
        }
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.DISABLE_ATTRIBUTE_MAPPING.getKey()))), (boolean)true);
    }

    public void setKeepExistingUserAttributes(Boolean keepExistingUserAttributes) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.DISABLE_ATTRIBUTE_MAPPING.getKey(), (Object)BooleanUtils.toString((Boolean)keepExistingUserAttributes, (String)"true", (String)"false", (String)"false"));
    }

    public void setLoginUserAttribute(String loginUserAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.LOGIN_USER_BY_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserAttribute, (CharSequence)"username"))));
    }

    public String getLoginUserAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.LOGIN_USER_BY_ATTRIBUTE.getKey())), (CharSequence)"username");
    }

    public String getUsernameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.USERNAME_ATTRIBUTE.getKey())), (CharSequence)"");
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.USERNAME_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)""))));
    }

    public Boolean getRegexPatternEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.ENABLE_REGEX_PATTERN.getKey()))), (boolean)false);
    }

    public void setRegexPatternEnabled(Boolean regexPatternEnabled) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.ENABLE_REGEX_PATTERN.getKey(), (Object)BooleanUtils.toString((Boolean)regexPatternEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.REGEX_PATTERN.getKey())), (CharSequence)"");
    }

    public void setRegexPattern(String regexPattern) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.REGEX_PATTERN.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPattern, (CharSequence)""))));
    }

    public String getEmailAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.EMAIL_ATTRIBUTE.getKey())), (CharSequence)"");
    }

    public void setEmailAttribute(String emailAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.EMAIL_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)""))));
    }

    public Boolean getExcludeGroupsRegexPattern() {
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.EXCLUDE_GROUPS_REGEX_PATTERN.getKey())), (CharSequence)"false")));
    }

    public void setExcludeGroupsRegexPattern(Boolean excludeGroupsRegexPattern) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.EXCLUDE_GROUPS_REGEX_PATTERN.getKey(), (Object)BooleanUtils.toString((Boolean)excludeGroupsRegexPattern, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPatternForExcludeGroups() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.REGEX_PATTERN_FOR_EXCLUDE_GROUPS.getKey())), (CharSequence)"");
    }

    public void setRegexPatternForExcludeGroups(String regexPatternForExcludeGroups) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.REGEX_PATTERN_FOR_EXCLUDE_GROUPS.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPatternForExcludeGroups, (CharSequence)""))));
    }

    public String getFullNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.FULL_NAME_ATTRIBUTE.getKey())), (CharSequence)"");
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.FULL_NAME_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""))));
    }

    public Boolean getUseSeparateNameAttributes() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.USE_SEPARATE_NAME_ATTRIBUTE.getKey()))), (boolean)false);
    }

    public void setUseSeparateNameAttributes(Boolean useSeparateNameAttributes) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.USE_SEPARATE_NAME_ATTRIBUTE.getKey(), (Object)BooleanUtils.toString((Boolean)useSeparateNameAttributes, (String)"true", (String)"false", (String)"false"));
    }

    public String getFirstNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.FIRST_NAME_ATTRIBUTE.getKey())), (CharSequence)"");
    }

    public void setFirstNameAttribute(String firstNameAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.FIRST_NAME_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)firstNameAttribute, (CharSequence)""))));
    }

    public String getLastNameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.AttributeMapping.LAST_NAME_ATTRIBUTE.getKey())), (CharSequence)"");
    }

    public void setLastNameAttribute(String lastNameAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.AttributeMapping.LAST_NAME_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)lastNameAttribute, (CharSequence)""))));
    }

    public void setRestrictUserCreation(Boolean restrictUserCreation) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.DISABLE_USER_CREATION.getKey(), (Object)BooleanUtils.toString((Boolean)restrictUserCreation, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRestrictUserCreation() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.DISABLE_USER_CREATION.getKey()))), (boolean)false);
    }

    public String getDefaultGroup() {
        String defaultGroup = (String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.DEFAULT_GROUP.getKey());
        if (StringUtils.isBlank((CharSequence)defaultGroup)) {
            defaultGroup = "";
            ArrayList<String> existingGroups = new ArrayList<String>();
            Pager groupObjects = this.bambooUserManager.getGroups();
            for (Group group : groupObjects) {
                existingGroups.add(group.getName());
            }
            defaultGroup = existingGroups.contains(this.bambooPermissionManager.getDefaultUsersGroup()) ? this.bambooPermissionManager.getDefaultUsersGroup() : (existingGroups.size() > 1 ? (String)existingGroups.get(1) : (String)existingGroups.get(0));
            LOGGER.debug((Object)("Default Group is " + defaultGroup));
        }
        return StringUtils.defaultString((String)defaultGroup, (String)"");
    }

    public void setDefaultGroup(String defaultGroup) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.DEFAULT_GROUP.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)defaultGroup, (CharSequence)"bamboo-admin"))));
    }

    public List<String> getDefaultGroupsList() {
        LOGGER.info((Object)"OAuth Settings getDefaultGroupsList Called..");
        ArrayList<String> defaultGroups = (ArrayList<String>)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.DEFAULT_GROUPS.getKey());
        if (defaultGroups == null || defaultGroups.isEmpty()) {
            defaultGroups = new ArrayList<String>();
            ArrayList<Group> existingGroups = new ArrayList<Group>();
            Pager groupObjects = this.bambooUserManager.getGroups();
            for (Group group : groupObjects) {
                existingGroups.add(group);
                if (!StringUtils.containsIgnoreCase((CharSequence)group.getName(), (CharSequence)"bamboo")) continue;
                defaultGroups.add(group.getName());
            }
            if (defaultGroups.size() == 0) {
                if (existingGroups.size() > 1) {
                    defaultGroups.add(((Group)existingGroups.get(1)).getName());
                } else {
                    defaultGroups.add(((Group)existingGroups.get(0)).getName());
                }
            }
            LOGGER.debug((Object)("Default Groups are " + ((Object)defaultGroups).toString()));
        }
        return defaultGroups;
    }

    public void setDefaultGroupsList(List<String> defaultGroups) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.DEFAULT_GROUPS.getKey(), defaultGroups);
    }

    public void setEnableDefaultGroupsFor(String enableDefaultGroupsFor) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ASSIGN_DEFAULT_GROUP_TO.getKey(), (Object)StringUtils.defaultIfEmpty((CharSequence)enableDefaultGroupsFor, (CharSequence)"newUsers"));
    }

    public String getEnableDefaultGroupsFor() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ASSIGN_DEFAULT_GROUP_TO.getKey())), (CharSequence)"newUsers");
    }

    public void setOnTheFlyGroupMapping(Boolean createUsersIfRoleMapped) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_GROUP_MAPPING.getKey(), (Object)BooleanUtils.toString((Boolean)createUsersIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyGroupMapping() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_GROUP_MAPPING.getKey()))), (boolean)false);
    }

    public Boolean getKeepExistingUserRoles() {
        if (this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.DISABLE_GROUP_MAPPING.getKey()) == null) {
            return true;
        }
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.DISABLE_GROUP_MAPPING.getKey()))), (boolean)true);
    }

    public void setKeepExistingUserRoles(Boolean keepExistingUserRoles) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.DISABLE_GROUP_MAPPING.getKey(), (Object)BooleanUtils.toString((Boolean)keepExistingUserRoles, (String)"true", (String)"false", (String)"false"));
    }

    public String getRoleAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.GROUP_ATTRIBUTE.getKey())), (CharSequence)"");
    }

    public void setRoleAttribute(String roleAttribute) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.GROUP_ATTRIBUTE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)roleAttribute, (CharSequence)""))));
    }

    public String getOnTheFlyFilterIDPGroupsOption() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION.getKey())), (CharSequence)"None");
    }

    public void setOnTheFlyFilterIDPGroupsOption(String onTheFlyFilterIDPGroupsOption) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)onTheFlyFilterIDPGroupsOption, (CharSequence)"None"))));
    }

    public String getOnTheFlyFilterIDPGroupsKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_FILTER_IDP_GROUPS_KEY.getKey())), (CharSequence)"");
    }

    public void setOnTheFlyFilterIDPGroupsKey(String onTheFlyFilterIDPGroupsKey) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_FILTER_IDP_GROUPS_KEY.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)onTheFlyFilterIDPGroupsKey, (CharSequence)""))));
    }

    public Boolean getCreateUsersIfRoleMapped() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.CREATE_USER_IF_ROLE_MAPPED.getKey()))), (boolean)false);
    }

    public void setCreateUsersIfRoleMapped(Boolean createUsersIfRoleMapped) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.CREATE_USER_IF_ROLE_MAPPED.getKey(), (Object)BooleanUtils.toString((Boolean)createUsersIfRoleMapped, (String)"true", (String)"false", (String)"false"));
    }

    public void setRoleMapping(HashMap<String, String> roleMapping) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ROLE_MAPPING.getKey(), roleMapping);
    }

    public HashMap<String, String> getRoleMapping() {
        Object roleMapping = this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ROLE_MAPPING.getKey());
        if (roleMapping != null) {
            return (HashMap)roleMapping;
        }
        return new HashMap<String, String>();
    }

    public void setOnTheFlyCreateNewGroups(Boolean onTheFlyCreateNewGroups) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_CREATE_NEW_GROUPS.getKey(), (Object)BooleanUtils.toString((Boolean)onTheFlyCreateNewGroups, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyCreateNewGroups() {
        String onTheFlyCreateNewGroups = (String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_CREATE_NEW_GROUPS.getKey());
        if (StringUtils.isBlank((CharSequence)onTheFlyCreateNewGroups)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)onTheFlyCreateNewGroups);
    }

    public void setOnTheFlyAssignNewGroupsOnly(Boolean onTheFlyAssignNewGroupsOnly) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_KEEP_EXISTING_USERS_GROUPS.getKey(), (Object)BooleanUtils.toString((Boolean)onTheFlyAssignNewGroupsOnly, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getOnTheFlyAssignNewGroupsOnly() {
        String onTheFlyAssignNewGroupsOnly = (String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_KEEP_EXISTING_USERS_GROUPS.getKey());
        if (StringUtils.isBlank((CharSequence)onTheFlyAssignNewGroupsOnly)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)onTheFlyAssignNewGroupsOnly);
    }

    public Object getOnTheFlyDoNotRemoveGroups() {
        if (this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_EXCLUDE_GROUPS.getKey()) != null) {
            return this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_EXCLUDE_GROUPS.getKey());
        }
        return new ArrayList();
    }

    public void setOnTheFlyDoNotRemoveGroups(List<String> groups) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.ON_THE_FLY_EXCLUDE_GROUPS.getKey(), groups);
    }

    public Boolean getDefaultLoginDisabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.DISABLE_DEFAULT_LOGIN.getKey())));
    }

    public void setDefaultLoginDisabled(Boolean defaultLoginDisabled) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.DISABLE_DEFAULT_LOGIN.getKey(), (Object)BooleanUtils.toString((Boolean)defaultLoginDisabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getLoginButtonText() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.LOGIN_BUTTON_TEXT.getKey())), (CharSequence)"Use OAuth Login");
    }

    public void setLoginButtonText(String loginButtonText) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.LOGIN_BUTTON_TEXT.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginButtonText, (CharSequence)"Use OAuth Login"))));
    }

    public String getSsoButtonLocation() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.SSO_BUTTON_LOCATION.getKey())), (CharSequence)"After Login Button");
    }

    public void setSsoButtonLocation(String ssoButtonLocation) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.SSO_BUTTON_LOCATION.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)ssoButtonLocation, (CharSequence)"After Login Button"))));
    }

    public void setRelayState(String relayState) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.RELAY_STATE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)relayState, (CharSequence)""))));
    }

    public String getRelayState() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.RELAY_STATE.getKey())), (CharSequence)"");
    }

    public Boolean getBackdoorEnabled() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_BACKDOOR.getKey())));
    }

    public void setBackdoorEnabled(Boolean backdoorEnabled) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_BACKDOOR.getKey(), (Object)BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRestrictBackdoor() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.RESTRICT_BACKDOOR.getKey())));
    }

    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.RESTRICT_BACKDOOR.getKey(), (Object)BooleanUtils.toString((Boolean)restrictBackdoor, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getBackdoorGroups() {
        ArrayList<String> backdoorGroups = (ArrayList<String>)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.BACKDOOR_GROUPS.getKey());
        if (backdoorGroups == null) {
            backdoorGroups = new ArrayList<String>();
            backdoorGroups.addAll(this.bambooPermissionManager.getAdminGroups());
        } else if (backdoorGroups.size() == 0) {
            backdoorGroups.addAll(this.bambooPermissionManager.getAdminGroups());
        }
        return backdoorGroups;
    }

    public void setBackdoorGroups(List<String> backdoorGroups) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.BACKDOOR_GROUPS.getKey(), backdoorGroups);
    }

    public List<String> convertArrayToList(String[] agentGroups) {
        ArrayList<String> agentGroupsList = new ArrayList<String>();
        if (agentGroups != null) {
            for (String agentGroup : agentGroups) {
                agentGroupsList.add(agentGroup);
            }
        }
        return agentGroupsList;
    }

    public void setBackdoorKey(String backdoorKey) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.BACKDOOR_KEY.getKey(), (Object)StringUtils.defaultIfBlank((CharSequence)backdoorKey, (CharSequence)"oauth_sso"));
    }

    public String getBackdoorKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.BACKDOOR_KEY.getKey())), (CharSequence)"oauth_sso");
    }

    public void setBackdoorValue(String backdoorValue) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.BACKDOOR_VALUE.getKey(), (Object)StringUtils.defaultIfBlank((CharSequence)backdoorValue, (CharSequence)"false"));
    }

    public String getBackdoorValue() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.BACKDOOR_VALUE.getKey())), (CharSequence)"false");
    }

    public Boolean getEnableAutoRedirectDelay() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_AUTO_REDIRECT_DELAY.getKey()))), (boolean)false);
    }

    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_AUTO_REDIRECT_DELAY.getKey(), (Object)BooleanUtils.toString((Boolean)enableAutoRedirectDelay, (String)"true", (String)"false", (String)"false"));
    }

    public String getAutoRedirectDelayInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.AUTO_REDIRECT_DELAY_INTERVAL.getKey())), (CharSequence)"5");
    }

    public void setAutoRedirectDelayInterval(String autoRedirectDelayInterval) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.AUTO_REDIRECT_DELAY_INTERVAL.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)autoRedirectDelayInterval, (CharSequence)""))));
    }

    public Boolean getEnableLoginTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_LOGIN_TEMPLATE.getKey()))), (boolean)false);
    }

    public void setEnableLoginTemplate(Boolean enableLoginTemplate) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_LOGIN_TEMPLATE.getKey(), (Object)BooleanUtils.toString((Boolean)enableLoginTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public String getLoginTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.LOGIN_TEMPLATE.getKey())), (CharSequence)LOGIN_TEMPLATE);
    }

    public void setLoginTemplate(String loginTemplate) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.LOGIN_TEMPLATE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)loginTemplate, (CharSequence)LOGIN_TEMPLATE))));
    }

    public void setEnableLogoutTemplate(Boolean enableLogoutTemplate) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_LOGOUT_TEMPLATE.getKey(), (Object)BooleanUtils.toString((Boolean)enableLogoutTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableLogoutTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_LOGOUT_TEMPLATE.getKey()))), (boolean)false);
    }

    public void setPluginApiAccessRestriction(Boolean pluginApiAccessRestriction) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.PLUGIN_API_ACCESS_RESTRICTION.getKey(), (Object)BooleanUtils.toString((Boolean)pluginApiAccessRestriction, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getPluginApiAccessRestriction() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.PLUGIN_API_ACCESS_RESTRICTION.getKey()))), (boolean)false);
    }

    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_ERROR_MSG_TEMPLATE.getKey(), (Object)BooleanUtils.toString((Boolean)enableErrorMsgTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableErrorMsgTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_ERROR_MSG_TEMPLATE.getKey()))), (boolean)false);
    }

    public Boolean getAllowPasswordReset() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ALLOW_PASSWORD_RESET.getKey()))), (boolean)true);
    }

    public void setAllowPasswordReset(Boolean allowPasswordReset) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ALLOW_PASSWORD_RESET.getKey(), (Object)BooleanUtils.toString((Boolean)allowPasswordReset, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableAutoLogin() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_AUTO_LOGIN.getKey()))), (boolean)false);
    }

    public void setEnableAutoLogin(Boolean enableAutoLogin) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_AUTO_LOGIN.getKey(), (Object)BooleanUtils.toString((Boolean)enableAutoLogin, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsAutoAttemptSuppProvider(String appName) {
        return StringUtils.equalsIgnoreCase((CharSequence)appName, (CharSequence)"Azure AD") || StringUtils.equalsIgnoreCase((CharSequence)appName, (CharSequence)"Azure B2C") || StringUtils.equalsIgnoreCase((CharSequence)appName, (CharSequence)"Keycloak") || StringUtils.equalsIgnoreCase((CharSequence)appName, (CharSequence)"Custom OAuth") || StringUtils.equalsIgnoreCase((CharSequence)appName, (CharSequence)"Custom OpenID");
    }

    public void setEnableForSoftware(Boolean enableForSoftware) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_SINGLE_SIGN_ON.getKey(), (Object)BooleanUtils.toString((Boolean)enableForSoftware, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableForSoftware() {
        String enableForSoftware = (String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_SINGLE_SIGN_ON.getKey());
        if (StringUtils.isBlank((CharSequence)enableForSoftware)) {
            return true;
        }
        return BooleanUtils.toBoolean((String)enableForSoftware);
    }

    public String getAllowedDomains() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ALLOWED_DOMAINS.getKey())), (CharSequence)"");
    }

    public void setAllowedDomains(String allowedDomains) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ALLOWED_DOMAINS.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)allowedDomains, (CharSequence)""))));
    }

    public void setLogoutTemplate(String logoutTemplate) {
        String encodedLogoutTemplate = Base64.getEncoder().encodeToString(logoutTemplate.getBytes());
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.LOGOUT_TEMPLATE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)encodedLogoutTemplate, (CharSequence)""))));
    }

    public String getLogoutTemplate() {
        String encodedLogoutTemplate = (String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.LOGOUT_TEMPLATE.getKey());
        if (StringUtils.isNotBlank((CharSequence)encodedLogoutTemplate)) {
            encodedLogoutTemplate = new String(Base64.getDecoder().decode(encodedLogoutTemplate));
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)encodedLogoutTemplate, (CharSequence)LOGOUT_TEMPLATE);
    }

    public void setCustomLogoutURL(String customLogoutURL) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.CUSTOM_LOGOUT_URL.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customLogoutURL, (CharSequence)""))));
    }

    public String getCustomLogoutURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.CUSTOM_LOGOUT_URL.getKey())), (CharSequence)"");
    }

    public void setErrorMsgTemplate(String errorMsgTemplate) {
        String encodedErrorMsgTemplate = Base64.getEncoder().encodeToString(errorMsgTemplate.getBytes());
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ERROR_MSG_TEMPLATE.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)encodedErrorMsgTemplate, (CharSequence)""))));
    }

    public String getErrorMsgTemplate() {
        String encodedLogoutTemplate = (String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ERROR_MSG_TEMPLATE.getKey());
        if (StringUtils.isNotBlank((CharSequence)encodedLogoutTemplate)) {
            encodedLogoutTemplate = new String(Base64.getDecoder().decode(encodedLogoutTemplate));
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)encodedLogoutTemplate, (CharSequence)ERRORMSG_TEMPLATE);
    }

    public void setAccessToken(String accessToken) {
        this.pluginSettings.put("miniorange.oauth.ACCESS_TOKEN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)accessToken, (CharSequence)""))));
    }

    public void setConfigurationStatus(String status) {
        this.pluginSettings.put("miniorange.oauth.CONFIGURATION_STATUS", (Object)StringUtils.defaultIfBlank((CharSequence)status, (CharSequence)""));
    }

    public String getConfigurationStatus() {
        return (String)this.pluginSettings.get("miniorange.oauth.CONFIGURATION_STATUS");
    }

    public String getAccessToken() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.oauth.ACCESS_TOKEN")), (CharSequence)"");
    }

    public String getRefreshToken() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.oauth.REFRESH_TOKEN")), (CharSequence)"");
    }

    public void setRefreshToken(String refreshToken) {
        this.pluginSettings.put("miniorange.oauth.REFRESH_TOKEN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)refreshToken, (CharSequence)""))));
    }

    public void setReturnUrl(String returnUrl) {
        this.pluginSettings.put("miniorange.oauth.RETURN_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)returnUrl, (CharSequence)""))));
    }

    public String getReturnUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.oauth.RETURN_URL")), (CharSequence)"");
    }

    public void setTenantID(String tenantID) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.TENANT_ID.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)tenantID, (CharSequence)""))));
    }

    public String getTenantID() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.TENANT_ID.getKey())), (CharSequence)"");
    }

    public void setUserInfoMap(HashMap<String, String> userInfoMap) {
        this.pluginSettings.put("miniorange.oauth.USER_INFO_MAP", userInfoMap);
    }

    public HashMap<String, String> getUserInfoMap() {
        Object userInfoMap = this.pluginSettings.get("miniorange.oauth.USER_INFO_MAP");
        if (userInfoMap != null) {
            return (HashMap)userInfoMap;
        }
        return new HashMap<String, String>();
    }

    public String getSingleLogoutURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.oauth.SINGLE_LOGOUT_URL")), (CharSequence)"");
    }

    public void setSingleLogoutURL(String singleLogoutURL) {
        this.pluginSettings.put("miniorange.oauth.SINGLE_LOGOUT_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)singleLogoutURL, (CharSequence)""))));
    }

    public String getPublicKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.PUBLIC_KEY.getKey())), (CharSequence)"");
    }

    public void setPublicKey(String publicKey) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.PUBLIC_KEY.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)publicKey, (CharSequence)""))));
    }

    public Boolean getNonceCheck() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.NONCE_VALIDATION.getKey()))), (boolean)false);
    }

    public void setNonceCheck(Boolean nonceCheck) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.NONCE_VALIDATION.getKey(), (Object)BooleanUtils.toString((Boolean)nonceCheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getACRValueCheck() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.ACR_VALUE_CHECK.getKey()))), (boolean)false);
    }

    public void setACRValueCheck(Boolean acrValueCheck) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.ACR_VALUE_CHECK.getKey(), (Object)BooleanUtils.toString((Boolean)acrValueCheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnablePKCESupport() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.ENABLE_PKCE_SUPPORT.getKey()))), (boolean)false);
    }

    public void setEnablePKCESupport(Boolean enablePKCESupport) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.ENABLE_PKCE_SUPPORT.getKey(), (Object)BooleanUtils.toString((Boolean)enablePKCESupport, (String)"true", (String)"false", (String)"false"));
    }

    public String getSendTokenAuthParameterIn() {
        String Parmeter = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.OAuthConfiguration.SEND_TOKEN_AUTHORIZATION_PARAMETERS_IN.getKey())), (CharSequence)"HttpBody");
        return Parmeter != null ? Parmeter : "HttpBody";
    }

    public void setSendTokenAuthParameterIn(String sendTokenAuthParameterIn) {
        this.pluginSettings.put(MoOAuthPluginConstants.OAuthConfiguration.SEND_TOKEN_AUTHORIZATION_PARAMETERS_IN.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)sendTokenAuthParameterIn, (CharSequence)"HttpBody"))));
    }

    public AdministrationConfigurationAccessor getAdministrationConfigurationAccessor() {
        return this.administrationConfigurationAccessor;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public BambooPermissionManager getBambooPermissionManager() {
        return this.bambooPermissionManager;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public String getPluginVersion() {
        String pluginKey = this.pluginLicenseManager.getPluginKey();
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        return plugin.getPluginInformation().getVersion();
    }

    public String getPluginName() {
        String pluginKey = this.pluginLicenseManager.getPluginKey();
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        return plugin.getName();
    }

    public String getServerVersion() {
        return BuildUtils.getCurrentVersion();
    }

    public void deleteKey(String constantKey) {
        this.pluginSettings.remove(constantKey);
    }

    public void clearPluginSettings() {
        this.pluginSettings.remove("miniorange.oauth.USER_INFO_MAP");
        this.pluginSettings.remove("miniorange.oauth.IS_TEST_CONFIGURATION_CLICKED");
        this.pluginSettings.remove("miniorange.oauth.IS_VERIFY_CREDENTIALS_CLICKED");
        this.pluginSettings.remove("miniorange.oauth.REFRESH_TOKEN");
        this.pluginSettings.remove("miniorange.oauth.ACCESS_TOKEN");
        this.pluginSettings.remove("miniorange.oauth.IS_CREDENTIALS_VERIFIED");
        this.pluginSettings.remove("miniorange.oauth.RETURN_URL");
        this.pluginSettings.remove("miniorange.oauth.GOOGLE_REFRESH_TOKEN");
        this.resetOAuthConfig();
        this.resetAttributeMapping();
        this.resetGroupMapping();
        this.resetSignOnSettings();
    }

    public void resetOAuthConfig() {
        LOGGER.debug((Object)"resetOAuthConfig called ");
        for (MoOAuthPluginConstants.OAuthConfiguration constant : MoOAuthPluginConstants.OAuthConfiguration.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetAttributeMapping() {
        LOGGER.debug((Object)"resetAttributeMapping called ");
        for (MoOAuthPluginConstants.AttributeMapping constant : MoOAuthPluginConstants.AttributeMapping.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetGroupMapping() {
        LOGGER.debug((Object)"resetGroupMapping called ");
        for (MoOAuthPluginConstants.GroupMapping constant : MoOAuthPluginConstants.GroupMapping.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetSignOnSettings() {
        LOGGER.debug((Object)"resetSignOnSettings called ");
        for (MoOAuthPluginConstants.SignInSettings constant : MoOAuthPluginConstants.SignInSettings.values()) {
            this.resetConfig(constant.getKey());
        }
    }

    public void resetConfig(String constantKey) {
        this.pluginSettings.remove(constantKey);
    }

    public Boolean getGroupRegexPatternEnabled() {
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.GROUP_REGEX_PATTERN_ENABLED.getKey())), (CharSequence)"false")));
    }

    public void setGroupRegexPatternEnabled(Boolean groupRegexPatternEnabled) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.GROUP_REGEX_PATTERN_ENABLED.getKey(), (Object)BooleanUtils.toString((Boolean)groupRegexPatternEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPatternForGroup() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.REGEX_PATTERN_FOR_GROUP.getKey())), (CharSequence)"");
    }

    public void setRegexPatternForGroup(String regexPatternForGroup) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.REGEX_PATTERN_FOR_GROUP.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPatternForGroup, (CharSequence)""))));
    }

    public String getRegexGroups() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.REGEX_GROUPS.getKey())), (CharSequence)"");
    }

    public void setRegexGroups(String regexGroups) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.REGEX_GROUPS.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexGroups, (CharSequence)""))));
    }

    public String getTestRegex() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoOAuthPluginConstants.GroupMapping.TEST_REGEX.getKey())), (CharSequence)"");
    }

    public void setTestRegex(String testRegex) {
        this.pluginSettings.put(MoOAuthPluginConstants.GroupMapping.TEST_REGEX.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)testRegex, (CharSequence)""))));
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoOAuthPluginConstants.SignInSettings.ENABLE_DEBUG_LOGS.getKey())));
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put(MoOAuthPluginConstants.SignInSettings.ENABLE_DEBUG_LOGS.getKey(), (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    static {
        try {
            String ERRORMSG_TEMPLATE_PATH = "/templates/errorMsgTemplate.ftl";
            ERRORMSG_TEMPLATE = IOUtils.toString(MoOAuthSettings.class.getResourceAsStream("/templates/errorMsgTemplate.ftl"), "UTF-8");
            String LOGIN_TEMPLATE_PATH = "/templates/loginTemplate.ftl";
            String LOGOUT_TEMPLATE_PATH = "/templates/logoutTemplate.ftl";
            LOGIN_TEMPLATE = IOUtils.toString(MoOAuthSettings.class.getResourceAsStream("/templates/loginTemplate.ftl"), "UTF-8");
            LOGOUT_TEMPLATE = IOUtils.toString(MoOAuthSettings.class.getResourceAsStream("/templates/logoutTemplate.ftl"), "UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)"An I/O error occurred while initializing the Settings.", (Throwable)e);
        }
        isPluginConfigurationFileUploaded = Boolean.FALSE;
    }
}

