/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.service;

import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationClientService {
    private final Logger LOGGER = LoggerFactory.getLogger(OAuthAuthorizationClientService.class);
    private MoOAuthSettings moOAuthSettings;

    public void buildAuthorizationRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, MoOAuthSettings settings, Boolean isAttemptAutoLoginRequest) throws UnsupportedEncodingException, IOException {
        this.LOGGER.debug("Building Authorization Request");
        try {
            String CLIENT_ID = settings.getClientID();
            String SCOPE = settings.getScope();
            String RESPONSE_TYPE = "code";
            String REDIRECT_URI = isAttemptAutoLoginRequest != false ? settings.getAutoCallBackUrl() : settings.getCallBackUrl() + settings.getCustomizableCallbackURL();
            Boolean nonceCheck = settings.getNonceCheck();
            Boolean acrValueCheck = settings.getACRValueCheck();
            Boolean useStateParameter = settings.getUseStateParameter();
            HashMap<String, String> oauth_request_parameters = settings.getOauth_request_parameters();
            Boolean oauthParameterCheck = !oauth_request_parameters.isEmpty();
            StringBuilder AUTHORIZE_ENDPOINT = new StringBuilder(settings.getAuthorizeEndpoint());
            if (StringUtils.equals((CharSequence)settings.getAppName(), (CharSequence)"Keycloak")) {
                SCOPE = "openid";
            }
            if (AUTHORIZE_ENDPOINT.indexOf("?") > -1) {
                AUTHORIZE_ENDPOINT.append("&");
            } else {
                AUTHORIZE_ENDPOINT.append("?");
            }
            AUTHORIZE_ENDPOINT.append("client_id=").append(CLIENT_ID).append("&scope=").append(URLEncoder.encode(SCOPE, "UTF-8")).append("&redirect_uri=").append(URLEncoder.encode(REDIRECT_URI, "UTF-8")).append("&response_type=").append(RESPONSE_TYPE).append("&access_type=offline").append("&include_granted_scopes=true");
            if (isAttemptAutoLoginRequest.booleanValue()) {
                AUTHORIZE_ENDPOINT.append("&prompt=none");
            }
            this.LOGGER.debug("Nonce Check : " + nonceCheck);
            this.LOGGER.debug("ACR Value Check : " + acrValueCheck);
            if (StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OAuth") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OpenID") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Okta") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"miniOrange") || useStateParameter.booleanValue() || nonceCheck.booleanValue() || acrValueCheck.booleanValue() || oauthParameterCheck.booleanValue()) {
                if (nonceCheck.booleanValue()) {
                    this.LOGGER.debug("send nonce in the request");
                    this.passNonceInRequest(request, AUTHORIZE_ENDPOINT);
                }
                if (acrValueCheck.booleanValue()) {
                    this.LOGGER.debug("send acr_values parameter in the request");
                    this.passACRValueParameterInRequest(request, AUTHORIZE_ENDPOINT);
                }
                if (useStateParameter.booleanValue() || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"OKTA")) {
                    this.LOGGER.debug("send state parameter in the request");
                    this.passStateParameterValue(request, AUTHORIZE_ENDPOINT);
                }
                if (oauthParameterCheck.booleanValue()) {
                    this.LOGGER.debug("send Oauth request parameters in the request");
                    this.passOauthParametersInRequest(request, AUTHORIZE_ENDPOINT, oauth_request_parameters);
                }
            }
            this.LOGGER.debug("OAuth CODE request generated");
            MoOAuthManager.httpRedirect(response, AUTHORIZE_ENDPOINT.toString());
        }
        catch (Exception e) {
            this.LOGGER.error("Error " + e);
        }
    }

    private void passNonceInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT) {
        String nonce = this.randomAlphaNumeric(10);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("nonce", (Object)nonce);
        AUTHORIZE_ENDPOINT.append("&nonce=").append(nonce);
    }

    private void passACRValueParameterInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT) {
        String acrValueParameter = this.randomAlphaNumeric(10);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("acr_values", (Object)acrValueParameter);
        AUTHORIZE_ENDPOINT.append("&acr_values=").append(acrValueParameter);
    }

    private void passOauthParametersInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT, Map<String, String> oauth_request_parameters) {
        HttpSession httpSession = request.getSession();
        for (Map.Entry<String, String> entry : oauth_request_parameters.entrySet()) {
            httpSession.setAttribute(entry.getKey(), (Object)entry.getValue());
            AUTHORIZE_ENDPOINT.append("&" + entry.getKey() + "=").append(entry.getValue());
        }
    }

    private void passStateParameterValue(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT) {
        String stateParameterValue = this.randomAlphaNumeric(10);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("state_attribute_parameter", (Object)stateParameterValue);
        AUTHORIZE_ENDPOINT.append("&state=").append(stateParameterValue);
    }

    private String randomAlphaNumeric(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }
}

