/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthLogoutFilter
implements Filter {
    private MoOAuthSettings settings;
    private MoOAuthManager oauthManager;
    private TemplateRenderer renderer;
    private static Log LOGGER = LogFactory.getLog(MoOAuthLogoutFilter.class);

    public MoOAuthLogoutFilter(MoOAuthSettings settings, MoOAuthManager oAuthManager, TemplateRenderer renderer) {
        this.settings = settings;
        this.oauthManager = oAuthManager;
        this.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        HttpSession session = req.getSession();
        Cookie logoutCookie = MoOAuthHttpUtils.getCookie("mo.bamboo-oauth.logoutcookie", req);
        if (logoutCookie != null) {
            MoOAuthHttpUtils.removeCookie("mo.bamboo-oauth.logoutcookie", req, res);
            if (StringUtils.isNotEmpty((CharSequence)this.settings.getSingleLogoutURL())) {
                LOGGER.debug((Object)("Redirect to single logout url: " + this.settings.getSingleLogoutURL()));
                session.invalidate();
                MoOAuthManager.httpRedirect(res, this.settings.getSingleLogoutURL());
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.settings.getCustomLogoutURL())) {
                session.invalidate();
                MoOAuthManager.httpRedirect(res, this.settings.getCustomLogoutURL());
                return;
            }
            if (this.settings.getEnableLogoutTemplate().booleanValue()) {
                session.invalidate();
                this.redirectToLogoutTemplate(res);
                return;
            }
            MoOAuthHttpUtils.removeCookie("mo.bamboo-oauth.logoutcookie", req, res);
            session.invalidate();
            MoOAuthManager.httpRedirect(res, this.settings.getBaseUrl());
            return;
        }
        MoOAuthHttpUtils.removeCookie("mo.bamboo-oauth.logoutcookie", req, res);
        session.invalidate();
        MoOAuthManager.httpRedirect(res, this.settings.getBaseUrl());
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private void redirectToLogoutTemplate(HttpServletResponse response) throws IOException {
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("baseURL", this.settings.getBaseUrl());
            StringBuffer result = new StringBuffer(this.renderer.renderFragment(this.settings.getLogoutTemplate(), context));
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            MoOAuthManager.httpRedirect(response, this.settings.getLoginPageUrl());
        }
    }
}

