/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthRedirectFilter
implements Filter {
    private MoOAuthSettings settings;
    private MoOAuthManager oauthManager;
    private static Log LOGGER = LogFactory.getLog(MoOAuthRedirectFilter.class);

    public MoOAuthRedirectFilter(MoOAuthSettings settings, MoOAuthManager oauthManager) {
        this.settings = settings;
        this.oauthManager = oauthManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        LOGGER.info((Object)"OAuth SSO Redirect Filter Called");
        if (this.settings.getDefaultLoginDisabled().booleanValue() && !this.settings.getEnableAutoRedirectDelay().booleanValue()) {
            if (req.getParameter("oauth_sso") != null && req.getParameter("oauth_sso").equals("false")) {
                chain.doFilter(request, response);
                return;
            }
            String oauthUrl = req.getContextPath() + "/plugins/servlet/oauth/auth";
            String osDestination = req.getParameter("os_destination");
            if (StringUtils.isNotBlank((CharSequence)StringUtils.trim((String)osDestination)) && !StringUtils.equals((CharSequence)osDestination, (CharSequence)"/")) {
                if (osDestination.indexOf("/") != 0) {
                    osDestination = "/" + osDestination;
                }
                oauthUrl = oauthUrl + "?return_to=" + URLEncoder.encode(osDestination, "UTF-8");
            }
            MoOAuthManager.httpRedirect((HttpServletResponse)response, oauthUrl);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

