/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.bamboo.util.HtmlUtils;
import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthLoginServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoOAuthLoginServlet.class);
    private MoOAuthSettings settings;

    public MoOAuthLoginServlet(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug((Object)"OAuth Authentication Servlet doGet() called...");
        String relayState = MoOAuthUtils.sanitizeRegex(request.getParameter("return_to"));
        LOGGER.debug((Object)("relayState is " + relayState));
        String referer = MoOAuthUtils.sanitizeText(request.getHeader("referer"));
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getBaseUrl())) {
            LOGGER.error((Object)"Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
            response.sendError(403, "Access Denied. You are not allowed to access this page.");
            return;
        }
        if (StringUtils.equals((CharSequence)relayState, (CharSequence)"testoauthconfiguration")) {
            MoOAuthHttpUtils.setCookie("test_configuration_in_use", "mo_test_configurations", response);
        } else {
            MoOAuthHttpUtils.removeCookie("test_configuration_in_use", request, response);
        }
        if (StringUtils.equals((CharSequence)relayState, (CharSequence)"verifycredentials")) {
            MoOAuthHttpUtils.setCookie("verify_credentials_in_use", "mo_verify_credentials", response);
        } else {
            MoOAuthHttpUtils.removeCookie("verify_credentials_in_use", request, response);
        }
        if (!this.settings.isTestIDPConfigurationInUse(request) || this.settings.isVerifyCredentialsInUse(request) || !StringUtils.isNotEmpty((CharSequence)request.getParameter("return_to"))) {
            HttpSession session = request.getSession();
            session.setAttribute("return_to", (Object)MoOAuthUtils.sanitizeText(request.getParameter("return_to")));
        }
        LOGGER.debug((Object)("returnTo : " + relayState));
        if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testregex")) {
            LOGGER.debug((Object)"testing regex pattern...");
            StringBuilder output = new StringBuilder("<div style='display:none'>");
            String regexp = MoOAuthUtils.sanitizeRegex(request.getParameter("regexp"));
            LOGGER.debug((Object)("Check if regex is valid : " + this.isRegexValid(regexp)));
            String message = "TEST REGEX....!";
            message = HtmlUtils.getTextAsHtml((Object)message);
            output.append(message);
            output.append("</div>");
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Pattern</div>");
            output.append("<div id=\"testregex\"> <input type=\"text\"  id=\"attrvalue\" name=\"attrvalue\" placeholder=\"Enter Attribute Value\" class=\"text long-field\"  style=\"width:250px;padding:10px; margin-left:20px\"/>&nbsp;&nbsp;&nbsp;<label id=\"result\"/><label id=\"error\"/></div><br><br>");
            output.append("<div style=\"margin:3%;display:block;\"><input id =\"testregex-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Test Regex\"></div>");
            output.append("<script>var input = document.getElementById(\"attrvalue\");input.addEventListener(\"keyup\", function(event) {if (event.keyCode === 13) {document.getElementById(\"testregex-button\").click();}});document.querySelector(\"#testregex-button\").onclick = function() {var attrValue = document.querySelector(\"#attrvalue\").value;var regexp ='" + regexp + "';console.log('original: '+regexp);if(" + this.isRegexValid(regexp) + "){console.log('Escaped: '+regexp);var regExp = new RegExp(regexp, 'g');var result = regExp.exec(attrValue); var username = '';if (result && result!=\"\") {if(result.length>1){var length = result.length;for(var count = 1; count < length; count++){console.log('Multiple Groups'); console.log(result[count]);username += result[count];}}else{console.log('No groups '+result);username = result[0];}console.log(\"Result : \" + username);document.querySelector(\"#result\").innerHTML = username;}else { document.querySelector(\"#result\").innerHTML = \"Error : No Pattern Found.\"; }} else { document.querySelector(\"#error\").innerHTML = \"Invalid Regex Expression.\";}}</script>");
            response.setContentType("text/html");
            response.getOutputStream().write(output.toString().getBytes("UTF-8"));
            return;
        }
        if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testgroupregexcreate")) {
            LOGGER.debug((Object)"test group regex create call...");
            try {
                this.showTestRegexGroupResult(request, response);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            return;
        }
        if (StringUtils.contains((CharSequence)relayState, (CharSequence)"testgroupregex")) {
            LOGGER.debug((Object)"test group regex call...");
            try {
                this.showTestGroupRegexWindow(response, request);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            return;
        }
        String CLIENT_ID = this.settings.getClientID();
        String SCOPE = this.settings.getScope();
        String RESPONSE_TYPE = "code";
        String REDIRECT_URI = this.settings.getBaseUrl().concat("/plugins/servlet/oauth/callback") + this.settings.getCustomizableCallbackURL();
        Boolean nonceCheck = this.settings.getNonceCheck();
        Boolean acrValueCheck = this.settings.getACRValueCheck();
        Boolean useStateParameter = this.settings.getUseStateParameter();
        HashMap<String, String> oauth_request_parameters = this.settings.getOauth_request_parameters();
        Boolean oauthParameterCheck = !oauth_request_parameters.isEmpty();
        StringBuilder AUTHORIZE_ENDPOINT = new StringBuilder(this.settings.getAuthorizeEndpoint());
        if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Keycloak")) {
            SCOPE = "openid";
        }
        if (AUTHORIZE_ENDPOINT.indexOf("?") > -1) {
            AUTHORIZE_ENDPOINT.append("&");
        } else {
            AUTHORIZE_ENDPOINT.append("?");
        }
        AUTHORIZE_ENDPOINT.append("client_id=").append(CLIENT_ID).append("&scope=").append(URLEncoder.encode(SCOPE, "UTF-8")).append("&redirect_uri=").append(URLEncoder.encode(REDIRECT_URI, "UTF-8")).append("&response_type=").append(RESPONSE_TYPE).append("&access_type=offline").append("&include_granted_scopes=true");
        LOGGER.debug((Object)("Nonce Check : " + nonceCheck));
        LOGGER.debug((Object)("ACR Value Check : " + acrValueCheck));
        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAppName(), (CharSequence)"Custom OAuth") || StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAppName(), (CharSequence)"Custom OpenID") || StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAppName(), (CharSequence)"Okta") || StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAppName(), (CharSequence)"miniOrange") || useStateParameter.booleanValue() || nonceCheck.booleanValue() || acrValueCheck.booleanValue() || oauthParameterCheck.booleanValue()) {
            if (nonceCheck.booleanValue()) {
                LOGGER.debug((Object)"send nonce in the request");
                this.passNonceInRequest(request, AUTHORIZE_ENDPOINT);
            }
            if (acrValueCheck.booleanValue()) {
                LOGGER.debug((Object)"send acr_values parameter in the request");
                this.passACRValueParameterInRequest(request, AUTHORIZE_ENDPOINT);
            }
            if (useStateParameter.booleanValue() || StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAppName(), (CharSequence)"OKTA")) {
                LOGGER.debug((Object)"send state parameter in the request");
                this.passStateParameterValue(request, AUTHORIZE_ENDPOINT);
            }
            if (oauthParameterCheck.booleanValue()) {
                LOGGER.debug((Object)"send Oauth request parameters in the request");
                this.passOauthParametersInRequest(request, AUTHORIZE_ENDPOINT, oauth_request_parameters);
            }
        }
        LOGGER.debug((Object)"OAuth CODE request generated");
        MoOAuthManager.httpRedirect(response, AUTHORIZE_ENDPOINT.toString());
    }

    public void showTestRegexGroupResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = MoOAuthUtils.sanitizeRegex(request.getParameter("regexp"));
        String regexg = MoOAuthUtils.sanitizeRegex(request.getParameter("regexg"));
        String groupName = MoOAuthUtils.sanitizeText(request.getParameter("groupName"));
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)regexg) && StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = MoOAuthLoginServlet.getGroupnameFromRegexMethod(regexp, regexg, groupName);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)regexg) || StringUtils.isBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)regexg)) {
                output.append("<li>Replace with field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            }
            output.append("</div>");
        } else if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Result</div>");
            output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Actual Value</th>\n        <th>Transformed Value</th>\n    </tr>\n    <tr>\n        <td align=\"center\">" + groupName + "</td>\n        <td align=\"center\">" + result + "</td>\n    </tr>    \n    </tbody></table>");
        } else if (StringUtils.isEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            output.append("<li>Regex not valid for the group Name.</li><br>");
            output.append("</div>");
        }
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    private void passNonceInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT) {
        String nonce = this.randomAlphaNumeric(10);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("nonce", (Object)nonce);
        AUTHORIZE_ENDPOINT.append("&nonce=").append(nonce);
    }

    private void passACRValueParameterInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT) {
        String acrValueParameter = this.randomAlphaNumeric(10);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("acr_values", (Object)acrValueParameter);
        AUTHORIZE_ENDPOINT.append("&acr_values=").append(acrValueParameter);
    }

    private void passOauthParametersInRequest(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT, Map<String, String> oauth_request_parameters) {
        HttpSession httpSession = request.getSession();
        for (Map.Entry<String, String> entry : oauth_request_parameters.entrySet()) {
            httpSession.setAttribute(entry.getKey(), (Object)entry.getValue());
            AUTHORIZE_ENDPOINT.append("&" + entry.getKey() + "=").append(entry.getValue());
        }
    }

    private void passStateParameterValue(HttpServletRequest request, StringBuilder AUTHORIZE_ENDPOINT) {
        String stateParameterValue = this.randomAlphaNumeric(10);
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("state_attribute_parameter", (Object)stateParameterValue);
        AUTHORIZE_ENDPOINT.append("&state=").append(stateParameterValue);
    }

    private String randomAlphaNumeric(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    private void showTestGroupRegexWindow(HttpServletResponse response, HttpServletRequest request) throws IOException {
        LOGGER.debug((Object)"testing group regex pattern...");
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = MoOAuthUtils.sanitizeRegex(request.getParameter("regexp"));
        String groupName = MoOAuthUtils.sanitizeText(request.getParameter("groupName"));
        Boolean result = Boolean.FALSE;
        LOGGER.debug((Object)("Check if regex is valid : " + this.isRegexValid(regexp)));
        String message = "TEST REGEX....!";
        message = HtmlUtils.getTextAsHtml((Object)message);
        output.append(message);
        if (StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = this.isGroupMatchingRegex(regexp, groupName);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)groupName) || !result.booleanValue()) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            } else if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            } else if (!result.booleanValue()) {
                output.append("<li>Group Name does not matches Regex</li><br>");
            }
            output.append("</div>");
        } else {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>TEST SUCCESSFUL</div>");
            output.append("<div style='color: #3c763d;font-size:14pt; margin-bottom:20px;'><li>Group Name matches Regex</li></div>");
        }
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    private Boolean isGroupMatchingRegex(String regexp, String groupName) {
        LOGGER.debug((Object)"checking groupname with regex");
        Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)regexp));
        Matcher matcher = pattern.matcher(groupName);
        if (matcher.find()) {
            return true;
        }
        return false;
    }

    private Boolean isRegexValid(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error((Object)"Invalid Regex Pattern.");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public static String getGroupnameFromRegexMethod(String groupRegexPattern, String regexGroups, String groupName) {
        LOGGER.debug((Object)("Applying regex pattern on Groupname : " + groupName));
        Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)groupRegexPattern));
        Matcher matcher = pattern.matcher(groupName);
        if (matcher.find()) {
            groupName = "";
            LOGGER.debug((Object)("Matched Groups " + matcher.groupCount()));
            groupName = matcher.groupCount() > 0 ? MoOAuthPluginHandler.getGroupNameFromRegex(matcher, StringUtils.trimToEmpty((String)regexGroups)) : matcher.group();
        }
        return groupName;
    }
}

