/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.bamboo.configuration.logs.ConfigureLog4jAction;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.component.ComponentLocator;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoAjaxCallsServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoAjaxCallsServlet.class);
    private MoOAuthSettings settings;
    private BambooUserManager bambooUserManager;
    private MoOAuthPluginHandler pluginHandler;
    private BambooUser bambooUser;

    public MoAjaxCallsServlet(MoOAuthSettings oauthSettings, BambooUserManager bambooUserManager, MoOAuthPluginHandler pluginHandler) {
        this.settings = oauthSettings;
        this.bambooUserManager = bambooUserManager;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug((Object)"Ajax Servlet doGet Called");
        String action = req.getParameter("action");
        String referer = req.getHeader("referer");
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !org.apache.commons.lang3.StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getBaseUrl())) {
            LOGGER.error((Object)"Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
            resp.sendError(403, "Access Denied. You are not allowed to access this page.");
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)action)) {
            resp.setContentType("text/html");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        switch (action) {
            case "fetchGroups": {
                if (this.settings.getCurrentBuildNumber() <= 60604) break;
                this.fetchGroups(req, resp);
                break;
            }
            case "checkBackdoorAccess": {
                this.checkBackdoorAccess(req, resp);
                break;
            }
            case "downloadBambooLogs": {
                this.downloadBambooLogs(req, resp);
                break;
            }
            default: {
                resp.setContentType("text/html");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                return;
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)action)) {
            resp.setContentType("text/html");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        switch (action) {
            case "updateBackdoorDetails": {
                this.updateBackdoorDetails(req, resp);
                break;
            }
            case "enableDebugLogs": {
                this.enableDebugLogs(req, resp);
                break;
            }
            default: {
                resp.setContentType("text/html");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                return;
            }
        }
    }

    private void checkBackdoorAccess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String username = StringUtils.trim((String)req.getParameter("username"));
        if (StringUtils.isBlank((String)username)) {
            resp.setContentType("application/json");
            resp.sendError(400, "The username is empty");
            return;
        }
        BambooUser bambooUser = this.bambooUserManager.getBambooUser(username);
        if (bambooUser != null) {
            List<String> groupList = this.settings.getBackdoorGroups();
            if (groupList.size() <= 0) {
                groupList.add("bamboo-admin");
            }
            boolean isUserPresentInGroups = this.pluginHandler.isUserPresentInGroups(username, groupList);
            JSONObject result = new JSONObject();
            LOGGER.debug((Object)("isUserPresentInGroups " + isUserPresentInGroups));
            try {
                result.put("isUserAllowedBackdoorAccess", isUserPresentInGroups);
            }
            catch (JSONException e) {
                e.printStackTrace();
                LOGGER.error((Object)"An Error Occurred while checking Backdoor Access for User ", (Throwable)e);
            }
            this.sendSuccessFullResponse(result.toString(), resp);
            return;
        }
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug((Object)"Ajax Servlet fetchGroup Called");
        try {
            String search = org.apache.commons.lang3.StringUtils.trim((String)req.getParameter("search"));
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)search, (CharSequence)"*")) {
                search = "";
            }
            CrowdService crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)search)).returningAtMost(10);
            LOGGER.debug((Object)("query =  " + query));
            Iterable groups = crowdService.search((Query)query);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (Group groupName : groups) {
                HashMap<String, Object> groupResultsMap = new HashMap<String, Object>();
                groupResultsMap.put("id", groupName.getName());
                groupResultsMap.put("text", groupName.getName());
                resultArray.put(groupResultsMap);
            }
            LOGGER.debug((Object)("resultArray :" + resultArray.toString()));
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)"An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void updateBackdoorDetails(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONObject result = new JSONObject();
        this.settings.setBackdoorKey(req.getParameter("backdoorKey"));
        this.settings.setBackdoorValue(req.getParameter("backdoorValue"));
        this.sendSuccessFullResponse(result.toString(), resp);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void enableDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean enableDebugLogs = BooleanUtils.toBoolean((String)req.getParameter("enableDebugLogs"));
        ConfigureLog4jAction configureLog4jAction = new ConfigureLog4jAction();
        configureLog4jAction.setExtraClassName("com.miniorange.oauth");
        if (enableDebugLogs) {
            configureLog4jAction.setExtraLevelName("DEBUG");
            LOGGER.debug((Object)"Debug logs are enabled.");
        } else {
            configureLog4jAction.setExtraLevelName("INFO");
            LOGGER.debug((Object)"Debug logs are disabled.");
        }
        configureLog4jAction.add();
        this.settings.setEnableDebugLogs(enableDebugLogs);
        this.sendSuccessFullResponse("Success", resp);
    }

    public void downloadBambooLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        File BambooFile = new File(bootstrapManager.getApplicationHome() + File.separator + "logs", "atlassian-bamboo.log");
        resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-Bamboo.txt\"");
        resp.setHeader("Cache-Control", "max-age=0");
        resp.setHeader("Pragma", "");
        resp.setContentType("text/plain");
        FileInputStream inputStream = new FileInputStream(BambooFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)resp.getOutputStream());
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public MoOAuthPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoOAuthPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

