/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.bamboo.dto.ProtocolType;
import com.miniorange.oauth.bamboo.dto.TokenResponse;
import com.miniorange.oauth.bamboo.factory.IProtocolAction;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class MoOAuthAction
implements IProtocolAction {
    private static Log LOGGER = LogFactory.getLog(MoOAuthAction.class);
    private static ProtocolType TYPE = ProtocolType.OAUTH;
    private JsonParser parser = new JsonParser();
    private String accessToken = "";
    private String refreshToken = "";

    @Override
    public TokenResponse sendTokenRequest(MoOAuthSettings settings, String code) {
        LOGGER.info((Object)"Create and send OAuth Access Token Request");
        String redirectURI = settings.getBaseUrl().concat("/plugins/servlet/oauth/callback") + settings.getCustomizableCallbackURL();
        String accessTokenURI = settings.getAccessTokenEndpoint();
        String sendTokenAuthParameterIn = settings.getSendTokenAuthParameterIn();
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", redirectURI));
        postParameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        postParameters.add((NameValuePair)new BasicNameValuePair("code", code));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accept", "application/json");
        if ((StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OAuth") || StringUtils.equalsIgnoreCase((CharSequence)settings.getAppName(), (CharSequence)"Custom OpenID")) && StringUtils.equalsIgnoreCase((CharSequence)sendTokenAuthParameterIn, (CharSequence)"HttpHeader")) {
            LOGGER.debug((Object)"Authorization parameters in HTTP Header");
            String authString = settings.getClientID() + ":" + settings.getClientSecret();
            byte[] authEncBytes = Base64.getEncoder().encode(authString.getBytes());
            String authStringEnc = new String(authEncBytes);
            String authorizationValue = "Basic " + authStringEnc;
            header.put("Authorization", authorizationValue);
        } else {
            LOGGER.debug((Object)"Sending Authorization parameters in HTTP Body of the access token request ");
            postParameters.add((NameValuePair)new BasicNameValuePair("client_id", settings.getClientID()));
            postParameters.add((NameValuePair)new BasicNameValuePair("client_secret", settings.getClientSecret()));
        }
        String response = MoOAuthHttpUtils.sendPostRequest(accessTokenURI, postParameters, "application/x-www-form-urlencoded", header);
        return new TokenResponse(response, TYPE);
    }

    @Override
    public TokenResponse sendUserInfoRequest(String accessTokenResponse, MoOAuthSettings settings) throws JsonParseException {
        LOGGER.debug((Object)"IN OAUTH ACTION send user info");
        JsonObject endpointResponse = this.parser.parse(accessTokenResponse).getAsJsonObject();
        String value = "";
        Set<Map.Entry<String, JsonElement>> entries = endpointResponse.entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            try {
                value = endpointResponse.get(entry.getKey()).getAsString();
                LOGGER.debug((Object)("EndPointResponse Value : " + value));
            }
            catch (Exception e) {
                LOGGER.debug((Object)"Endpoint response is JSon Object:");
            }
        }
        if (endpointResponse.has("error")) {
            if (StringUtils.equals((CharSequence)value, (CharSequence)"invalid_client")) {
                LOGGER.debug((Object)"unauthorized invalid_client");
            }
            return new TokenResponse(value, TYPE);
        }
        this.accessToken = endpointResponse.get("access_token").getAsString();
        return this.sendGetRequest(this.accessToken, settings);
    }

    @Override
    public TokenResponse sendGroupInfoRequest(JsonObject userInfodata, HttpServletRequest request, String email, String id, MoOAuthSettings settings, MoOAuthUtils oAuthUtils) throws JsonParseException {
        LOGGER.debug((Object)"OAuth Action Send Group Info Request");
        String groupsResponse = "";
        if (settings.getAppName().equals("Google")) {
            groupsResponse = this.fetchGroupInfoForGoogle(request, id, settings);
        } else if (!StringUtils.equals((CharSequence)settings.getAppName(), (CharSequence)"Discord") && StringUtils.isNotEmpty((CharSequence)settings.getFetchGroupsEndpoint())) {
            groupsResponse = this.fetchGroupInfo(request, id, settings);
        }
        return new TokenResponse(groupsResponse, TYPE);
    }

    @Override
    public ProtocolType getProtocolType() {
        return TYPE;
    }

    private String fetchGroupInfo(HttpServletRequest request, String id, MoOAuthSettings settings) {
        String authHeader = "Bearer " + this.accessToken;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authHeader);
        String groupResponse = "";
        groupResponse = StringUtils.equals((CharSequence)settings.getAppName(), (CharSequence)"Facebook") ? MoOAuthHttpUtils.sendGetRequestWithHeaders(settings.getFetchGroupsEndpoint() + id + "/groups", headers) : MoOAuthHttpUtils.sendGetRequestWithHeaders(settings.getFetchGroupsEndpoint(), headers);
        LOGGER.debug((Object)("Groups Response is: " + groupResponse));
        return groupResponse;
    }

    private String fetchGroupInfoForGoogle(HttpServletRequest request, String email, MoOAuthSettings settings) throws JsonParseException {
        this.accessToken = "";
        LOGGER.debug((Object)"Fetch Group Info For Google");
        String accessTokenResponse = this.endpointCallToGetAccessTokenForGoogle(settings);
        JsonObject accessTokenEndpointData = this.parser.parse(accessTokenResponse).getAsJsonObject();
        LOGGER.debug((Object)("accessTokenEndpointData " + accessTokenEndpointData));
        if (accessTokenEndpointData.has("access_token")) {
            this.accessToken = accessTokenEndpointData.get("access_token").getAsString();
        }
        String authHeader = "Bearer " + this.accessToken;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authHeader);
        String groupResponse = MoOAuthHttpUtils.sendGetRequestWithHeaders(settings.getFetchGroupsEndpoint() + "?userKey=" + email, headers);
        return groupResponse;
    }

    @Override
    public TokenResponse endpointCallToGetRefreshToken(String code, MoOAuthSettings settings) {
        String ACCESSTOKEN_ENDPOINT = settings.getAccessTokenEndpoint();
        String REDIRECT_URI = settings.getBaseUrl().concat("/plugins/servlet/oauth/callback") + settings.getCustomizableCallbackURL();
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", REDIRECT_URI));
        postParameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        postParameters.add((NameValuePair)new BasicNameValuePair("client_id", settings.getClientID()));
        postParameters.add((NameValuePair)new BasicNameValuePair("client_secret", settings.getClientSecret()));
        postParameters.add((NameValuePair)new BasicNameValuePair("code", code));
        String Response = MoOAuthHttpUtils.sendPostRequest(ACCESSTOKEN_ENDPOINT, postParameters, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("response " + Response));
        return new TokenResponse(Response, TYPE);
    }

    private String endpointCallToGetAccessTokenForGoogle(MoOAuthSettings settings) {
        LOGGER.debug((Object)("EndPoint For Access token GOOGLE: " + settings.getGoogleRefreshToken()));
        ArrayList<NameValuePair> postParams1 = new ArrayList<NameValuePair>();
        postParams1.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        postParams1.add((NameValuePair)new BasicNameValuePair("client_id", settings.getClientID()));
        postParams1.add((NameValuePair)new BasicNameValuePair("client_secret", settings.getClientSecret()));
        postParams1.add((NameValuePair)new BasicNameValuePair("refresh_token", settings.getGoogleRefreshToken()));
        String refreshTokenEndpointResponse = MoOAuthHttpUtils.sendPostRequest(settings.getAccessTokenEndpoint(), postParams1, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("response " + refreshTokenEndpointResponse));
        return refreshTokenEndpointResponse;
    }

    private TokenResponse sendGetRequest(String accessToken, MoOAuthSettings settings) {
        String userInfoEndpoint = settings.getUserInfoEndpoint();
        String authHeader = "Bearer " + accessToken;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authHeader);
        if (StringUtils.contains((CharSequence)settings.getUserInfoEndpoint(), (CharSequence)"=")) {
            userInfoEndpoint = userInfoEndpoint + accessToken;
        }
        String userDetailedInfoResponse = MoOAuthHttpUtils.sendGetRequestWithHeaders(userInfoEndpoint, headers);
        LOGGER.debug((Object)("userDetailedInfoResponse " + userDetailedInfoResponse));
        return new TokenResponse(userDetailedInfoResponse, TYPE);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

