/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.configuration.logs.ConfigureLog4jAction;
import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginConstants;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.struts2.ServletActionContext;

public class MoClientConfigurationAction
extends BambooActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(MoClientConfigurationAction.class);
    private String customAppName;
    private String clientID;
    private String scope;
    private String clientSecret;
    private String authorizeEndpoint;
    private String accessTokenEndpoint;
    private String userInfoEndpoint;
    private String fetchGroupsEndpoint;
    private String singleLogoutURL;
    private String publicKey;
    private Boolean nonceCheck;
    private Boolean isCredentialsVerified;
    private Boolean useStateParameter;
    private Boolean acrValueCheck;
    private Boolean enableCheckIssuerFor;
    private String checkIssuerFor;
    private String customIssuerValue;
    private String tenantID;
    private String hostName;
    private String realmName;
    private String domainName;
    private String appHostedOn;
    private String appName;
    private Boolean submitted;
    private Boolean deleterefreshtoken;
    private PluginLicenseManager pluginLicenseManager;
    private MoOAuthSettings settings;
    private String xsrfToken;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String isOpenIdProtocol;
    private String sendTokenAuthParameterIn;
    private ArrayList<String> defaultOpenIdApps = new ArrayList();
    private ArrayList<String> defaultOauthApps = new ArrayList();
    private Map<String, String> oauth_request_parameters;

    public MoClientConfigurationAction(MoOAuthSettings settings, PluginLicenseManager pluginLicenseManager, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        LOGGER.info((Object)"OAuth Configuration Action validate");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        Boolean error = false;
        ArrayList<String> invalidValues = new ArrayList<String>();
        UrlValidator urlValidator = new UrlValidator(8L);
        if (StringUtils.isBlank((CharSequence)this.clientID)) {
            invalidValues.add("clientid");
        }
        if (StringUtils.isBlank((CharSequence)this.clientSecret)) {
            invalidValues.add("clientsecret");
        }
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            invalidValues.add("appname");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Custom App") || StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Custom OpenID")) {
            if (!urlValidator.isValid(this.authorizeEndpoint)) {
                invalidValues.add("authorizeendpoint");
            }
            if (!urlValidator.isValid(this.accessTokenEndpoint)) {
                invalidValues.add("accesstokenendpoint");
            }
            if (StringUtils.isBlank((CharSequence)this.sendTokenAuthParameterIn) || StringUtils.equalsIgnoreCase((CharSequence)this.sendTokenAuthParameterIn, null)) {
                this.sendTokenAuthParameterIn = this.settings.getSendTokenAuthParameterIn();
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Custom App")) {
            if (!urlValidator.isValid(this.userInfoEndpoint)) {
                invalidValues.add("userinfoendpoint");
            }
            if (StringUtils.isBlank((CharSequence)this.customAppName)) {
                invalidValues.add("customappname");
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Keycloak") && StringUtils.isBlank((CharSequence)this.hostName)) {
            invalidValues.add("hostName");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Keycloak") && StringUtils.isBlank((CharSequence)this.realmName)) {
            invalidValues.add("realmName");
        }
        if ((StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"AWS Cognito") || StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"ADFS")) && StringUtils.isBlank((CharSequence)this.domainName)) {
            invalidValues.add("domainName");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Azure AD") && StringUtils.isBlank((CharSequence)this.tenantID)) {
            invalidValues.add("tenantid");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"GitLab")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.appHostedOn, (CharSequence)"self-hosted") && StringUtils.isNotBlank((CharSequence)this.domainName)) {
                if (!urlValidator.isValid(this.domainName)) {
                    this.addActionError(this.getText("oauth.error.invalid.domainNameUrl"));
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.appHostedOn, (CharSequence)"self-hosted") && StringUtils.isBlank((CharSequence)this.domainName)) {
                invalidValues.add("domainName");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.singleLogoutURL) && !urlValidator.isValid(this.singleLogoutURL)) {
            invalidValues.add("singleLogoutEndpoint");
        }
        if (MoOAuthUtils.isOpenIdProtocol(this.appName) && StringUtils.isNotBlank((CharSequence)this.publicKey)) {
            String publicCertificate = this.publicKey;
            publicCertificate = MoOAuthUtils.deserializePublicKey(publicCertificate);
            byte[] publicBytes = Base64.decodeBase64(publicCertificate);
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                keyFactory.generatePublic(keySpec);
            }
            catch (GeneralSecurityException e) {
                invalidValues.add("publicKey");
            }
        }
        for (String invalidValue : invalidValues) {
            error = true;
            this.addActionError(this.getText("oauth.error.invalid." + invalidValue));
        }
        if (super.hasActionErrors() || error.booleanValue()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeOAuthConfig();
            return;
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info((Object)"OAuth Configuration Action doExecute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug((Object)("OAuth Configuration Action doExecute Submitted: " + this.submitted));
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                if (!this.settings.isLicenseValid().booleanValue()) {
                    try {
                        response.sendRedirect(this.settings.getManageAddOnURL());
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (BooleanUtils.toBoolean((Boolean)this.deleterefreshtoken)) {
                    this.settings.setRefreshToken("");
                }
                if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                    if (StringUtils.equals((CharSequence)this.settings.getClientID(), (CharSequence)"")) {
                        MoOAuthPluginHandler.saveDefaultConfiguration();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"OKTA")) {
                        this.useStateParameter = Boolean.TRUE;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"miniOrange")) {
                        this.setUseStateParameter(Boolean.TRUE);
                    }
                    HashMap<String, String> oauth_request_parameters = new HashMap<String, String>();
                    int totalOauthParameters = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("totalOauthParameters"), (CharSequence)"0"));
                    for (int i = 0; i < totalOauthParameters; ++i) {
                        String key = request.getParameter("oauthParameterKey[" + i + "]");
                        String value = request.getParameter("oauthParameterValue[" + i + "]");
                        if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                        oauth_request_parameters.put(key.trim(), value.trim());
                    }
                    this.accessTokenEndpoint = this.accessTokenEndpoint.trim().replace(" ", "%20");
                    this.authorizeEndpoint = this.authorizeEndpoint.trim().replace(" ", "%20");
                    this.userInfoEndpoint = this.userInfoEndpoint.trim().replace(" ", "%20");
                    if (StringUtils.equals((CharSequence)this.appName, (CharSequence)"Custom OAuth") || StringUtils.equals((CharSequence)this.appName, (CharSequence)"Custom OpenID")) {
                        MoOAuthPluginHandler.saveOAuthConfiguration(this.appName, this.customAppName, this.clientID, this.clientSecret, this.scope, this.authorizeEndpoint, this.accessTokenEndpoint, this.userInfoEndpoint, this.fetchGroupsEndpoint, this.useStateParameter, this.enableCheckIssuerFor, this.checkIssuerFor, this.customIssuerValue, this.singleLogoutURL, this.nonceCheck, this.publicKey, this.acrValueCheck, oauth_request_parameters, this.sendTokenAuthParameterIn);
                    } else {
                        MoOAuthPluginHandler.saveOAuthConfiguration(this.appName, this.appHostedOn, this.clientID, this.clientSecret, this.scope, this.tenantID, this.hostName, this.realmName, this.domainName, this.enableCheckIssuerFor, this.checkIssuerFor, this.customIssuerValue, this.singleLogoutURL, this.useStateParameter, this.nonceCheck, this.publicKey, this.acrValueCheck, oauth_request_parameters);
                    }
                    LOGGER.info((Object)"OAuth Configuration saved");
                    this.addActionMessage(this.getText("oauth.success.config"));
                }
                this.initializeOAuthConfig();
                return "success";
            }
            catch (MoOAuthPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error((Object)("Error is : " + e));
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(MoOAuthPluginHandler.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeOAuthConfig() {
        LOGGER.info((Object)"initializing OAuthConfig");
        this.customAppName = this.settings.getCustomAppName();
        this.appName = this.settings.getAppName();
        this.classifyAppsInOauthAndOpenId();
        if (StringUtils.equals((CharSequence)this.appName, (CharSequence)"Microsoft")) {
            this.customAppName = "Azure AD";
            this.appName = "Azure AD";
            this.settings.setAppName(this.appName);
            this.settings.setCustomAppName(this.customAppName);
        }
        this.isOpenIdProtocol = MoOAuthUtils.isOpenIdProtocol(this.appName) ? "true" : "false";
        this.initializeDebugLogs();
        LOGGER.debug((Object)("isOpenIdProtocol: " + this.isOpenIdProtocol));
        this.appHostedOn = this.settings.getAppHostedOn();
        this.clientID = this.settings.getClientID();
        this.clientSecret = this.settings.getClientSecret();
        this.authorizeEndpoint = this.settings.getAuthorizeEndpoint();
        this.accessTokenEndpoint = this.settings.getAccessTokenEndpoint();
        this.userInfoEndpoint = this.settings.getUserInfoEndpoint();
        this.fetchGroupsEndpoint = this.settings.getFetchGroupsEndpoint();
        this.scope = this.settings.getScope();
        this.isCredentialsVerified = this.settings.getIsCredentialsVerified();
        this.tenantID = this.settings.getTenantID();
        this.hostName = this.settings.getHostName();
        this.realmName = this.settings.getRealmName();
        this.domainName = this.settings.getDomainName();
        this.useStateParameter = this.settings.getUseStateParameter();
        this.enableCheckIssuerFor = this.settings.getEnableCheckIssuerFor();
        this.checkIssuerFor = this.settings.getCheckIssuerFor();
        this.customIssuerValue = this.settings.getCustomIssuerValue();
        this.singleLogoutURL = this.settings.getSingleLogoutURL();
        this.publicKey = StringUtils.trim((String)this.settings.getPublicKey());
        this.nonceCheck = this.settings.getNonceCheck();
        this.acrValueCheck = this.settings.getACRValueCheck();
        this.oauth_request_parameters = this.settings.getOauth_request_parameters();
        this.sendTokenAuthParameterIn = this.settings.getSendTokenAuthParameterIn();
        LOGGER.info((Object)"initializeOAuthConfig done....");
    }

    private void initializeDebugLogs() {
        Boolean enableDebugLogs = this.settings.getEnableDebugLogs();
        ConfigureLog4jAction configureLog4jAction = new ConfigureLog4jAction();
        configureLog4jAction.setExtraClassName("com.miniorange.oauth");
        if (enableDebugLogs.booleanValue()) {
            configureLog4jAction.setExtraLevelName("DEBUG");
        } else {
            configureLog4jAction.setExtraLevelName("INFO");
        }
        configureLog4jAction.add();
    }

    private void classifyAppsInOauthAndOpenId() {
        for (MoOAuthPluginConstants.OAuthApps oAuthApps : MoOAuthPluginConstants.OAuthApps.values()) {
            this.defaultOauthApps.add(oAuthApps.getAppName());
        }
        for (Enum enum_ : MoOAuthPluginConstants.OpenIdApps.values()) {
            this.defaultOpenIdApps.add(((MoOAuthPluginConstants.OpenIdApps)enum_).getAppName());
        }
    }

    public void setDefaultOpenIdApps(ArrayList<String> defaultOpenIdApps) {
        this.defaultOpenIdApps = defaultOpenIdApps;
    }

    public void setDefaultOauthApps(ArrayList<String> defaultOauthApps) {
        this.defaultOauthApps = defaultOauthApps;
    }

    public ArrayList<String> getDefaultOpenIdApps() {
        return this.defaultOpenIdApps;
    }

    public ArrayList<String> getDefaultOauthApps() {
        return this.defaultOauthApps;
    }

    public String getCustomAppName() {
        return this.customAppName;
    }

    public void setCustomAppName(String customAppName) {
        this.customAppName = customAppName;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAuthorizeEndpoint() {
        return this.authorizeEndpoint;
    }

    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getFetchGroupsEndpoint() {
        return this.fetchGroupsEndpoint;
    }

    public void setFetchGroupsEndpoint(String fetchGroupsEndpoint) {
        this.fetchGroupsEndpoint = fetchGroupsEndpoint;
    }

    public Boolean getCredentialsVerified() {
        return this.isCredentialsVerified;
    }

    public void setCredentialsVerified(Boolean credentialsVerified) {
        this.isCredentialsVerified = credentialsVerified;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getDeleterefreshtoken() {
        return this.deleterefreshtoken;
    }

    public void setDeleterefreshtoken(Boolean deleterefreshtoken) {
        this.deleterefreshtoken = deleterefreshtoken;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Boolean getUseStateParameter() {
        return this.useStateParameter;
    }

    public void setUseStateParameter(Boolean useStateParameter) {
        this.useStateParameter = useStateParameter;
    }

    public Boolean getEnableCheckIssuerFor() {
        return this.enableCheckIssuerFor;
    }

    public void setEnableCheckIssuerFor(Boolean enableCheckIssuerFor) {
        this.enableCheckIssuerFor = enableCheckIssuerFor;
    }

    public String getCheckIssuerFor() {
        return this.checkIssuerFor;
    }

    public void setCheckIssuerFor(String checkIssuerFor) {
        this.checkIssuerFor = checkIssuerFor;
    }

    public String getCustomIssuerValue() {
        return this.customIssuerValue;
    }

    public void setCustomIssuerValue(String customIssuerValue) {
        this.customIssuerValue = customIssuerValue;
    }

    public String getSingleLogoutURL() {
        return this.singleLogoutURL;
    }

    public void setSingleLogoutURL(String singleLogoutURL) {
        this.singleLogoutURL = singleLogoutURL;
    }

    public String getAppHostedOn() {
        return this.appHostedOn;
    }

    public void setAppHostedOn(String appHostedOn) {
        this.appHostedOn = appHostedOn;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Boolean getNonceCheck() {
        return this.nonceCheck;
    }

    public void setNonceCheck(Boolean nonceCheck) {
        this.nonceCheck = nonceCheck;
    }

    public String getIsOpenIdProtocol() {
        return this.isOpenIdProtocol;
    }

    public void setIsOpenIdProtocol(String isOpenIdProtocol) {
        this.isOpenIdProtocol = isOpenIdProtocol;
    }

    public Boolean getAcrValueCheck() {
        return this.acrValueCheck;
    }

    public void setAcrValueCheck(Boolean acrValueCheck) {
        this.acrValueCheck = acrValueCheck;
    }

    public Map<String, String> getOauth_request_parameters() {
        return this.oauth_request_parameters;
    }

    public void setOauth_request_parameters(Map<String, String> oauth_request_parameters) {
        this.oauth_request_parameters = oauth_request_parameters;
    }

    public String getSendTokenAuthParameterIn() {
        return this.sendTokenAuthParameterIn;
    }

    public void setSendTokenAuthParameterIn(String sendTokenAuthParameterIn) {
        this.sendTokenAuthParameterIn = sendTokenAuthParameterIn;
    }
}

