/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.bamboo.MoOAuthUserManager;
import com.miniorange.oauth.bamboo.dto.TokenResponse;
import com.miniorange.oauth.bamboo.factory.IProtocolAction;
import com.miniorange.oauth.bamboo.factory.OAuthOpenIdDecisionHandler;
import com.miniorange.oauth.bamboo.servlet.MoOAuthLoginServlet;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class MoOAuthCallbackServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoOAuthCallbackServlet.class);
    private MoOAuthSettings settings;
    private BambooUserManager bambooUserManager;
    private MoOAuthManager oauthManager;
    private MoOAuthUserManager userManager;
    private MoOAuthUtils oauthUtils;
    private BambooPermissionManager bambooPermissionManager;
    private Gson gson = new Gson();
    private JsonParser parser = new JsonParser();
    private String accessToken = "";
    private HashMap<String, String> userInfoMap = new HashMap();
    private String refreshToken = "";
    private String googleRefreshToken = "";
    private IProtocolAction protocolAction;
    private TemplateRenderer renderer;
    static HttpServletRequest reqObjectForRememberMe;
    static HttpServletResponse respObjectForRememberMe;

    public MoOAuthCallbackServlet(MoOAuthSettings settings, BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager, MoOAuthManager oauthManager, MoOAuthUserManager userManager, MoOAuthUtils oauthUtils, TemplateRenderer renderer) {
        this.settings = settings;
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.userManager = userManager;
        this.oauthManager = oauthManager;
        this.oauthUtils = oauthUtils;
        this.renderer = renderer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            LOGGER.debug((Object)"Executing OAuth Authentication Callback Servlet");
            LOGGER.debug((Object)("Code received : " + request.getParameter("code")));
            if (StringUtils.isBlank((CharSequence)this.refreshToken)) {
                this.refreshToken = this.settings.getRefreshToken();
            }
            LOGGER.debug((Object)("Refresh Token : " + this.refreshToken));
            this.protocolAction = OAuthOpenIdDecisionHandler.getProtocolHandler(this.settings.getAppName());
            if (this.settings.isTestIDPConfigurationInUse(request)) {
                LOGGER.debug((Object)("TestIDPConfigurationInUse::" + this.settings.isTestIDPConfigurationInUse(request)));
                MoOAuthHttpUtils.removeCookie("test_configuration_in_use", request, response);
                LOGGER.debug((Object)"Rendering Test Configuration");
                this.showTestConfigurationResult(request, response, null);
                return;
            }
            if (this.settings.isVerifyCredentialsInUse(request)) {
                MoOAuthHttpUtils.removeCookie("verify_credentials_in_use", request, response);
                LOGGER.debug((Object)"Initiating credential verification for Google Apps");
                this.showVerifyCredentials(request, response);
                return;
            }
            if (BooleanUtils.toBoolean((Boolean)this.settings.getUseStateParameter())) {
                String stateParameterToServer = this.getSessionAttribute("state_attribute_parameter", request);
                String stateParameterFromServer = request.getParameter("state");
                if (stateParameterFromServer == null || stateParameterFromServer.equalsIgnoreCase("")) {
                    LOGGER.error((Object)"No State Parameter in the response. State parameter validation failed. redirecting to login page");
                    this.redirectToLoginWithOAuthError(response, null, "cant_signin_no_state_parameter_found");
                    return;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)stateParameterToServer, (CharSequence)stateParameterFromServer)) {
                    LOGGER.error((Object)"State parameter validation failed. redirecting to login page");
                    this.redirectToLoginWithOAuthError(response, null, "cant_signin_invalid_state_parameter");
                    return;
                }
                LOGGER.debug((Object)"State Parameter is validated successfully");
            }
            if (!this.settings.isLicenseDefine().booleanValue()) {
                LOGGER.error((Object)"The plugin is not licensed. Redirecting user to login page");
                this.redirectToLoginWithOAuthError(response, null, "cant_signin_no_license");
                return;
            }
            String accessTokenResponse = MoOAuthUserManager.getAndSetAccessAndRefreshToken(request, this.protocolAction);
            if (accessTokenResponse.equals("invalid_token")) {
                LOGGER.error((Object)"Invalid Access Token. Redirecting to the login page ");
                this.redirectToLoginWithOAuthError(response, null, "invalid signature");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)accessTokenResponse) || StringUtils.isBlank((CharSequence)accessTokenResponse) || accessTokenResponse.equals("Failed") || accessTokenResponse.equals("error")) {
                LOGGER.debug((Object)"Error with the AccessTokenEndpoint");
                this.redirectToLoginWithOAuthError(response, null, "Error with the AccessTokenEndpoint");
                return;
            }
            JsonObject accessTokenEndpointData = this.parser.parse(accessTokenResponse).getAsJsonObject();
            LOGGER.debug((Object)("Access Token response " + accessTokenEndpointData.toString()));
            if (accessTokenEndpointData.has("error")) {
                LOGGER.error((Object)"Invalid Access Token Response");
                this.redirectToLoginWithOAuthError(response, null, "invalid configuration parameters");
                return;
            }
            String accessToken = "";
            if (MoOAuthUtils.isOpenIdProtocol(this.settings.getAppName()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.settings.getPublicKey()})) {
                LOGGER.debug((Object)"Validating Signature in the JWT Token(ID Token)");
                accessToken = accessTokenEndpointData.get("id_token").getAsString();
                LOGGER.debug((Object)("ID Token = " + accessToken));
                DecodedJWT jwt = JWT.decode(accessToken);
                String algorithm = jwt.getAlgorithm();
                PublicKey publicKey = MoOAuthUserManager.getPublicKeyObjectFromConfiguredKey(this.settings.getPublicKey());
                Boolean isValid = MoOAuthUserManager.verifyTokenSignature(jwt, publicKey, algorithm);
                if (!BooleanUtils.toBoolean((Boolean)isValid)) {
                    LOGGER.error((Object)"Signature Validation Failed!");
                    this.redirectToLoginWithOAuthError(response, null, "invalid signature");
                    return;
                }
            }
            this.accessToken = accessTokenEndpointData.get("access_token").getAsString();
            TokenResponse tokenResponse = this.protocolAction.sendUserInfoRequest(accessTokenResponse, this.settings);
            String userDetailedInfoResponse = tokenResponse.getResponse();
            if (userDetailedInfoResponse == "Failed") {
                LOGGER.error((Object)"UserInfoResponse Failed!");
                this.redirectToLoginWithOAuthError(response, null, "invalid userDetailedInfo request URL");
                return;
            }
            JsonObject getUserInfoData = this.parser.parse(userDetailedInfoResponse).getAsJsonObject();
            HashMap<String, Object> userDetailsMap = new HashMap<String, Object>();
            this.userInfoMap = this.oauthUtils.copyToStringValueMap(this.oauthUtils.toMapObjects(getUserInfoData, userDetailsMap));
            LOGGER.debug((Object)("User Info Map: " + this.userInfoMap));
            if (this.settings.getNonceCheck().booleanValue() && MoOAuthUtils.isOpenIdProtocol(this.settings.getAppName())) {
                LOGGER.debug((Object)"Validating Nonce Parameter");
                String nonceValueFromServer = this.userInfoMap.get("nonce");
                String nonceValueToServer = this.getSessionAttribute("nonce", request);
                LOGGER.debug((Object)("Nonce parameter sent : " + nonceValueToServer + " Nonce received in the response : " + nonceValueFromServer));
                if (!nonceValueFromServer.equals(nonceValueToServer) || nonceValueFromServer == null) {
                    LOGGER.debug((Object)"Nonce Parameter validation failed.");
                    this.redirectToLoginWithOAuthError(response, null, "cant_signin_invalid_nonce_found");
                    return;
                }
            }
            Set<String> emails = this.oauthUtils.findEmails(this.userInfoMap);
            String email = "";
            if (emails.size() > 0) {
                LOGGER.debug((Object)"Searching for email in the response");
                ArrayList<String> list = new ArrayList<String>(emails);
                email = (String)list.get(0);
                LOGGER.debug((Object)("User email: " + email));
            }
            if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Meetup")) {
                String meetupid = this.oauthUtils.findKey(getUserInfoData, "id", this.settings.getAppName());
                email = meetupid + "@meetup.com";
            }
            LOGGER.debug((Object)("email: " + email));
            if (StringUtils.isEmpty((CharSequence)this.settings.getUsernameAttribute()) && StringUtils.isEmpty((CharSequence)this.settings.getEmailAttribute()) && email.isEmpty()) {
                LOGGER.error((Object)"No user identifier attributes is configured. Unable to identify SSO User. Please check the user profile configuration in the plugin !");
                this.redirectToLoginWithOAuthError(response, null, "cant_signin_check_configuration");
                return;
            }
            this.authoriseAndRedirect(getUserInfoData, request, response, email, this.settings.getRegexPatternEnabled(), this.accessToken);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
        String refreshToken = req.getParameter("refresh_token");
        if (refreshToken != null) {
            if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Google")) {
                this.settings.setGoogleRefreshToken(refreshToken);
            } else {
                this.settings.setRefreshToken(refreshToken);
            }
        }
    }

    private void showTestConfigurationResult(HttpServletRequest request, HttpServletResponse response, String error) throws IOException {
        block32: {
            StringBuffer htmlStart = new StringBuffer("<head><style>table{font-family: arial, sans-serif;border-collapse: collapse;width: 100%;}td, th {border: 1px solid #dddddd;text-align: left;padding: 8px;}tr:nth-child(even){background-color: #dddddd;}</style></head><div style=\"font-family:Calibri;padding:0 3%;\">");
            try {
                if (error != null) break block32;
                String email = "";
                String id = "";
                String userInfoResult = MoOAuthUserManager.fetchUserInfo(request, this.protocolAction);
                LOGGER.debug((Object)userInfoResult);
                if (userInfoResult.equals("invalid_client")) {
                    htmlStart = htmlStart.append("<div style=\"padding: 10px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt;'> Error with the unauthorized invalid client. Please check if the user is valid and the entered values are correct. </br> </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
                    return;
                }
                if (userInfoResult.equals("error")) {
                    htmlStart = htmlStart.append("<div style=\"padding: 10px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt;'> Error with the AccessTokenEndpoint / Client Secret. Please check if the Access Token Endpoint is correct. </br> </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes());
                    return;
                }
                if (userInfoResult.equals("Failed")) {
                    htmlStart = htmlStart.append("<div style=\"padding: 10px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt;'> An unexpected error occured in response. Please check your configurations. </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes());
                    return;
                }
                if (userInfoResult.equals("invalid_request")) {
                    htmlStart = htmlStart.append("<div style=\"padding: 10px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt;'> Error with the plugin configurations.  Please check if the configuration done in plugin and scope entered  is correct. </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes());
                    return;
                }
                if (userInfoResult.equals("invalid_token")) {
                    htmlStart = htmlStart.append("<div style=\"padding: 10px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt;'> Invalid Issuer or Public key found in response Please check if Issuer or Public Key is correct. </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
                    return;
                }
                JsonObject getUserInfoData = this.parser.parse(userInfoResult).getAsJsonObject();
                LOGGER.debug((Object)("userInfoData " + getUserInfoData));
                if (getUserInfoData.has("error")) {
                    LOGGER.error((Object)"invalid userDetailedInfo request URL");
                    htmlStart = htmlStart.append("<div style=\"padding: 15px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"border:1px solid #E6B3B2;padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt'> Error with the User Info response. Please check if the User Info Endpoint is correct. </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.toString().getBytes());
                }
                HashMap<String, Object> userDetailsMap = new HashMap<String, Object>();
                HashMap<String, String> userInfoMap = new HashMap();
                userInfoMap = this.oauthUtils.copyToStringValueMap(this.oauthUtils.toMapObjects(getUserInfoData, userDetailsMap));
                LOGGER.debug((Object)("User Info Map: " + userInfoMap));
                Set<String> emails = this.oauthUtils.findEmails(userInfoMap);
                LOGGER.debug((Object)("User emails are " + emails));
                if (emails.size() > 0) {
                    ArrayList<String> list = new ArrayList<String>(emails);
                    email = (String)list.get(0);
                    LOGGER.debug((Object)("User email is " + email));
                }
                LOGGER.debug((Object)"Test successfully completed");
                htmlStart = htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
                htmlStart = htmlStart.append("<div style=\"text-align:left;\"><h2><b>User Attributes</b></h2></div><div style=\"padding:20px;vertical-align:middle; text-align:center\"><table><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
                if (userInfoMap.containsKey("id")) {
                    id = userInfoMap.get("id");
                }
                Iterator<Map.Entry<String, String>> it = userInfoMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> pair = it.next();
                    htmlStart = htmlStart.append("<tr>");
                    htmlStart = htmlStart.append("<td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + pair.getKey() + "</td>");
                    htmlStart = htmlStart.append("<td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">" + pair.getValue() + "</td>");
                    htmlStart = htmlStart.append("</tr>");
                    it.remove();
                }
                htmlStart = htmlStart.append("</table></div>");
                String groupInfoResult = "";
                if (!MoOAuthUtils.isOpenIdProtocol(this.settings.getAppName())) {
                    groupInfoResult = MoOAuthUserManager.fetchGroupInfo(getUserInfoData, request, email, id, this.settings, this.protocolAction, this.oauthUtils);
                }
                if (groupInfoResult.equals("Failed")) {
                    this.refreshToken = "";
                    this.sendRequestToSaveToken("");
                    htmlStart = htmlStart.append("<div style=\"text-align:left;\"><h2>Unable to fetch Groups Info! </h2></div>");
                    if (this.settings.getAppName().equals("Google")) {
                        htmlStart = htmlStart.append("<div style=\"text-align:left;\"><h2>Please verify your administrator credentials for fetching Groups of users.</h2></div>");
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)groupInfoResult)) {
                    htmlStart = htmlStart.append("<div style=\"text-align:left;\"><h2><b>User Group Attributes</b></h2></div>");
                    htmlStart = htmlStart.append("<div style=\"padding:20px;vertical-align:middle; text-align:center\"><table><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
                    if (!groupInfoResult.startsWith("[")) {
                        groupInfoResult = "[" + groupInfoResult + "]";
                    }
                    JsonArray jsonArray = this.parser.parse(groupInfoResult).getAsJsonArray();
                    if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Meetup")) {
                        htmlStart = htmlStart.append("<tr>");
                        htmlStart = htmlStart.append("<td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">name</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                    }
                    for (int groupIndex = 0; groupIndex < jsonArray.size(); ++groupIndex) {
                        Map<Object, Object> groupDetailsMap = new HashMap<String, JsonElement>();
                        try {
                            JsonObject getGroupUserInfoResponse = jsonArray.get(groupIndex).getAsJsonObject();
                            LOGGER.debug((Object)("Group Info Response: " + getGroupUserInfoResponse));
                            groupDetailsMap = this.oauthUtils.jsonToMap(getGroupUserInfoResponse);
                        }
                        catch (JsonParseException e) {
                            JsonElement group = jsonArray.get(groupIndex);
                            groupDetailsMap.put(this.settings.getRoleAttribute(), group);
                        }
                        LOGGER.debug((Object)("Group Details Map: " + groupDetailsMap));
                        if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Meetup")) {
                            if (!groupDetailsMap.containsKey("name")) continue;
                            htmlStart = htmlStart.append(((JsonElement)groupDetailsMap.get("name")).getAsString() + "</br><hr/>");
                            continue;
                        }
                        for (Map.Entry<Object, Object> entry : groupDetailsMap.entrySet()) {
                            String key = (String)entry.getKey();
                            Object value = null;
                            if (((JsonElement)entry.getValue()).isJsonNull()) {
                                value = entry.getValue();
                            } else {
                                try {
                                    value = ((JsonElement)entry.getValue()).getAsString();
                                }
                                catch (UnsupportedOperationException e) {
                                    value = entry.getValue();
                                }
                                catch (IllegalStateException i) {
                                    value = entry.getValue();
                                }
                            }
                            htmlStart = htmlStart.append("<tr>");
                            htmlStart = htmlStart.append("<td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td>");
                            if (value instanceof JsonArray) {
                                LOGGER.debug((Object)"JSONArray Found!!!!!!");
                                htmlStart = htmlStart.append("<td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\"></td></tr>");
                                JsonArray array = (JsonArray)value;
                                for (int index = 0; index < array.size(); ++index) {
                                    htmlStart = htmlStart.append("<tr style=\"height: 10px !important;\"></tr>");
                                    JsonObject object = ((JsonArray)value).get(index).getAsJsonObject();
                                    Map<String, JsonElement> nestedMap = this.oauthUtils.jsonToMap(object);
                                    for (Map.Entry<String, JsonElement> nestedEntry : nestedMap.entrySet()) {
                                        String nestedKey = nestedEntry.getKey();
                                        JsonElement nestedValue = nestedEntry.getValue();
                                        htmlStart = htmlStart.append("<tr>");
                                        htmlStart = htmlStart.append("<td style=\"font-weight:bold;border:2px solid #949090; padding:2%; text-align:right;\">" + nestedKey + "</td>");
                                        htmlStart = htmlStart.append("<td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">" + nestedValue + "</td>");
                                        htmlStart = htmlStart.append("</tr>");
                                    }
                                }
                                htmlStart = htmlStart.append("<tr style=\"height: 10px !important;\"></tr>");
                                continue;
                            }
                            htmlStart = value != null ? htmlStart.append("<td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">" + value.toString().replaceAll("^\"|\"$", "") + "</td>") : htmlStart.append("<td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">" + value + "</td>");
                            htmlStart = htmlStart.append("</tr>");
                        }
                    }
                    if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Meetup")) {
                        htmlStart = htmlStart.append("</td></tr>");
                    }
                    htmlStart = htmlStart.append("</table>");
                    htmlStart = htmlStart.append("</div>");
                    htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
                }
                response.setContentType("text/html");
                response.getOutputStream().write(htmlStart.toString().getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                htmlStart = htmlStart.append("<div style=\"padding: 10px;margin-bottom: 30px;text-align:center;font-size:18pt;font-family=Courier New\">Oops! Something went wrong! </div><div style=\"padding: 15px;margin-bottom: 30px;text-align:left;font-family=Courier New\"><b style='font-size:17pt'>Possible Cause:</b><hr style=\"border: 1px solid #E6B3B2; \" class=\"header\" /> <p style='font-size:15pt;'> An unexpected error occured in response. Please check your configurations. </br> If you need any help, please <a href=\"https://miniorange.atlassian.net/servicedesk/customer/portal/2\"> click here</a> to reach out to us.</p></div>");
                response.setContentType("text/html");
                response.getOutputStream().write(htmlStart.toString().getBytes("UTF-8"));
                return;
            }
        }
    }

    private void showVerifyCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug((Object)"showVerifyCredentials function!");
        StringBuffer htmlStart = new StringBuffer("<head><style>table{font-family: arial, sans-serif;border-collapse: collapse;width: 100%;}td, th {border: 1px solid #dddddd;text-align: left;padding: 8px;}tr:nth-child(even){background-color: #dddddd;}</style></head><div style=\"font-family:Calibri;padding:0 3%;\">");
        if (StringUtils.isEmpty((CharSequence)this.googleRefreshToken)) {
            this.googleRefreshToken = this.settings.getGoogleRefreshToken();
        }
        if (StringUtils.isEmpty((CharSequence)this.googleRefreshToken)) {
            String refreshTokenResponse = this.endpointCallToGetRefreshToken(request.getParameter("code"));
            LOGGER.debug((Object)("refreshTokenResponse is " + refreshTokenResponse));
            JsonObject refreshTokenData = this.parser.parse(refreshTokenResponse).getAsJsonObject();
            if (refreshTokenData.has("refresh_token")) {
                this.refreshToken = refreshTokenData.get("refresh_token").getAsString();
                this.sendRequestToSaveToken(this.refreshToken);
                LOGGER.debug((Object)("Saved token after verify " + this.settings.getGoogleRefreshToken()));
                htmlStart = htmlStart.append("<div style=\"color: black; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">Thanks for verifying your account with the Administrator Account. Groups will be fetched for your users now. </div>");
            } else {
                htmlStart = htmlStart.append("<div style=\"color: black; padding:2%;margin-bottom:20px;text-align:left; border:1px solid #AEDB9A; font-size:16pt;\">Unable to Verify Admin Credentials.. Please make sure you are verifying the credentials with the Administrator Account.<br/><br/>If you signed in with an Admin Account and are still seeing this, please follow the below steps and try again.<ol><li>Login to <a href='https://www.google.com/settings/u/1/security'>Google Admin Console</a></li><li>Navigate to Sign In & security >> Apps with Account Access >> Manage Access.</li><li>Remove access for the App you are using to grant Google Groups permissions.</li><li>Close this popup and Verify Credentials again.</li></ol></div>");
            }
        } else {
            htmlStart = htmlStart.append("<div style=\"color: black; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">You have already verified the credentials of the administrator account. Groups of users will be fetched from Google.</div>");
        }
        htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        response.setContentType("text/html");
        response.getOutputStream().write(htmlStart.toString().getBytes());
    }

    private void sendRequestToSaveToken(String refreshToken) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", "saveRefreshToken"));
        postParameters.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        String Response = MoOAuthHttpUtils.sendPostRequest(this.settings.getCallBackUrl() + this.settings.getCustomizableCallbackURL(), postParameters, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("Response " + Response));
    }

    private String endpointCallToGetRefreshToken(String code) {
        String ACCESSTOKEN_ENDPOINT = this.settings.getAccessTokenEndpoint();
        String REDIRECT_URI = this.settings.getBaseUrl().concat("/plugins/servlet/oauth/callback") + this.settings.getCustomizableCallbackURL();
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", REDIRECT_URI));
        postParameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        postParameters.add((NameValuePair)new BasicNameValuePair("client_id", this.settings.getClientID()));
        postParameters.add((NameValuePair)new BasicNameValuePair("client_secret", this.settings.getClientSecret()));
        postParameters.add((NameValuePair)new BasicNameValuePair("code", code));
        String Response = MoOAuthHttpUtils.sendPostRequest(ACCESSTOKEN_ENDPOINT, postParameters, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("response " + Response));
        return Response;
    }

    private BambooUser tryCreateOrUpdateUser(HttpServletRequest request, String email, String userName, JsonObject getUserInfoData, String accessToken) {
        try {
            LOGGER.debug((Object)"Creating/Updating user.");
            String fullName = "";
            String firstName = "";
            String lastName = "";
            LOGGER.debug((Object)"Fetching FullName...");
            if (this.settings.getUseSeparateNameAttributes().booleanValue()) {
                if (StringUtils.isNotEmpty((CharSequence)this.settings.getFirstNameAttribute()) && this.userInfoMap.containsKey(this.settings.getFirstNameAttribute())) {
                    firstName = this.userInfoMap.get(this.settings.getFirstNameAttribute());
                    LOGGER.debug((Object)("First Name fetched for the attribute " + this.settings.getFirstNameAttribute() + " is......." + firstName));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.settings.getLastNameAttribute()) && this.userInfoMap.containsKey(this.settings.getLastNameAttribute())) {
                    lastName = this.userInfoMap.get(this.settings.getLastNameAttribute());
                    LOGGER.debug((Object)("Last Name  fetched for the attribute " + this.settings.getLastNameAttribute() + " is......." + lastName));
                }
                fullName = firstName + " " + lastName;
            } else if (StringUtils.isNotEmpty((CharSequence)this.settings.getFullNameAttribute()) && this.userInfoMap.containsKey(this.settings.getFullNameAttribute())) {
                fullName = this.userInfoMap.get(this.settings.getFullNameAttribute());
                LOGGER.debug((Object)("FullName fetched......." + fullName));
            }
            String id = "";
            if (StringUtils.equals((CharSequence)this.settings.getAppName(), (CharSequence)"Facebook")) {
                id = getUserInfoData.get("id").getAsString();
            }
            LOGGER.debug((Object)("id: " + id));
            String groupsResponse = "";
            groupsResponse = MoOAuthUserManager.fetchGroupInfo(getUserInfoData, request, email, id, this.settings, this.protocolAction, this.oauthUtils);
            if ((groupsResponse.isEmpty() || StringUtils.equals((CharSequence)groupsResponse, (CharSequence)"Failed")) && StringUtils.isNotEmpty((CharSequence)this.settings.getRoleAttribute()) && this.userInfoMap.containsKey(this.settings.getRoleAttribute())) {
                groupsResponse = this.userInfoMap.get(this.settings.getRoleAttribute());
                LOGGER.debug((Object)("Group Values fetched from user map......." + groupsResponse));
            }
            String groupValues = "";
            if (!groupsResponse.isEmpty() && !StringUtils.equals((CharSequence)groupsResponse, (CharSequence)"Failed")) {
                LOGGER.debug((Object)("Group Response is: " + groupsResponse));
                if (!groupsResponse.startsWith("[")) {
                    groupsResponse = "[" + groupsResponse + "]";
                }
                try {
                    JsonArray jsonArray = this.parser.parse(groupsResponse).getAsJsonArray();
                    LOGGER.debug((Object)("jsonArray :" + jsonArray));
                    for (int groupIndex = 0; groupIndex < jsonArray.size(); ++groupIndex) {
                        if (jsonArray.get(groupIndex).isJsonObject()) {
                            JsonObject getGroupUserInfoData = jsonArray.get(groupIndex).getAsJsonObject();
                            String value = this.oauthUtils.findKey(getGroupUserInfoData, this.settings.getRoleAttribute(), this.settings.getAppName());
                            if (StringUtils.isNotEmpty((CharSequence)value)) {
                                groupValues = groupValues + ";" + value;
                            }
                            LOGGER.debug((Object)("When object fetched Group Values are: " + groupValues));
                            continue;
                        }
                        String value = jsonArray.get(groupIndex).getAsString();
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            groupValues = groupValues + ";" + value;
                        }
                        LOGGER.debug((Object)("When String fetched Group Values are: " + groupValues));
                    }
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"error :", (Throwable)e);
                }
            }
            ArrayList<String> groupValueList = null;
            List<Object> groupsToAssign = new ArrayList();
            if (groupValues != null && StringUtils.isNotEmpty((CharSequence)groupValues)) {
                groupValueList = new ArrayList<String>(Arrays.asList(groupValues.split(";")));
                groupValueList.remove("");
            }
            LOGGER.debug((Object)("groupregexpattern = " + this.settings.getGroupRegexPatternEnabled()));
            if (this.settings.getGroupRegexPatternEnabled().booleanValue() && groupValueList != null) {
                for (int i = 0; i < groupValueList.size(); ++i) {
                    String groupname = MoOAuthLoginServlet.getGroupnameFromRegexMethod(this.settings.getRegexPatternForGroup(), this.settings.getRegexGroups(), groupValueList.get(i));
                    LOGGER.debug((Object)groupname);
                    groupValueList.set(i, groupname);
                }
            }
            String userIdentity = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLoginUserAttribute(), (CharSequence)"email")) {
                LOGGER.debug((Object)"Email attribute is selected for login/creating user in Bamboo");
                SearchResult emailUserSearchResult = this.bambooUserManager.getUsersByEmail(email);
                Pager pager = emailUserSearchResult.pager();
                int countUser = 0;
                String userFoundByEmail = "";
                for (Object user : pager) {
                    ++countUser;
                    if (user instanceof DefaultUser) {
                        userFoundByEmail = ((DefaultUser)user).getName();
                        continue;
                    }
                    if (!(user instanceof EmbeddedCrowdUser)) continue;
                    userFoundByEmail = ((EmbeddedCrowdUser)user).getName();
                }
                if (countUser > 1) {
                    LOGGER.error((Object)("More than one user found with the same email i.e " + email + " address."));
                    return null;
                }
                if (!StringUtils.isEmpty((CharSequence)userFoundByEmail)) {
                    BambooUser bambooUser = this.bambooUserManager.getBambooUser(userFoundByEmail);
                    LOGGER.debug((Object)("Bamboo user found by email  = " + bambooUser));
                    userIdentity = bambooUser.getName();
                }
                if (StringUtils.isEmpty((CharSequence)userIdentity)) {
                    userIdentity = StringUtils.isNotEmpty((CharSequence)userName) ? userName : (StringUtils.isNotEmpty((CharSequence)email) && !this.oauthUtils.isEmailId(email) ? email : email);
                }
            } else {
                userIdentity = StringUtils.isEmpty((CharSequence)userName) ? email : userName;
            }
            LOGGER.debug((Object)("User identity is " + userIdentity));
            BambooUser updateBambooUser = null;
            List<String> defaultGroupsList = this.settings.getDefaultGroupsList();
            if (this.bambooUserManager.getBambooUser(userIdentity) != null) {
                LOGGER.debug((Object)("User exists: " + userIdentity));
                updateBambooUser = this.bambooUserManager.getBambooUser(userIdentity);
                if (!BooleanUtils.toBoolean((Boolean)this.settings.getKeepExistingUserAttributes())) {
                    try {
                        LOGGER.debug((Object)"Updating user attributes.");
                        if (fullName.isEmpty()) {
                            fullName = updateBambooUser.getFullName();
                        }
                        updateBambooUser = MoOAuthUserManager.saveAPICall("saveUser", userIdentity, email, fullName);
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)("An exception occurs while updating user. " + e));
                    }
                }
                Boolean canBeUpdated = this.canGroupBeUpdated(userIdentity);
                List existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)this.bambooUserManager.getBambooUser(userIdentity));
                ArrayList<String> newGroupsToAssign = new ArrayList<String>();
                newGroupsToAssign.addAll(existingGroupsOfUser);
                if (!BooleanUtils.toBoolean((Boolean)this.settings.getKeepExistingUserRoles())) {
                    LOGGER.debug((Object)"Existing user groups can be updated. Updating groups");
                    if (BooleanUtils.toBoolean((Boolean)this.settings.getOnTheFlyGroupMapping())) {
                        LOGGER.debug((Object)"On the Fly Group mapping is enabled");
                        if (!StringUtils.equals((CharSequence)this.settings.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"None") && groupValueList != null) {
                            groupValueList = this.onTheFlyFilterIDPGroups(groupValueList);
                            LOGGER.debug((Object)("List of IDP Groups after applying filter :" + groupValueList.toString()));
                        }
                        List<String> onTheFlyGroupsToAssign = new ArrayList();
                        List doNotRemoveFromGroups = (List)this.settings.getOnTheFlyDoNotRemoveGroups();
                        if (!BooleanUtils.toBoolean((Boolean)this.settings.getOnTheFlyAssignNewGroupsOnly())) {
                            for (String group : existingGroupsOfUser) {
                                if (doNotRemoveFromGroups.contains(group) || !BooleanUtils.toBoolean((Boolean)canBeUpdated) || groupValueList.contains(group)) continue;
                                if (this.bambooPermissionManager.getAdminGroups().contains(group)) {
                                    LOGGER.debug((Object)(group + " has ADMINISTRATOR permission & checking for single admin "));
                                    if (this.getAdminUsers().size() <= 1 || this.settings.getExcludeGroupsRegexPattern().booleanValue() && this.checkExcludeGroupRegex(group)) continue;
                                    newGroupsToAssign.remove(group);
                                    continue;
                                }
                                if (this.settings.getExcludeGroupsRegexPattern().booleanValue() && this.checkExcludeGroupRegex(group)) continue;
                                newGroupsToAssign.remove(group);
                            }
                        }
                        if (groupValues != null && StringUtils.isNotEmpty((CharSequence)groupValues)) {
                            LOGGER.debug((Object)"Assigning groups from response");
                            onTheFlyGroupsToAssign = this.createAndAssignGroups(groupValueList, userIdentity);
                            for (String newGroups : onTheFlyGroupsToAssign) {
                                if (!BooleanUtils.toBoolean((Boolean)canBeUpdated) || newGroupsToAssign.contains(newGroups)) continue;
                                newGroupsToAssign.add(newGroups);
                            }
                        }
                    } else {
                        LOGGER.debug((Object)"Manual Group mapping is enabled");
                        if (groupValues != null && StringUtils.isNotEmpty((CharSequence)groupValues)) {
                            groupsToAssign = this.getListOfMappedGroupsToAssign(groupValueList);
                        }
                        if (!this.settings.getRoleAttribute().isEmpty()) {
                            for (Object newGroups : groupsToAssign) {
                                if (!BooleanUtils.toBoolean((Boolean)canBeUpdated) || existingGroupsOfUser.contains(newGroups)) continue;
                                newGroupsToAssign.add((String)newGroups);
                            }
                            HashMap<String, String> roleMapping = this.settings.getRoleMapping();
                            for (String groups : existingGroupsOfUser) {
                                if (groupsToAssign.contains(groups) || !StringUtils.isNotEmpty((CharSequence)roleMapping.get(groups)) || !BooleanUtils.toBoolean((Boolean)canBeUpdated) || !existingGroupsOfUser.contains(groups)) continue;
                                newGroupsToAssign.remove(groups);
                            }
                        } else {
                            LOGGER.debug((Object)"RoleAttribute() is EMPTY.");
                        }
                    }
                } else {
                    LOGGER.debug((Object)"Existing user group updating is set to FALSE. KeepExistingUserRoles is checked");
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getEnableDefaultGroupsFor(), (CharSequence)"allUsers")) {
                    LOGGER.debug((Object)"Assigning default groups to existing user");
                    if (defaultGroupsList != null && defaultGroupsList.size() > 0) {
                        for (String group : defaultGroupsList) {
                            if (!BooleanUtils.toBoolean((Boolean)canBeUpdated) || newGroupsToAssign.contains(group)) continue;
                            newGroupsToAssign.add(group);
                        }
                    } else if (BooleanUtils.toBoolean((Boolean)canBeUpdated) && !newGroupsToAssign.contains(this.settings.getDefaultGroup())) {
                        newGroupsToAssign.add(this.settings.getDefaultGroup());
                    }
                }
                if (!BooleanUtils.toBoolean((Boolean)this.settings.getKeepExistingUserRoles()) || StringUtils.equalsIgnoreCase((CharSequence)this.settings.getEnableDefaultGroupsFor(), (CharSequence)"allUsers")) {
                    LOGGER.debug((Object)("New groups to be assgined to the SSO user : " + ((Object)newGroupsToAssign).toString()));
                    LOGGER.debug((Object)"making call to group update API");
                    MoOAuthUserManager.groupUpdateAPICall("updateGroups", userIdentity, newGroupsToAssign);
                }
                return updateBambooUser;
            }
            LOGGER.debug((Object)"User DOES NOT exist. Creating new user.");
            if (!BooleanUtils.toBoolean((Boolean)this.settings.getRestrictUserCreation())) {
                if (!email.isEmpty()) {
                    if (StringUtils.isBlank((CharSequence)fullName)) {
                        fullName = userIdentity;
                    }
                    if (BooleanUtils.toBoolean((Boolean)this.settings.getOnTheFlyGroupMapping())) {
                        LOGGER.debug((Object)"On the Fly Group mapping is enabled");
                        if (!StringUtils.equals((CharSequence)this.settings.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"None") && groupValueList != null) {
                            groupValueList = this.onTheFlyFilterIDPGroups(groupValueList);
                            LOGGER.debug((Object)("List of IDP Groups after applying filter :" + groupValueList.toString()));
                        }
                        if (groupValues != null && StringUtils.isNotEmpty((CharSequence)groupValues)) {
                            groupsToAssign = this.createAndAssignGroups(groupValueList, userIdentity);
                        }
                    } else {
                        LOGGER.debug((Object)"Manual Group mapping is enabled");
                        if (groupValues != null && StringUtils.isNotEmpty((CharSequence)groupValues)) {
                            groupsToAssign = this.getListOfMappedGroupsToAssign(groupValueList);
                        }
                        if (!this.settings.getCreateUsersIfRoleMapped().booleanValue() || groupsToAssign.size() > 0) {
                            LOGGER.debug((Object)("Roles found. Creating user with Username: " + userIdentity + ", Email: " + email + ", Name:" + fullName));
                        } else {
                            LOGGER.debug((Object)("groups are not properly mapped for the email " + email));
                            return null;
                        }
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)this.settings.getEnableDefaultGroupsFor(), (CharSequence)"doNotAssignDefaultGroup")) {
                        LOGGER.debug((Object)"Assigning default groups to new user");
                        if (defaultGroupsList != null && defaultGroupsList.size() > 0) {
                            groupsToAssign.addAll(defaultGroupsList);
                        } else {
                            groupsToAssign.add(this.settings.getDefaultGroup());
                        }
                    }
                    LOGGER.debug((Object)("username = " + userIdentity + "email = " + email + "fullName = " + fullName + "Groups = " + groupsToAssign));
                    return MoOAuthUserManager.createAPICall("createUser", userIdentity, email, fullName, groupsToAssign);
                }
                LOGGER.debug((Object)"User creation failed due to empty email");
                return null;
            }
            LOGGER.debug((Object)"User creation is disabled for all the users.");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Boolean authoriseUserAndEstablishSession(DefaultAuthenticator authenticator, Object userObject, HttpServletRequest request, HttpServletResponse response) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, AuthenticatorException {
        Principal principal = (Principal)userObject;
        Method authUserMethod = DefaultAuthenticator.class.getDeclaredMethod("authoriseUserAndEstablishSession", HttpServletRequest.class, HttpServletResponse.class, Principal.class);
        authUserMethod.setAccessible(true);
        Boolean result = (Boolean)authUserMethod.invoke((Object)authenticator, request, response, principal);
        LOGGER.debug((Object)("Authentication Result: " + result + " Is cookie Enabled?: " + this.settings.getRememberMeCookieEnabled()));
        if (result.booleanValue() && this.settings.getRememberMeCookieEnabled().booleanValue()) {
            reqObjectForRememberMe = request;
            respObjectForRememberMe = response;
            ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
            postParameters.add((NameValuePair)new BasicNameValuePair("action", "rememberMeFeature"));
            postParameters.add((NameValuePair)new BasicNameValuePair("name", principal.getName()));
            String Response = MoOAuthHttpUtils.sendPostRequest("http://localhost:8085/plugins/servlet/oauth/moapi", postParameters, "application/x-www-form-urlencoded", null);
            LOGGER.debug((Object)("response " + Response));
        }
        MoOAuthHttpUtils.setCookie("mo.bamboo-oauth.logoutcookie", "mo.bamboo-oauth.logoutcookie", response);
        return result;
    }

    private void redirectToSuccessfulAuthLandingPage(HttpServletRequest request, HttpServletResponse response, String relayState) throws IOException {
        String redirectUrl = this.settings.getDashboardUrl();
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            redirectUrl = StringUtils.contains((CharSequence)relayState, (CharSequence)"://") ? relayState : this.settings.getBaseUrl().concat(relayState);
        }
        LOGGER.debug((Object)("Redirecting user to " + redirectUrl));
        MoOAuthManager.httpRedirect(response, redirectUrl);
    }

    private void redirectToLoginWithOAuthError(HttpServletResponse response, Exception exception, String oauthError) throws IOException, ServletException {
        if (exception != null) {
            LOGGER.error((Object)("OAuth Plugin error: " + exception.getMessage()), (Throwable)exception);
        }
        String redirectUrl = this.settings.getLoginPageUrl() + "?oautherror=" + oauthError;
        try {
            if (this.settings.getEnableErrorMsgTemplate().booleanValue()) {
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("baseURL", this.settings.getBaseUrl());
                StringBuffer result = new StringBuffer(this.renderer.renderFragment(this.settings.getErrorMsgTemplate(), context));
                response.setContentType("text/html");
                response.getOutputStream().write(result.toString().getBytes());
            } else {
                redirectUrl = redirectUrl + "&oauth_sso=false";
                MoOAuthManager.httpRedirect(response, redirectUrl);
            }
        }
        catch (Exception e) {
            MoOAuthManager.httpRedirect(response, redirectUrl);
        }
    }

    private void authoriseAndRedirect(JsonObject getUserInfoData, HttpServletRequest request, HttpServletResponse response, String email, Boolean regexEnabled, String accessToken) throws IOException, ServletException {
        LOGGER.debug((Object)"Initiating user authentication and authorization flow");
        try {
            Boolean isDomainAllowed = Boolean.TRUE;
            LOGGER.debug((Object)("email address : " + email));
            String username = "";
            LOGGER.debug((Object)"Fetching Username...");
            if (StringUtils.isNotEmpty((CharSequence)this.settings.getUsernameAttribute())) {
                LOGGER.debug((Object)("Fetching Username from configured username attribute" + this.settings.getUsernameAttribute()));
                if (this.oauthUtils.checkIfKeyExist(this.userInfoMap, this.settings.getUsernameAttribute())) {
                    username = this.oauthUtils.getValue(this.userInfoMap, this.settings.getUsernameAttribute());
                    username = username.replace("\"", "");
                    LOGGER.debug((Object)("Username from map :" + username));
                } else {
                    username = this.oauthUtils.findKey(getUserInfoData, this.settings.getUsernameAttribute(), this.settings.getAppName());
                    username = username.replace("\"", "");
                    LOGGER.debug((Object)("Username from key :" + username));
                }
            }
            LOGGER.debug((Object)("SSO User's username : " + username));
            LOGGER.info((Object)"Fetching Email.....");
            String emailAttribute = this.settings.getEmailAttribute();
            if (StringUtils.isNotBlank((CharSequence)emailAttribute)) {
                String[] emailAttrValueArray;
                for (String emailAttr : emailAttrValueArray = emailAttribute.split(";")) {
                    if (this.oauthUtils.checkIfKeyExist(this.userInfoMap, emailAttr = StringUtils.trimToEmpty((String)emailAttr))) {
                        email = this.oauthUtils.getValue(this.userInfoMap, emailAttr);
                        if (!this.oauthUtils.isEmailId(email)) continue;
                        break;
                    }
                    email = this.oauthUtils.findKey(getUserInfoData, emailAttr, this.settings.getAppName());
                }
            }
            LOGGER.debug((Object)("email : " + email));
            LOGGER.debug((Object)("SSO User's email : " + email));
            if (regexEnabled.booleanValue() && StringUtils.isNotBlank((CharSequence)username)) {
                LOGGER.debug((Object)"regex enabled...");
                Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)this.settings.getRegexPattern()));
                Matcher matcher = pattern.matcher(username);
                LOGGER.debug((Object)("matcher : " + matcher));
                try {
                    if (matcher.find()) {
                        username = "";
                        if (matcher.groupCount() > 0) {
                            for (int i = 1; i <= matcher.groupCount(); ++i) {
                                username = username + matcher.group(i);
                            }
                        } else {
                            username = matcher.group();
                        }
                        LOGGER.debug((Object)("Username after appling regex: " + username));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Invalid regex pattern");
                    this.redirectToLoginWithOAuthError(response, null, "cant_signin_regex_pattern_exception");
                    return;
                }
            }
            LOGGER.debug((Object)("Customer email received: " + email));
            if (!email.isEmpty() && StringUtils.isNotEmpty((CharSequence)this.settings.getAllowedDomains())) {
                isDomainAllowed = this.checkForAllowedDomain(email);
            }
            if (BooleanUtils.toBoolean((Boolean)isDomainAllowed)) {
                BambooUser userObject;
                Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
                Method getUserMethod = DefaultAuthenticator.class.getDeclaredMethod("getUser", String.class);
                getUserMethod.setAccessible(true);
                if (authenticator instanceof DefaultAuthenticator && (userObject = this.tryCreateOrUpdateUser(request, email, username, getUserInfoData, this.accessToken)) != null) {
                    BambooUser bambooUser = userObject;
                    if (!bambooUser.isEnabled()) {
                        LOGGER.error((Object)"User is deactivated. Can't create user session.");
                        this.redirectToLoginWithOAuthError(response, null, "user_is_deactivated_contact_admin");
                        return;
                    }
                    LOGGER.debug((Object)("Establishing session for: " + bambooUser.getName()));
                    boolean result = this.authoriseUserAndEstablishSession((DefaultAuthenticator)authenticator, userObject, request, response);
                    if (result) {
                        LOGGER.debug((Object)("Session created Successfully! redirect url = " + this.getSessionAttribute("return_to", request)));
                        String returnTo = this.getSessionAttribute("return_to", request);
                        if (StringUtils.isNotEmpty((CharSequence)this.settings.getRelayState())) {
                            this.redirectToSuccessfulAuthLandingPage(request, response, this.settings.getRelayState());
                        } else if (StringUtils.isNotBlank((CharSequence)returnTo)) {
                            this.redirectToSuccessfulAuthLandingPage(request, response, returnTo);
                        } else {
                            this.redirectToSuccessfulAuthLandingPage(request, response, this.settings.getBaseUrl());
                        }
                        return;
                    }
                    LOGGER.error((Object)"Session could NOT be created. Redirecting user to login page.");
                }
            } else {
                LOGGER.error((Object)"User is restricted to login");
                this.redirectToLoginWithOAuthError(response, null, "user_not_allowed");
                return;
            }
            this.redirectToLoginWithOAuthError(response, null, "cant_signin_check_configuration");
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while signing in the user.", (Throwable)e);
            this.redirectToLoginWithOAuthError(response, e, "cant_signin_check_configuration");
            return;
        }
    }

    private String getSessionAttribute(String attributeName, HttpServletRequest request) {
        HttpSession session = request.getSession();
        String returnTo = (String)session.getAttribute(attributeName);
        return returnTo;
    }

    private List<String> createAndAssignGroups(ArrayList<String> roleValuesList, String userIdentity) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        Boolean canCreateNewGroups = this.settings.getOnTheFlyCreateNewGroups();
        try {
            for (String groupsName : roleValuesList) {
                Group bambooGroup;
                if (this.bambooUserManager.getGroup(groupsName.trim()) == null && BooleanUtils.toBoolean((Boolean)canCreateNewGroups)) {
                    LOGGER.debug((Object)("Creating New Group : " + groupsName.trim()));
                    MoOAuthUserManager.groupCreateAPICall("createGroup", userIdentity, groupsName.trim());
                }
                if ((bambooGroup = this.bambooUserManager.getGroup(groupsName.trim())) != null) {
                    LOGGER.debug((Object)("Assigning Bamboo Group to user with name : " + bambooGroup.getName().trim()));
                    groupsToAssign.add(groupsName.trim());
                    continue;
                }
                LOGGER.debug((Object)("Group not present in Bamboo with name : " + groupsName.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An Error occurred while creating a list of group for assigning the user");
            e.printStackTrace();
        }
        return groupsToAssign;
    }

    private List<String> getListOfMappedGroupsToAssign(ArrayList<String> roleValuesList) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        if (roleValuesList != null && roleValuesList.size() > 0) {
            HashMap<String, String> roleMapping = this.settings.getRoleMapping();
            for (String key : roleMapping.keySet()) {
                String value = roleMapping.get(key);
                String[] groupNamesConfigured = StringUtils.split((String)value, (String)";");
                for (int i = 0; i < groupNamesConfigured.length; ++i) {
                    Group bambooUsersGroup;
                    String groupValue = groupNamesConfigured[i];
                    if (!roleValuesList.contains(groupValue) || (bambooUsersGroup = this.bambooUserManager.getGroup(key)) == null) continue;
                    groupsToAssign.add(bambooUsersGroup.toString());
                }
            }
        }
        return groupsToAssign;
    }

    private boolean checkForAllowedDomain(String email) {
        String[] domains = this.settings.getAllowedDomains().split(";");
        String userDomain = email.split("@")[1];
        for (int index = 0; index < domains.length; ++index) {
            if (!StringUtils.equals((CharSequence)StringUtils.trimToEmpty((String)domains[index]), (CharSequence)userDomain)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean canGroupBeUpdated(String userIdentity) {
        com.atlassian.crowd.embedded.api.User user;
        LOGGER.debug((Object)"canGroupBeUpdated called");
        if (this.settings.getCurrentBuildNumber() < 60604) {
            return !this.bambooUserManager.isReadOnly(this.bambooUserManager.getUser(userIdentity));
        }
        CrowdService crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentLocator.getComponent(CrowdDirectoryService.class);
        Directory directory = crowdDirectoryService.findDirectoryById((user = crowdService.getUser(userIdentity)).getDirectoryId());
        return directory == null ? false : directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private Collection<String> getAdminUsers() {
        HashSet<String> adminUsers = new HashSet<String>();
        adminUsers.addAll(this.bambooPermissionManager.getAdminUsers());
        adminUsers.addAll(this.bambooPermissionManager.getRestrictedAdminUsers());
        for (String groupName : this.bambooPermissionManager.getAdminGroups()) {
            List users = this.bambooUserManager.getMemberNamesAsList(this.bambooUserManager.getGroup(groupName));
            adminUsers.addAll(users);
        }
        return adminUsers;
    }

    private ArrayList<String> onTheFlyFilterIDPGroups(ArrayList<String> idpGroups) {
        ArrayList<String> filteredGroups;
        block6: {
            block7: {
                block5: {
                    filteredGroups = new ArrayList<String>();
                    LOGGER.debug((Object)("Filtering IDP groups using filter type : " + this.settings.getOnTheFlyFilterIDPGroupsOption() + ", and filter key :" + this.settings.getOnTheFlyFilterIDPGroupsKey()));
                    if (!StringUtils.equals((CharSequence)this.settings.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Starts with")) break block5;
                    for (String group : idpGroups) {
                        if (!StringUtils.startsWith((CharSequence)group, (CharSequence)this.settings.getOnTheFlyFilterIDPGroupsKey())) continue;
                        filteredGroups.add(group);
                    }
                    break block6;
                }
                if (!StringUtils.equals((CharSequence)this.settings.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Contains")) break block7;
                for (String group : idpGroups) {
                    if (!StringUtils.contains((CharSequence)group, (CharSequence)this.settings.getOnTheFlyFilterIDPGroupsKey())) continue;
                    filteredGroups.add(group);
                }
                break block6;
            }
            if (!StringUtils.equals((CharSequence)this.settings.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Regex")) break block6;
            Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)this.settings.getOnTheFlyFilterIDPGroupsKey()));
            for (String group : idpGroups) {
                Matcher matcher = pattern.matcher(group);
                try {
                    if (!matcher.find()) continue;
                    filteredGroups.add(group);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error while filtering groups using regex pattern", (Throwable)e);
                }
            }
        }
        return filteredGroups;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public void setOAuthManager(MoOAuthManager oauthManager) {
        this.oauthManager = oauthManager;
    }

    public MoOAuthUtils getOauthUtils() {
        return this.oauthUtils;
    }

    public void setOauthUtils(MoOAuthUtils oauthUtils) {
        this.oauthUtils = oauthUtils;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private boolean checkExcludeGroupRegex(String group) {
        Pattern pattern = Pattern.compile(this.settings.getRegexPatternForExcludeGroups(), 2);
        Matcher matcher = pattern.matcher(group);
        return matcher.find();
    }

    public HashMap<String, String> getUserInfoMap() {
        return this.userInfoMap;
    }

    public void setUserInfoMap(HashMap<String, String> userInfoMap) {
        this.userInfoMap = userInfoMap;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

