/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.servlet.utils;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.crowd.common.config.MoConnectorConfigAjax;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoHttpUtils;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoConfluenceUtils
implements MoPlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfluenceUtils.class);
    private static final String DEFAULT_LOGIN_TEMPLATE_PATH_FOR_CONFLUENCE = "/templates/defaultLoginTemplateConfluence.vm";

    @Override
    public String getBaseUrl() {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        return settingsManager.getGlobalSettings().getBaseUrl();
    }

    @Override
    public String getBackDoorUrl(String baseUrl) {
        return baseUrl.concat("/login.action");
    }

    @Override
    public String getAdminBackDoorUrl(String baseUrl) throws UnsupportedEncodingException {
        return baseUrl.concat(URLEncoder.encode(this.getBaseUrl().concat("/authenticate.action"), "UTF-8"));
    }

    @Override
    public MoConnectorConfigAjax initializeConfig(MoPluginConfigurationManager pluginConfigurationManager, HashMap<String, String> savedConfiguration, String platform, Boolean autoRedirectToIDP, String crowdDomainURL, String ssoButtonText, Boolean backdoorEnabled, Boolean enableAutoRedirectDelay, Boolean configured, Boolean useLoginTemplate, String loginTemplate, Boolean useErrorTemplate, String errorTemplate, String defaultRedirectRule, String defaultRedirectURL, Boolean showSSOButton, Boolean showLoginPage, String backdoorKey, String backdoorValue, Boolean enableGlobalSSO, String ssoPath) {
        try {
            LOGGER.debug("Initializing confluence specific config");
            Boolean domainMappingForConfluence = Boolean.FALSE;
            HashMap<String, String> idpsForConfluence = new HashMap<String, String>();
            Iterator<String> iterator = savedConfiguration.keySet().iterator();
            while (iterator.hasNext()) {
                ObjectMapper mapper = new ObjectMapper();
                String idpId = iterator.next();
                MoCrowdConnectorSSOConfig config = (MoCrowdConnectorSSOConfig)mapper.readValue(savedConfiguration.get(idpId), MoCrowdConnectorSSOConfig.class);
                if (config.getSsoForConfluence().booleanValue()) {
                    idpsForConfluence.put(idpId, config.getIdpName());
                }
                if (pluginConfigurationManager.getAppRedirectionRulesMap().size() <= 0 || !config.getSsoForConfluence().booleanValue() || domainMappingForConfluence.booleanValue()) continue;
                domainMappingForConfluence = Boolean.TRUE;
            }
            return new MoConnectorConfigAjax(configured, autoRedirectToIDP, crowdDomainURL, pluginConfigurationManager.getBaseUrl(), pluginConfigurationManager.getJSDBaseUrl(), ssoButtonText, backdoorEnabled, enableAutoRedirectDelay, pluginConfigurationManager.getRedirectionParameter(), null, null, null, null, idpsForConfluence, domainMappingForConfluence, null, null, null, null, null, null, platform, useLoginTemplate, loginTemplate, useErrorTemplate, errorTemplate, defaultRedirectRule, defaultRedirectURL, showSSOButton, showLoginPage, backdoorKey, backdoorValue, enableGlobalSSO, ssoPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error in ConfluenceUtils initializeConfig : " + e.toString());
            return null;
        }
    }

    @Override
    public HashMap<String, String> saveOrUpdateCrowdSSOConfig(HashMap<String, String> connectorsSSOConfig, String[] redirectDomainMapping, String[] redirectGroupMapping, ArrayList<Boolean> ssoForJIRASoftware, ArrayList<Boolean> ssoForJSD, ArrayList<Boolean> ssoForConfluence, ArrayList<Boolean> ssoForfisheye, ArrayList<Boolean> ssoForbitbucket, ArrayList<Boolean> ssoForbamboo) {
        try {
            int index = 0;
            for (String idpId : connectorsSSOConfig.keySet()) {
                MoCrowdConnectorSSOConfig ssoConfig = new MoCrowdConnectorSSOConfig();
                ObjectMapper mapper = new ObjectMapper();
                ssoConfig = (MoCrowdConnectorSSOConfig)mapper.readValue(connectorsSSOConfig.get(idpId), MoCrowdConnectorSSOConfig.class);
                LOGGER.debug("saved Crowd Connector SSO Config  : " + ssoConfig.toString());
                ssoConfig.setSsoForConfluence(ssoForConfluence.get(index));
                String jsonString = mapper.writeValueAsString((Object)ssoConfig);
                connectorsSSOConfig.put(idpId, jsonString);
                ++index;
            }
            return connectorsSSOConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error in ConfluenceUtils saveOrUpdateCrowdSSOConfig : " + e.toString());
            return null;
        }
    }

    @Override
    public String getDefaultLogoutTemplate() {
        String template = "<html>\n    <head>\n        $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n        <meta name=\"decorator\" content=\"atl.general\">\n        <style>\n            #main.aui-page-panel {\n                border: 1px solid #ccc;\n                border-radius: 5px;\n                margin: 50px auto 0 auto;\n                min-height: 190px;\n                overflow: auto;\n                max-width: 500px;\n            }\n        </style>\n    </head>\n    <body id=\"com-atlassian-confluence\" class=\"theme-default login aui-layout aui-theme-default\">\n    <div id=\"stp-licenseStatus-banner\"></div>\n    <div id=\"page\">\n        <div id=\"full-height-container\">\n            <div id=\"login-container\">\n                <div class=\"login-section \">\n                    <div class=\"aui-message aui-message-success shadowed\">\n                        <p class=\"title\">You have been successfully logged out. Any automatic login has also been\n                            stopped.</p>\n                        <p>Didn't mean to log out?<a href=\"$baseUrl\"> Log in again.</a>\n                        <p>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n    </div>\n    </body>\n</html>";
        return template;
    }

    @Override
    public String getDefaultErrorTemplate() {
        String errorTemplate = "<html>\n <head>\n  <title>SSO Error</title>\n  \t $webResourceManager.requireResource(\"$pluginproperties.pluginkey:resources\")\n \t <meta name=\"decorator\" content=\"atl.general\">\n\t <style>\n\t\t #main.aui-page-panel {\n\t\t\t border: 1px solid #ccc;\n\t\t\t border-radius: 5px;\n\t\t\t margin: 50px auto 0 auto;\n\t\t\t min-height: 200px;\n\t\t\t overflow: auto;\n\t\t\t max-width: 500px;\n\t\t }\n\t </style>\n </head>\n  <body id =\"com-atlassian-confluence\" class=\"theme-default login aui-layout aui-theme-default\" >\n  <hr/>\n  <div id = \"stp-licenseStatus-banner\" ></div>\n\t\t<div id=\"page\">\n\t\t\t<div id=\"full-height-container\">\n\t\t\t\t<div id=\"login-container\">\n\t\t\t\t\t<div class=\"login-section \">\n\t\t\t\t\t\t<div class=\"aui-message aui-message-error\">\n\t\t\t\t\t\t\t<p class=\"title\">Single Sign-on failed.</p>\n\t\t\t\t\t\t\t<p>Please contact administrator for more information.<p>\n\t\t\t\t\t\t\t<p>Click <a href=\"$baseUrl\">here</a> to go to the login page.</p>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n </body>\n</html>\n";
        return errorTemplate;
    }

    @Override
    public String getDefaultLoginTemplate() {
        String loginTemplate = "";
        try {
            loginTemplate = IOUtils.toString((InputStream)MoPluginConfigurationManager.class.getResourceAsStream(DEFAULT_LOGIN_TEMPLATE_PATH_FOR_CONFLUENCE), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return loginTemplate;
    }

    @Override
    public String doesUserHaveAccess(String username, String pwd, String url) {
        try {
            ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
            postParameters.add((NameValuePair)new BasicNameValuePair("action", "doesUserHaveAccess"));
            postParameters.add((NameValuePair)new BasicNameValuePair("username", username));
            postParameters.add((NameValuePair)new BasicNameValuePair("pwd", pwd));
            url = url + "/plugins/servlet//confluenceUtil";
            String response = MoHttpUtils.sendPostRequest(url, postParameters, "application/x-www-form-urlencoded", null);
            return response;
        }
        catch (Exception e) {
            LOGGER.debug("\nException occured :- " + e);
            return "FALSE";
        }
    }

    @Override
    public boolean isUserLoggedIn() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return confluenceUser != null;
    }
}

