/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.rest;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.AccountNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoHttpUtils;
import java.io.IOException;
import java.util.Enumeration;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoEnableBackdoorUrl
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoEnableBackdoorUrl.class);
    private CrowdService crowdService;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private I18nResolver i18nResolver;
    @ComponentImport
    private UserManager userManager;

    @Autowired
    public MoEnableBackdoorUrl(CrowdService crowdService, UserManager userManager, MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver) {
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug((Object)"Enable Backdoor servlet called from doGet");
        JSONObject responseJson = new JSONObject();
        responseJson.put("Status", "ERROR");
        responseJson.put("Message", "GET method is not allowed");
        responseJson.put("Description", "The method received in the request-line is known by the origin server but not supported by the target resource. Use POST instead of GET");
        resp.setStatus(405);
        resp.setContentType("application/json");
        resp.getOutputStream().write(responseJson.toString().getBytes());
        resp.getOutputStream().close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)"Enable Backdoor servlet called from doPost");
        String key = "";
        String value = "";
        String username = "";
        String password = "";
        Boolean isAdmin = Boolean.FALSE;
        Boolean isAuthenticated = Boolean.FALSE;
        JSONObject responseJson = new JSONObject();
        Enumeration requestHeader = request.getHeaderNames();
        LOGGER.debug((Object)("Request Header : " + requestHeader.toString()));
        while (requestHeader.hasMoreElements()) {
            LOGGER.debug((Object)"Extracting request header information");
            key = (String)requestHeader.nextElement();
            if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
            LOGGER.debug((Object)"Extracting Authorization keys");
            value = request.getHeader(key);
            value = value.split(" ")[1];
            byte[] valueDecoded = Base64.decodeBase64((String)value);
            value = MoHttpUtils.sanitizeText(new String(valueDecoded));
            String[] arr = value.split(":");
            if (arr.length >= 1) {
                username = arr[0];
            }
            if (arr.length < 2) break;
            password = arr[1];
            break;
        }
        if (StringUtils.isEmpty((CharSequence)username) && StringUtils.isEmpty((CharSequence)password)) {
            LOGGER.error((Object)"username and password not found in the request");
            response.setStatus(400);
            responseJson.put("Status", "ERROR");
            responseJson.put("Message", "username and password not found");
            responseJson.put("Description", "API is protected with HTTP basic authentication. Pass the authentication information to the server in an Authorization header.");
        } else if (StringUtils.isEmpty((CharSequence)username)) {
            LOGGER.error((Object)"username not found in the request");
            response.setStatus(400);
            responseJson.put("Status", "ERROR");
            responseJson.put("Message", "username not found");
            responseJson.put("Description", "API is protected with HTTP basic authentication. Pass the authentication information to the server in an Authorization header.");
        } else if (StringUtils.isEmpty((CharSequence)password)) {
            LOGGER.error((Object)"password not found in the request");
            response.setStatus(400);
            responseJson.put("Status", "ERROR");
            responseJson.put("Message", "password not found");
            responseJson.put("Description", "API is protected with HTTP basic authentication. Pass the authentication information to the server in an Authorization header.");
        } else {
            try {
                LOGGER.debug((Object)("Authenticating user : " + username));
                User user = this.crowdService.authenticate(username, password);
                LOGGER.debug((Object)"The user is authenticated successfully");
                isAuthenticated = Boolean.TRUE;
            }
            catch (AccountNotFoundException e) {
                LOGGER.error((Object)"The user does not exist", (Throwable)e);
                response.setStatus(401);
                responseJson.put("Status", "ERROR");
                responseJson.put("Message", "Account Not Found.");
                responseJson.put("Description", "User with the given name could not be found in Confluence");
            }
            catch (InactiveAccountException e) {
                LOGGER.error((Object)"The user does not exist", (Throwable)e);
                response.setStatus(401);
                responseJson.put("Status", "ERROR");
                responseJson.put("Message", "Inactive Account.");
                responseJson.put("Description", "The user account is inactive");
            }
            catch (ExpiredCredentialException e) {
                LOGGER.error((Object)"The user's credentials have expired", (Throwable)e);
                response.setStatus(401);
                responseJson.put("Status", "ERROR");
                responseJson.put("Message", "Expired Credential.");
                responseJson.put("Description", "The user's credentials have expired. The user must change their credentials in order to successfully authenticate.");
            }
            catch (FailedAuthenticationException e) {
                LOGGER.error((Object)"The user could not be authenticated.", (Throwable)e);
                response.setStatus(401);
                responseJson.put("Status", "ERROR");
                responseJson.put("Message", "Basic Authentication Failed");
                responseJson.put("Description", "Authentication with the provided credentials failed. It may indicate that the user does not exist or the user's account is inactive or the credentials are incorrect");
            }
            catch (OperationFailedException e) {
                LOGGER.error((Object)"The user could not be authenticated.", (Throwable)e);
                response.setStatus(401);
                responseJson.put("Status", "ERROR");
                responseJson.put("Message", "Basic Authentication Failed");
                responseJson.put("Description", "An unknown exception occured while authenticating the user");
            }
            if (isAuthenticated.booleanValue()) {
                isAdmin = this.userManager.isAdmin(username);
                LOGGER.debug((Object)("The user has a system admin permission ? " + isAdmin));
            }
        }
        if (isAdmin.booleanValue() && isAuthenticated.booleanValue()) {
            LOGGER.debug((Object)"User is authorised. Enabling the backdoor url");
            this.pluginConfigurationManager.setBackdoorEnabled(Boolean.TRUE);
            responseJson.put("Status", "SUCCESS");
            responseJson.put("Message ", " Backdoor is enabled successfully");
            String backdoorURL = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)"jira", (CharSequence)this.i18nResolver.getText("my.plugin.platform"))) {
                backdoorURL = this.pluginConfigurationManager.getJIRALoginPageUrl();
            }
            backdoorURL = StringUtils.equalsIgnoreCase((CharSequence)"bamboo", (CharSequence)this.i18nResolver.getText("my.plugin.platform")) ? this.pluginConfigurationManager.getPlatformLoginPageUrl() : this.pluginConfigurationManager.getBaseUrl();
            backdoorURL = backdoorURL + "?" + this.pluginConfigurationManager.getBackdoorKey() + "=" + this.pluginConfigurationManager.getBackdoorValue();
            response.setStatus(200);
            responseJson.put("Backdoor URL ", backdoorURL);
        } else if (isAuthenticated.booleanValue() && !isAdmin.booleanValue()) {
            LOGGER.error((Object)"The user does not have System Admin permission");
            response.setStatus(401);
            responseJson.put("Status", "ERROR");
            responseJson.put("Message", "Access Denied");
            responseJson.put("Description", "The user does not have System Admin permission");
        }
        LOGGER.debug((Object)"Forming response");
        response.setContentType("application/json");
        response.getOutputStream().write(responseJson.toString().getBytes());
        response.getOutputStream().close();
    }
}

