/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.config;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.crowd.common.handler.MoPlatformDecisionHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCrowdConfigServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoCrowdConfigServlet.class);
    private MoPluginConfigurationHandler pluginConfigurationsHandler;
    private MoPluginConfigurationManager pluginConfigurationsManager;
    private I18nResolver i18nResolver;

    public MoCrowdConfigServlet(MoPluginConfigurationHandler pluginConfigurationHandler, MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver) {
        this.pluginConfigurationsHandler = pluginConfigurationHandler;
        this.pluginConfigurationsManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.checkAccessPermission(request, response).booleanValue()) {
            if (this.pluginConfigurationsManager.isLicenseValid().booleanValue()) {
                try {
                    String jsonConfigurations = this.pluginConfigurationsHandler.generateConfigurationsJson();
                    response.setHeader("Cache-Control", "max-age=0");
                    response.setHeader("Pragma", "");
                    response.setContentType("application/json");
                    response.getOutputStream().write(jsonConfigurations.getBytes());
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while downloading the json." + e.getMessage());
                }
            } else {
                this.showErrorMessage(response, "Your License has expired", "Please renew the license to use the API Call.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Configure Plugin servlet called from doPost");
        if (this.checkAccessPermission(request, response).booleanValue()) {
            StringBuffer sb = new StringBuffer();
            try (BufferedReader bufferedReader = null;){
                int bytesRead;
                bufferedReader = request.getReader();
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) != -1) {
                    sb.append(charBuffer, 0, bytesRead);
                }
            }
            if (this.pluginConfigurationsManager.isLicenseValid().booleanValue()) {
                File configurationFile = new File(sb.toString());
                try {
                    MoPluginConfigurationHandler.importConfigurations(sb.toString());
                }
                catch (Exception e) {
                    LOGGER.error("Error occured while importing plugin configuration", (Throwable)e);
                }
                this.showSuccessMessage(response, "SAML settings updated", "SAML App Configured successfully.");
            } else {
                this.showErrorMessage(response, "Your License has expired", "Please renew the license to use the API Call.");
            }
        }
    }

    private void showSuccessMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while showing success message", (Throwable)e);
        }
    }

    private void showErrorMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(401);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while showing error message response", (Throwable)e);
        }
    }

    private Boolean checkAccessPermission(HttpServletRequest request, HttpServletResponse response) {
        Enumeration headerNames = request.getHeaderNames();
        String key = "";
        String value = "";
        String username = "";
        String pwd = "";
        Boolean isAdmin = Boolean.FALSE;
        while (headerNames.hasMoreElements()) {
            try {
                key = (String)headerNames.nextElement();
                if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
                value = request.getHeader(key);
                value = value.split(" ")[1];
                byte[] valueDecoded = Base64.decodeBase64((String)value);
                value = new String(valueDecoded);
                String[] arr = value.split(":");
                username = arr[0];
                pwd = arr[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.debug("Something went wrong while fetching username and password.", (Throwable)e);
            }
        }
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String resp = platformUtils.doesUserHaveAccess(username, pwd, this.pluginConfigurationsManager.getApplicationBaseUrl());
        if (resp.equals("TRUE")) {
            return true;
        }
        if (resp.equals("FALSE")) {
            this.showErrorMessage(response, "Error Occured! App Configuration url can be only access by the administrators", "Please check error logs for more information");
        } else {
            this.showErrorMessage(response, "Error Occured", resp);
        }
        return false;
    }

    public void setPluginConfigurationsHandler(MoPluginConfigurationHandler pluginConfigurationsHandler) {
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
    }

    public void setPluginConfigurationsManager(MoPluginConfigurationManager pluginConfigurationsManager) {
        this.pluginConfigurationsManager = pluginConfigurationsManager;
    }
}

