/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.servlet;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class bambooUtils
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(bambooUtils.class);
    private BambooUserManager bambooUserManager;
    private BambooPermissionManager bambooPermissionManager;

    public bambooUtils(BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager) {
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String action;
            switch (action = request.getParameter("action")) {
                case "doesUserHaveAccess": {
                    this.doesUserHaveAccess(request.getParameter("username"), request.getParameter("pwd"), response);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doesUserHaveAccess(String username, String pwd, HttpServletResponse response) throws Exception {
        Boolean isAdmin = Boolean.FALSE;
        String attrsJSON = "FALSE";
        if (StringUtils.isNotBlank((CharSequence)username)) {
            BambooUser bambooUser = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username}) || StringUtils.isNotEmpty((CharSequence)username)) {
                bambooUser = this.bambooUserManager.getBambooUser(username);
            }
            if (bambooUser != null) {
                LOGGER.debug("User exist with username : " + username);
                if (BooleanUtils.toBoolean((Boolean)this.bambooUserManager.authenticate(bambooUser.getUser().getName(), pwd))) {
                    isAdmin = this.bambooPermissionManager.isAdmin(username) || this.bambooPermissionManager.isSystemAdmin(username);
                } else {
                    attrsJSON = "Authentication with the provided credentials failed. It may indicate that the user does not exist or the user's account is inactive or the credentials are incorrect";
                    isAdmin = Boolean.FALSE;
                }
            }
        }
        if (isAdmin.booleanValue()) {
            attrsJSON = "TRUE";
        }
        LOGGER.debug("Response attribute : " + attrsJSON.toString());
        response.setContentType("text/plain");
        response.getOutputStream().write(attrsJSON.getBytes());
        response.getOutputStream().close();
    }
}

