/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.servlet.utils;

import com.miniorange.crowd.common.config.MoConnectorConfigAjax;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoHttpUtils;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoBambooUtils
implements MoPlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoBambooUtils.class);
    private static final String DEFAULT_LOGIN_TEMPLATE_PATH_FOR_BAMBOO = "/templates/defaultLoginTemplateBamboo.ftl";

    @Override
    public String getBaseUrl() {
        return null;
    }

    @Override
    public MoConnectorConfigAjax initializeConfig(MoPluginConfigurationManager pluginConfigurationManager, HashMap<String, String> savedConfiguration, String platform, Boolean autoRedirectToIDP, String crowdDomainURL, String ssoButtonText, Boolean backdoorEnabled, Boolean enableAutoRedirectDelay, Boolean configured, Boolean useLoginTemplate, String loginTemplate, Boolean useErrorTemplate, String errorTemplate, String defaultRedirectRule, String defaultRedirectURL, Boolean showSSOButton, Boolean showLoginPage, String backdoorKey, String backdoorValue, Boolean enableGlobalSSO, String ssoPath) {
        try {
            LOGGER.debug("Initializing bamboo specific config");
            Boolean domainMappingForbamboo = Boolean.FALSE;
            HashMap<String, String> idpsForbamboo = new HashMap<String, String>();
            Iterator<String> iterator = savedConfiguration.keySet().iterator();
            while (iterator.hasNext()) {
                ObjectMapper mapper = new ObjectMapper();
                String idpId = iterator.next();
                MoCrowdConnectorSSOConfig config = (MoCrowdConnectorSSOConfig)mapper.readValue(savedConfiguration.get(idpId), MoCrowdConnectorSSOConfig.class);
                if (config.getSsoForbamboo().booleanValue()) {
                    idpsForbamboo.put(idpId, config.getIdpName());
                }
                if (pluginConfigurationManager.getAppRedirectionRulesMap().size() <= 0 || !config.getSsoForbamboo().booleanValue() || domainMappingForbamboo.booleanValue()) continue;
                domainMappingForbamboo = Boolean.TRUE;
            }
            return new MoConnectorConfigAjax(configured, autoRedirectToIDP, crowdDomainURL, pluginConfigurationManager.getApplicationBaseUrl(), pluginConfigurationManager.getJSDBaseUrl(), ssoButtonText, backdoorEnabled, enableAutoRedirectDelay, pluginConfigurationManager.getRedirectionParameter(), null, null, null, null, null, null, null, null, null, null, idpsForbamboo, domainMappingForbamboo, platform, useLoginTemplate, loginTemplate, useErrorTemplate, errorTemplate, defaultRedirectRule, defaultRedirectURL, showSSOButton, showLoginPage, backdoorKey, backdoorValue, enableGlobalSSO, ssoPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error in bamboo initializeConfig : " + e.toString());
            return null;
        }
    }

    @Override
    public HashMap<String, String> saveOrUpdateCrowdSSOConfig(HashMap<String, String> connectorsSSOConfig, String[] redirectDomainMapping, String[] redirectGroupMapping, ArrayList<Boolean> ssoForJIRASoftware, ArrayList<Boolean> ssoForJSD, ArrayList<Boolean> ssoForConfluence, ArrayList<Boolean> ssoForfisheye, ArrayList<Boolean> ssoForbitbucket, ArrayList<Boolean> ssoForbamboo) {
        try {
            int index = 0;
            for (String idpId : connectorsSSOConfig.keySet()) {
                MoCrowdConnectorSSOConfig ssoConfig = new MoCrowdConnectorSSOConfig();
                ObjectMapper mapper = new ObjectMapper();
                ssoConfig = (MoCrowdConnectorSSOConfig)mapper.readValue(connectorsSSOConfig.get(idpId), MoCrowdConnectorSSOConfig.class);
                LOGGER.debug("saved Crowd Connector SSO Config  : " + ssoConfig.toString());
                ssoConfig.setSsoForbamboo(ssoForbamboo.get(index));
                String jsonString = mapper.writeValueAsString((Object)ssoConfig);
                connectorsSSOConfig.put(idpId, jsonString);
                ++index;
            }
            return connectorsSSOConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error in JiraUtils saveOrUpdateCrowdSSOConfig : " + e.toString());
            return null;
        }
    }

    @Override
    public String getDefaultLogoutTemplate() {
        String logoutTemplate = "<html>\n <head>\n     <title>Logout</title>\n     <meta name='decorator' content='atl.general'>\n     <style> .aui-page-panel { margin-left: auto; margin-right: auto; max-width: 600px; } </style>\n</head>\n<body class='aui-layout aui-theme-default page-type-login' >\n     <div class='aui-page-panel-inner'>\n         <section class='aui-page-panel-content'>\n             <div class=\"aui-message info\">\n                 <p class=\"title\">You are now logged out. Any automatic login has also been stopped.</p>\n                 <p>Didn't mean to log out?<a href=\"$baseUrl\"> Log in again.</a><p>\n             </div>\n         </section>\n     </div>\n</body>\n</html>\n";
        return logoutTemplate;
    }

    @Override
    public String getDefaultErrorTemplate() {
        String errorTemplate = "<html> \n<head> \n <title>SSO Error</title> \n <meta name='decorator' content='atl.general'> \n<style> .aui-page-panel { margin-left: auto; margin-right: auto; max-width: 600px; } </style>\n </head> \n <body class='aui-layout aui-theme-default page-type-error'> \n <div class='aui-page-panel' style=''> \n <div class='aui-page-panel-inner'> \n <section class='aui-page-panel-content'> \n <header style='margin-top:20px;'> \n <h1>Single Sign On Failed</h1> \n </header> \n <div class='aui-message aui-message-error'> \n <p>Please contact your administrator for more information</p> \n </div> \n <p> Click <a href=\"$baseUrl\">here</a> to go to the login page</p> \n </section> \n </div> \n </div> \n</body> \n</html> \n";
        return errorTemplate;
    }

    @Override
    public String getDefaultLoginTemplate() {
        String loginTemplate = " ";
        try {
            loginTemplate = loginTemplate + IOUtils.toString((InputStream)MoPluginConfigurationManager.class.getResourceAsStream(DEFAULT_LOGIN_TEMPLATE_PATH_FOR_BAMBOO), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return loginTemplate;
    }

    @Override
    public String getBackDoorUrl(String baseUrl) {
        return baseUrl.concat("/userlogin!doDefault.action");
    }

    @Override
    public String getAdminBackDoorUrl(String baseUrl) throws UnsupportedEncodingException {
        return null;
    }

    @Override
    public String doesUserHaveAccess(String username, String pwd, String url) {
        try {
            ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
            postParameters.add((NameValuePair)new BasicNameValuePair("action", "doesUserHaveAccess"));
            postParameters.add((NameValuePair)new BasicNameValuePair("username", username));
            postParameters.add((NameValuePair)new BasicNameValuePair("pwd", pwd));
            url = url + "/plugins/servlet/bambooUtils";
            String response = MoHttpUtils.sendPostRequest(url, postParameters, "application/x-www-form-urlencoded", null);
            return response;
        }
        catch (Exception e) {
            LOGGER.debug("\nException occured :- " + e);
            return "FALSE";
        }
    }

    @Override
    public boolean isUserLoggedIn() {
        return false;
    }
}

