/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.rest;

import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.crowd.common.config.MoConnectorConfigAjax;
import com.miniorange.crowd.common.handler.MoPlatformDecisionHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoGetConfiguration
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoGetConfiguration.class);
    private MoPluginConfigurationManager pluginConfigurationManager;
    private I18nResolver i18nResolver;

    public MoGetConfiguration(MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("getting plugin configurtion");
        String platform = this.i18nResolver.getText("my.plugin.platform");
        String application = request.getParameter("application");
        try {
            if (this.pluginConfigurationManager.isLicenseDefined() && (!this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() || this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() && this.pluginConfigurationManager.isLicenseValid().booleanValue() || this.pluginConfigurationManager.hasValidLicenseKey().booleanValue()) && !this.pluginConfigurationManager.isLicenseExpired().booleanValue()) {
                Boolean configured = Boolean.FALSE;
                if (StringUtils.isNotEmpty((CharSequence)this.pluginConfigurationManager.getCrowdDomainURL())) {
                    configured = Boolean.TRUE;
                }
                String ssoPath = this.pluginConfigurationManager.getSSOPath();
                Boolean autoRedirectToIDP = this.pluginConfigurationManager.getAutoRedirectToIDP();
                String crowdDomainURL = this.pluginConfigurationManager.getCrowdDomainURL();
                String ssoButtonText = this.pluginConfigurationManager.getSsoButtonText();
                Boolean backdoorEnabled = this.pluginConfigurationManager.getBackdoorEnabled();
                Boolean enableAutoRedirectDelay = this.pluginConfigurationManager.getEnableAutoRedirectDelay();
                Boolean useLoginTemplate = this.pluginConfigurationManager.getUseLoginTemplate();
                String loginTemplate = this.pluginConfigurationManager.getLoginTemplate();
                Boolean useErrorTemplate = this.pluginConfigurationManager.getUseErrorTemplate();
                String errorTemplate = this.pluginConfigurationManager.getErrorTemplate();
                String defaultRedirectRule = this.pluginConfigurationManager.getDefaultAppIDP();
                String defaultRedirectURL = this.pluginConfigurationManager.getAppDefaultRedirectURL();
                String backdoorKey = this.pluginConfigurationManager.getBackdoorKey();
                String backdoorValue = this.pluginConfigurationManager.getBackdoorValue();
                Boolean enableGlobalSSO = this.pluginConfigurationManager.getEnableGlobalSSO();
                if (application != null && application.equals("jsd")) {
                    defaultRedirectRule = this.pluginConfigurationManager.getDefaultJsdIDP();
                    defaultRedirectURL = this.pluginConfigurationManager.getJsdDefaultRedirectURL();
                    useLoginTemplate = this.pluginConfigurationManager.getUseLoginTemplateJSD();
                    loginTemplate = this.pluginConfigurationManager.getLoginTemplateJSD();
                }
                Boolean showSSOButton = this.pluginConfigurationManager.getShowSSOButton();
                Boolean showLoginPage = this.pluginConfigurationManager.getShowLoginPage();
                HashMap<String, String> savedConfiguration = this.pluginConfigurationManager.getConnectorSSOConfig();
                MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
                MoConnectorConfigAjax ajaxConfig = platformUtils.initializeConfig(this.pluginConfigurationManager, savedConfiguration, platform, autoRedirectToIDP, crowdDomainURL, ssoButtonText, backdoorEnabled, enableAutoRedirectDelay, configured, useLoginTemplate, loginTemplate, useErrorTemplate, errorTemplate, defaultRedirectRule, defaultRedirectURL, showSSOButton, showLoginPage, backdoorKey, backdoorValue, enableGlobalSSO, ssoPath);
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString((Object)ajaxConfig);
                LOGGER.debug("\nJSON String :" + jsonString);
                response.setContentType("application/json");
                response.getOutputStream().write(jsonString.getBytes());
                response.getOutputStream().close();
            }
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while getting plugin configuration");
            e.printStackTrace();
        }
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }
}

