/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.servlet;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCrowdUploadFileConfigurationServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoCrowdUploadFileConfigurationServlet.class);
    private MoPluginConfigurationHandler pluginConfigurationHandler;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private String xsrfToken;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;

    public MoCrowdUploadFileConfigurationServlet(MoPluginConfigurationHandler pluginConfigurationHandler, MoPluginConfigurationManager pluginConfigurationManager, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.pluginConfigurationHandler = pluginConfigurationHandler;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        MoPluginConfigurationManager.fileUploaded = true;
        LOGGER.debug("MoUploadPluginConfigurationServlet doPost  called");
        try {
            this.handleUploadConfigurations(response);
            response.sendRedirect(this.pluginConfigurationManager.getApplicationBaseUrl() + "/plugins/servlet/bamboo-crowd-sso/backupandrestore.action");
        }
        catch (Exception e) {
            e.printStackTrace();
            MoPluginConfigurationManager.configurationUpdated = false;
            response.sendRedirect(this.pluginConfigurationManager.getApplicationBaseUrl() + "/plugins/servlet/bamboo-crowd-sso/backupandrestore.action");
        }
    }

    private void handleUploadConfigurations(HttpServletResponse response) throws IOException {
        LOGGER.debug("handleUploadConfigurations called");
        String fileContents = "";
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] files = wrapper.getFiles("configFile");
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UploadedFile file = files[i];
                if (!file.isFile()) continue;
                try {
                    fileContents = FileUtils.readFileToString((File)((File)file.getContent()));
                    if (!StringUtils.isEmpty((String)fileContents)) {
                        MoPluginConfigurationHandler.importConfigurations(fileContents);
                        MoPluginConfigurationManager.configurationUpdated = true;
                    } else {
                        MoPluginConfigurationManager.configurationUpdated = false;
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MoPluginConfigurationManager.configurationUpdated = false;
                    LOGGER.debug("exception message = " + e.getMessage());
                    LOGGER.debug("Invalid file is  provided. Could not parse app configuration file.");
                    return;
                }
            }
        } else {
            MoPluginConfigurationManager.configurationUpdated = false;
            LOGGER.debug("An error occurred while uploading the app configuring file.");
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoPluginConfigurationHandler getPluginConfigurationHandler() {
        return this.pluginConfigurationHandler;
    }

    public void setPluginConfigurationHandler(MoPluginConfigurationHandler pluginConfigurationHandler) {
        this.pluginConfigurationHandler = pluginConfigurationHandler;
    }
}

