/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.action;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoCrowdContactUsAction
extends BambooActionSupport {
    private static Log LOGGER = LogFactory.getLog(MoCrowdContactUsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoPluginConfigurationManager pluginConfigurationManager;

    public MoCrowdContactUsAction(UserManager userManager, LoginUriProvider loginUriProvider, MoPluginConfigurationManager pluginConfigurationManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public String execute() throws Exception {
        if (!this.pluginConfigurationManager.isLicenseValid().booleanValue()) {
            LOGGER.error((Object)"Invalid license");
            return "upm";
        }
        UserProfile user = this.userManager.getRemoteUser();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return "success";
        }
        LOGGER.error((Object)"User does not have permission to access Crowd Configuration page");
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }
}

