<html>
<head>

    <meta name="decorator" content="atl.general">
    <script>
            <#include "/js/redirectrules.js" parse=true>
            $(document).ready(function () {
                $(".aui-nav li").removeClass("aui-nav-selected");
                $("#mo-redirection-rules").addClass("aui-nav-selected");
            });
    </script>
    <style>
                .aui-page-panel-content{
    				padding: 0px !important;
    			}

    			.aui-page-panel{
    				margin: 0px !important;
    			}
            <#include "*/css/addidp.css" >
            <#include "/css/redirectrules.css" parse=true>
    </style>
</head>
<body>

    <#include "*/header.ftl" parse=true>
<div class="tabs-pane active-pane" id="redirection-rules" role="tabpanel" style="margin:10px">
    <h1>Redirection Rules</h1>
    <hr class="header"/>

    <p>Redirection Rules allow you to define rules on how the users should be redirected to IDP.</p>
    <p>You can set rules based on user's email domain, directory or group.</p>

    <div id="expander-with-replace-text-content" class="aui-expander-content" aria-expanded="true">

        <p><b>Here's how you can do that:</b></p>
        <ol>
            <li>Click on
                <b> Add Rule</b> button
            </li>
            <li>In the dropdown after <b>If</b>, select the deciding parameter of the rule, i.e. the parameter against
                which the user will be checked. for example, you can select directory, group or domain
            </li>
            <li>In the field after <b>equals</b>, enter the value for that parameter. For example, you can enter <i>Bamboo-users</i>
                value for <i>group</i> parameter
            </li>
            <li>In the field after <b>Redirect To</b>, select the IDP where you want to redirect the user if the
                conditions passes. You can also select Bamboo's login page here.
            </li>
            <li>Rules will be applied top-to-bottom. Use the arrows given beside the rules to change the order in which
                they'll be applied
            </li>
        </ol>
    </div>
    <p>
        <a id="replace-text-trigger" data-replace-text="Show More ..." class="aui-expander-trigger" aria-controls="expander-with-replace-text-content">Show less</a>
    </p>


    <div id="app-rules">
        <div>
            <h2 style="float: left;">Bamboo Redirection Rules&emsp;</h2>
            <button id="add-app-rule" class="aui-button aui-button-primary add-rule">
                <span class="aui-icon aui-icon-small aui-iconfont-add-circle"></span> Add Rule
            </button>&emsp;
            <aui-spinner id="app-order-spinner" class="order-spinner" size="small"></aui-spinner>
            <span id="app-saved-message" class="saved-message"><span
                    class="aui-icon aui-icon-small aui-iconfont-successful-build"></span>&nbsp;All Changes Saved</span>
        </div>
        <hr class="header subsection"/>

        <form id="save-app-order-form" name="save-app-order-form" class="aui" action="" method="POST">
            <input type="hidden" name="platform" value="app"/>
            <input type="hidden" name="action" value="saveOrder"/>
            <input type="hidden" name="atl_token" value="${xsrfToken}" />
            <table class="aui aui-table-list">
                <thead>
                <tr>
                    <th colspan="2" width="70%">Rules</th>
                    <th width="20%">Order</th>
                    <th width="10%">
                        Actions
                    </th>
                </tr>
                </thead>
                <tbody>
                    <#assign counter = 0 >
                    <#assign sizeOfMap = redirectionRulesMap.size() >
                    <#foreach key in redirectionRulesMap.keySet() >
                    <tr id="row-${key}">
                        <td colspan="2">
                            <input type="hidden" id="app-rule-${key}" name="ruleKey" value="${key}"/>
                            <b>${key}: </b>
                            <#assign expressionWithHtml= redirectionRulesMap.get(key) >
                            ${expressionWithHtml}
                        </td>
                        <td>
                            <#if (sizeOfMap>=1) >

                                <a class="app-move-up" style="cursor:pointer"><span
                                        class="aui-icon aui-icon-small aui-iconfont-chevron-double-up"
                                        <#if (sizeOfMap==1) >
                                            style="color:grey" <#else> style="color:blue"
                                        </#if>
                                        >move up</span></a>
                                &nbsp;
                                <a class="app-move-down" style="cursor:pointer"><span
                                        class="aui-icon aui-icon-small aui-iconfont-chevron-double-down"
                                        <#if (sizeOfMap==1) >
                                            style="color:grey" <#else> style="color:blue"
                                        </#if>
                                        >move down</span></a>

                            </#if>
                        </td>
                        <td>
                            <a class="edit-app-rule" data-rule-id="${key}" class="aui-button aui-button-subtle"><span
                                    class="aui-icon aui-icon-small aui-iconfont-edit-filled">edit</span></a>
                            &emsp;
                            <a class="delete-app-rule" data-rule-id="${key}" class="aui-button aui-button-subtle"><span
                                    class="aui-icon aui-icon-small aui-iconfont-trash"></span></a>
                        </td>
                    </tr>
                        <#assign counter=counter+1 >
                    </#foreach>
                </tbody>
            </table>
            <table class="aui">
                <tbody>
                <tr id="row-app-default">
                    <td>
                        <span><b>Default Rule: </b>Redirect the users to</span>&emsp;
                        <aui-select id="defaultAppIDP" name="defaultAppIDP" placeholder="Select Default IDP"
                                    class="default-idp-select">
                            <#foreach idpId in connectorssSSOConfig.keySet() >
                                <aui-option id="${idpId}" value="${idpId}"
                                    <#if defaultAppIDP.equals(idpId) > selected </#if>
                                >${connectorssSSOConfig.get(idpId).getIdpName()}</aui-option>
                            </#foreach>
                            <aui-option value="loginPage" id="loginPage"
                                <#if defaultAppIDP.equals("loginPage") > selected </#if>
                            >Login Page</aui-option>
                            <aui-option value="redirectUrl"
                            <#if defaultAppIDP.equals("redirectUrl") > selected </#if>
                        >Redirect to a URL</aui-option>
                        </aui-select>
                    </td>
                </tr>
                <tr id="defaultAppIDP-redirect-url" style="display: none">
                    <td>
                        <span><b>URL to redirect Users to :</b></span>
                        <input type="text" value="${appDefaultURL}" id="appDefaultURL" name="appDefaultURL" class="text long-field default-redirect-url defaultAppIDP-default-redirect-url" style="display: inline">
                        <div id="save-redirect-url-rule-app" style="display: none; vertical-align: middle;">
                            <a id="save-redirect-url-button-app"
                               class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-success"
                               title="save"></a>
                            <a
                                    id="cancel-redirect-url-button-app"
                                    class="aui-button aui-button-subtle aui-icon aui-icon-small aui-iconfont-close-dialog"
                                    title="cancel"></a>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </form>
</div>
<form id="redirection--form" class="aui long-label advanced-settings-form" action="" method="POST">
<div id="advanced settings">
    <div>
        <h2 style="float: left;">Advanced Settings</h2>
    </div>
    <hr class="header subsection" style="width:100%">
     <br>
    <div class="field-group" id="allowLocalAuthenticationDiv">
        <label for="allowLocalAuthenticationSlider">Allow Local Authentication:</label>
        <span style="vertical-align:sub;">

            <label class="switch" style="vertical-align:middle;">
                    <input type="checkbox" id="allowLocalAuthentication" value="true" name="allowLocalAuthentication"
                        <#if allowLocalAuthentication == true> checked="true" </#if> >
                    <span id="allowLocalAuthentication" class="slider round"></span>
            </label>
        </span>
        <div class="description">If disabled, local authentication for users configured to use SSO login will not work. They can only use local credentials while login using backdoor URL.</div>
    </div>
    <div class="field-group" id="showLoginPageDiv">
        <label for="showLoginPageSlider">Show default login page:</label>
        <span style="vertical-align:sub;">

            <label class="switch" style="vertical-align:middle;">
                    <input type="checkbox" id="showLoginPage" value="true" name="showLoginPage"
                        <#if showLoginPage == true> checked="true" </#if> >
                    <span id="showLoginPageSlider" class="slider round"></span>
            </label>
        </span>
        <div class="description">Show the default login page to the users. This will disable the user domain-mapping form when redirection rules are configured.</div>
    </div>
</div>
</form>
</div>
    <#include "*/createRuleDialogue.ftl" parse=true >
    <#include "*/footer.ftl" parse=true >
    </section>
    </div>
    </div>
</body>
</html>