AJS.$(function () {
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#mo-redirection-rules").addClass("aui-nav-selected");
    AJS.$("#mo-saml").addClass("aui-nav-selected");
    AJS.$("#reveal-text-trigger").trigger("aui-expander-expand");
    window.onbeforeunload = null;
    var moApi = AJS.contextPath() + "/plugins/servlet/samlsso/moapi";

    // showSavedTab();
    AJS.$(".add-rule").click(function () {
        AJS.$("#redirection-rules").hide();
        AJS.$("#create-rule").show();
        AJS.$("#rule-window-title").html("Add Rule");
        AJS.$("#ruleName").removeAttr("readonly");
        AJS.$("#formaction").prop("name", "addRedirectionRuleSubmitted");
        if (this.id === "add-jsd-rule")
            AJS.$("#platform").val("jsd");
        clearFieldValues();
    });

    AJS.$(document).on("click", ".edit-app-rule,.edit-jsd-rule", function () {
        var id = AJS.$(this).attr('data-rule-id');
        AJS.$("#redirection-rules").hide();
        AJS.$("#create-rule").show();
        AJS.$("#rule-window-title").html("Edit Rule");
        AJS.$("#formaction").prop("name", "editRedirectionRuleSubmitted");
        var application = AJS.$(this).is(".edit-app-rule") ? "app" : 'jsd';
        AJS.$("#ruleName").prop("readonly", "true");
        AJS.$("#platform").val(application);
        var getRule = moApi;
        AJS.$.ajax({
            url: getRule,
            type: 'GET',
            data: {
                'action': 'getRule',
                'key': id
            },
            success: function (response) {
                populateEditRuleForm(response);
            }
        });
    });

    function clearFieldValues() {
        var elements = document.querySelectorAll("#add-redirection-rule-form input[type=text]");
        for (var i = 0, element; element = elements[i++];) {
            element.value = "";
        }

        elements = document.querySelectorAll("#add-redirection-rule-form aui-select");
        for (var i = 0, element; element = elements[i++];) {
            element.value = "";
        }
    }

    function populateEditRuleForm(rule) {
        AJS.$("#ruleID").val(rule.name);
        AJS.$("#ruleName").val(rule.name);
        var condition = rule.condition;
        var decisionFactor = condition.decisionFactor;
        AJS.$("#decisionFactor").val(decisionFactor);
        var decisionObject = condition[decisionFactor];
        var conditionOperation = decisionObject.conditionOperation;
        AJS.$("#conditionOperation").val(conditionOperation);
        var value = decisionObject[conditionOperation];
        var idp = rule.idp;
        AJS.$("#idp").val(idp);
        switch (decisionFactor) {
            case 'domain':
                AJS.$('#textConditionValue').val(value);
                break;
            case 'directory':
                AJS.$("#directoryList").auiSelect2('data',
                    {
                        'id': value,
                        'text': value
                    }
                );
                break;
            case 'group':
                AJS.$("#groupsList").auiSelect2('data',
                    {
                        'id': value,
                        'text': value
                    }
                );
                break;
        }
    }

    AJS.$("#cancel-create-rule").click(function (e) {
        AJS.$("#redirection-rules").show();
        AJS.$("#create-rule").hide();
    });

    AJS.$(document).on("click", ".delete-app-rule,.delete-jsd-rule", function (e) {
        var id = AJS.$(this).attr('data-rule-id');
        var application = AJS.$(this).is(".delete-app-rule") ? 'app' : 'jsd';
        var deleteUrl = AJS.contextPath() + "/plugins/servlet/samlsso/moapi?action=deleteRule&key=" + id + "&application=" + application;

        var dialog = new AJS.Dialog({
            width: 400,
            height: 150,
            id: "delete-dialog",
            closeOnOutsideClick: true
        });
        dialog.addPanel("Panel 1", "<p>Are you sure you want to delete rule " + id + "?</p>", "panel-body");

        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            AJS.$.ajax({
                url: deleteUrl,
                type: 'DELETE',
                success: function (response) {
                    AJS.$("#row-" + id).remove();
                    if (AJS.$("." + application + "-move-up").length === 1) {
                        AJS.$("." + application + "-move-up").remove();
                        AJS.$("." + application + "-move-down").remove();
                    }
                    showSuccessMessage(response);
                }
            });

        });

        dialog.addLink("No", function (dialog) {
            dialog.hide();
        }, "#");

        dialog.show();
    });


    AJS.$(document).on("change", "#decisionFactor", function () {
        AJS.$(".condition-value").hide();
        AJS.$(".condition-value").prop("disabled", true);
        AJS.$(".condition-value").prop("required", false);
        switch (this.value) {
            case "directory":
                AJS.$("#directoryList").show();
                AJS.$("#directoryList").prop("disabled", false);
                AJS.$("#directoryList").prop("required", true);
                AJS.$("#directoryList").auiSelect2();
                break;
            case "group":
                AJS.$("#groupsList").show();
                AJS.$("#groupsList").prop("disabled", false);
                AJS.$("#groupsList").prop("required", true);
                initializeGroupsDropdown();
                break;
            default:
                AJS.$("#textConditionValue").show();
                AJS.$("#textConditionValue").prop("disabled", false);
                AJS.$("#textConditionValue").prop("required", true);

        }
    });


    function swapInputNames(row1, row2, platform) {
        var key1 = (row1.attr('id').split('row-'))[1];
        var key2 = (row2.attr('id').split('row-'))[1];

        var ruleName = "#" + platform + "-rule-";
        var name1 = AJS.$(ruleName + key1).attr('name');
        AJS.$(ruleName + key1).attr('name', AJS.$(ruleName + key2).attr('name'));
        AJS.$(ruleName + key2).attr('name', name1);

        //Swapping Expression Keys
        var expressionName = "#" + platform + "-rule-expression-";
        var expression1 = AJS.$(expressionName + key1).attr('name');
        AJS.$(expressionName + key1).attr('name', AJS.$(expressionName + key2).attr('name'));
        AJS.$(expressionName + key2).attr('name', expression1);

    }

    AJS.$(".app-move-up,.app-move-down,.jsd-move-up,.jsd-move-down").click(function () {
        var row = AJS.$(this).parents("tr:first");
        var platform = 'app';

        if (AJS.$(this).is(".jsd-move-up") || AJS.$(this).is(".jsd-move-down")) {
            platform = 'jsd';
        }


        var message = AJS.$("#" + platform + "-order-saved");
        var html = "<button id=\"save-" + platform + "-order\" class=\"aui-button aui-button-primary\" value=\"Save\" title=\"Save Order\"><span class=\"aui-icon aui-icon-small aui-iconfont-clone-small\">save-icon</span> Save</button>";
        AJS.$(html).insertAfter(message);
        AJS.$(message).remove();

        if (AJS.$(this).is(".app-move-up") || AJS.$(this).is(".jsd-move-up")) {
            var prev = row.prev();
            if (!prev.attr('id'))
                return;
            AJS.$("#" + platform + "-saved-message").hide();
            AJS.$("#" + platform + "-order-spinner").show();
            swapInputNames(AJS.$(row), AJS.$(row.prev()), platform);
            row.insertBefore(row.prev());
        } else {
            var next = row.next();
            if (!next.attr('id'))
                return;
            AJS.$("#" + platform + "-saved-message").hide();
            AJS.$("#" + platform + "-order-spinner").show();
            swapInputNames(row, row.next(), platform);
            row.insertAfter(row.next());
        }
        saveOrder(platform);
    });

    function saveOrder(platform) {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/samlsso/moapi",
            type: "POST",
            data: AJS.$("#save-" + platform + "-order-form").serialize(),
            error: function (response) {
            },
            success: function (response) {
                setTimeout(hideSpinner, 2000, platform);
            }
        });
    }

    function hideSpinner(platform) {
        AJS.$("#" + platform + "-order-spinner").hide();
        AJS.$("#" + platform + "-saved-message").show("show");
    }

    AJS.$(document).on("click", "#save-app-order,#save-jsd-order", function (e) {
        e.preventDefault();
        if (AJS.$(this).is("#save-app-order"))
            AJS.$("#save-app-order-form").submit();
        else
            AJS.$("#save-jsd-order-form").submit();
    });

    AJS.$(".redirection-rules-tab").click(function (evt) {
        var tabName = 'rules-div';
        if (this.id === 'toggles-tab')
            tabName = 'toggles-div';

        var tabcontent = document.getElementsByClassName("tabcontent");
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
        }
        var tablinks = document.getElementsByClassName("tablinks");
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
        }
        document.getElementById(tabName).style.display = "block";
        evt.currentTarget.className += " active ";
    });


    if (AJS.$("#defaultAppIDP").val() === "redirectUrl") {
        if (AJS.$("#defaultAppIDP-redirect-url").is(":hidden")) {
            AJS.$("#defaultAppIDP-redirect-url").css("display", "contents");
        }
    } else {
        if (AJS.$("#defaultAppIDP-redirect-url").is(":visible")) {
            AJS.$("#defaultAppIDP-redirect-url").css("display", "none");
        }
    }

    if (AJS.$("#defaultJsdIDP").val() === "redirectUrl") {
        if (AJS.$("#defaultJsdIDP-redirect-url").is(":hidden")) {
            AJS.$("#defaultJsdIDP-redirect-url").css("display", "contents");
        }
    } else {
        if (AJS.$("#defaultJsdIDP-redirect-url").is(":visible")) {
            AJS.$("#defaultJsdIDP-redirect-url").css("display", "none");
        }
    }

    AJS.$(document).on("change", ".default-idp-select", function (e) {
        if (AJS.$("#" + this.id).val() === "redirectUrl") {
            if (AJS.$("#" + this.id + "-redirect-url").is(":hidden")) {
                AJS.$("#" + this.id + "-redirect-url").css("display", "contents");
            }
            if (AJS.$("." + this.id + "-default-redirect-url").val()){
                var value = AJS.$("." + this.id + "-default-redirect-url").val();
                var platform = this.id;
                saveDefaultRedirectURL(value,platform);
            }
        } else {
            if (AJS.$("#" + this.id + "-redirect-url").css('display') === 'contents') {
                AJS.$("#" + this.id + "-redirect-url").css("display", "none");
            }

            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/samlsso/moapi",
                data: {
                    "action": "saveDefaultRule",
                    "defaultIDP": AJS.$("#" + this.id).val(),
                    "platform": this.id
                },
                type: 'POST',
                error: function (response) {
                    showErrorMessage(response);
                },
                success: function (response) {
                    showSuccessMessage(response);
                }
            });
        }
    });
    
    AJS.$("." + this.id + "-default-redirect-url").keypress(function (e) {
        if (e.which === 13) {
            var value = AJS.$("." + this.id + "-default-redirect-url").val();
            var platform = this.id;
            saveDefaultRedirectURL(value,platform);
            return false;    //<---- Add this line
        }
    });

    AJS.$("#showLoginPage").change(function(){
        var message = "";
        var value;
        if(document.getElementById("showLoginPage").checked)
        {
            message = "Default Login Page Enabled";
            value = "true";
        }else {
            message = "Default Login Page Disabled";
            value = "false"
       }
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/samlsso/moapi",
            data: {
                "action": "showLoginPage",
                "showLoginPage": value,
            },
            type: 'POST',
            error: function (response) {
                showErrorMessage(response);
            },
            success: function (response) {
                showSuccessMessage(message);
            }
        });
    });

    AJS.$("#allowLocalAuthentication").change(function(){
        var message = "";
            var value;
            if(document.getElementById("allowLocalAuthentication").checked)
            {
                message = "Local Authentication Enabled";
                value = "true";
            }else {
                message = "Local Authentication Disabled";
                value = "false"
           }
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/samlsso/moapi",
                data: {
                    "action": "allowLocalAuthentication",
                    "allowLocalAuthentication": value,
                },
                type: 'POST',
                error: function (response) {
                    showErrorMessage(response);
                },
                success: function (response) {
                    showSuccessMessage(message);
                }
            });
    });

    function saveDefaultRedirectURL(value, platform){
    console.log("Save Redirect URL:"+value+" Platform:"+platform);
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/samlsso/moapi",
            data: {
                "action": "saveDefaultRedirectURL",
                "defaultRedirectURL": value,
                "platform": platform
            },
            type: 'POST',
            error: function (response) {
                showErrorMessage(response);
            },
            success: function (response) {
                showSuccessMessage(response);
            }
        });
    }

    function showSavedTab() {
        if (AJS.$("#rules-tab")[0].classList.contains('active')) {
            AJS.$("#rules-div").show();
            AJS.$("#toggles-div").hide();
        }

    }

    function initializeGroupsDropdown() {
        AJS.$("#groupsList").auiSelect2({
            placeholder: 'Select the groups to apply this rule',
            ajax: {
                url: AJS.contextPath() + '/plugins/servlet/samlsso/moapi',
                data: function (params) {
                    var query = {
                        search: params,
                        action: 'fetchGroups'
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                results: function (data, page) {
                    return {
                        results: data.results
                    };
                },

            }
        });

    }

    function showSuccessMessage(message) {
        require('aui/flag')({
            title: 'Success!',
            type: 'success',
            close: 'auto',
            body: '<p>' + message + '</p><br/>'
        });
    }

    function showErrorMessage(message) {
        require('aui/flag')({
            title: 'Error!',
            type: 'error',
            close: 'auto',
            body: '<p>'+message.responseText+'</p><br/>'
        });

    }

    AJS.$(document).on("click", "#appDefaultURL", function (e) {
        if(AJS.$("#save-redirect-url-rule-app").is(":hidden")){
            AJS.$("#save-redirect-url-rule-app").css("display","inline");
        }
    });

    AJS.$(document).on("click","#save-redirect-url-button-app", function (e) {
        var value = AJS.$("#appDefaultURL").val();
        var platform = "appDefaultURL";
        saveDefaultRedirectURL(value,platform);
    });

    AJS.$(document).on("click","#cancel-redirect-url-button-app", function (e) {
        AJS.$("#appDefaultURL").val(" ");
    });

    AJS.$(document).on("click", "#jsdDefaultURL", function (e) {
        if(AJS.$("#save-redirect-url-rule-jsd").is(":hidden")){
            AJS.$("#save-redirect-url-rule-jsd").css("display","inline");
        }
    });

    AJS.$(document).on("click","#save-redirect-url-button-jsd", function (e) {
        var value = AJS.$("#jsdDefaultURL").val();
        var platform = "jsdDefaultURL";
        saveDefaultRedirectURL(value,platform);
    });

    AJS.$(document).on("click","#cancel-redirect-url-button-jsd", function (e) {
        AJS.$("#jsdDefaultURL").val(" ");
    });

    if ( window.history.replaceState ) {
      window.history.replaceState( null, null, window.location.href );
    }

});