/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.scheduler;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.scheduler.MoGetCrowdSSOConfigurationTaskHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoGetCrowdSSOConfigurationService
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(MoGetCrowdSSOConfigurationService.class);
    public static final String KEY = MoGetCrowdSSOConfigurationTaskHandler.class.getName() + ":instance";
    private static final String JOB_NAME = "MoFetchCrowdSSOConfScheduler";
    private static final long SCHEDULER_INTERVAL_TIME = Integer.toUnsignedLong(43200000);
    private MoPluginConfigurationManager pluginConfigurationManager;
    private final PluginScheduler pluginScheduler;

    public MoGetCrowdSSOConfigurationService(MoPluginConfigurationManager pluginConfigurationManager, PluginScheduler pluginScheduler) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.pluginScheduler = pluginScheduler;
    }

    public void schedule() {
        LOGGER.debug((Object)"Scheduling task to refresh Crowd SAML IDP configuration");
        try {
            HashMap<String, MoGetCrowdSSOConfigurationService> jobDataMap = new HashMap<String, MoGetCrowdSSOConfigurationService>();
            jobDataMap.put(KEY, this);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(12, 1);
            this.pluginScheduler.scheduleJob(KEY, MoGetCrowdSSOConfigurationTaskHandler.class, jobDataMap, cal.getTime(), SCHEDULER_INTERVAL_TIME);
        }
        catch (Exception e) {
            LOGGER.error((Object)("An Exception occured while scheduling the FetchCrowdSSOInfoScheduler : error message : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void reschedule() {
        LOGGER.debug((Object)"Re-scheduling task to refresh Crowd SAML IDP configuration");
        try {
            HashMap<String, MoGetCrowdSSOConfigurationService> jobDataMap = new HashMap<String, MoGetCrowdSSOConfigurationService>();
            jobDataMap.put(KEY, this);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(12, 1);
            this.pluginScheduler.scheduleJob(KEY, MoGetCrowdSSOConfigurationTaskHandler.class, jobDataMap, cal.getTime(), SCHEDULER_INTERVAL_TIME);
        }
        catch (Exception e) {
            LOGGER.error((Object)("An Exception occured while scheduling the FetchCrowdSSOInfoScheduler : error message : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void unschedule() {
        LOGGER.debug((Object)"Unscheduling task to refresh Crowd SAML IDP configuration");
        try {
            this.pluginScheduler.unscheduleJob(KEY);
        }
        catch (Exception e) {
            LOGGER.error((Object)("An Exception occured while unscheduling the FetchCrowdSSOInfoScheduler : error message : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void onStart() {
        if (StringUtils.isNotEmpty((CharSequence)this.pluginConfigurationManager.getCrowdDomainURL())) {
            this.schedule();
        } else {
            this.unschedule();
        }
    }

    public void onStop() {
        this.unschedule();
    }

    public String getCrowdBaseURL() {
        return this.pluginConfigurationManager.getCrowdDomainURL();
    }
}

