/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.handler;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.templaterenderer.velocity.one.six.VelocityTemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoOfflineLicenseSettings;
import com.miniorange.crowd.common.handler.MoPlatformDecisionHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.servlet.utils.MoJSONUtils;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoPluginConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoPluginConfigurationManager.class);
    private PluginSettings pluginSettings;
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginLicenseManager pluginLicenseManager;
    private I18nResolver i18nResolver;
    private CrowdService crowdService;
    private DirectoryManager directoryManager;
    private ApplicationProperties applicationProperties;
    private VelocityTemplateRenderer renderer;
    private static final String DEFAULT_LOGOUT_TEMPLATE_PATH = "/templates/logoutTemplate.vm";
    public static String DEFAULT_LOGOUT_TEMPLATE = "";
    public static Boolean fileUploaded = Boolean.FALSE;
    public static Boolean configurationUpdated = Boolean.FALSE;
    private MoOfflineLicenseSettings offlineLicenseSettings;

    public MoPluginConfigurationManager(PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager pluginLicenseManager, I18nResolver i18nResolver, ApplicationProperties applicationProperties, DirectoryManager directoryManager, CrowdService crowdService, VelocityTemplateRenderer renderer, MoOfflineLicenseSettings offlineLicenseSettings) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.applicationProperties = applicationProperties;
        this.pluginLicenseManager = pluginLicenseManager;
        this.i18nResolver = i18nResolver;
        this.directoryManager = directoryManager;
        this.crowdService = crowdService;
        this.renderer = renderer;
        this.offlineLicenseSettings = offlineLicenseSettings;
    }

    public void clearPluginSettings() {
        this.pluginSettings.remove("miniorange.saml.AUTO_REDIRECT_TO_IDP");
        this.pluginSettings.remove("miniorange.saml.CONFLUENCE_SSO_ENABLE");
        this.pluginSettings.remove("miniorange.saml.CONNECTORS_SSO_CONFIG");
        this.pluginSettings.remove("miniorange.saml.CROWD_DOMAIN_URL");
        this.pluginSettings.remove("miniorange.saml.CROWD_IDP_CONFIG");
        this.pluginSettings.remove("miniorange.saml.ENABLE_AUTO_REDIRECT_DELAY");
        this.pluginSettings.remove("miniorange.saml.ENABLE_BACKDOOR");
        this.pluginSettings.remove("miniorange.saml.ERROR_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.LOGIN_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.LOGOUT_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.LOGOUT_URL");
        this.pluginSettings.remove("miniorange.saml.SSO_BUTTON_TEXT");
        this.pluginSettings.remove("miniorange.saml.SSO_ENABLE");
        this.pluginSettings.remove("miniorange.saml.USE_LOGIN_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.USE_ERROR_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.USE_LOGOUT_TEMPLATE");
        this.pluginSettings.remove("miniorange.saml.JSD_SSO_ENABLE");
        this.pluginSettings.remove("miniorange.saml.DISABLE_LOCAL_AUTHENTICATION");
        this.pluginSettings.remove("miniorange.saml.ENABLE_GLOBAL_SSO");
    }

    public String getApplicationBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public Boolean getUseLogoutTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_LOGOUT_TEMPLATE"))), (boolean)false);
    }

    public void setUseLogoutTemplate(Boolean useLogoutTemplate) {
        this.pluginSettings.put("miniorange.saml.USE_LOGOUT_TEMPLATE", (Object)BooleanUtils.toString((Boolean)useLogoutTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUseLogoutTemplateJSD() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_JSD_LOGOUT_TEMPLATE"))), (boolean)false);
    }

    public void setUseLogoutTemplateJSD(Boolean useLogoutTemplateJSD) {
        this.pluginSettings.put("miniorange.saml.USE_JSD_LOGOUT_TEMPLATE", (Object)BooleanUtils.toString((Boolean)useLogoutTemplateJSD, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUseErrorTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_ERROR_TEMPLATE"))), (boolean)false);
    }

    public void setUseErrorTemplate(Boolean useErrorTemplate) {
        this.pluginSettings.put("miniorange.saml.USE_ERROR_TEMPLATE", (Object)BooleanUtils.toString((Boolean)useErrorTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUseLoginTemplate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_LOGIN_TEMPLATE"))), (boolean)false);
    }

    public void setUseLoginTemplate(Boolean useLoginTemplate) {
        this.pluginSettings.put("miniorange.saml.USE_LOGIN_TEMPLATE", (Object)BooleanUtils.toString((Boolean)useLoginTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUseLoginTemplateJSD() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.USE_JSD_LOGIN_TEMPLATE"))), (boolean)false);
    }

    public void setUseLoginTemplateJSD(Boolean useLoginTemplate) {
        this.pluginSettings.put("miniorange.saml.USE_JSD_LOGIN_TEMPLATE", (Object)BooleanUtils.toString((Boolean)useLoginTemplate, (String)"true", (String)"false", (String)"false"));
    }

    public String getLogoutUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGOUT_URL")), (CharSequence)"");
    }

    public void setLogoutUrl(String logoutUrl) {
        this.pluginSettings.put("miniorange.saml.LOGOUT_URL", (Object)StringUtils.defaultIfEmpty((CharSequence)logoutUrl, (CharSequence)""));
    }

    public String getLogoutUrlJSD() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGOUT_URL_JSD")), (CharSequence)"");
    }

    public void setLogoutUrlJSD(String logoutUrlJSD) {
        this.pluginSettings.put("miniorange.saml.LOGOUT_URL_JSD", (Object)StringUtils.defaultIfEmpty((CharSequence)logoutUrlJSD, (CharSequence)""));
    }

    public Boolean getEnableSingleLogoutURL() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_SINGLE_LOGOUT_URL"))), (boolean)false);
    }

    public void setEnableSingleLogoutURL(Boolean enableSingleLogoutURL) {
        this.pluginSettings.put("miniorange.saml.ENABLE_SINGLE_LOGOUT_URL", (Object)BooleanUtils.toString((Boolean)enableSingleLogoutURL, (String)"true", (String)"false", (String)"false"));
    }

    public String getErrorTemplate() {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultErrorTemplate();
        if (defaultTemplate.contains("$baseUrl")) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("baseUrl", this.getApplicationBaseUrl());
            defaultTemplate = this.renderer.renderFragment(defaultTemplate, context);
            return (String)StringUtils.defaultIfEmpty((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ERROR_TEMPLATE")), (CharSequence)defaultTemplate);
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)this.pluginSettings.get("miniorange.saml.ERROR_TEMPLATE")), (CharSequence)defaultTemplate);
    }

    public void setErrorTemplate(String errorTemplate) {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultErrorTemplate();
        this.pluginSettings.put("miniorange.saml.ERROR_TEMPLATE", (Object)StringUtils.defaultIfEmpty((CharSequence)errorTemplate, (CharSequence)defaultTemplate));
    }

    public String getLoginTemplate() {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultLoginTemplate();
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGIN_TEMPLATE")), (CharSequence)defaultTemplate);
    }

    public void setLoginTemplate(String loginTemplate) {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultLoginTemplate();
        this.pluginSettings.put("miniorange.saml.LOGIN_TEMPLATE", (Object)StringUtils.defaultIfEmpty((CharSequence)loginTemplate, (CharSequence)defaultTemplate));
    }

    public String getLoginTemplateJSD() {
        String defaultTemplate = this.getDefaultLoginTemplateJSD();
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)this.pluginSettings.get("miniorange.saml.JSD_LOGIN_TEMPLATE")), (CharSequence)defaultTemplate);
    }

    public void setLoginTemplateJSD(String loginTemplate) {
        String defaultTemplate = this.getDefaultLoginTemplateJSD();
        this.pluginSettings.put("miniorange.saml.JSD_LOGIN_TEMPLATE", (Object)StringUtils.defaultIfEmpty((CharSequence)loginTemplate, (CharSequence)defaultTemplate));
    }

    public String getDefaultLoginTemplateJSD() {
        String loginTemplate = "";
        try {
            loginTemplate = IOUtils.toString((InputStream)MoPluginConfigurationManager.class.getResourceAsStream("/templates/defaultLoginTemplateJSD.vm"), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return loginTemplate;
    }

    public String getLogoutTemplate() {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultLogoutTemplate();
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)this.pluginSettings.get("miniorange.saml.LOGOUT_TEMPLATE")), (CharSequence)defaultTemplate);
    }

    public void setLogutTemplate(String logutTemplate) {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultLogoutTemplate();
        this.pluginSettings.put("miniorange.saml.LOGOUT_TEMPLATE", (Object)StringUtils.defaultIfEmpty((CharSequence)logutTemplate, (CharSequence)defaultTemplate));
    }

    public String getLogoutTemplateJSD() {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultLogoutTemplate();
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)this.pluginSettings.get("miniorange.saml.JSD_LOGOUT_TEMPLATE")), (CharSequence)defaultTemplate);
    }

    public void setLogoutTemplateJSD(String logutTemplateJSD) {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
        String defaultTemplate = platformUtils.getDefaultLogoutTemplate();
        this.pluginSettings.put("miniorange.saml.JSD_LOGOUT_TEMPLATE", (Object)StringUtils.defaultIfEmpty((CharSequence)logutTemplateJSD, (CharSequence)defaultTemplate));
    }

    public String getCrowdDomainURL() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.CROWD_DOMAIN_URL")));
    }

    public void setCrowdDomainURL(String crowdDomainURL) {
        this.pluginSettings.put("miniorange.saml.CROWD_DOMAIN_URL", (Object)StringUtils.trimToEmpty((String)crowdDomainURL));
    }

    public String getSsoButtonText() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SSO_BUTTON_TEXT")), (CharSequence)"SSO Login");
    }

    public void setSsoButtonText(String ssoButtonText) {
        this.pluginSettings.put("miniorange.saml.SSO_BUTTON_TEXT", (Object)StringUtils.trimToEmpty((String)ssoButtonText));
    }

    public Boolean getAutoRedirectToIDP() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.AUTO_REDIRECT_TO_IDP"))), (boolean)false);
    }

    public void setAutoRedirectToIDP(Boolean autoRedirectToIDP) {
        this.pluginSettings.put("miniorange.saml.AUTO_REDIRECT_TO_IDP", (Object)BooleanUtils.toString((Boolean)autoRedirectToIDP, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowSSOButton() {
        String showSSOButtonStr = (String)this.pluginSettings.get("miniorange.saml.SHOW_SSO_BUTTON");
        if (StringUtils.isBlank((CharSequence)showSSOButtonStr)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)showSSOButtonStr);
    }

    public void setShowSSOButton(Boolean showSSOLoginButton) {
        this.pluginSettings.put("miniorange.saml.SHOW_SSO_BUTTON", (Object)BooleanUtils.toString((Boolean)showSSOLoginButton, (String)"true", (String)"false", (String)"false"));
    }

    public void setEnableGlobalSSO(Boolean enableGlobalSSO) {
        this.pluginSettings.put("miniorange.saml.ENABLE_GLOBAL_SSO", (Object)BooleanUtils.toString((Boolean)enableGlobalSSO, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableGlobalSSO() {
        String enableGlobalSSOStr = (String)this.pluginSettings.get("miniorange.saml.ENABLE_GLOBAL_SSO");
        if (StringUtils.isBlank((CharSequence)enableGlobalSSOStr)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)enableGlobalSSOStr);
    }

    public void setAllowAnonymousAccess(Boolean allowAnonymousAccess) {
        this.pluginSettings.put("miniorange.saml.ALLOW_ANONYMOUS_ACCESS", (Object)BooleanUtils.toString((Boolean)allowAnonymousAccess, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAllowAnonymousAccess() {
        String platfrom = this.i18nResolver.getText("my.plugin.platform");
        if (platfrom.equalsIgnoreCase("confluence")) {
            if (Boolean.valueOf(this.pluginSettings.get("miniorange.saml.ALLOW_ANONYMOUS_ACCESS") == null).booleanValue()) {
                return MoPluginConfigurationManager.isGlobalAnonymousAccessEnabled();
            }
            return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.ALLOW_ANONYMOUS_ACCESS")), (String)"true"));
        }
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.ALLOW_ANONYMOUS_ACCESS")), (String)"false"));
    }

    public static boolean isGlobalAnonymousAccessEnabled() {
        PermissionManager permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        return permissionManager.hasPermission(null, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
    }

    public Boolean getRemoteDirectorySync() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.REMOTE_DIRECTORY_SYNC"))), (boolean)false);
    }

    public void setRemoteDirectorySync(Boolean remoteDirectorySync) {
        this.pluginSettings.put("miniorange.saml.REMOTE_DIRECTORY_SYNC", (Object)BooleanUtils.toString((Boolean)remoteDirectorySync, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableSSO() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.SSO_ENABLE"))), (boolean)true);
    }

    public void setEnableSSO(Boolean enableSSO) {
        this.pluginSettings.put("miniorange.saml.SSO_ENABLE", (Object)BooleanUtils.toString((Boolean)enableSSO, (String)"true", (String)"false", (String)"true"));
    }

    public Boolean getEnableJSDSSO() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.JSD_SSO_ENABLE"))), (boolean)true);
    }

    public void setEnableJSDSSO(Boolean enableJSDSSO) {
        this.pluginSettings.put("miniorange.saml.JSD_SSO_ENABLE", (Object)BooleanUtils.toString((Boolean)enableJSDSSO, (String)"true", (String)"false", (String)"true"));
    }

    public Boolean getEnableConfluenceSSO() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.CONFLUENCE_SSO_ENABLE"))), (boolean)true);
    }

    public void setEnableConfluenceSSO(Boolean enableConfluenceSSO) {
        this.pluginSettings.put("miniorange.saml.CONFLUENCE_SSO_ENABLE", (Object)BooleanUtils.toString((Boolean)enableConfluenceSSO, (String)"true", (String)"false", (String)"true"));
    }

    public Boolean getBackdoorEnabled() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_BACKDOOR"))), (boolean)false);
    }

    public void setBackdoorEnabled(Boolean backdoorEnabled) {
        this.pluginSettings.put("miniorange.saml.ENABLE_BACKDOOR", (Object)BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"false"));
    }

    public void setBackdoorKey(String backdoorKey) {
        this.pluginSettings.put("miniorange.saml.BACKDOOR_KEY", (Object)StringUtils.defaultIfBlank((CharSequence)backdoorKey, (CharSequence)"saml_sso"));
    }

    public String getBackdoorKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.BACKDOOR_KEY")), (CharSequence)"saml_sso");
    }

    public void setBackdoorValue(String backdoorValue) {
        this.pluginSettings.put("miniorange.saml.BACKDOOR_VALUE", (Object)StringUtils.defaultIfBlank((CharSequence)backdoorValue, (CharSequence)"false"));
    }

    public String getBackdoorValue() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.BACKDOOR_VALUE")), (CharSequence)"false");
    }

    public Boolean getEnableAutoRedirectDelay() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_AUTO_REDIRECT_DELAY"))), (boolean)false);
    }

    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.pluginSettings.put("miniorange.saml.ENABLE_AUTO_REDIRECT_DELAY", (Object)BooleanUtils.toString((Boolean)enableAutoRedirectDelay, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAllowLocalAuthentication() {
        if (this.pluginSettings.get("miniorange.saml.DISABLE_LOCAL_AUTHENTICATION") == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_LOCAL_AUTHENTICATION"))), (boolean)Boolean.TRUE);
    }

    public void setAllowLocalAuthentication(Boolean allowLocalAuthentication) {
        this.pluginSettings.put("miniorange.saml.DISABLE_LOCAL_AUTHENTICATION", (Object)BooleanUtils.toString((Boolean)allowLocalAuthentication, (String)"true", (String)"false", (String)"true"));
    }

    public Boolean getShowLoginPage() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.SHOW_LOGIN_PAGE"))), (boolean)false);
    }

    public void setShowLoginPage(Boolean showLoginPage) {
        this.pluginSettings.put("miniorange.saml.SHOW_LOGIN_PAGE", (Object)BooleanUtils.toString((Boolean)showLoginPage, (String)"true", (String)"false", (String)"false"));
    }

    public String getCrowdIDPConfig() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.saml.CROWD_IDP_CONFIG")), (String)"");
    }

    public void setCrowdIDPConfig(String crowdIDPConfig) {
        this.pluginSettings.put("miniorange.saml.CROWD_IDP_CONFIG", (Object)StringUtils.trimToEmpty((String)crowdIDPConfig));
    }

    public HashMap<String, String> getCrowdConfiguredSAMLIdps() {
        Object configuredIDPs = this.pluginSettings.get("miniorange.saml.CONFIGURED_SAML_IDPS");
        if (configuredIDPs != null) {
            return (HashMap)configuredIDPs;
        }
        return new HashMap<String, String>();
    }

    public void setCrowdConfiguredSAMLIdps(HashMap<String, String> configuredSAMLIdps) {
        this.pluginSettings.put("miniorange.saml.CONFIGURED_SAML_IDPS", configuredSAMLIdps);
    }

    public HashMap<String, String> getConnectorSSOConfig() {
        Object connectorSSOConfig = this.pluginSettings.get("miniorange.saml.CONNECTORS_SSO_CONFIG");
        if (connectorSSOConfig != null) {
            return (HashMap)connectorSSOConfig;
        }
        return new HashMap<String, String>();
    }

    public void setConnectorSSOConfig(HashMap<String, String> connectorsSSOConfig) {
        this.pluginSettings.put("miniorange.saml.CONNECTORS_SSO_CONFIG", connectorsSSOConfig);
    }

    public String getRedirectionParameter() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.REDIRECTION_PARAMETER")), (CharSequence)"Domains");
    }

    public void setRedirectionParameter(String redirectionParameter) {
        this.pluginSettings.put("miniorange.saml.REDIRECTION_PARAMETER", (Object)StringUtils.trimToEmpty((String)redirectionParameter));
    }

    public void createWebSudoSession(HttpServletRequest request, HttpServletResponse response, String websudoSessionKey) {
        LOGGER.debug("createWebSudoSession  called");
        HttpSession session = request.getSession(true);
        if (null == session) {
            throw new SecurityException("Unable to create a WebSudo session.");
        }
        session.setAttribute("jira.websudo.timestamp", (Object)this.currentTimeMillis());
        request.setAttribute("jira.websudo.request", (Object)Boolean.TRUE);
        session.setAttribute(websudoSessionKey, (Object)this.currentTimeMillis());
        response.setHeader("X-Atlassian-WebSudo", "Has-Authentication");
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        response.sendRedirect(redirectUrl);
    }

    public String getBaseUrl() {
        String platfrom = this.i18nResolver.getText("my.plugin.platform");
        if (platfrom.equalsIgnoreCase("jira")) {
            return ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
        }
        if (platfrom.equalsIgnoreCase("fisheye")) {
            return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        }
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platfrom);
        return platformUtils.getBaseUrl();
    }

    public String getDefaultLogoutPageUrl() {
        return this.getBaseUrl().concat("/login.action?servlet=true");
    }

    public String getJSDBaseUrl() {
        return this.getBaseUrl() + "/servicedesk/customer/portal";
    }

    public String getJIRALoginPageUrl() {
        String platfrom = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platfrom);
        return platformUtils.getBackDoorUrl(this.getBaseUrl());
    }

    public String getPlatformLoginPageUrl() {
        String platfrom = this.i18nResolver.getText("my.plugin.platform");
        MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platfrom);
        return platformUtils.getBackDoorUrl(this.getApplicationBaseUrl());
    }

    public String getJIRAAdminLoginPageUrl() {
        try {
            String platform = this.i18nResolver.getText("my.plugin.platform");
            MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
            String baseURL = this.getBaseUrl();
            String backdoorKey = this.getBackdoorKey();
            String backdoorValue = this.getBackdoorValue();
            baseURL = StringUtils.equalsIgnoreCase((CharSequence)"jira", (CharSequence)platform) ? baseURL + "/login.jsp?" + backdoorKey + "=" + backdoorValue + "&os_destination=" : baseURL + "/login.action?" + backdoorKey + "=" + backdoorValue + "&os_destination=";
            return platformUtils.getAdminBackDoorUrl(baseURL);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Boolean isEvaluationOrSubscriptionLicense() {
        try {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (pluginLicense.isEvaluation() || pluginLicense.isSubscription()) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            LOGGER.debug(" pluginLicenseManager.getLicense().isDefined() : " + this.pluginLicenseManager.getLicense().isDefined());
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                LOGGER.error("Invalid License");
                return Boolean.FALSE;
            }
        }
        if ((this.i18nResolver.getText("my.plugin.platform").equals("jira") || this.i18nResolver.getText("my.plugin.platform").equals("confluence")) && !this.offlineLicenseSettings.isDatacenter() && this.offlineLicenseSettings.isOfflineLicenseValid().booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public int getMaxUsers() {
        int t = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return t;
    }

    public boolean isLicenseDefined() {
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                return Boolean.TRUE;
            }
            if ((this.i18nResolver.getText("my.plugin.platform").equals("jira") || this.i18nResolver.getText("my.plugin.platform").equals("confluence")) && !this.offlineLicenseSettings.isDatacenter()) {
                if (this.offlineLicenseSettings.offlineLicenseDetails() != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while verifying the license");
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseExpired() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isMaintenanceExpired();
        }
        if ((this.i18nResolver.getText("my.plugin.platform").equals("jira") || this.i18nResolver.getText("my.plugin.platform").equals("confluence")) && !this.offlineLicenseSettings.isDatacenter()) {
            return this.offlineLicenseSettings.isOfflineLicenseExpired();
        }
        return true;
    }

    public String getConfigurationPageUrl() {
        return this.getBaseUrl().concat("/secure/admin/configure.jspa");
    }

    public String getManageAddOnURL() {
        return this.getApplicationBaseUrl().concat("/plugins/servlet/upm");
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public boolean getIsMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.IS_CONNECTOR_MIGRATED"))), (boolean)false);
    }

    public void setIsMigrated(boolean migrated) {
        this.pluginSettings.put("miniorange.saml.IS_CONNECTOR_MIGRATED", (Object)BooleanUtils.toString((Boolean)migrated, (String)"true", (String)"false", (String)"false"));
    }

    public HashMap<String, MoCrowdConnectorSSOConfig> getCrowdConnectorSSOConfigMap() {
        return MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(this.getConnectorSSOConfig());
    }

    public void setRedirectionRule(String rule, String ruleName) {
        this.pluginSettings.put("miniorange.saml.REDIRECTION_RULE" + ruleName, (Object)rule);
    }

    public JSONObject getRedirectionRule(String ruleName) {
        String rule = (String)this.pluginSettings.get("miniorange.saml.REDIRECTION_RULE" + ruleName);
        try {
            JSONObject redirectionRule = new JSONObject(rule);
            return redirectionRule;
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while getting Redirection Rule", (Throwable)e);
            return null;
        }
    }

    public String getAppRedirectionRuleJson() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.APP_REDIRECTION_RULES")), (CharSequence)new JSONObject().toString());
    }

    public void setAppRedirectionRulesMap(String appRedirectionRules) {
        this.pluginSettings.put("miniorange.saml.APP_REDIRECTION_RULES", (Object)appRedirectionRules);
    }

    public Map<String, String> getAppRedirectionRulesMap() {
        String appRedirectionRules = this.getAppRedirectionRuleJson();
        LOGGER.debug("DB rules in Json " + appRedirectionRules);
        Map<String, String> appRedirectionRulesMap = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)appRedirectionRules)) {
            return appRedirectionRulesMap;
        }
        appRedirectionRulesMap = MoJSONUtils.convertJsonToMap(appRedirectionRules, appRedirectionRulesMap);
        return appRedirectionRulesMap;
    }

    public String getJSDRedirectionRuleJson() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.JSD_REDIRECTION_RULES")), (CharSequence)new JSONObject().toString());
    }

    public void setJSDRedirectionRulesMap(String jsdRedirectionRules) {
        this.pluginSettings.put("miniorange.saml.JSD_REDIRECTION_RULES", (Object)jsdRedirectionRules);
    }

    public Map<String, String> getJSDRedirectionRulesMap() {
        String jsdRedirectionRules = this.getJSDRedirectionRuleJson();
        Map<String, String> jsdRedirectionRulesMap = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)jsdRedirectionRules)) {
            return jsdRedirectionRulesMap;
        }
        jsdRedirectionRulesMap = MoJSONUtils.convertJsonToMap(jsdRedirectionRules, jsdRedirectionRulesMap);
        return jsdRedirectionRulesMap;
    }

    public void setAppDefaultRedirectURL(String appDefaultRedirectURL) {
        this.pluginSettings.put("miniorange.saml.APP_DEFAULT_REDIRECT_URL", (Object)StringUtils.defaultIfBlank((CharSequence)appDefaultRedirectURL, (CharSequence)""));
    }

    public String getAppDefaultRedirectURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.APP_DEFAULT_REDIRECT_URL")), (CharSequence)"");
    }

    public void setJsdDefaultRedirectURL(String jsdDefaultRedirectURL) {
        this.pluginSettings.put("miniorange.saml.JSD_DEFAULT_REDIRECT_URL", (Object)StringUtils.defaultIfBlank((CharSequence)jsdDefaultRedirectURL, (CharSequence)""));
    }

    public String getJsdDefaultRedirectURL() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.JSD_DEFAULT_REDIRECT_URL")), (CharSequence)"");
    }

    public void setDefaultAppIDP(String defaultAppIDP) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_APP_IDP", (Object)StringUtils.defaultIfBlank((CharSequence)defaultAppIDP, (CharSequence)"loginPage"));
    }

    public String getDefaultAppIDP() {
        String defaultAppIDP = "";
        defaultAppIDP = this.getCrowdConnectorSSOConfigMap().isEmpty() || this.getAutoRedirectToIDP() == false ? "loginPage" : this.getDefaultIDP();
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_APP_IDP")), (CharSequence)defaultAppIDP);
    }

    public String getDefaultIDP() {
        String idp = "loginPage";
        for (String idpID : this.getCrowdConnectorSSOConfigMap().keySet()) {
            if (this.getCrowdConnectorSSOConfigMap().get(idpID).getSsoForJIRASoftware().booleanValue() && this.getPlatform().equals("jira")) {
                idp = idpID;
                break;
            }
            if (this.getCrowdConnectorSSOConfigMap().get(idpID).getSsoForConfluence().booleanValue() && this.getPlatform().equals("confluence")) {
                idp = idpID;
                break;
            }
            if (this.getCrowdConnectorSSOConfigMap().get(idpID).getSsoForBitbucket().booleanValue() && this.getPlatform().equals("bitbucket")) {
                idp = idpID;
                break;
            }
            if (this.getCrowdConnectorSSOConfigMap().get(idpID).getSsoForbamboo().booleanValue() && this.getPlatform().equals("bamboo")) {
                idp = idpID;
                break;
            }
            if (this.getCrowdConnectorSSOConfigMap().get(idpID).getSsoForFisheye().booleanValue() && this.getPlatform().equals("fisheye")) {
                idp = idpID;
                break;
            }
            idp = "loginPage";
        }
        return idp;
    }

    public void setDefaultJSDIDP(String defaultJSDIDP) {
        this.pluginSettings.put("miniorange.saml.DEFAULT_JSD_IDP", (Object)StringUtils.defaultIfBlank((CharSequence)defaultJSDIDP, (CharSequence)"loginPage"));
    }

    public String getDefaultJsdIDP() {
        String defaultJSDIDP = "";
        if (this.getCrowdConnectorSSOConfigMap().isEmpty() || !this.getAutoRedirectToIDP().booleanValue()) {
            defaultJSDIDP = "loginPage";
        } else {
            for (String idpID : this.getCrowdConnectorSSOConfigMap().keySet()) {
                if (this.getCrowdConnectorSSOConfigMap().get(idpID).getSsoForJSD().booleanValue() && this.getPlatform().equals("jira")) {
                    defaultJSDIDP = idpID;
                    break;
                }
                defaultJSDIDP = "loginPage";
            }
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.DEFAULT_JSD_IDP")), (CharSequence)defaultJSDIDP);
    }

    public String getPlatform() {
        return this.i18nResolver.getText("my.plugin.platform");
    }

    public void deleteRedirectionRule(String ruleId, String application) {
        this.pluginSettings.remove("miniorange.saml.REDIRECTION_RULE" + ruleId);
        Map<String, String> rulesMap = StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"jsd") ? this.getJSDRedirectionRulesMap() : this.getAppRedirectionRulesMap();
        rulesMap.remove(ruleId);
        String redirectionRules = MoJSONUtils.convertMapToJSON(rulesMap);
        if (StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"jsd")) {
            this.setJSDRedirectionRulesMap(redirectionRules);
        } else {
            this.setAppRedirectionRulesMap(redirectionRules);
        }
    }

    public JSONArray getRedirectionRules(String application) {
        JSONArray rules = new JSONArray();
        Map<String, String> rulesMap = StringUtils.equals((CharSequence)application, (CharSequence)"jsd") ? this.getJSDRedirectionRulesMap() : this.getAppRedirectionRulesMap();
        for (String key : rulesMap.keySet()) {
            JSONObject rule = this.getRedirectionRule(key);
            rules.put(rule);
        }
        return rules;
    }

    public Map<String, String> getRedirectionRulesMap(String application) {
        return StringUtils.equals((CharSequence)application, (CharSequence)"jsd") ? this.getJSDRedirectionRulesMap() : this.getAppRedirectionRulesMap();
    }

    public ArrayList<String> getAllGroupsOfUser(String username) {
        MembershipQuery<Group> query = QueryBuilder.queryFor(Group.class, EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable<Group> groups = this.crowdService.search(query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    private Boolean checkRedirection(String decisionFactor, String conditionValue, String email, ArrayList<String> userGroups) {
        String domain = email.substring(email.indexOf("@") + 1);
        if (decisionFactor.equals("domain") && domain.equalsIgnoreCase(conditionValue)) {
            return true;
        }
        if (decisionFactor.equals("group") && userGroups.contains(conditionValue)) {
            LOGGER.debug("Group Matched:" + userGroups.contains(conditionValue));
            return true;
        }
        if (decisionFactor.equals("directory")) {
            try {
                User user = this.directoryManager.findUserByName(Long.valueOf(conditionValue), email);
                if (user != null) {
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error("User Not found in this directory:", (Throwable)e);
            }
        }
        return false;
    }

    public JSONObject getIDPFromRedirectionRules(String application, String email) {
        ArrayList<String> userGroups = this.getAllGroupsOfUser(email);
        JSONArray rules = this.getRedirectionRules(application);
        ArrayList<String> ssoEnabledIdpList = new ArrayList<String>();
        HashMap<String, MoCrowdConnectorSSOConfig> configMap = this.getCrowdConnectorSSOConfigMap();
        for (String idpID : configMap.keySet()) {
            if (application.equals("jira") && configMap.get(idpID).getSsoForJIRASoftware().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                LOGGER.debug("Adding to list:" + idpID);
                continue;
            }
            if (application.equals("jsd") && configMap.get(idpID).getSsoForJSD().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (application.equals("confluence") && configMap.get(idpID).getSsoForConfluence().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (application.equals("bitbucket") && configMap.get(idpID).getSsoForBitbucket().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (application.equals("bamboo") && configMap.get(idpID).getSsoForbamboo().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (!application.equals("fisheye") || !configMap.get(idpID).getSsoForFisheye().booleanValue()) continue;
            ssoEnabledIdpList.add(idpID);
        }
        LOGGER.info("RulesLength:" + rules.length() + " Rules:" + rules.toString());
        String idpName = "";
        try {
            String conditionValue;
            String decisionFactor;
            JSONObject rule;
            for (int i = 0; !(i >= rules.length() || (ssoEnabledIdpList.contains(idpName = (String)(rule = rules.optJSONObject(i)).get("idp")) || idpName.equals("loginPage")) && this.checkRedirection(decisionFactor = (String)rule.getJSONObject("condition").get("decisionFactor"), conditionValue = (String)rule.getJSONObject("condition").getJSONObject(decisionFactor).get("equals"), email, userGroups).booleanValue()); ++i) {
                idpName = "";
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while checking redirection rules:", (Throwable)e);
        }
        JSONObject jsonResponse = new JSONObject();
        if (idpName.isEmpty()) {
            String value;
            String string = value = application.equals("jsd") ? this.getDefaultJsdIDP() : this.getDefaultAppIDP();
            if (!value.equals("redirectUrl") && !value.equals("loginPage") && ssoEnabledIdpList.contains(value)) {
                jsonResponse.put("defaultRule", value);
            } else if (value.equals("redirectUrl") || value.equals("loginPage")) {
                jsonResponse.put("defaultRule", value);
                if (value.equals("redirectUrl")) {
                    jsonResponse.put("RedirectURL", application.equals("jsd") ? this.getJsdDefaultRedirectURL() : this.getAppDefaultRedirectURL());
                }
            } else {
                jsonResponse.put("defaultRule", "");
            }
        }
        jsonResponse.put("idpId", idpName);
        jsonResponse.put("baseUrl", this.getApplicationBaseUrl());
        jsonResponse.put("confluenceBaseUrl", this.getBaseUrl());
        jsonResponse.put("fisheyeBaseUrl", this.getApplicationBaseUrl());
        jsonResponse.put("bambooBaseUrl", this.getApplicationBaseUrl());
        jsonResponse.put("jsdBaseUrl", this.getJSDBaseUrl());
        jsonResponse.put("crowdDomainURL", this.getCrowdDomainURL());
        LOGGER.debug("FINAL Redirection Rules RESPONSE:" + jsonResponse.toString());
        return jsonResponse;
    }

    public Boolean getDisableLicenseExpiringWarning() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_LICENSE_EXPIRING_WARNING"))), (boolean)false);
    }

    public void setDisableLicenseExpiringWarning(Boolean disableLicenseWarning) {
        this.pluginSettings.put("miniorange.saml.DISABLE_LICENSE_EXPIRING_WARNING", (Object)BooleanUtils.toString((boolean)disableLicenseWarning, (String)"true", (String)"false"));
    }

    public Boolean getDisableLicenseExpiredWarning() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.DISABLE_LICENSE_EXPIRED_WARNING"))), (boolean)false);
    }

    public void setDisableLicenseExpiredWarning(Boolean disableLicenseExpiredWarning) {
        this.pluginSettings.put("miniorange.saml.DISABLE_LICENSE_EXPIRED_WARNING", (Object)BooleanUtils.toString((boolean)disableLicenseExpiredWarning, (String)"true", (String)"false"));
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.ENABLE_DEBUG_LOGS"))), (boolean)false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put("miniorange.saml.ENABLE_DEBUG_LOGS", (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    public String getSSOPath() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.SSO_PATH")), (CharSequence)"/plugins/servlet/saml/auth");
    }

    public void setSSOPath(String ssoPath) {
        this.pluginSettings.put("miniorange.saml.SSO_PATH", (Object)ssoPath);
    }

    public String getOfflineLicenseKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.OFFLINE_LICENSE_KEY")), (CharSequence)"");
    }

    public void setOfflineLicenseKey(String licenseKey) {
        this.pluginSettings.put("miniorange.saml.OFFLINE_LICENSE_KEY", (Object)StringUtils.defaultIfBlank((CharSequence)licenseKey, (CharSequence)""));
    }

    static {
        try {
            DEFAULT_LOGOUT_TEMPLATE = IOUtils.toString((InputStream)MoPluginConfigurationManager.class.getResourceAsStream(DEFAULT_LOGOUT_TEMPLATE_PATH), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

