/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.handler;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.config.MoCrowdSAMLIDPConfig;
import com.miniorange.crowd.common.handler.MoPlatformDecisionHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.scheduler.MoGetCrowdSSOConfigurationService;
import com.miniorange.crowd.common.servlet.utils.MoHttpUtils;
import com.miniorange.crowd.common.servlet.utils.MoJSONUtils;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class MoPluginConfigurationHandler {
    private static Log LOGGER = LogFactory.getLog(MoPluginConfigurationHandler.class);
    private static MoPluginConfigurationManager pluginConfigurationManager;
    private static MoGetCrowdSSOConfigurationService crowdSSOConfigurationService;
    private static I18nResolver i18nResolver;
    private static DirectoryManager directoryManager;
    private static String DEFAULT_IDP_NAME;
    private static String DEFAULT_IDP_ID;

    public MoPluginConfigurationHandler(MoPluginConfigurationManager pluginConfigurationManager, MoGetCrowdSSOConfigurationService crowdSSOConfigurationService, I18nResolver i18nResolver, DirectoryManager directoryManager) {
        MoPluginConfigurationHandler.pluginConfigurationManager = pluginConfigurationManager;
        MoPluginConfigurationHandler.crowdSSOConfigurationService = crowdSSOConfigurationService;
        MoPluginConfigurationHandler.i18nResolver = i18nResolver;
        MoPluginConfigurationHandler.directoryManager = directoryManager;
    }

    public static void saveConfiguration(Boolean enableSSO, String crowdDomainURL, Boolean enableJSDSSO, Boolean enableConfluenceSSO, String redirectionParameter, HashMap<String, String> SsoConfigObj) {
        pluginConfigurationManager.setEnableSSO(enableSSO);
        pluginConfigurationManager.setEnableJSDSSO(enableJSDSSO);
        pluginConfigurationManager.setCrowdDomainURL(crowdDomainURL);
        pluginConfigurationManager.setEnableConfluenceSSO(enableConfluenceSSO);
        pluginConfigurationManager.setRedirectionParameter(redirectionParameter);
        pluginConfigurationManager.setConnectorSSOConfig(SsoConfigObj);
        MoPluginConfigurationHandler.toggleSchedulerService(crowdDomainURL);
    }

    public static void toggleSchedulerService(String crowdDomainURL) {
        if (StringUtils.isNotEmpty((CharSequence)crowdDomainURL)) {
            LOGGER.debug((Object)"Schedule the event ");
            crowdSSOConfigurationService.reschedule();
        } else {
            LOGGER.debug((Object)"Unschedule the event ");
            crowdSSOConfigurationService.unschedule();
        }
    }

    public static void saveRedirectionConfiguration(Boolean enableGlobalSSO, String ssoButtonText, Boolean autoRedirectToIDP, Boolean backdoorEnabled, Boolean enableAutoRedirectDelay, String logoutUrl, Boolean useLogoutTemplate, String logoutTemplate, Boolean enableSingleLogoutURL, Boolean allowAnonymousAccess, Boolean remoteDirectorySync) {
        pluginConfigurationManager.setEnableGlobalSSO(enableGlobalSSO);
        pluginConfigurationManager.setSsoButtonText(ssoButtonText);
        pluginConfigurationManager.setAutoRedirectToIDP(autoRedirectToIDP);
        pluginConfigurationManager.setRemoteDirectorySync(remoteDirectorySync);
        if (autoRedirectToIDP != null) {
            if (autoRedirectToIDP.booleanValue()) {
                pluginConfigurationManager.setDefaultAppIDP("loginPage");
                pluginConfigurationManager.setDefaultJSDIDP("loginPage");
            }
            pluginConfigurationManager.setEnableAutoRedirectDelay(BooleanUtils.toBoolean((Boolean)enableAutoRedirectDelay));
        } else {
            pluginConfigurationManager.setEnableAutoRedirectDelay(Boolean.FALSE);
        }
        pluginConfigurationManager.setBackdoorEnabled(backdoorEnabled);
        pluginConfigurationManager.setLogoutUrl(logoutUrl);
        pluginConfigurationManager.setUseLogoutTemplate(useLogoutTemplate);
        pluginConfigurationManager.setLogutTemplate(logoutTemplate);
        LOGGER.debug((Object)("SLO ==== " + enableSingleLogoutURL));
        pluginConfigurationManager.setEnableSingleLogoutURL(enableSingleLogoutURL);
        pluginConfigurationManager.setAllowAnonymousAccess(allowAnonymousAccess);
        LOGGER.debug((Object)("SLO from db==" + pluginConfigurationManager.getEnableSingleLogoutURL()));
    }

    public static void saveLookAndFeelConfiguration(Boolean useErrorTemplate, String errorTemplate, Boolean useLoginTemplate, String loginTemplate) {
        pluginConfigurationManager.setUseErrorTemplate(useErrorTemplate);
        pluginConfigurationManager.setErrorTemplate(errorTemplate);
        pluginConfigurationManager.setUseLoginTemplate(useLoginTemplate);
        pluginConfigurationManager.setLoginTemplate(loginTemplate);
    }

    public static void saveCrowdConnectorSSOConfiguration(String crowdBaseURL, String redirectionParameter, String[] redirectDomainMapping, String[] redirectGroupMapping, ArrayList<Boolean> ssoForJIRASoftware, ArrayList<Boolean> ssoForJSD, ArrayList<Boolean> ssoForConfluence, ArrayList<Boolean> ssoForfisheye, ArrayList<Boolean> ssoForBitbucket, ArrayList<Boolean> ssoForbamboo) {
        LOGGER.debug((Object)"Saving plugin's SSO configuration");
        String platform = i18nResolver.getText("my.plugin.platform");
        try {
            HashMap<String, String> connectorsSSOConfig = pluginConfigurationManager.getConnectorSSOConfig();
            LOGGER.debug((Object)("Saved plugin configuration : " + connectorsSSOConfig.toString()));
            LOGGER.debug((Object)"Form Data : ");
            LOGGER.debug((Object)("Crowd Base URL : " + crowdBaseURL + " redirectionParameter : " + redirectionParameter + " redirectDomainMapping : " + Arrays.toString(redirectDomainMapping) + " redirectGroupMapping : " + Arrays.toString(redirectGroupMapping) + " ssoForJIRASoftware : " + ssoForJIRASoftware + " ssoForJSD : " + ssoForJSD + " ssoForConfluence : " + ssoForConfluence + " ssoForfisheye : " + ssoForfisheye));
            pluginConfigurationManager.setCrowdDomainURL(crowdBaseURL);
            pluginConfigurationManager.setRedirectionParameter(redirectionParameter);
            MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
            connectorsSSOConfig = platformUtils.saveOrUpdateCrowdSSOConfig(connectorsSSOConfig, redirectDomainMapping, redirectGroupMapping, ssoForJIRASoftware, ssoForJSD, ssoForConfluence, ssoForfisheye, ssoForBitbucket, ssoForbamboo);
            pluginConfigurationManager.setConnectorSSOConfig(connectorsSSOConfig);
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occured while saving the Crowd SAML IDP config.");
            e.printStackTrace();
        }
    }

    public static void fetchUpdatedCrowdIDPConfig() {
        LOGGER.debug((Object)"Fetching Crowd IDP Config");
        try {
            String crowdSSOGetConfEndpoint = pluginConfigurationManager.getCrowdDomainURL() + "/plugins/servlet/saml/getidpconfig";
            LOGGER.debug((Object)("Crowd IDP Fetch Endpoint : " + crowdSSOGetConfEndpoint));
            String response = MoHttpUtils.sendGetRequest(crowdSSOGetConfEndpoint);
            LOGGER.debug((Object)("Response from Crowd : " + response));
            if (StringUtils.isNotEmpty((CharSequence)response)) {
                ObjectMapper mapper = new ObjectMapper();
                MoCrowdSAMLIDPConfig config = mapper.readValue(response, MoCrowdSAMLIDPConfig.class);
                LOGGER.debug((Object)("Currently configured SAML IDPs in Crowd: " + config.toString()));
                StringBuilder ssoPath = new StringBuilder("/plugins/servlet");
                if (config.getIsOAuth().booleanValue()) {
                    ssoPath.append("/oauth/auth");
                } else {
                    ssoPath.append("/saml/auth");
                }
                pluginConfigurationManager.setSSOPath(ssoPath.toString());
                for (String idpId : config.getConfiguredIdps().keySet()) {
                    LOGGER.debug((Object)"Updating Connector's SSO config");
                    MoPluginConfigurationHandler.AddOrUpdateCrowdConnectorSSOConfig(idpId, config);
                }
                MoPluginConfigurationHandler.deleteCrowdConnectorSSOConfig(config);
            } else {
                LOGGER.debug((Object)"No response from Crowd SAML. Adding temp default IDP");
                MoPluginConfigurationHandler.AddDefaultIdp(DEFAULT_IDP_ID);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occured while fetching the Crowd SAML IDP config.");
            e.printStackTrace();
        }
    }

    public static void AddDefaultIdp(String idpId) {
        try {
            if (MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(pluginConfigurationManager.getConnectorSSOConfig()).get(idpId) == null) {
                HashMap<String, String> connectorsSSOConfig = new HashMap<String, String>();
                MoCrowdConnectorSSOConfig ssoConfig = new MoCrowdConnectorSSOConfig();
                MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(pluginConfigurationManager.getConnectorSSOConfig());
                ssoConfig.setIdpId(DEFAULT_IDP_ID);
                ssoConfig.setIdpName(DEFAULT_IDP_NAME);
                ssoConfig.setIdpRedirectDomains(new ArrayList<String>());
                ssoConfig.setIdpRedirectGroups(new ArrayList<String>());
                ssoConfig.setSsoForJIRASoftware(true);
                ssoConfig.setSsoForJSD(true);
                ssoConfig.setSsoForConfluence(true);
                ssoConfig.setSsoForFisheye(true);
                ssoConfig.setSsoForbamboo(true);
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString(ssoConfig);
                connectorsSSOConfig.put(idpId, jsonString);
                LOGGER.debug((Object)("\n\n\n Adding default idp  " + jsonString + "\n\n\n"));
                pluginConfigurationManager.setConnectorSSOConfig(connectorsSSOConfig);
            } else {
                pluginConfigurationManager.getConnectorSSOConfig();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occured while fetching the Crowd SAML IDP config.");
            e.printStackTrace();
        }
    }

    public static void deleteCrowdConnectorSSOConfig(MoCrowdSAMLIDPConfig config) {
        HashMap<String, String> connectorsSSOConfig = pluginConfigurationManager.getConnectorSSOConfig();
        if (config != null && connectorsSSOConfig != null) {
            Iterator<Map.Entry<String, String>> iterator = connectorsSSOConfig.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (config.getConfiguredIdps().keySet().contains(entry.getKey())) continue;
                LOGGER.debug((Object)("Deleting IdP configuration :  " + entry.getValue()));
                iterator.remove();
            }
        }
        LOGGER.debug((Object)("Crowd Connector Config  : " + connectorsSSOConfig.toString()));
        pluginConfigurationManager.setConnectorSSOConfig(connectorsSSOConfig);
    }

    public static void AddOrUpdateCrowdConnectorSSOConfig(String idpId, MoCrowdSAMLIDPConfig crowdSAMLConfig) {
        try {
            LOGGER.debug((Object)("Refreshing Crowd Connector SSO Config : IDPID :" + idpId));
            HashMap<String, String> connectorsSSOConfig = pluginConfigurationManager.getConnectorSSOConfig();
            LOGGER.debug((Object)("connectorsSSOConfig.containsKey(idpId) " + connectorsSSOConfig.containsKey(idpId)));
            if (connectorsSSOConfig == null || connectorsSSOConfig != null && !connectorsSSOConfig.containsKey(idpId)) {
                MoCrowdConnectorSSOConfig ssoConfig = new MoCrowdConnectorSSOConfig();
                LOGGER.debug((Object)("New IDP configuration found idpID: " + idpId));
                ssoConfig.setIdpId(idpId);
                ssoConfig.setIdpName(crowdSAMLConfig.getConfiguredIdps().get(idpId));
                ssoConfig.setIdpRedirectDomains(new ArrayList<String>());
                ssoConfig.setIdpRedirectGroups(new ArrayList<String>());
                ssoConfig.setSsoForJIRASoftware(true);
                ssoConfig.setSsoForJSD(true);
                ssoConfig.setSsoForConfluence(true);
                ssoConfig.setSsoForFisheye(true);
                ssoConfig.setSsoForBitbucket(true);
                ssoConfig.setSsoForbamboo(true);
                LOGGER.debug((Object)("New IDP configuration object" + ssoConfig.toString()));
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString(ssoConfig);
                LOGGER.debug((Object)("New IDP configuration JSON String" + jsonString));
                connectorsSSOConfig.put(idpId, jsonString);
                pluginConfigurationManager.setConnectorSSOConfig(connectorsSSOConfig);
            } else if (connectorsSSOConfig != null && connectorsSSOConfig.containsKey(idpId)) {
                LOGGER.debug((Object)"Updating Crowd Connector SSO Config");
                MoCrowdConnectorSSOConfig ssoConfig = new MoCrowdConnectorSSOConfig();
                ObjectMapper mapper = new ObjectMapper();
                ssoConfig = mapper.readValue(connectorsSSOConfig.get(idpId), MoCrowdConnectorSSOConfig.class);
                LOGGER.debug((Object)("saved Crowd Connector SSO Config  : " + ssoConfig.toString()));
                ssoConfig.setIdpName(crowdSAMLConfig.getConfiguredIdps().get(idpId));
                String jsonString = mapper.writeValueAsString(ssoConfig);
                connectorsSSOConfig.put(idpId, jsonString);
                pluginConfigurationManager.setConnectorSSOConfig(connectorsSSOConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MoCrowdConnectorSSOConfig constructCrowdConnectorSSOConfig(String idpId, String savedJsonStringConfig) {
        LOGGER.debug((Object)"Constructing the JIRA Crowd Connector config object");
        MoCrowdConnectorSSOConfig config = new MoCrowdConnectorSSOConfig();
        try {
            if (StringUtils.isNotEmpty((CharSequence)savedJsonStringConfig)) {
                LOGGER.debug((Object)("saved configuraion  : " + savedJsonStringConfig));
                ObjectMapper mapper = new ObjectMapper();
                config = mapper.readValue(savedJsonStringConfig, MoCrowdConnectorSSOConfig.class);
                LOGGER.debug((Object)("saved Crowd Connector SSO Config  : " + config.toString()));
                LOGGER.debug((Object)("saved Domain Mapping info  : " + config.getIdpRedirectDomains()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occured while fetching the Crowd SAML IDP config.");
            e.printStackTrace();
        }
        return config;
    }

    public static HashMap<String, MoCrowdConnectorSSOConfig> initializeCrowdConnectorSSOConfig(HashMap<String, String> savedConnectorConfig) {
        LOGGER.debug((Object)"Initializing JIRA Crowd Connector config object");
        HashMap<String, MoCrowdConnectorSSOConfig> crowdConnectorConfigMap = new HashMap<String, MoCrowdConnectorSSOConfig>();
        for (String idpId : savedConnectorConfig.keySet()) {
            crowdConnectorConfigMap.put(idpId, MoPluginConfigurationHandler.constructCrowdConnectorSSOConfig(idpId, savedConnectorConfig.get(idpId)));
        }
        return crowdConnectorConfigMap;
    }

    public static List<String> retrieveGroups(String search, int i) {
        CrowdService crowdService = ComponentAccessor.getCrowdService();
        String startWith = search;
        if (StringUtils.equalsIgnoreCase((CharSequence)search, (CharSequence)"*")) {
            startWith = "";
        }
        EntityQuery<Group> query = QueryBuilder.queryFor(Group.class, EntityDescriptor.group()).with(Restriction.on(GroupTermKeys.NAME).startingWith(startWith)).returningAtMost(i);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable<Group> groups = crowdService.search(query);
        for (Group groupObject : groups) {
            LOGGER.debug((Object)("groups from JIRA Server = " + groupObject.getName()));
            existingGroups.add(StringUtils.trim((String)groupObject.getName()));
        }
        LOGGER.debug((Object)("groups from Confluence Server = " + ((Object)existingGroups).toString()));
        return existingGroups;
    }

    public String generateConfigurationsJson() {
        LOGGER.debug((Object)"Generating configurations JSON string ");
        JSONObject config = new JSONObject();
        try {
            config.putOpt("Global SSO", pluginConfigurationManager.getEnableGlobalSSO());
            config.putOpt("Remote Directory Sync", pluginConfigurationManager.getRemoteDirectorySync());
            config.putOpt("Crowd Domain Url", pluginConfigurationManager.getCrowdDomainURL());
            config.putOpt("Auto Redirect To IDP", pluginConfigurationManager.getAutoRedirectToIDP());
            config.putOpt("SSO Button Text", pluginConfigurationManager.getSsoButtonText());
            config.putOpt("Show SSO Button", pluginConfigurationManager.getShowSSOButton());
            config.putOpt("Enable SSO", pluginConfigurationManager.getEnableSSO());
            config.putOpt("JSD SSO Enable", pluginConfigurationManager.getEnableJSDSSO());
            config.putOpt("Enable Backdoor", pluginConfigurationManager.getBackdoorEnabled());
            config.putOpt("Backdoor Key", pluginConfigurationManager.getBackdoorKey());
            config.putOpt("Backdoor Value", pluginConfigurationManager.getBackdoorValue());
            config.putOpt("Enable Auto Redirect Delay", pluginConfigurationManager.getEnableAutoRedirectDelay());
            config.putOpt("Logout URL", pluginConfigurationManager.getLogoutUrl());
            config.putOpt("Use Error Template", pluginConfigurationManager.getUseErrorTemplate());
            config.putOpt("Error Template", pluginConfigurationManager.getErrorTemplate());
            config.putOpt("Use Login Template", pluginConfigurationManager.getUseLoginTemplate());
            config.putOpt("Login Template", pluginConfigurationManager.getLoginTemplate());
            config.putOpt("Use Logout Template", pluginConfigurationManager.getUseLogoutTemplate());
            config.putOpt("Logout Template", pluginConfigurationManager.getLogoutTemplate());
            config.putOpt("Confluence SSO Enable", pluginConfigurationManager.getEnableConfluenceSSO());
            config.putOpt("Crowd IDP Config", pluginConfigurationManager.getCrowdIDPConfig());
            config.putOpt("Configured SAML IDPS", pluginConfigurationManager.getCrowdConfiguredSAMLIdps());
            config.putOpt("Redirection Parameter", pluginConfigurationManager.getRedirectionParameter());
            config.putOpt("Connector SSO Config", pluginConfigurationManager.getConnectorSSOConfig());
            config.putOpt("Enanble Single Logout Url", pluginConfigurationManager.getEnableSingleLogoutURL());
            config.putOpt("Use Login Template For JSD", pluginConfigurationManager.getUseLoginTemplateJSD());
            config.putOpt("Login Template For JSD", pluginConfigurationManager.getLoginTemplateJSD());
            String appRedirectionRule = pluginConfigurationManager.getAppRedirectionRuleJson();
            String JSDRedirectionRule = pluginConfigurationManager.getJSDRedirectionRuleJson();
            JSONObject appRedirectionRuleJSON = new JSONObject(appRedirectionRule);
            JSONObject JSDRedirectionRuleJSON = new JSONObject(JSDRedirectionRule);
            config.putOpt("App Redirection Rules", appRedirectionRuleJSON);
            config.putOpt("JSD Redirection Rules", JSDRedirectionRuleJSON);
            config.putOpt("Show Default Login Page", pluginConfigurationManager.getShowLoginPage());
            config.putOpt("Default App IDP", pluginConfigurationManager.getDefaultAppIDP());
            config.putOpt("Default JSD IDP", pluginConfigurationManager.getDefaultJsdIDP());
            config.putOpt("Default App Redirect URL", pluginConfigurationManager.getAppDefaultRedirectURL());
            config.putOpt("Default JSD Redirect URL", pluginConfigurationManager.getJsdDefaultRedirectURL());
            config.putOpt("JSD Logout URL", pluginConfigurationManager.getLogoutUrlJSD());
            config.putOpt("Use Logout Template JSD", pluginConfigurationManager.getUseLogoutTemplateJSD());
            config.putOpt("Logout Template JSD", pluginConfigurationManager.getLogoutTemplateJSD());
            config.putOpt("Allow Local Authentication", pluginConfigurationManager.getAllowLocalAuthentication());
            config.putOpt("Connectors SSO Config", pluginConfigurationManager.getConnectorSSOConfig().toString());
            config.putOpt("Enable Debug Logs", pluginConfigurationManager.getEnableDebugLogs());
            config.putOpt("SSO Path", pluginConfigurationManager.getSSOPath());
            config.putOpt("Allow Anonymous Access", pluginConfigurationManager.getAllowAnonymousAccess());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error Occurred while generating json file for plugin Configuration " + e));
        }
        return config.toString(4);
    }

    public static void importConfigurations(String pluginConfigurations) throws IOException, Exception {
        LOGGER.debug((Object)"Importing plugin's configuration from config file");
        try {
            JSONObject pluginConfigObj = new JSONObject(pluginConfigurations);
            String crowdDomainURL = pluginConfigObj.optString("Crowd Domain Url", "");
            Boolean enableSSO = pluginConfigObj.optBoolean("Enable SSO", Boolean.TRUE);
            Boolean enableJSDSSO = pluginConfigObj.optBoolean("JSD SSO Enable", Boolean.TRUE);
            Boolean enableConfluenceSSO = pluginConfigObj.optBoolean("Confluence SSO Enable", Boolean.TRUE);
            String redirectionParameter = pluginConfigObj.optString("Redirection Parameter", "");
            JSONObject connectorSsoConfig = pluginConfigObj.optJSONObject("Connector SSO Config");
            Iterator<String> keys = connectorSsoConfig.keys();
            HashMap<String, String> SsoConfigObj = new HashMap<String, String>();
            while (keys.hasNext()) {
                String key = keys.next();
                Object value = connectorSsoConfig.get(key);
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString(value);
                jsonString = jsonString.substring(1, jsonString.length() - 1);
                jsonString = jsonString.replaceAll("\\\\", "");
                JSONObject json = new JSONObject(jsonString);
                LOGGER.debug((Object)("json string :- " + jsonString + "\njson object" + json));
                SsoConfigObj.put(key, jsonString);
            }
            MoPluginConfigurationHandler.saveConfiguration(enableSSO, crowdDomainURL, enableJSDSSO, enableConfluenceSSO, redirectionParameter, SsoConfigObj);
            Boolean enableGlobalSSO = pluginConfigObj.optBoolean("Global SSO", Boolean.TRUE);
            Boolean remoteDirectorySync = pluginConfigObj.optBoolean("Remote Directory Sync", Boolean.FALSE);
            String ssoButtonText = pluginConfigObj.optString("SSO Button Text", "");
            Boolean autoRedirectToIDP = pluginConfigObj.optBoolean("Auto Redirect To IDP", Boolean.FALSE);
            Boolean backdoorEnabled = pluginConfigObj.optBoolean("Enable Backdoor", Boolean.FALSE);
            Boolean enableAutoRedirectDelay = pluginConfigObj.optBoolean("Enable Auto Redirect Delay", Boolean.FALSE);
            String logoutURL = pluginConfigObj.optString("Logout URL", "");
            Boolean useErrorTemplate = pluginConfigObj.optBoolean("Use Error Template", Boolean.FALSE);
            String errorTemplate = pluginConfigObj.optString("Error Template", "");
            Boolean useLoginTemplate = pluginConfigObj.optBoolean("Use Login Template", Boolean.FALSE);
            String loginTemplate = pluginConfigObj.optString("Login Template", "");
            Boolean useLogoutTemplate = pluginConfigObj.optBoolean("Use Logout Template", Boolean.FALSE);
            String logoutTemplate = pluginConfigObj.optString("Logout Template", "");
            String crowdIdpConfig = pluginConfigObj.optString("Crowd IDP Config", "");
            Boolean enableSingleLogoutURL = pluginConfigObj.optBoolean("Enanble Single Logout Url", Boolean.FALSE);
            Boolean showLoginPage = pluginConfigObj.optBoolean("Show Default Login Page", Boolean.FALSE);
            String backdoorKey = pluginConfigObj.optString("Backdoor Key", "saml_sso");
            String backdoorValue = pluginConfigObj.optString("Backdoor Value", "false");
            Boolean allowAnonymousAccess = pluginConfigObj.optBoolean("Allow Anonymous Access", Boolean.FALSE);
            Boolean showSSOButton = pluginConfigObj.optBoolean("Show SSO Button", Boolean.TRUE);
            MoPluginConfigurationHandler.saveRedirectionConfiguration(enableGlobalSSO, ssoButtonText, autoRedirectToIDP, backdoorEnabled, enableAutoRedirectDelay, logoutURL, useLogoutTemplate, logoutTemplate, enableSingleLogoutURL, allowAnonymousAccess, remoteDirectorySync);
            MoPluginConfigurationHandler.saveLookAndFeelConfiguration(useErrorTemplate, errorTemplate, useLoginTemplate, loginTemplate);
            Boolean useLoginTemplateJSD = pluginConfigObj.optBoolean("Use Login Template For JSD");
            String loginTemplateJSD = pluginConfigObj.optString("Login Template For JSD");
            LOGGER.debug((Object)("\n\n\n\nUse Login Template for JSD" + useLoginTemplateJSD));
            LOGGER.debug((Object)("\n\n\n\nLoginTemplateFOr JSD " + loginTemplateJSD));
            pluginConfigurationManager.setBackdoorKey(backdoorKey);
            pluginConfigurationManager.setBackdoorValue(backdoorValue);
            pluginConfigurationManager.setLoginTemplateJSD(loginTemplateJSD);
            pluginConfigurationManager.setUseLoginTemplateJSD(useLoginTemplateJSD);
            pluginConfigurationManager.setShowLoginPage(showLoginPage);
            pluginConfigurationManager.setShowSSOButton(showSSOButton);
            JSONObject appRedirectionRuleJSON = pluginConfigObj.optJSONObject("App Redirection Rules");
            JSONObject JSDRedirectionRuleJSON = pluginConfigObj.optJSONObject("JSD Redirection Rules");
            pluginConfigurationManager.setJSDRedirectionRulesMap(JSDRedirectionRuleJSON.toString());
            pluginConfigurationManager.setAppRedirectionRulesMap(appRedirectionRuleJSON.toString());
            String defaultAppIDP = pluginConfigObj.optString("Default App IDP");
            String defaultJSDIDP = pluginConfigObj.optString("Default JSD IDP");
            String defaultAppRedirectURL = pluginConfigObj.optString("Default App Redirect URL");
            String defaultJSDRedirectURL = pluginConfigObj.optString("Default JSD Redirect URL");
            String logoutUrlJSD = pluginConfigObj.optString("JSD Logout URL");
            Boolean useLogoutTemplateJSD = pluginConfigObj.optBoolean("Use Logout Template JSD");
            String logoutTemplateJSD = pluginConfigObj.optString("Logout Template JSD");
            Boolean allowLocalAuthentication = pluginConfigObj.optBoolean("Allow Local Authentication");
            Boolean enableDebugLogs = pluginConfigObj.optBoolean("Enable Debug Logs");
            HashMap<String, String> connectorsSSOConfig = MoPluginConfigurationHandler.convertToHashmap(pluginConfigObj.optString("Connectors SSO Config"));
            String ssoPath = pluginConfigObj.optString("SSO Path", "");
            pluginConfigurationManager.setDefaultAppIDP(defaultAppIDP);
            pluginConfigurationManager.setDefaultJSDIDP(defaultJSDIDP);
            pluginConfigurationManager.setAppDefaultRedirectURL(defaultAppRedirectURL);
            pluginConfigurationManager.setJsdDefaultRedirectURL(defaultJSDRedirectURL);
            pluginConfigurationManager.setLogoutUrlJSD(logoutUrlJSD);
            pluginConfigurationManager.setUseLogoutTemplateJSD(useLogoutTemplateJSD);
            pluginConfigurationManager.setLogoutTemplateJSD(logoutTemplateJSD);
            pluginConfigurationManager.setAllowLocalAuthentication(allowLocalAuthentication);
            pluginConfigurationManager.setConnectorSSOConfig(connectorsSSOConfig);
            pluginConfigurationManager.setEnableDebugLogs(enableDebugLogs);
            pluginConfigurationManager.setSSOPath(ssoPath);
        }
        catch (JSONException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    public static HashMap<String, String> convertToHashmap(String connectorsSSOConfigString) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(connectorsSSOConfigString.substring(1, connectorsSSOConfigString.length() - 1).replace(", ", "\n")));
        HashMap<String, String> connectorsSSOConfig = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            connectorsSSOConfig.put((String)e.getKey(), (String)e.getValue());
        }
        return connectorsSSOConfig;
    }

    public static void saveRedirectionRules(String platform, String ruleName, String decisionFactor, String conditionOperation, String conditionValue, String idp) {
        JSONObject rule = new JSONObject();
        rule.put("name", ruleName);
        rule.put("idp", idp);
        JSONObject condition = new JSONObject();
        JSONObject value = new JSONObject();
        value.put("conditionOperation", conditionOperation);
        value.put(conditionOperation, conditionValue);
        condition.put("decisionFactor", decisionFactor);
        condition.put(decisionFactor, value);
        rule.put("condition", condition);
        pluginConfigurationManager.setRedirectionRule(rule.toString(), ruleName);
        String ruleExpression = MoPluginConfigurationHandler.createExpression(decisionFactor, conditionOperation, conditionValue, idp);
        if (StringUtils.equalsIgnoreCase((CharSequence)platform, (CharSequence)"jsd")) {
            String jsdRedirectionRules = pluginConfigurationManager.getJSDRedirectionRuleJson();
            jsdRedirectionRules = MoJSONUtils.addKeyValue(jsdRedirectionRules, ruleName, ruleExpression);
            pluginConfigurationManager.setJSDRedirectionRulesMap(jsdRedirectionRules);
        } else {
            String appRedirectionRules = pluginConfigurationManager.getAppRedirectionRuleJson();
            appRedirectionRules = MoJSONUtils.addKeyValue(appRedirectionRules, ruleName, ruleExpression);
            pluginConfigurationManager.setAppRedirectionRulesMap(appRedirectionRules);
        }
    }

    private static String createExpression(String decisionFactor, String conditionOperation, String conditionValue, String idp) {
        StringBuilder expression = new StringBuilder("<label><b>If user's</b></label> ");
        expression.append("<em>" + decisionFactor + "</em>");
        expression.append(" <label><b>" + conditionOperation + "</b></label> ");
        if (StringUtils.equals((CharSequence)decisionFactor, (CharSequence)"directory")) {
            try {
                conditionValue = directoryManager.findDirectoryById(Long.valueOf(conditionValue)).getName();
            }
            catch (DirectoryNotFoundException e) {
                LOGGER.error((Object)"Error Occurred while creating Rue Expression ", (Throwable)e);
            }
        }
        expression.append("<em>" + conditionValue + "</em> ");
        expression.append("<label><b>then redirect to</b></label> ");
        if (StringUtils.equalsIgnoreCase((CharSequence)idp, (CharSequence)"loginpage")) {
            expression.append("<em>Login Page</em>");
        } else {
            expression.append("<em>" + pluginConfigurationManager.getCrowdConnectorSSOConfigMap().get(idp).getIdpName() + "</em>");
        }
        return expression.toString();
    }

    public void saveAppRedirectionRules(Map<String, String> appRedirectionRulesMap) {
        String appRedirectionRules = MoJSONUtils.convertMapToJSON(appRedirectionRulesMap);
        pluginConfigurationManager.setAppRedirectionRulesMap(appRedirectionRules);
    }

    public void saveJSDRedirectionRules(Map<String, String> jsdRedirectionRulesMap) {
        String jsdRedirectionRules = MoJSONUtils.convertMapToJSON(jsdRedirectionRulesMap);
        pluginConfigurationManager.setJSDRedirectionRulesMap(jsdRedirectionRules);
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        MoPluginConfigurationHandler.pluginConfigurationManager = pluginConfigurationManager;
    }

    public static MoGetCrowdSSOConfigurationService getCrowdSSOConfigurationService() {
        return crowdSSOConfigurationService;
    }

    public static void setCrowdSSOConfigurationService(MoGetCrowdSSOConfigurationService crowdSSOConfigurationService) {
        MoPluginConfigurationHandler.crowdSSOConfigurationService = crowdSSOConfigurationService;
    }

    public static I18nResolver getI18nResolver() {
        return i18nResolver;
    }

    public static void setI18nResolver(I18nResolver i18nResolver) {
        MoPluginConfigurationHandler.i18nResolver = i18nResolver;
    }

    static {
        DEFAULT_IDP_NAME = "Default IDP";
        DEFAULT_IDP_ID = "default_idp_id";
    }
}

