/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.handler;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.crowd.common.handler.MoEncryptionUtils;
import com.miniorange.license.MoLicenseDetails;
import com.miniorange.license.MoLicenseManager;
import com.miniorange.license.constants.MoPluginKey;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOfflineLicenseSettings {
    private static Log LOGGER = LogFactory.getLog(MoOfflineLicenseSettings.class);
    private PluginSettings pluginSettings;
    private PluginLicenseManager pluginLicenseManager;
    private MoLicenseManager licenseManager;
    private LicenseHandler licenseHandler;
    private I18nResolver i18nResolver;

    public MoOfflineLicenseSettings(PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory, LicenseHandler licenseHandler, MoLicenseManager licenseManager, I18nResolver i18nResolver) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseManager = licenseManager;
        this.licenseHandler = licenseHandler;
        this.i18nResolver = i18nResolver;
    }

    public boolean isDatacenter() {
        Collection allProductLicenses = this.licenseHandler.getAllProductLicenses();
        LOGGER.debug((Object)"\n\nis Datacenter :- ");
        Iterator iterator = allProductLicenses.iterator();
        if (iterator.hasNext()) {
            MultiProductLicenseDetails productLicenseDetails = (MultiProductLicenseDetails)iterator.next();
            LOGGER.debug((Object)("\nprod" + productLicenseDetails.toString() + "\n\n"));
            return productLicenseDetails.isDataCenter();
        }
        return true;
    }

    public MoLicenseDetails offlineLicenseDetails() {
        String licenseKey = this.getOfflineLicenseKey();
        MoPluginKey pluginKey = null;
        switch (this.i18nResolver.getText("my.plugin.platform")) {
            case "jira": {
                pluginKey = MoPluginKey.JIRA_CROWD;
                break;
            }
            case "confluence": {
                pluginKey = MoPluginKey.CONFLUENCE_CROWD;
            }
        }
        String serverId = this.licenseHandler.getServerId();
        LOGGER.debug((Object)("server id is: " + serverId));
        MoLicenseDetails moLicenseDetails = this.licenseManager.verifyAndFetchDetails(licenseKey, serverId, pluginKey);
        return moLicenseDetails;
    }

    public String getOfflineLicenseKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.OFFLINE_LICENSE_KEY")), (CharSequence)"");
    }

    public void setMOCustomerToken(String customerToken) {
        this.pluginSettings.put("miniorange.saml.CUSTOMER_TOKEN", (Object)customerToken);
    }

    public void setMOLicensedUserTier(Integer licensedUserTier) {
        String customerToken = this.getMOCustomerToken();
        String userTier = MoEncryptionUtils.encrypt(customerToken, String.valueOf(licensedUserTier));
        this.pluginSettings.put("miniorange.saml.USER_TIER", (Object)userTier);
    }

    public String getMOCustomerToken() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.saml.CUSTOMER_TOKEN")), (CharSequence)"NYFz3WIfBEn3DUHx");
    }

    public void setMOLicenseExpiryDate(String expiryDate) {
        String customerToken = this.getMOCustomerToken();
        String encryptedExpiryDate = MoEncryptionUtils.encrypt(customerToken, expiryDate);
        this.pluginSettings.put("miniorange.saml.OFFLINE_LICENSE_EXPIRY_DATE", (Object)encryptedExpiryDate);
    }

    public String getMOLicenseExpiryDate() {
        String customerToken = this.getMOCustomerToken();
        String expiryDate = (String)this.pluginSettings.get("miniorange.saml.OFFLINE_LICENSE_EXPIRY_DATE");
        if (StringUtils.isNotBlank((CharSequence)expiryDate)) {
            String decryptedValue = MoEncryptionUtils.decrypt(customerToken, expiryDate);
            return decryptedValue;
        }
        return "";
    }

    public void setIsValidLicenseFileConfigured(boolean isValidLicenseFileConfigured) {
        this.pluginSettings.put("miniorange.saml.VALID_OFFLINE_LICENSING", (Object)BooleanUtils.toString((Boolean)isValidLicenseFileConfigured, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsValidLicenseFileConfigured() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.saml.VALID_OFFLINE_LICENSING"))), (boolean)false);
    }

    public Integer getDaysLeftToExpire(String licenseExpireDateString) {
        Integer daysLeft = -1;
        try {
            if (StringUtils.isNotBlank((CharSequence)licenseExpireDateString)) {
                Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
                LOGGER.debug((Object)("licenseExpireDate = " + licenseExpireDate.toString()));
                Date currentDate = new Date();
                daysLeft = (int)((licenseExpireDate.getTime() - currentDate.getTime()) / 86400000L);
                if (daysLeft >= 0 && licenseExpireDate.getTime() > currentDate.getTime()) {
                    return daysLeft;
                }
                LOGGER.debug((Object)"License Expired.");
                return -1;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An exception occurs while calculating days left to expire", (Throwable)e);
        }
        return -1;
    }

    public Boolean isOfflineLicenseValid() {
        MoLicenseDetails moLicenseDetails = this.offlineLicenseDetails();
        if (moLicenseDetails == null) {
            this.setIsValidLicenseFileConfigured(false);
            LOGGER.error((Object)"Unable to fetch License Details Object");
            return false;
        }
        String licenseExpiryDate = moLicenseDetails.getExpiryDate();
        LOGGER.debug((Object)("license expiry date = " + licenseExpiryDate));
        if (this.getDaysLeftToExpire(licenseExpiryDate) < 0) {
            LOGGER.error((Object)"License has expired");
            return false;
        }
        return true;
    }

    public boolean isOfflineLicenseExpired() {
        MoLicenseDetails moLicenseDetails = this.offlineLicenseDetails();
        String licenseExpiryDate = moLicenseDetails.getExpiryDate();
        if (this.getDaysLeftToExpire(licenseExpiryDate) < 0) {
            LOGGER.error((Object)"License has expired");
            return true;
        }
        return false;
    }
}

