/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.filter;

import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MoLoginInterceptorFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginInterceptorFilter.class);
    private MoPluginConfigurationManager pluginConfigurationManager;
    private I18nResolver i18nResolver;
    private LoginUriProvider loginUriProvider;
    private CrowdService crowdService;

    public MoLoginInterceptorFilter(MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver, LoginUriProvider loginUriProvider, CrowdService crowdService) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
        this.loginUriProvider = loginUriProvider;
        this.crowdService = crowdService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug((Object)"inside init of LoginInterceptor");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.debug((Object)"inside doFilter of LoginInterceptor");
        if (this.pluginConfigurationManager.isLicenseDefined() && (!this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() || this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() && this.pluginConfigurationManager.isLicenseValid().booleanValue()) && !this.pluginConfigurationManager.isLicenseExpired().booleanValue()) {
            String username = "";
            HttpServletRequest req = (HttpServletRequest)request;
            String application = this.i18nResolver.getText("my.plugin.platform");
            LOGGER.debug((Object)("URL=" + req.getRequestURL().toString()));
            if (req.getRequestURL().toString().contains("/servicedesk/customer/")) {
                application = "jsd";
            }
            LOGGER.debug((Object)("Application : " + application));
            username = StringUtils.equalsIgnoreCase((String)application, (String)"bitbucket") ? request.getParameter("j_username") : (StringUtils.equalsIgnoreCase((String)application, (String)"fisheye") ? request.getParameter("username") : request.getParameter("os_username"));
            String confluenceCaptcha = request.getParameter("captchaResponse");
            String jiraCaptcha = StringUtils.trimToNull((String)request.getParameter("os_captcha"));
            LOGGER.debug((Object)"-------------MoLoginInterceptorFilter ---------------------------");
            LOGGER.debug((Object)("username  : " + username));
            HttpServletResponse res = (HttpServletResponse)response;
            String referer = req.getHeader("referer");
            if ((referer != null && referer.contains("saml_sso=false") || confluenceCaptcha != null || jiraCaptcha != null) && this.pluginConfigurationManager.getBackdoorEnabled().booleanValue()) {
                LOGGER.debug((Object)"Backdoor is enabled.Allow user to login");
            } else if (StringUtils.isNotEmpty((String)username) && !this.canUseLocalCredentials(username, application).booleanValue()) {
                LOGGER.debug((Object)"user is not authorized to access, redirecting user to the error page");
                if (application.equals("jira")) {
                    LoginManager loginManager = (LoginManager)ComponentAccessor.getComponentOfType(LoginManager.class);
                    loginManager.onLoginAttempt(req, username, false);
                } else if (application.equals("confluence")) {
                    com.atlassian.confluence.security.login.LoginManager loginManager = (com.atlassian.confluence.security.login.LoginManager)ContainerManager.getComponent((String)"loginManager");
                    loginManager.onFailedLoginAttempt(username, req);
                } else if (application.equals("bamboo")) {
                    LoginInformationManager loginInformationManager = (LoginInformationManager)ContainerManager.getComponent((String)"loginInformationManager");
                    loginInformationManager.incrementFailedCountAndCheckThreshold(username);
                }
                res.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(req)).toString());
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private Boolean canUseLocalCredentials(String username, String application) {
        try {
            LOGGER.debug((Object)"Check if user is authorized to login using local credentials");
            JSONObject redirectionRule = this.pluginConfigurationManager.getIDPFromRedirectionRules(application, username);
            String idpName = redirectionRule.get("idpId").toString();
            String defaultRule = "";
            Boolean allowLocalAuthentication = this.pluginConfigurationManager.getAllowLocalAuthentication();
            if (redirectionRule.has("defaultRule")) {
                defaultRule = redirectionRule.get("defaultRule").toString();
            }
            LOGGER.debug((Object)("Found IDP " + idpName));
            LOGGER.debug((Object)("defaultRule " + defaultRule));
            if (StringUtils.isEmpty((String)idpName) && StringUtils.equalsIgnoreCase((String)defaultRule, (String)"loginPage") || StringUtils.equalsIgnoreCase((String)defaultRule, (String)"loginPage") || StringUtils.equalsIgnoreCase((String)idpName, (String)"loginPage")) {
                return Boolean.TRUE;
            }
            if (!allowLocalAuthentication.booleanValue()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while getting the user's IDP");
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private URI getUri(HttpServletRequest request) {
        return URI.create("notAuthorized");
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }
}

