/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoCrowdRedirectionAction
extends BambooActionSupport {
    private static Log LOGGER = LogFactory.getLog(MoCrowdRedirectionAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Boolean showSSOButton;
    private String ssoButtonText;
    private Boolean backdoorEnabled;
    private Boolean enableAutoRedirectDelay;
    private String logoutUrl;
    private Boolean useLogoutTemplate;
    private String logoutTemplate;
    private Boolean submitted;
    private Boolean error = Boolean.FALSE;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private Boolean autoRedirectToIDP;
    private I18nResolver i18nResolver;
    private String platform;
    private String xsrfToken;
    private Boolean enableSingleLogoutURL;
    private Boolean enableGlobalSSO;
    private Boolean allowAnonymousAccess;

    public MoCrowdRedirectionAction(MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
    }

    public void doValidation() {
        this.error = Boolean.FALSE;
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.ssoButtonText)) {
            this.addActionError(this.i18nResolver.getText("crowdsso.error.config.ssoButtonText.empty"));
            this.error = Boolean.TRUE;
        }
        if (!StringUtils.isBlank((CharSequence)this.logoutUrl)) {
            try {
                new URL(this.logoutUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Invalid Custom logout URL");
                this.addActionError(this.i18nResolver.getText("crowdsso.error.config.logoutUrL.malformed"));
                this.error = Boolean.TRUE;
            }
        }
    }

    public String execute() throws Exception {
        LOGGER.debug((Object)"CrowdRedirectionConfigurationAction execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.pluginConfigurationManager.isLicenseValid().booleanValue()) {
                    LOGGER.error((Object)"Invalid license");
                    return "upm";
                }
                this.doValidation();
                if (BooleanUtils.toBoolean((Boolean)this.submitted) && !BooleanUtils.toBoolean((Boolean)this.error)) {
                    LOGGER.debug((Object)"CrowdRedirectionConfigurationAction: configuration submited");
                    LOGGER.debug((Object)("enableGlobalSSO : " + this.enableGlobalSSO + "ShowSSOButton : " + this.showSSOButton + " SSO Button Text : " + this.ssoButtonText + " Auto RedirectToIDP : " + this.autoRedirectToIDP + " Backdoor Enabled : " + this.backdoorEnabled + " Enable AutoRedirect Delay : " + this.enableAutoRedirectDelay + " Logout url : " + this.logoutUrl + "Use servlet template : " + this.useLogoutTemplate + "Logout template : " + this.logoutTemplate + ",\n enableSingleLogoutURL " + this.enableSingleLogoutURL));
                    MoPluginConfigurationHandler.saveRedirectionConfiguration(this.enableGlobalSSO, this.ssoButtonText, this.autoRedirectToIDP, this.backdoorEnabled, this.enableAutoRedirectDelay, this.logoutUrl, this.useLogoutTemplate, this.logoutTemplate, this.enableSingleLogoutURL, this.allowAnonymousAccess, null);
                    this.pluginConfigurationManager.setShowSSOButton(this.showSSOButton);
                    this.initializeSAMLConfig();
                    this.addActionMessage(this.i18nResolver.getText("crowdsso.success.redirection"));
                    return "success";
                }
                LOGGER.debug((Object)"Reached initialize config");
                this.initializeSAMLConfig();
                return "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError(this.i18nResolver.getText("crowdsso.error.saving.redirection.settings"));
                return "error";
            }
        }
        LOGGER.error((Object)"User does not have permission to access Crowd Configuration page");
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        LOGGER.debug((Object)"inside initialise config");
        this.platform = this.i18nResolver.getText("my.plugin.platform");
        this.autoRedirectToIDP = this.pluginConfigurationManager.getAutoRedirectToIDP();
        LOGGER.debug((Object)this.pluginConfigurationManager.getAutoRedirectToIDP());
        this.showSSOButton = this.pluginConfigurationManager.getShowSSOButton();
        LOGGER.debug((Object)this.pluginConfigurationManager.getShowSSOButton());
        this.ssoButtonText = this.pluginConfigurationManager.getSsoButtonText();
        LOGGER.debug((Object)this.pluginConfigurationManager.getSsoButtonText());
        this.backdoorEnabled = this.pluginConfigurationManager.getBackdoorEnabled();
        this.enableAutoRedirectDelay = this.pluginConfigurationManager.getEnableAutoRedirectDelay();
        this.logoutUrl = this.pluginConfigurationManager.getLogoutUrl();
        this.useLogoutTemplate = this.pluginConfigurationManager.getUseLogoutTemplate();
        LOGGER.debug((Object)("Use Logout template :- " + this.pluginConfigurationManager.getUseLogoutTemplate()));
        this.logoutTemplate = this.pluginConfigurationManager.getLogoutTemplate();
        LOGGER.debug((Object)("Logout Template :- " + this.pluginConfigurationManager.getLogoutTemplate()));
        this.enableSingleLogoutURL = this.pluginConfigurationManager.getEnableSingleLogoutURL();
        this.enableGlobalSSO = this.pluginConfigurationManager.getEnableGlobalSSO();
        this.allowAnonymousAccess = this.pluginConfigurationManager.getAllowAnonymousAccess();
        LOGGER.debug((Object)"end of initialize config");
    }

    public String getSsoButtonText() {
        return this.ssoButtonText;
    }

    public void setSsoButtonText(String ssoButtonText) {
        this.ssoButtonText = ssoButtonText;
    }

    public Boolean getBackdoorEnabled() {
        return this.backdoorEnabled;
    }

    public void setBackdoorEnabled(Boolean backdoorEnabled) {
        this.backdoorEnabled = backdoorEnabled;
    }

    public Boolean getEnableAutoRedirectDelay() {
        return this.enableAutoRedirectDelay;
    }

    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.enableAutoRedirectDelay = enableAutoRedirectDelay;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getAutoRedirectToIDP() {
        return this.autoRedirectToIDP;
    }

    public void setAutoRedirectToIDP(Boolean autoRedirectToIDP) {
        this.autoRedirectToIDP = autoRedirectToIDP;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public Boolean getUseLogoutTemplate() {
        return this.useLogoutTemplate;
    }

    public void setUseLogoutTemplate(Boolean useLogoutTemplate) {
        this.useLogoutTemplate = useLogoutTemplate;
    }

    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    public Boolean getError() {
        return this.error;
    }

    public void setError(Boolean error) {
        this.error = error;
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public Boolean getEnableSingleLogoutURL() {
        return this.enableSingleLogoutURL;
    }

    public void setEnableSingleLogoutURL(Boolean enableSingleLogoutURL) {
        this.enableSingleLogoutURL = enableSingleLogoutURL;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public Boolean getShowSSOButton() {
        return this.showSSOButton;
    }

    public void setShowSSOButton(Boolean showSSOButton) {
        this.showSSOButton = showSSOButton;
    }

    public Boolean getEnableGlobalSSO() {
        return this.enableGlobalSSO;
    }

    public void setEnableGlobalSSO(Boolean enableGlobalSSO) {
        this.enableGlobalSSO = enableGlobalSSO;
    }

    public Boolean getAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(Boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }
}

