/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCrowdBackupAndRestoreAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoCrowdBackupAndRestoreAction.class);
    private I18nResolver i18nResolver;
    private String platform;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Boolean importFileSubmitted;
    private String xsrfToken;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private MoPluginConfigurationHandler pluginConfigurationHandler;

    public MoCrowdBackupAndRestoreAction(UserManager userManager, LoginUriProvider loginUriProvider, I18nResolver i18nResolver, MoPluginConfigurationManager pluginConfigurationManager, MoPluginConfigurationHandler pluginConfigurationHandler) {
        this.i18nResolver = i18nResolver;
        this.platform = i18nResolver.getText("my.plugin.platform");
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigurationHandler = pluginConfigurationHandler;
    }

    public String execute() throws Exception {
        LOGGER.debug("MoImportExportAction execute() called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                String message = "";
                LOGGER.debug("MoImportExportAction execute submitted: " + this.importFileSubmitted);
                if (!this.pluginConfigurationManager.isLicenseValid().booleanValue()) {
                    LOGGER.error("Invalide License");
                    return "upm";
                }
                if (MoPluginConfigurationManager.fileUploaded.booleanValue()) {
                    MoPluginConfigurationManager.fileUploaded = false;
                    if (MoPluginConfigurationManager.configurationUpdated.booleanValue()) {
                        this.addActionMessage(this.i18nResolver.getText("crowdsso.success.backupAndRestore"));
                    } else {
                        this.addActionError(this.i18nResolver.getText("crowdsso.error.backupAndRestore"));
                    }
                }
                return "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    public URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getImportFileSubmitted() {
        return this.importFileSubmitted;
    }

    public void setImportFileSubmitted(Boolean importFileSubmitted) {
        this.importFileSubmitted = importFileSubmitted;
    }
}

