/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class IdentifierSet
extends ForwardingSet<String> {
    private final Set<String> delegate;

    public IdentifierSet() {
        this.delegate = Sets.newHashSet();
    }

    public IdentifierSet(int expectedSize) {
        this.delegate = Sets.newHashSetWithExpectedSize(expectedSize);
    }

    @Override
    protected Set<String> delegate() {
        return this.delegate;
    }

    private Object lowercase(Object element) {
        return element instanceof String ? IdentifierUtils.toLowerCase((String)element) : element;
    }

    private Collection<?> lowercase(Collection<?> collection) {
        return Collections2.transform(collection, new Function<Object, Object>(){

            @Override
            public Object apply(Object element) {
                return IdentifierSet.this.lowercase(element);
            }
        });
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate().removeAll(this.lowercase(collection));
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate().contains(this.lowercase(object));
    }

    @Override
    public boolean add(String element) {
        return this.delegate().add((String)this.lowercase(element));
    }

    @Override
    public boolean remove(Object object) {
        return this.delegate().remove(this.lowercase(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate().containsAll(this.lowercase(collection));
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        return this.delegate().addAll(this.lowercase(strings));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.delegate().retainAll(this.lowercase(collection));
    }
}

