/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.scheduler;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MoPluginMigrationEvent
implements InitializingBean,
DisposableBean {
    private static Log LOGGER = LogFactory.getLog(MoPluginMigrationEvent.class);
    private PluginScheduler pluginScheduler;
    private MoPluginConfigurationManager moPluginConfigurationManager;
    private MoPluginConfigurationHandler moPluginConfigurationHandler;
    private I18nResolver i18nResolver;
    private String platform;

    public MoPluginMigrationEvent(PluginScheduler pluginScheduler, MoPluginConfigurationManager moPluginConfigurationManager, I18nResolver i18nResolver, MoPluginConfigurationHandler moPluginConfigurationHandler) {
        this.pluginScheduler = pluginScheduler;
        this.moPluginConfigurationManager = moPluginConfigurationManager;
        this.i18nResolver = i18nResolver;
        this.moPluginConfigurationHandler = moPluginConfigurationHandler;
    }

    public void afterPropertiesSet() {
        LOGGER.debug((Object)"MoPluginMigrationEvent afterPropertiesSet Called");
        try {
            this.platform = this.i18nResolver.getText("my.plugin.platform");
        }
        catch (Exception e) {
            this.platform = "fisheye";
        }
        this.migrateSettings();
    }

    private void migrateSettings() {
        LOGGER.debug((Object)"migratingSettings");
        if (!this.moPluginConfigurationManager.getIsMigrated()) {
            if (this.moPluginConfigurationManager.getRedirectionParameter().equals("Domains")) {
                this.migrateDomainMappingSettings();
            } else {
                this.migrateGroupMappingSettings();
            }
        }
        this.moPluginConfigurationManager.setIsMigrated(true);
    }

    public void destroy() throws Exception {
        LOGGER.debug((Object)"MoPluginMigrationEvent destroy Called");
    }

    private void migrateDomainMappingSettings() {
        LOGGER.info((Object)"Migrating Domain Mapping Settings");
        String ruleName = "domainMapping";
        String decisionFactor = "domain";
        String conditionOperation = "equals";
        HashMap<String, MoCrowdConnectorSSOConfig> config = MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(this.moPluginConfigurationManager.getConnectorSSOConfig());
        int i = 0;
        try {
            for (String idpID : config.keySet()) {
                for (String conditionValue : config.get(idpID).getIdpRedirectDomains()) {
                    MoPluginConfigurationHandler.saveRedirectionRules(this.platform, ruleName + "_" + this.platform + "_" + i, decisionFactor, conditionOperation, conditionValue, idpID);
                    if (this.platform.equals("jira")) {
                        MoPluginConfigurationHandler.saveRedirectionRules("jsd", ruleName + "_jsd_" + i, decisionFactor, conditionOperation, conditionValue, idpID);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while migrating domain mapping", (Throwable)e);
        }
    }

    private void migrateGroupMappingSettings() {
        LOGGER.info((Object)"Migrating Group Mapping Settings");
        String ruleName = "groupMapping";
        String decisionFactor = "group";
        String conditionOperation = "equals";
        HashMap<String, MoCrowdConnectorSSOConfig> config = MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(this.moPluginConfigurationManager.getConnectorSSOConfig());
        int i = 0;
        try {
            for (String idpID : config.keySet()) {
                for (String conditionValue : config.get(idpID).getIdpRedirectGroups()) {
                    MoPluginConfigurationHandler.saveRedirectionRules(this.platform, ruleName + "_" + this.platform + "_" + i, decisionFactor, conditionOperation, conditionValue, idpID);
                    if (this.platform.equals("jira")) {
                        MoPluginConfigurationHandler.saveRedirectionRules("jsd", ruleName + "_jsd_" + i, decisionFactor, conditionOperation, conditionValue, idpID);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while migrating domain mapping", (Throwable)e);
        }
    }
}

