/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.rest;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoHttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig
public class MoAjaxCallServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAjaxCallServlet.class);
    private MoPluginConfigurationHandler moPluginConfigurationHandler;
    private MoPluginConfigurationManager moPluginConfigurationManager;
    private CrowdService crowdService;
    private I18nResolver i18nResolver;

    public MoAjaxCallServlet(MoPluginConfigurationManager moPluginConfigurationManager, CrowdService crowdService, MoPluginConfigurationHandler moPluginConfigurationHandler, I18nResolver i18nResolver) {
        this.moPluginConfigurationManager = moPluginConfigurationManager;
        this.moPluginConfigurationHandler = moPluginConfigurationHandler;
        this.crowdService = crowdService;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax Servlet doGet Called");
        String action = req.getParameter("action");
        LOGGER.debug("Action parameter : " + action);
        switch (action) {
            case "fetchGroups": {
                this.fetchGroups(req, resp);
                break;
            }
            case "getRule": {
                this.getRule(req, resp);
                break;
            }
            case "downloadLogs": {
                this.downloadLogs(req, resp);
                break;
            }
            case "getLicenseValidity": {
                this.getLicenseValidity(req, resp);
                break;
            }
            default: {
                resp.setContentType("text/html");
                LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws SecurityException, IOException {
        String action = req.getParameter("action");
        if (StringUtils.isBlank((String)action)) {
            resp.setContentType("application/json");
            LOGGER.error(" 400.The requested parameter [action] not found or is empty");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        switch (action) {
            case "saveDefaultRule": {
                this.saveDefaultRule(req, resp);
                break;
            }
            case "saveDefaultRedirectURL": {
                this.saveDefaultRedirectURL(req, resp);
                break;
            }
            case "saveOrder": {
                this.saveRulesOrder(req, resp);
                break;
            }
            case "allowLocalAuthentication": {
                this.allowLocalAuthentication(req, resp);
                break;
            }
            case "showLoginPage": {
                this.showLoginPage(req, resp);
                break;
            }
            case "saveBackdoor": {
                this.saveBackdoor(req, resp);
            }
            case "enableDebugLogs": {
                this.enableDebugLogs(req, resp);
                break;
            }
            case "disableLicenseWarning": {
                this.disableLicenseWarning(req, resp);
            }
            default: {
                resp.setContentType("application/json");
                LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String action = StringUtils.trimToEmpty((String)req.getParameter("action"));
        if (StringUtils.isBlank((String)action)) {
            resp.setContentType("application/json");
            LOGGER.error(" 400.The requested parameter [action] not found or is empty");
            resp.sendError(400, "The requested parameter [action] not found or is empty");
            return;
        }
        if (action.equals("deleteRule")) {
            this.deleteRedirectionRule(req, resp);
        } else {
            resp.setContentType("application/json");
            LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
            resp.sendError(405, "The requested action is not allowed. Choose valid Action");
        }
    }

    private void allowLocalAuthentication(HttpServletRequest req, HttpServletResponse resp) {
        Boolean allowLocalAuthentication = BooleanUtils.toBoolean((String)req.getParameter("allowLocalAuthentication"));
        if (allowLocalAuthentication.booleanValue()) {
            this.moPluginConfigurationManager.setAllowLocalAuthentication(true);
        } else {
            this.moPluginConfigurationManager.setAllowLocalAuthentication(false);
        }
    }

    private void showLoginPage(HttpServletRequest req, HttpServletResponse resp) {
        Boolean showLoginPage = BooleanUtils.toBoolean((String)req.getParameter("showLoginPage"));
        if (showLoginPage.booleanValue()) {
            this.moPluginConfigurationManager.setShowLoginPage(true);
        } else {
            this.moPluginConfigurationManager.setShowLoginPage(false);
        }
    }

    private void deleteRedirectionRule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String ruleId = req.getParameter("key");
        String application = req.getParameter("application");
        if (StringUtils.isBlank((String)ruleId)) {
            this.sendErrorResponse(JSONObject.quote("Rule name cannot be empty"), 400, resp);
            return;
        }
        if (StringUtils.isBlank((String)application)) {
            this.sendErrorResponse(JSONObject.quote("Application name cannot be empty"), 400, resp);
            return;
        }
        this.moPluginConfigurationManager.deleteRedirectionRule(ruleId, application);
        this.sendSuccessFullResponse(JSONObject.quote("Rule " + ruleId + " deleted successfully"), resp);
    }

    private void saveRulesOrder(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] ruleNames;
        String platform = req.getParameter("platform");
        if (StringUtils.isBlank((String)platform)) {
            this.sendErrorResponse("Platform cannot be empty", 400, resp);
            return;
        }
        Map<String, String> redirectionRulesMap = StringUtils.equals((String)platform, (String)"jsd") ? this.moPluginConfigurationManager.getJSDRedirectionRulesMap() : this.moPluginConfigurationManager.getAppRedirectionRulesMap();
        LinkedHashMap<String, String> newRedirectionRulesMap = new LinkedHashMap<String, String>();
        for (String ruleName : ruleNames = req.getParameterValues("ruleKey")) {
            newRedirectionRulesMap.put(ruleName, redirectionRulesMap.get(ruleName));
        }
        if (StringUtils.equals((String)platform, (String)"jsd")) {
            this.moPluginConfigurationHandler.saveJSDRedirectionRules(newRedirectionRulesMap);
        } else {
            this.moPluginConfigurationHandler.saveAppRedirectionRules(newRedirectionRulesMap);
        }
        this.sendSuccessFullResponse(null, resp);
    }

    private void saveDefaultRedirectURL(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String platform = req.getParameter("platform");
        if (StringUtils.isBlank((String)platform)) {
            this.sendErrorResponse("Platform cannot be empty", 400, resp);
            return;
        }
        String defaultRedirectURL = org.apache.commons.lang3.StringUtils.trim((String)req.getParameter("defaultRedirectURL"));
        if (StringUtils.isBlank((String)defaultRedirectURL)) {
            this.sendErrorResponse("Redirect URL cannot be empty", 400, resp);
            return;
        }
        try {
            new URL(defaultRedirectURL);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid redirect URL", (Throwable)e);
            this.sendErrorResponse("Invalid Redirect URL", 400, resp);
            return;
        }
        LOGGER.debug("setting default redirect URL to : " + defaultRedirectURL);
        if (StringUtils.containsIgnoreCase((String)platform, (String)"jsd")) {
            LOGGER.info("redirect URL for Jsd submitted");
            this.moPluginConfigurationManager.setJsdDefaultRedirectURL(defaultRedirectURL);
            this.moPluginConfigurationManager.setDefaultJSDIDP("redirectUrl");
        } else {
            LOGGER.info("redirect URL for Jira submitted");
            this.moPluginConfigurationManager.setAppDefaultRedirectURL(defaultRedirectURL);
            this.moPluginConfigurationManager.setDefaultAppIDP("redirectUrl");
        }
        this.moPluginConfigurationManager.setAutoRedirectToIDP(false);
        this.sendSuccessFullResponse(JSONObject.quote("Default rule saved"), resp);
    }

    private void saveDefaultRule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String idpId = req.getParameter("defaultIDP");
        String platformID = req.getParameter("platform");
        if (StringUtils.equalsIgnoreCase((String)platformID, (String)"defaultAppIDP")) {
            this.moPluginConfigurationManager.setDefaultAppIDP(idpId);
        } else {
            this.moPluginConfigurationManager.setDefaultJSDIDP(idpId);
        }
        if (!this.moPluginConfigurationManager.getDefaultAppIDP().equals("loginPage") && !this.moPluginConfigurationManager.getDefaultAppIDP().equals("redirectUrl") || !this.moPluginConfigurationManager.getDefaultJsdIDP().equals("loginPage") && !this.moPluginConfigurationManager.getDefaultJsdIDP().equals("redirectUrl") && this.moPluginConfigurationManager.getPlatform().equals("jira")) {
            this.moPluginConfigurationManager.setAutoRedirectToIDP(false);
        }
        this.sendSuccessFullResponse(JSONObject.quote("Default rule saved"), resp);
    }

    private void getRule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("key");
        JSONObject rule = this.moPluginConfigurationManager.getRedirectionRule(id);
        if (rule == null) {
            this.sendErrorResponse("Rule not found", 500, resp);
            return;
        }
        this.sendSuccessFullResponse(rule.toString(), resp);
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug("Ajax Servlet fetchGroup Called");
        try {
            String search = StringUtils.trim((String)req.getParameter("search"));
            if (StringUtils.equalsIgnoreCase((String)search, (String)"*")) {
                search = "";
            }
            EntityQuery<Group> query = QueryBuilder.queryFor(Group.class, EntityDescriptor.group()).with(Restriction.on(GroupTermKeys.NAME).startingWith(search)).returningAtMost(10);
            LOGGER.debug("query =  " + query);
            Iterable<Group> groups = this.crowdService.search(query);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (Group groupName : groups) {
                HashMap<String, Object> groupResultsMap = new HashMap<String, Object>();
                groupResultsMap.put("id", groupName.getName());
                groupResultsMap.put("text", groupName.getName());
                resultArray.put(groupResultsMap);
            }
            LOGGER.debug("resultArray :" + resultArray.toString());
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred while fetching groups :" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveBackdoor(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Ajax Servlet fetchGroup Called");
        String backdoorKey = MoHttpUtils.sanitizeText(request.getParameter("backdoorKey"));
        String backdoorValue = MoHttpUtils.sanitizeText(request.getParameter("backdoorValue"));
        this.moPluginConfigurationManager.setBackdoorKey(backdoorKey);
        this.moPluginConfigurationManager.setBackdoorValue(backdoorValue);
    }

    private void enableDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Boolean enableDebugLogs = BooleanUtils.toBoolean((String)req.getParameter("enableDebugLogs"));
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"com.miniorange.crowd");
        String message = "";
        if (enableDebugLogs.booleanValue()) {
            logger.setLevel(Level.DEBUG);
            message = "Debug Logs enabled successfully";
        } else {
            logger.setLevel(Level.INFO);
            message = "Debug Logs disabled successfully";
        }
        this.moPluginConfigurationManager.setEnableDebugLogs(enableDebugLogs);
        this.sendSuccessFullResponse(JSONObject.quote(message), resp);
    }

    private void downloadLogs(HttpServletRequest req, HttpServletResponse resp) {
        String application = this.i18nResolver.getText("my.plugin.platform");
        if (StringUtils.equalsIgnoreCase((String)application, (String)"confluence")) {
            BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
            try {
                File dataFolder = bootstrapManager.getLocalHome();
                File logsFolder = null;
                File confluenceLogFile = null;
                for (File f : dataFolder.listFiles()) {
                    if (!f.isDirectory() || !org.apache.commons.lang3.StringUtils.equals((CharSequence)f.getName(), (CharSequence)"logs")) continue;
                    logsFolder = f;
                    break;
                }
                for (File f : logsFolder.listFiles()) {
                    if (!f.isFile() || !org.apache.commons.lang3.StringUtils.equals((CharSequence)f.getName(), (CharSequence)"atlassian-confluence.log")) continue;
                    confluenceLogFile = f;
                    break;
                }
                resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-confluence.log\"");
                resp.setHeader("Cache-Control", "max-age=0");
                resp.setHeader("Pragma", "");
                resp.setContentType("text/plain");
                FileUtils.copyFile((File)confluenceLogFile, (OutputStream)resp.getOutputStream());
            }
            catch (Exception dataFolder) {}
        } else if (StringUtils.equalsIgnoreCase((String)application, (String)"jira")) {
            JiraHome jiraHome = (JiraHome)ComponentAccessor.getComponent(JiraHome.class);
            try {
                File folder = jiraHome.getLogDirectory();
                File jiraLogFile = null;
                for (File f : folder.listFiles()) {
                    if (!f.isFile() || !org.apache.commons.lang3.StringUtils.equals((CharSequence)f.getName(), (CharSequence)"atlassian-jira.log")) continue;
                    jiraLogFile = f;
                    break;
                }
                resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-jira.log\"");
                resp.setHeader("Cache-Control", "max-age=0");
                resp.setHeader("Pragma", "");
                resp.setContentType("text/plain");
                FileUtils.copyFile((File)jiraLogFile, (OutputStream)resp.getOutputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void getLicenseValidity(HttpServletRequest req, HttpServletResponse resp) {
        try {
            PluginLicense pluginLicense = (PluginLicense)this.moPluginConfigurationManager.getPluginLicenseManager().getLicense().get();
            String Platform2 = this.i18nResolver.getText("my.plugin.platform");
            LOGGER.debug("the platform is" + Platform2);
            if (pluginLicense.isEvaluation()) {
                LOGGER.debug("the license is evaluation");
            }
            if (pluginLicense == null) {
                LOGGER.debug("the license is null");
            }
            if (pluginLicense != null && !pluginLicense.isEvaluation()) {
                String expiryDateString = pluginLicense.getExpiryDate().toString();
                LOGGER.debug("the expiry date is" + expiryDateString);
                if (expiryDateString.startsWith("some(") && expiryDateString.endsWith(")")) {
                    expiryDateString = expiryDateString.substring(5);
                    expiryDateString = expiryDateString.substring(0, expiryDateString.length() - 1);
                    DateTime currentDate = new DateTime();
                    LOGGER.debug("Current Date is " + currentDate);
                    DateTime expiryDate = new DateTime((Object)expiryDateString);
                    if (!currentDate.isBefore((ReadableInstant)expiryDate) && !this.moPluginConfigurationManager.getDisableLicenseExpiredWarning().booleanValue()) {
                        LOGGER.debug("License Expired");
                        JSONObject licenseValidity = new JSONObject();
                        licenseValidity.put("validity", "expired");
                        licenseValidity.put("platform", Platform2);
                        this.sendSuccessFullResponse(licenseValidity.toString(), resp);
                    } else if (currentDate.plusMonths(1).isAfter((ReadableInstant)expiryDate) && currentDate.isBefore((ReadableInstant)expiryDate) && !this.moPluginConfigurationManager.getDisableLicenseExpiringWarning().booleanValue()) {
                        LOGGER.debug("License Validity less than a month");
                        JSONObject licenseValidity = new JSONObject();
                        licenseValidity.put("validity", "expiring");
                        licenseValidity.put("platform", Platform2);
                        this.sendSuccessFullResponse(licenseValidity.toString(), resp);
                    }
                    if (currentDate.plusMonths(1).isBefore((ReadableInstant)expiryDate) && (this.moPluginConfigurationManager.getDisableLicenseExpiringWarning().booleanValue() || this.moPluginConfigurationManager.getDisableLicenseExpiredWarning().booleanValue())) {
                        this.moPluginConfigurationManager.setDisableLicenseExpiredWarning(Boolean.FALSE);
                        this.moPluginConfigurationManager.setDisableLicenseExpiringWarning(Boolean.FALSE);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("the error is" + e);
        }
    }

    protected void disableLicenseWarning(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Disabling License Warning");
        String licenseStatus = req.getParameter("licenseStatus");
        if (StringUtils.equalsIgnoreCase((String)licenseStatus, (String)"expiring")) {
            LOGGER.debug("disabling expiring license popup");
            this.moPluginConfigurationManager.setDisableLicenseExpiringWarning(Boolean.TRUE);
        } else if (StringUtils.equalsIgnoreCase((String)licenseStatus, (String)"expired")) {
            LOGGER.debug("disabling expired license popup");
            this.moPluginConfigurationManager.setDisableLicenseExpiredWarning(Boolean.TRUE);
        }
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), resp);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    public MoPluginConfigurationManager getMoPluginConfigurationManager() {
        return this.moPluginConfigurationManager;
    }

    public void setMoPluginConfigurationManager(MoPluginConfigurationManager moPluginConfigurationManager) {
        this.moPluginConfigurationManager = moPluginConfigurationManager;
    }
}

