/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoCrowdConfigurationAction
extends BambooActionSupport {
    private static Log LOGGER = LogFactory.getLog(MoCrowdConfigurationAction.class);
    private String xsrfToken;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Boolean submitted;
    private Boolean error = Boolean.FALSE;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private I18nResolver i18nResolver;
    private HashMap<String, String> connectorssSSOConfig;
    private HashMap<String, MoCrowdConnectorSSOConfig> connectorssSSOConfigMap;
    private String crowdDomainURL;
    private ArrayList<Boolean> ssoForbamboo;
    private String platform;

    public MoCrowdConfigurationAction(I18nResolver i18nResolver, MoPluginConfigurationManager pluginConfigurationManager, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
    }

    public void doValidation() {
        this.error = Boolean.FALSE;
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.crowdDomainURL)) {
            LOGGER.error((Object)"Crowd Domain URL is empty");
            this.addActionError(this.i18nResolver.getText("crowdsso.error.config.crowdDomainURL.empty"));
            this.error = Boolean.TRUE;
        } else {
            try {
                new URL(this.crowdDomainURL);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"Invalid Crowd Base URL");
                this.addActionError(this.i18nResolver.getText("crowdsso.error.config.crowdDomainURL.malformed"));
                this.error = Boolean.TRUE;
            }
        }
    }

    public String execute() throws Exception {
        String platform = this.i18nResolver.getText("my.plugin.platform");
        LOGGER.debug((Object)"CrowdConfigurationAction execute called");
        UserProfile user = this.userManager.getRemoteUser();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.pluginConfigurationManager.isLicenseValid().booleanValue()) {
                    LOGGER.error((Object)"Invalid license");
                    return "upm";
                }
                this.doValidation();
                if (!BooleanUtils.toBoolean((Boolean)this.error) && BooleanUtils.toBoolean((Boolean)this.submitted)) {
                    LOGGER.debug((Object)"CrowdConfigurationAction: configuration submited");
                    this.ssoForbamboo = new ArrayList();
                    for (int index = 0; index < this.pluginConfigurationManager.getConnectorSSOConfig().keySet().size(); ++index) {
                        String enableSSOforbamboo = request.getParameter("ssoForbamboo_" + index);
                        if (enableSSOforbamboo == null) {
                            this.ssoForbamboo.add(Boolean.FALSE);
                            continue;
                        }
                        this.ssoForbamboo.add(BooleanUtils.toBoolean((String)enableSSOforbamboo));
                    }
                    MoPluginConfigurationHandler.saveCrowdConnectorSSOConfiguration(this.crowdDomainURL, "", null, null, new ArrayList<Boolean>(), new ArrayList<Boolean>(), new ArrayList<Boolean>(), new ArrayList<Boolean>(), new ArrayList<Boolean>(), this.ssoForbamboo);
                    this.initializeSAMLConfig();
                    this.addActionMessage(this.i18nResolver.getText("crowdsso.success.config"));
                    return "success";
                }
                this.initializeSAMLConfig();
                return "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "input";
            }
        }
        LOGGER.error((Object)"User does not have permission to access Crowd Configuration page");
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeSAMLConfig() {
        this.platform = this.i18nResolver.getText("my.plugin.platform");
        if (StringUtils.isNotEmpty((CharSequence)this.pluginConfigurationManager.getCrowdDomainURL())) {
            MoPluginConfigurationHandler.fetchUpdatedCrowdIDPConfig();
        }
        this.connectorssSSOConfig = this.pluginConfigurationManager.getConnectorSSOConfig();
        LOGGER.debug((Object)("Current Crowd SSO Config : " + this.connectorssSSOConfig.toString()));
        this.connectorssSSOConfigMap = MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(this.connectorssSSOConfig);
        this.crowdDomainURL = this.pluginConfigurationManager.getCrowdDomainURL();
    }

    public String getCrowdDomainURL() {
        return this.crowdDomainURL;
    }

    public void setCrowdDomainURL(String crowdDomainURL) {
        this.crowdDomainURL = crowdDomainURL;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getError() {
        return this.error;
    }

    public void setError(Boolean error) {
        this.error = error;
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public HashMap<String, String> getConnectorssSSOConfig() {
        return this.connectorssSSOConfig;
    }

    public void setConnectorssSSOConfig(HashMap<String, String> connectorssSSOConfig) {
        this.connectorssSSOConfig = connectorssSSOConfig;
    }

    public HashMap<String, MoCrowdConnectorSSOConfig> getConnectorssSSOConfigMap() {
        return this.connectorssSSOConfigMap;
    }

    public void setConnectorssSSOConfigMap(HashMap<String, MoCrowdConnectorSSOConfig> connectorssSSOConfigMap) {
        this.connectorssSSOConfigMap = connectorssSSOConfigMap;
    }

    public ArrayList<Boolean> getSsoForbamboo() {
        return this.ssoForbamboo;
    }

    public void setSsoForbamboo(ArrayList<Boolean> ssoForbamboo) {
        this.ssoForbamboo = ssoForbamboo;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }
}

