/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.lookandfeel;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class LookAndFeelConfiguration {
    private final boolean showLogo;
    private final String customLogoId;
    private final String header;
    private final String welcomeText;
    private final String primaryColor;

    public LookAndFeelConfiguration() {
        this.showLogo = false;
        this.customLogoId = null;
        this.header = null;
        this.welcomeText = null;
        this.primaryColor = null;
    }

    private LookAndFeelConfiguration(Builder builder) {
        this.showLogo = builder.showLogo;
        this.customLogoId = builder.customLogoId;
        this.header = builder.header;
        this.welcomeText = builder.welcomeText;
        this.primaryColor = builder.primaryColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LookAndFeelConfiguration lookAndFeelConfiguration) {
        return new Builder(lookAndFeelConfiguration);
    }

    public boolean isShowLogo() {
        return this.showLogo;
    }

    public String getCustomLogoId() {
        return this.customLogoId;
    }

    public String getHeader() {
        return this.header;
    }

    public String getWelcomeText() {
        return this.welcomeText;
    }

    public String getPrimaryColor() {
        return this.primaryColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookAndFeelConfiguration that = (LookAndFeelConfiguration)o;
        return Objects.equals(this.showLogo, that.showLogo) && Objects.equals(this.customLogoId, that.customLogoId) && Objects.equals(this.header, that.header) && Objects.equals(this.welcomeText, that.welcomeText) && Objects.equals(this.primaryColor, that.primaryColor);
    }

    public int hashCode() {
        return Objects.hash(this.showLogo, this.customLogoId, this.header, this.welcomeText, this.primaryColor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("showLogo", this.showLogo).add("customLogoId", this.customLogoId).add("header", this.header).add("welcomeText", this.welcomeText).add("primaryColor", this.primaryColor).toString();
    }

    public static final class Builder {
        private boolean showLogo;
        private String customLogoId;
        private String header;
        private String welcomeText;
        private String primaryColor;

        private Builder() {
        }

        private Builder(LookAndFeelConfiguration lookAndFeelConfiguration) {
            this.showLogo = lookAndFeelConfiguration.isShowLogo();
            this.customLogoId = lookAndFeelConfiguration.getCustomLogoId();
            this.header = lookAndFeelConfiguration.getHeader();
            this.welcomeText = lookAndFeelConfiguration.getWelcomeText();
            this.primaryColor = lookAndFeelConfiguration.getPrimaryColor();
        }

        public Builder setShowLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        public Builder setCustomLogoId(String customLogoId) {
            this.customLogoId = customLogoId;
            return this;
        }

        public Builder setHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder setWelcomeText(String welcomeText) {
            this.welcomeText = welcomeText;
            return this;
        }

        public Builder setPrimaryColor(String primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public LookAndFeelConfiguration build() {
            return new LookAndFeelConfiguration(this);
        }
    }
}

