/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.rest;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoVerifyDomainAPI
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoVerifyDomainAPI.class);
    private MoPluginConfigurationManager pluginConfigurationManager;
    private CrowdService crowdService;
    private DirectoryManager directoryManager;

    public MoVerifyDomainAPI(MoPluginConfigurationManager pluginConfigurationManager, CrowdService crowdService, DirectoryManager directoryManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            LOGGER.debug("verifying domain");
            String application = request.getParameter("application");
            String email = request.getParameter("email");
            LOGGER.debug("Submitted email :" + email + " and requested application : " + application);
            this.getIDPFromRedirectionRules(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("An exception occured while verifying the submitted domain : " + e.getMessage());
        }
    }

    public ArrayList<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    private void getIDPFromRedirectionRules(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String application = req.getParameter("application");
        String email = req.getParameter("email");
        ArrayList<String> userGroups = this.getAllGroupsOfUser(email);
        JSONArray rules = new JSONArray();
        rules = application.equals("jsd") ? this.pluginConfigurationManager.getRedirectionRules(application) : this.pluginConfigurationManager.getRedirectionRules("app");
        ArrayList<String> ssoEnabledIdpList = new ArrayList<String>();
        HashMap<String, MoCrowdConnectorSSOConfig> configMap = this.pluginConfigurationManager.getCrowdConnectorSSOConfigMap();
        for (String idpID : configMap.keySet()) {
            if (application.equals("jira") && configMap.get(idpID).getSsoForJIRASoftware().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                LOGGER.debug("Adding to list:" + idpID);
                continue;
            }
            if (application.equals("jsd") && configMap.get(idpID).getSsoForJSD().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (application.equals("confluence") && configMap.get(idpID).getSsoForConfluence().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (application.equals("bitbucket") && configMap.get(idpID).getSsoForBitbucket().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (application.equals("bamboo") && configMap.get(idpID).getSsoForbamboo().booleanValue()) {
                ssoEnabledIdpList.add(idpID);
                continue;
            }
            if (!application.equals("fisheye") || !configMap.get(idpID).getSsoForFisheye().booleanValue()) continue;
            ssoEnabledIdpList.add(idpID);
        }
        LOGGER.info("RulesLength:" + rules.length() + " Rules:" + rules.toString());
        String idpName = "";
        try {
            String conditionValue;
            String decisionFactor;
            JSONObject rule;
            for (int i = 0; !(i >= rules.length() || (ssoEnabledIdpList.contains(idpName = (String)(rule = rules.optJSONObject(i)).get("idp")) || idpName.equals("loginPage")) && this.checkRedirection(decisionFactor = (String)rule.getJSONObject("condition").get("decisionFactor"), conditionValue = (String)rule.getJSONObject("condition").getJSONObject(decisionFactor).get("equals"), email, userGroups).booleanValue()); ++i) {
                idpName = "";
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while checking redirection rules:", (Throwable)e);
        }
        JSONObject jsonResponse = new JSONObject();
        if (idpName.isEmpty()) {
            String value;
            String string = value = application.equals("jsd") ? this.pluginConfigurationManager.getDefaultJsdIDP() : this.pluginConfigurationManager.getDefaultAppIDP();
            if (!value.equals("redirectUrl") && !value.equals("loginPage") && ssoEnabledIdpList.contains(value)) {
                jsonResponse.put("defaultRule", value);
            } else if (value.equals("redirectUrl") || value.equals("loginPage")) {
                jsonResponse.put("defaultRule", value);
                if (value.equals("redirectUrl")) {
                    jsonResponse.put("RedirectURL", application.equals("jsd") ? this.pluginConfigurationManager.getJsdDefaultRedirectURL() : this.pluginConfigurationManager.getAppDefaultRedirectURL());
                }
            } else {
                jsonResponse.put("defaultRule", "");
            }
        }
        jsonResponse.put("idpId", idpName);
        jsonResponse.put("baseUrl", this.pluginConfigurationManager.getApplicationBaseUrl());
        jsonResponse.put("confluenceBaseUrl", this.pluginConfigurationManager.getBaseUrl());
        jsonResponse.put("fisheyeBaseUrl", this.pluginConfigurationManager.getApplicationBaseUrl());
        jsonResponse.put("bambooBaseUrl", this.pluginConfigurationManager.getApplicationBaseUrl());
        jsonResponse.put("jsdBaseUrl", this.pluginConfigurationManager.getJSDBaseUrl());
        jsonResponse.put("crowdDomainURL", this.pluginConfigurationManager.getCrowdDomainURL());
        jsonResponse.put("ssoPath", this.pluginConfigurationManager.getSSOPath());
        LOGGER.debug("FINAL Redirection Rules RESPONSE:" + jsonResponse.toString());
        this.sendSuccessFullResponse(jsonResponse.toString(), resp);
    }

    private Boolean checkRedirection(String decisionFactor, String conditionValue, String email, ArrayList<String> userGroups) {
        String domain = email.substring(email.indexOf("@") + 1);
        if (decisionFactor.equals("domain") && domain.equalsIgnoreCase(conditionValue)) {
            return true;
        }
        if (decisionFactor.equals("group") && userGroups.contains(conditionValue)) {
            LOGGER.debug("Group Matched:" + userGroups.contains(conditionValue));
            return true;
        }
        if (decisionFactor.equals("directory")) {
            try {
                User user = this.directoryManager.findUserByName(Long.valueOf(conditionValue).longValue(), email);
                if (user != null) {
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error("User Not found in this directory:", (Throwable)e);
            }
        }
        return false;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }
}

