/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.config.MoCrowdConnectorSSOConfig;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoCrowdRedirectionRulesAction
extends BambooActionSupport {
    private static Log LOGGER = LogFactory.getLog(MoCrowdRedirectionRulesAction.class);
    private String platform;
    private String ruleName;
    private String decisionFactor;
    private String conditionOperation;
    private String conditionValue;
    private String idp;
    private Boolean addRedirectionRuleSubmitted;
    private Boolean editRedirectionRuleSubmitted;
    private Map<String, String> redirectionRulesMap;
    private Map<String, String> jsdRedirectionRulesMap;
    private String defaultAppIDP;
    private String defaultJsdIDP;
    private String appDefaultURL;
    private String jsdDefaultURL;
    private Boolean error = Boolean.FALSE;
    private String xsrfToken;
    private Boolean showLoginPage;
    private Boolean allowLocalAuthentication;
    private MoPluginConfigurationHandler moPluginConfigurationHandler;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private I18nResolver i18nResolver;
    private DirectoryManager directoryManager;
    private UserManager userManager;

    public MoCrowdRedirectionRulesAction(I18nResolver i18nResolver, MoPluginConfigurationManager pluginConfigurationManager, DirectoryManager directoryManager, MoPluginConfigurationHandler moPluginConfigurationHandler, UserManager userManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.moPluginConfigurationHandler = moPluginConfigurationHandler;
        this.i18nResolver = i18nResolver;
        this.directoryManager = directoryManager;
        this.userManager = userManager;
    }

    public void doValidation() {
        this.error = Boolean.FALSE;
        UserProfile user = this.userManager.getRemoteUser();
        if (!this.userManager.isAdmin(user.getUserKey())) {
            this.addActionError(this.i18nResolver.getText("samlsso.error.config.admin.privilege"));
            this.error = Boolean.TRUE;
        }
        if (BooleanUtils.toBoolean((Boolean)this.addRedirectionRuleSubmitted) || BooleanUtils.toBoolean((Boolean)this.editRedirectionRuleSubmitted)) {
            if (StringUtils.isBlank((CharSequence)this.ruleName)) {
                this.addActionError(this.i18nResolver.getText("samlsso.error.empty.rule.name"));
                this.error = true;
            }
            Map<String, String> jiraRuleMap = this.pluginConfigurationManager.getAppRedirectionRulesMap();
            Map<String, String> jsdRuleMap = this.pluginConfigurationManager.getJSDRedirectionRulesMap();
            if ((jiraRuleMap.containsKey(this.ruleName) || jsdRuleMap.containsKey(this.ruleName)) && BooleanUtils.toBoolean((Boolean)this.addRedirectionRuleSubmitted)) {
                this.addActionError(this.i18nResolver.getText("samlsso.error.duplicate.rule.name"));
                this.error = true;
            }
            if (StringUtils.isBlank((CharSequence)this.conditionValue)) {
                this.error = true;
                switch (this.decisionFactor) {
                    case "domain": {
                        this.addActionError(this.i18nResolver.getText("samlsso.error.empty.domain"));
                        break;
                    }
                    case "directory": {
                        this.addActionError(this.i18nResolver.getText("samlsso.error.empty.directory"));
                        break;
                    }
                    case "group": {
                        this.addActionError(this.i18nResolver.getText("samlsso.error.empty.group"));
                        break;
                    }
                    default: {
                        this.addActionError(this.i18nResolver.getText("samlsso.error.unsuppported.decisionfactor"));
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.idp)) {
                this.addActionError(this.i18nResolver.getText("samlsso.error.empty.idp"));
                this.error = true;
            }
        }
    }

    public String execute() throws Exception {
        LOGGER.debug((Object)"BambooRedirectionRules execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        try {
            if (!this.pluginConfigurationManager.isLicenseValid().booleanValue()) {
                LOGGER.error((Object)"License is not verified");
                return "upm";
            }
            if (BooleanUtils.toBoolean((Boolean)this.addRedirectionRuleSubmitted) || BooleanUtils.toBoolean((Boolean)this.editRedirectionRuleSubmitted)) {
                this.doValidation();
                if (!this.error.booleanValue()) {
                    LOGGER.debug((Object)"CrowdRedirectionRulesConfigurationAction: configuration submited");
                    MoPluginConfigurationHandler.saveRedirectionRules(this.platform, this.ruleName, this.decisionFactor, this.conditionOperation, this.conditionValue, this.idp);
                    this.addActionMessage(this.i18nResolver.getText("samlsso.success.config"));
                }
            }
            this.initializeSAMLConfig();
            return "success";
        }
        catch (Exception e) {
            LOGGER.debug((Object)"An error occurred while saving redirection rules:", (Throwable)e);
            e.printStackTrace();
            this.initializeSAMLConfig();
            this.addActionError("An error occurred while saving redirection configuration. Please check logs for more info.");
            return "error";
        }
    }

    public void initializeSAMLConfig() {
        this.redirectionRulesMap = this.pluginConfigurationManager.getAppRedirectionRulesMap();
        this.jsdRedirectionRulesMap = this.pluginConfigurationManager.getJSDRedirectionRulesMap();
        this.defaultAppIDP = this.pluginConfigurationManager.getDefaultAppIDP();
        this.defaultJsdIDP = this.pluginConfigurationManager.getDefaultJsdIDP();
        this.appDefaultURL = this.pluginConfigurationManager.getAppDefaultRedirectURL();
        this.jsdDefaultURL = this.pluginConfigurationManager.getJsdDefaultRedirectURL();
        this.showLoginPage = this.pluginConfigurationManager.getShowLoginPage();
        this.allowLocalAuthentication = this.pluginConfigurationManager.getAllowLocalAuthentication();
        this.platform = this.i18nResolver.getText("my.plugin.platform");
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getDecisionFactor() {
        return this.decisionFactor;
    }

    public void setDecisionFactor(String decisionFactor) {
        this.decisionFactor = decisionFactor;
    }

    public String getConditionOperation() {
        return this.conditionOperation;
    }

    public void setConditionOperation(String conditionOperation) {
        this.conditionOperation = conditionOperation;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(String conditionValue) {
        this.conditionValue = conditionValue;
    }

    public String getIdp() {
        return this.idp;
    }

    public void setIdp(String idp) {
        this.idp = idp;
    }

    public Boolean getAddRedirectionRuleSubmitted() {
        return this.addRedirectionRuleSubmitted;
    }

    public void setAddRedirectionRuleSubmitted(Boolean addRedirectionRuleSubmitted) {
        this.addRedirectionRuleSubmitted = addRedirectionRuleSubmitted;
    }

    public Boolean getEditRedirectionRuleSubmitted() {
        return this.editRedirectionRuleSubmitted;
    }

    public void setEditRedirectionRuleSubmitted(Boolean editRedirectionRuleSubmitted) {
        this.editRedirectionRuleSubmitted = editRedirectionRuleSubmitted;
    }

    public Map<String, String> getRedirectionRulesMap() {
        return this.redirectionRulesMap;
    }

    public void setRedirectionRulesMap(Map<String, String> redirectionRulesMap) {
        this.redirectionRulesMap = redirectionRulesMap;
    }

    public Map<String, String> getJsdRedirectionRulesMap() {
        return this.jsdRedirectionRulesMap;
    }

    public void setJsdRedirectionRulesMap(Map<String, String> jsdRedirectionRulesMap) {
        this.jsdRedirectionRulesMap = jsdRedirectionRulesMap;
    }

    public String getDefaultAppIDP() {
        return this.defaultAppIDP;
    }

    public void setDefaultAppIDP(String defaultAppIDP) {
        this.defaultAppIDP = defaultAppIDP;
    }

    public String getDefaultJsdIDP() {
        return this.defaultJsdIDP;
    }

    public void setDefaultJsdIDP(String defaultJsdIDP) {
        this.defaultJsdIDP = defaultJsdIDP;
    }

    public String getAppDefaultURL() {
        return this.appDefaultURL;
    }

    public void setAppDefaultURL(String appDefaultURL) {
        this.appDefaultURL = appDefaultURL;
    }

    public String getJsdDefaultURL() {
        return this.jsdDefaultURL;
    }

    public void setJsdDefaultURL(String jsdDefaultURL) {
        this.jsdDefaultURL = jsdDefaultURL;
    }

    public List<Directory> getDirectoryList() {
        List directoryList = this.directoryManager.findAllDirectories();
        return directoryList;
    }

    public HashMap<String, MoCrowdConnectorSSOConfig> getConnectorssSSOConfig() {
        return MoPluginConfigurationHandler.initializeCrowdConnectorSSOConfig(this.pluginConfigurationManager.getConnectorSSOConfig());
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getShowLoginPage() {
        return this.showLoginPage;
    }

    public void setShowLoginPage(Boolean showLoginPage) {
        this.showLoginPage = showLoginPage;
    }

    public Boolean getAllowLocalAuthentication() {
        return this.allowLocalAuthentication;
    }

    public void setAllowLocalAuthentication(Boolean allowLocalAuthentication) {
        this.allowLocalAuthentication = allowLocalAuthentication;
    }
}

