<html>
<head>
    <title>SAML Redirection Configuration</title>
    <meta name="decorator" content="atl.general">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script>
        $(document).ready(function () {
            $(".aui-nav li").removeClass("aui-nav-selected");
            $("#mo-redirection").addClass("aui-nav-selected");
        });
      if (AJS.$("#autoRedirectToIDP").is(":checked")) {

                AJS.$("#bamboo_auto_redirect_delay").show();
        	} else {

                AJS.$("#bamboo_auto_redirect_delay").hide();
        	}
        	AJS.$(document).on('change','#autoRedirectToIDP',function(){
            		if(this.checked){

            	         AJS.$("#bamboo_auto_redirect_delay").show();
            	    }else{

            	         AJS.$("#bamboo_auto_redirect_delay").hide();
            	    }
            	});


    </script>

    <style>
        		.aui-page-panel-content{
    				padding: 0px !important;
    			}

    			.aui-page-panel{
    				margin: 0px !important;
    			}

    			.labelClass {
        			width: 275px !important;
        			margin-left: -286px !important;
    			}

    			.field-group{
    				margin: 10px 100px 1px 145px !important;
    			}

        	</style>

</head>
<body>
   <#include "*/header.ftl" parse=true>
<div class="tabs-pane active-pane" id="attribute-mapping" role="tabpanel" aria-hidden="true" style="padding-left: 10px; padding-top: 20px;">

    <form id="crowd-redirect-configuration-form" class="aui long-label" action="" method="POST">
        <input type="hidden" name="submitted" value="true"/>
        <input type="hidden" name="atl_token" value="${xsrfToken}" />
        <p style="font-size:13pt;">SSO Redirection </p>
        <hr class="header"/>

        <div class="field-group">
            <label for="ssoButtonText">Login Button Text:
                <span class="aui-icon icon-required">(required)</span>
            </label>
            <input type="text" required="true" id="ssoButtonText" name="ssoButtonText"
                   value="${ssoButtonText}" class="text long-field"/>
            <div class="description">Set button label for SSO button shown on login page. </div>
        </div>

        <div class="field-group" id="show-SSO-button-id">
             <label for="ssoLoginButton">Show SSO Button:</label>
            <span style="vertical-align:middle;">
                <label class="switch" style="vertical-align:middle;">
                    <input type="checkbox" id="showSSOButton" value="true" name="showSSOButton"
                           <#if showSSOButton == true> checked="true" </#if> >
                    <span id="showSSOButtonSlider" class="slider round"></span>
                </label>
            </span>
        </div>

        <div class="field-group" id="redirectToIdp">
            <label for="autoRedirectToIDP">Auto Redirect to IDP:</label>
            <span style="vertical-align:middle;">
                <label class="switch" style="vertical-align:middle;">
                        <input type="checkbox" id="autoRedirectToIDP" value="true" name="autoRedirectToIDP"
                               <#if autoRedirectToIDP == true> checked="true" </#if> >
                        <span id="autoRedirectSlider" class="slider round"></span>
                </label>
                <span style="height:16px; width: 16px">
                    <strong>Disable Bamboo's default login and auto Redirect to IdP for authentication</strong>
                </span>
                    </span>
        </div>

        <#if autoRedirectToIDP == true>
        <div class="field-group" id="bamboo_auto_redirect_delay">
        <#else>
        <div class="field-group" id="bamboo_auto_redirect_delay" style="display:none">
        </#if>
            <span style="vertical-align:middle;">
                <label class="switch" style="vertical-align:middle;">

                    <input type="checkbox" id="enableAutoRedirectDelay" value="true" name="enableAutoRedirectDelay"
                    <#if enableAutoRedirectDelay == true> checked="true" </#if> >
                    <span id="enableDelaySlider" class="slider round"></span>
                </label>
                <span style="height:16px; width: 16px">
                    <strong>Enable AutoRedirect Delay</strong>
                </span>
            </span>
            <div class="description">Introduce a delay on the login page before user is redirected to the IDP for
                authentication. This lets user go to login page if they don't want to get redirected. Recommended for testing Auto-redirect.
            </div>
        </div>
        <div class="field-group" id="bamboo_saml_backdoor">
                <label for="backdoorEnabled">Enable Backdoor Login:</label>
                    <span style="vertical-align:middle;">
                        <label class="switch" style="vertical-align:middle;">
                            <input type="checkbox" id="backdoorEnabled" value="true" name="backdoorEnabled"
                                <#if backdoorEnabled == true> checked="true" </#if> >
                            <span id="enableBackdoorSlider" class="slider round"></span>
                        </label>
                        <span style="height:16px; width: 16px">
                            <strong>Enable Backdoor Login </strong>
                        </span>
                    </span>
            </div>

            <div class="field-group"  id="bamboo_saml_backdoor_url">
                <table style="word-wrap: break-word; width: 800px">
                    <tr>
                        <td width="42%">
                            <b>Backdoor URL for Enduser</b>
                        </td>
                    </tr>
                    <tr>
                        <td width="42%">
                            <span>${pluginConfigurationManager.getApplicationBaseUrl()}/userlogin!doDefault.action?saml_sso=false</span>
                        </td>
                    </tr>
                    <br/>
                </table>
            </div>

        <p>
                    <p style="font-size:13pt;">Logout Redirection </p>
                    </a>
                </p>
        		<hr class="header" />
        		<div class="sign-out-settings-div" id="sign-out-settings-div">

        		   <#--  <div class="field-group" id="enableSingleLogoutURLDiv">
                        <label for="enableSingleLogoutURL">Enable Single Logout URL:</label>
                        <span style="vertical-align:middle;">
                            <label class="switch" style="vertical-align:middle;">
                            <#if $pluginConfigurationManager.getIsPremiumPlugin()>
                                    <input type="checkbox" id="enableSingleLogoutURL" value="true" name="enableSingleLogoutURL"
                                           <#if enableSingleLogoutURL == true> checked="true" </#if> >
                                    <span id="enableSingleLogoutURLSlider" class="slider round"></span>
                            <#else>
                                <input type="checkbox" id="enableSingleLogoutURL" value="true" name="enableSingleLogoutURL"
                                   disabled >
                                <span id="enableSingleLogoutURLSlider" class="slider round"></span>
                                <div class="description">This feature is available with Premium version of crowd saml plugin.</div>
                            </#if>
                            </label>
                    </div>-->

                    <div  class="field-group"  >
                       <label for="logoutUrl" class="labelClass">Custom Logout URL:</label>
                       <div>
                          <input type="url"  id="logoutUrl" name="logoutUrl" value="${logoutUrl}"
                             placeholder="Custom Logout URL" class="text long-field" <#if useLogoutTemplate == true> disabled="disabled" </#if> />
                          <div class="description">
                             Redirect to this URL after logging out (e.g. your IdP logout page). Leave empty to redirect on default bamboo login page.
                          </div>
                       </div>
                       <p style="font-size:13pt;">&nbsp;&nbsp;&nbsp;OR</p>
                       <br>
                       <div>
                        <label class="switch" style="vertical-align:middle;">

                          <input class="checkbox" type="checkbox"   name="useLogoutTemplate" value="true" id="useLogoutTemplate"
                            <#if useLogoutTemplate == true> checked="true" </#if> />
                           <span id="useLogoutTemplateSlider" class="slider round"></span>
        				   </label>
                           <span>Use Custom Logout Template</span>
                       </div>
        			  </div>
        				<div id="custom_logout_template" class="field-group" >

                          <legend><span>Custom Logout Template:</span></legend>
                            <#if useLogoutTemplate == true>
                                <textarea id="logoutTemplate"  name="logoutTemplate" class="textarea long-field" style="font-family:Courier New;" cols="64" rows="5">${logoutTemplate?html}</textarea>
                            <#else>
                                <textarea id="logoutTemplate"  name="logoutTemplate" class="textarea long-field" style="font-family:Courier New;" cols="64" rows="5"  disabled="disabled">${logoutTemplate?html}</textarea>
                            </#if>
                       <div class="description">Your IdP is not in the list? Click here
                          Define the Custom logout page. This template will be shown to the user when user logs out. <br>Enable Custom Logout template and use <b>$baseUrl</b> for login page.
                       </div>
                    </div>
        		 </div>


        <div class="field-group">
            <input type="Submit" value="Save" class="aui-button aui-button-primary" style="width:100px;"/>&nbsp;&nbsp;&nbsp;
        </div>

    </form>
   </div>
   <br>
    </div>
   </section>
  </div>
 </div>
   <#include "*/footer.ftl">
</body>
</html>