<html>
<head>
    <meta name="decorator" content="atl.general">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script>
        $(document).ready(function () {
            $(".aui-nav li").removeClass("aui-nav-selected");
            $("#mo-backup-and-restore").addClass("aui-nav-selected");
        });
    </script>
    <style>
        .aui-page-panel-content{
            padding: 0px !important;
        }

        .aui-page-panel{
            margin: 0px !important;
        }

        .labelClass {
            width: 275px !important;
            margin-left: -286px !important;
        }

        .field-group{
            margin: 10px 100px 1px 145px !important;
        }
    </style>
</head>
<body>
<#include "*/header.ftl" parse=true>
<div class="tabs-pane active-pane" id="attribute-mapping" role="tabpanel" aria-hidden="true" style="padding-left: 10px; padding-top: 20px;">
    <p style="font-size:13pt;">Backup And Restore</p>
    <hr class="header"/>
 <p>This tab will help you to transfer your app configurations when you change your
     instance;e.g. when you switch from test environment to production. Follow these 3 simple steps to do that:
    <ol>
        <li>Download app configuration file by clicking on the link given below.</li>
        <li>Install the app on new instance.</li>
        <li>Upload the configuration file in Import app Configurations section.</li>
    </ol>
    </p>
    <p> And just like that, all your app configurations will be transferred! </p>
    <p>You can also send us this file along with your support query.</p>

    <hr class="header"/>

    <p style="font-size:13pt;"><b>Export app Configurations</b></p><br>
    <#assign downloadconfigurationsUrl  = pluginConfigurationManager.getApplicationBaseUrl() + "/plugins/servlet/samlsso/downloadconfigurations">
    <a href=${downloadconfigurationsUrl}><b>Click Here</b></a> to download your app configurations file

    <hr class="header" />
    <p style="font-size: 13pt"><b>Import app Configurations</b></p>
    <#assign uploadJSONFile = pluginConfigurationManager.getApplicationBaseUrl() + "/plugins/servlet/samlsso/uploadconfiguration">
    <form id="importConfigurations" class="aui long-label" action="${uploadJSONFile}" method="post" enctype="multipart/form-data">
        <input type="hidden" name="atl_token" value="${xsrfToken}" />
        <input type="hidden" name="importFileSubmitted" value="true" />
        <table style="width:100%">
            <tr>
                <td width="20%">Choose File
                    <span style="color:red">*</span>: </td>
                <td>
                    <input type="file" id="configFile" name="configFile" class="ignore-inline-attach" accept=".json" required/></input> &nbsp; &nbsp;
                    <input type="submit" value="Import" class="aui-button aui-button-primary" />
                </td></tr>
            <tr><td width="20%"></td>
                <td>
                    <div class="description">Upload app_configurations.json file here</div>
                </td>

            </tr>
        </table>
    </form>

    <hr class="header"/>
    		<p style="font-size:12pt;"><b>2. Configure/Fetch app configuration via REST API.</b></p>
    		<div class="aui-message aui-message-info">
            <p><span>Note: The user must have administrator credentials to fetch the app configuration. To fetch app configuration, you need to use GET and to configure the app use POST.</p>
            <p>Use Basic Authentication and it will be base64 encoded.</p>
            </div>
            <div>
    		<table style=" width: 100%;">
    		<tbody>
    		<td style=" width: 39%;vertical-align: initial;">
    		<br>
                            <p style="font-size:12pt;">A. Download/Fetch App configuration</p><br>
    						<div style="margin-left: 35px;">
    							<strong>URL&emsp;&emsp;</strong> : ${pluginConfigurationManager.getApplicationBaseUrl()}/plugins/servlet/configureplugin  <br>
    							<strong>Method</strong> : GET<br>
    							<Strong>Request Parameters:</strong><br>
    								   <ul>
    									<strong>Headers</strong> :-
    									<div style="margin-left: 35px;">
    									<li>
    										Content-Type : application/json
    									</li>
    									<li>
    										Authorization Basic Authentication <base64 encoded admin_username:password>
    									</li>
    									</div>
    									</ul>
    								   <p>You will get JSON raw data in response. Copy and store raw data in the JSON file that you will need during the configuration.</p><br>
    		</td>
    		<td>
    		<div></div>
    		</td>
    		<td style=" width: 59%;vertical-align: initial;"><br>
    		<p style="font-size:12pt;">Sample Response</p>
    		<textarea rows = "12" class="textarea long-field" cols = "74" style="background-color: rgb(235, 236, 240);line-height:1.8; width:671px;" readonly>
{
    "Crowd Domain Url": "http://localhost:8095/crowd",
    "Auto Redirect To IDP": true,
    "SSO Button Text": "SSO Login",
    "Enable SSO": false,
    "JSD SSO Enable": false,
    "Enable Backdoor": false,
    "Enable Auto Redirect Delay": false,
    "Logout URL": "https://www.google.comj",
    "Use Error Template": false,
    "Error Template": ,
    "Use Login Template": true,
    "Login Template": "hello world",
    "Use Logout Template": false,
    "Logout Template": ,
    "Confluence SSO Enable": false,
    "Crowd IDP Config": "",
    "Configured SAML IDPS": {},
    "Redirection Parameter": "Domains",
    "Connector SSO Config": {"default_idp_id": "{\"idpId\":\"default_idp_id\",\"idpName\":\"Default IDP\",\"idpRedirectDomains\":[\"gmail.com\",\"miniorange.com\"],\"idpRedirectGroups\":[\"\"],\"ssoForJIRASoftware\":true,\"ssoForJSD\":true,\"ssoForConfluence\":true,\"ssoForFisheye\":true,\"ssoForBitbucket\":null,\"ssoForbamboo\":true}"}
}
</textarea>

</td>
</tbody>
</table>
						</div>

                         <p style="font-size:12pt;">B. Update App configuration</p><br>
							<div style="margin-left: 35px;">
                                <strong>URL&emsp;&emsp;</strong>    : ${pluginConfigurationManager.getApplicationBaseUrl()}/plugins/servlet/configureplugin<br>
								<strong>Method</strong> : POST<br>
                                <Strong>Request Parameters</strong> :<br>
                                  <ul>
								  <strong>Headers</strong> :-
								  <div style="margin-left: 35px;">
                                  <li>
                                     Content-Type : application/json
                                  </li>
                                  <li>
                                     Authorization : Basic Authentication <base64 encoded admin_username:password>
                                  </li>
								  </div>
                                  </ul>
                                <ul>
								<strong>Body</strong> :-
								<div style="margin-left: 35px;">
                                <li>
                                    The body content type should be in Raw format(application/json).
                                </li>
                                <li>
                                    Paste JSON raw data you receive in response to your GET request or download raw data from the link above in the Download app Configurations.
                                </li>
								</div>
                                </ul>
							</div>

</div>
</section>
</div>

</div>
</div>
</section>
</div>
</div>
<#include "*/footer.ftl">
</body>
</html>