(function($) {

var count = 0;
var useErrorTemplate;
var errorTemplate;
	var currentUrl = $(location).attr('href');
	if (currentUrl.match(/userlogin/i)) {
        test();
	}

    AJS.$(document).on('change', "#useLogoutTemplate", function(){
        if (this.checked){
            AJS.$("#logoutUrl").prop("disabled",true);
            AJS.$("#logoutTemplate").prop("disabled",false);
        } else{
            AJS.$("#logoutUrl").prop("disabled",false);
            AJS.$("#logoutTemplate").prop("disabled",true);
        }
    });

    AJS.$(document).on('change', "#useErrorTemplate", function(){
        if (this.checked){
            AJS.$("#errorTemplate").prop("disabled",false);
        } else{
            AJS.$("#errorTemplate").prop("disabled",true);
        }
    });

    AJS.$(document).on('change', "#useLoginTemplate", function(){
        if (this.checked){
            AJS.$("#loginTemplate").prop("disabled",false);
        } else{
            AJS.$("#loginTemplate").prop("disabled",true);
        }
    });

    function test() {
		count++;
		if ($("#loginForm").length > 0) {
			loadLoginForm($("#loginForm"));
		} else {
			var url = window.location.href;
			if (url.match(/userlogin/i) && count <= 50) {
				setTimeout(loadLoginForm, 100);
			}
		}
	}

    AJS.$(document).on('change', "#redirectionParameter", function() {
	    if(AJS.$("#redirectionParameter").val() == "Domains"){
	        AJS.$(".domain-mapping").show();
	        AJS.$(".group-mapping").hide();
	    }else{
	        AJS.$(".domain-mapping").hide();
	        AJS.$(".group-mapping").show();
	    }
	});

    function loadLoginForm() {
        count++;
        loginForm=AJS.$("#loginForm");
        AJS.$("#loginForm").hide();

        if(ReadCookie("samlsso_idp.key")!= "" && ReadCookie("SAMLCOOKIE")!=""){

            AJS.$
                .ajax({
                    url: AJS.contextPath()
                        + "/plugins/servlet/samlsso/getconfig",
                    type: "GET",
                    error: function () {
                        console
                            .log("Get configiration response status : ERROR");
                        loginForm.hidden = false;
                        return;
                    },
                    success: function (response) {
                        useErrorTemplate = response.useErrorTemplate;
                        errorTemplate = response.errorTemplate;
                        loginForm.hidden = true;
                        console.log("\n\n\nInside this function :- " + useErrorTemplate);

                        console.log("errorTemplate = " + errorTemplate);
                        var htmlerror = useErrorTemplate ? errorTemplate : '<div id="sso_failed_error" class="aui-message aui-message-error closeable"><p>We couldn\'t sign you in. Please contact your Administrator or <a href="'+response.baseUrl+'" >click here </a> to try again. </p></div>';
                        AJS.$(htmlerror).remove();
                        AJS.$(htmlerror).insertBefore(loginForm);
                        deleteCookie("samlsso_idp.key");
                        return;
                    }
                });
            return;
        }

        $.ajax({
            url : AJS.contextPath() + "/plugins/servlet/samlsso/getconfig",
            type : "GET",
            async : false,
            error : function() {
            },
            success : function(response)
            {
                useErrorTemplate = response.useErrorTemplate;
                errorTemplate = response.errorTemplate;
                if (response.configured === true && Object.entries(response.idpsForbamboo).length != 0) {

                    if (response.backdoorEnabled === true&& verifyBackdoorParameter()) {

                        AJS.$("#loginForm").show();
                        return;
                    }
                    var pathname = window.location.pathname;
                    if (response.domainMappingForbamboo && !getCurrentUserName() && !verifyBackdoorParameter() && !response.showLoginPage && getQueryParameterByName('os_destination') != "notAuthorized") {
                        // TODO check for domain mapping
                        showDomainMappingForm(loginForm,response);
                        return;
                    } else if (response.autoRedirectToIDP === true){

                          if(Object.entries(response.idpsForbamboo).length === 1) {

                       // TODO Check for auto-redirect
                       // delay
                               if (response.enableAutoRedirectDelay === false) redirectToIDP(response);
                               else insertDelay(loginForm,response);
                               AJS.$("#loginForm").show();
                           }else{
                               AJS.$("#loginForm").hide();
                               renderSSOLinkOnly(loginForm,response);
                          }
                          return;

                    } else if (response.defaultRedirectRule !="loginPage" && response.defaultRedirectRule !="redirectUrl" && !getCurrentUserName() && !response.showLoginPage) {

                           var samlSSOURL = generateRedirectURL(response);
                           var idpId = response.defaultRedirectRule;
                           if (samlSSOURL.indexOf("return_to") > 0) {
                               samlSSOURL = samlSSOURL + '&idp=' + idpId;
                           } else {
                               samlSSOURL = samlSSOURL + '?idp=' + idpId;
                           }
                           window.location.href = samlSSOURL;

                       return;

                    } else if (response.useLoginTemplate === true && getQueryParameterByName("show_login_form")!=="true" && response.defaultRedirectRule === "loginPage" && !(pathname == "/userlogin!doDefault.action" && getQueryParameterByName('os_destination') == "notAuthorized")){
                             console.log("show Custom login form");
                             renderCustomLoginForm(loginForm,response);
                             return;
                    }else if(response.defaultRedirectRule ==="redirectUrl" && !verifyBackdoorParameter() && !getCurrentUserName() && !response.showLoginPage){
                         window.location.href = response.defaultRedirectURL;
                    }else {
                        renderLoginPage(loginForm,response);
                        AJS.$("#loginForm").show();
                        return;
                    }
                    //loginForm.hidden = false;
                    //  renderLoginPage(response,loginForm);
                }else {

                    AJS.$("#loginForm").show();
                    return;
                }

            }
        });

    }

    function renderLoginPage(loginForm,response) {
        var dropdownHtml;
        var ssoLink;
        var idpId="";

        var samlSSOURL = generateRedirectURL(response);

         if(getQueryParameterByName('os_destination') === "notAuthorized"){
            var errorMsg = '<div id="sso_failed_error" class="aui-message aui-message-error closeable"><p>You are not authorized to login. Please contact your administrator for more details.</p></div>';
            var element = document.getElementsByClassName("aui").loginForm.childNodes[1];
            AJS.$(errorMsg).insertBefore(element);

        }

        var idpId = ReadCookie("samlsso_idp.key");
        if (Object.entries(response.idpsForbamboo).length > 1 && (idpId ==="" || !getCurrentUserName()) && response.showSSOButton) {
            ssoLink = generateMultipleIDPButtons(response, samlSSOURL, idpId);
            AJS.$(ssoLink).insertAfter(AJS.$("#loginForm"));
        }else{
            if(idpId===""){
                idpId = Object.keys(response.idpsForbamboo)[0]
            }

            if (samlSSOURL.indexOf("return_to") > 0) {
                samlSSOURL = samlSSOURL + '&idp=' + idpId;
            } else {
                samlSSOURL = samlSSOURL + '?return_to=' + response.baseUrl;
                samlSSOURL = samlSSOURL + '&idp=' + idpId;
            }

            if(idpId ==="default_idp_id"){
                createCookie("samlsso_idp.key",idpId);
            }
            var html = '<a class="aui-button aui-style aui-button-primary" href="' + samlSSOURL + '" style="align:center;">' + response.ssoButtonText + '</a>';
            var samlerror=getQueryParameterByName("samlerror");

           if(response.showSSOButton)
           {
               if (AJS.$("#loginForm_save")) {
                  console.log("Adding sso button after login button.");
                  loginForm.show();
                  AJS.$(html).insertAfter(AJS.$("#loginForm_save"));
               }
           }

            if(samlerror!=null){
                var htmlerror = (useErrorTemplate === false) ? '<div class="aui-message aui-message-error closeable"><p>We couldn\'t sign you in. Please contact your Administrator. </p></div>' : errorTemplate;
                AJS.$(htmlerror).insertBefore(AJS.$("div[id='fieldArea_loginForm_os_username']"));
            }
        }

    }

    function renderCustomLoginForm(loginForm, response) {
        AJS.$('body').hide();
        var html = '<div>' + response.loginTemplate + '</div>';
        AJS.$("body").html(html);
        AJS.$('body').show();
    }

    function generateMultipleIDPButtons(response, samlSSOURL, tempIdpID) {
        var ssoLink;
        if(tempIdpID===""){
            tempIdpID = Object.keys(response.idpsForbamboo)[0]
        }

        ssoLink += '<hr><div id="mo_sso_form"><h2 style="text-align:center" >Sign in with your other account</h2></div>'
                + '<div id="oauth_application_list" class="buttons-container"><br><div style="margin-left: 14%;">';

        if(tempIdpID ==="default_idp_id"){
            createCookie("samlsso_idp.key",tempIdpID);
        }

        for ( var idpId in response.idpsForbamboo) {
            idpName = (response.idpsForbamboo)[idpId];
            var idpSSOURL;
            if (samlSSOURL.indexOf("return_to") > 0) {
                ssoLink += '<a class="aui-button aui-style aui-button-primary" name ="samlSSOButton" id="samlSSOButton" href="'+ samlSSOURL + '&idp='
                        + encodeURIComponent(idpId)+ '" style="align:center;width: 250px;margin-bottom: 8px;margin-top: 2px;margin-left: 15%;text-align: center;">' + idpName + '</a><br>';
            } else {
                ssoLink += '<a class="aui-button aui-style aui-button-primary" name ="samlSSOButton" id="samlSSOButton" href="'+ samlSSOURL+ '?idp='
                        + encodeURIComponent(idpId)+ '" style="align:center;width: 250px;margin-bottom: 8px;margin-top: 2px;margin-left: 15%;text-align: center;">'+ idpName + '</a><br>';
            }
        }

        ssoLink += '</div></div>';

        return ssoLink
    }

    function renderSSOLinkOnly(loginForm, response) {
        var samlSSOURL = generateRedirectURL(response);
        var ssoLink = "";
        var idpId = ReadCookie("samlsso_idp.key");

        ssoLink += generateMultipleIDPButtons(response, samlSSOURL, idpId);
        AJS.$(ssoLink).insertAfter(AJS.$(loginForm));
    }

    function verifyBackdoorParameter() {
        var backdoorValue = getQueryParameterByName("saml_sso");

        if (backdoorValue && backdoorValue === "false") {
            return true;
        }
        return false;
    }
    function redirectToIDP(response) {

        samlSSOURL = generateRedirectURL(response);

        var idpId = ReadCookie("samlsso_idp.key");


        if(idpId===""){
            idpId = Object.keys(response.idpsForbamboo)[0]
        }
        if (samlSSOURL.indexOf("return_to") > 0) {
            samlSSOURL = samlSSOURL + '&idp=' + encodeURIComponent(idpId);
        } else {
            samlSSOURL = samlSSOURL + '?idp=' + encodeURIComponent(idpId);
        }

        if(idpId ==="default_idp_id"){
            createCookie("samlsso_idp.key",idpId);
        }
        window.onbeforeunload = null;
        window.location.href = samlSSOURL;
    }

    function insertDelay(loginForm, response) {

        var samlSSOURL =generateRedirectURL(response);

        var idpId = ReadCookie("samlsso_idp.key");

        if(idpId===""){
            idpId = Object.keys(response.idpsForbamboo)[0]
        }
        if (samlSSOURL.indexOf("return_to") > 0) {
            samlSSOURL = samlSSOURL + '&idp=' + encodeURIComponent(idpId);
        } else {
            samlSSOURL = samlSSOURL + '?idp=' + encodeURIComponent(idpId);
        }

        var textOnCancel = '<a href="' + samlSSOURL + '" id="redirectMessage" class="aui-button  aui-button-link">'
        + response.ssoButtonText + '</a>';
        /** Create the delay box on the login page */
        var html = '<div id="moRedirectBox" class="aui-message aui-message-info">' + '<ssoDIV>'
        + '<span id="defaultText">Redirecting to IDP.</span>' + '<span id="textOnCancel" style="display:none;">'
        + textOnCancel + '</span>'
        + '<button id="stopAutoRedirect" class="aui-button aui-button-primary" style="float:right;"'
        + 'resolved="" onClick="stopAutoRedirect()">Cancel</button>' + '</ssoDIV>'
        + '<input type="hidden" id="samlSSOURL" value="' + samlSSOURL + '"></input>'
        + '<div id="moRedirectProgress" class="aui-progress-indicator" style="margin-top: 1.5em;'
        + 'background: #e9e9e9;border-radius: 3px;height: 5px;overflow: hidden;position: relative;'
        + 'width: 100%;" data-value="0.01">'
        + '<span class="aui-progress-indicator-value" style="position: absolute;display: block;'
        + 'height: 5px;animation: progressSlide 1s infinite linear;animation-play-state: running;'
        + '-webkit-animation-play-state: paused;animation-play-state: paused;background: #3572b0;'
        + 'border-radius: 3px 0 0 3px;transition: width .5s;-webkit-transform: skewX(0);'
        + 'transform: skewX(0);width:0%"></span>'
        + '</div>'
        + '</div>'
        + '<script>'
        + 'var delayFunc;'
        + 'var progress = 0.005;'
        /**
        * Function is used to stop the Auto redirect and show a
        * link to redirect the user to the IDP for
        * authentication.
        */
        + 'function stopAutoRedirect(){'
        + 'clearTimeout(delayFunc);'
        + 'AJS.$("#moRedirectProgress").remove();'
        + 'AJS.$("#defaultText").remove();'
        + 'AJS.$("#stopAutoRedirect").remove();'
        + 'AJS.$("#textOnCancel").css("display","block");'
        + '}'
        /**
        * Function is used to update the progressBar added to
        * the login page if admin has set a delay for the
        * auto-redirect. If the progress bar reaches 100% then
        * redirect the user to the IDP.
        */
        + 'function updateProgressBar(){'
        + 'if(progress<0.995){'
        + 'progress = progress+0.005;'
        + 'var percentage = progress*100+"%";'
        + 'AJS.$("#moRedirectProgress").attr("data-value",progress);'
        + 'AJS.$(".aui-progress-indicator-value").css("width",percentage);'
        + 'delayFunc = setTimeout(function(){ updateProgressBar(); } , 25 );'
        + '}else{'
        + 'progress=0.1;'
        + 'var url = AJS.$("#samlSSOURL").val();'
        + 'var currentUrl = window.location.href.split("'
        + '?'
        + '")[0];' + 'console.log(currentUrl);'
        + 'window.location.href = url;'
        + '}' + '}' + 'updateProgressBar();' + '</script>';

        AJS.$("#gadget-0").css("height","355px");
        AJS.$(html).insertAfter(loginForm);
    }
    function getQueryParameterByName(name) {
        var url = window.location.href;
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"), results = regex
            .exec(url);
        if (!results)
            return null;
        if (!results[2])
            return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }
    function showDomainMappingForm(loginForm, response) {

        AJS.$("#loginForm").show();
        var notFoundHtml = useErrorTemplate ?  errorTemplate : '<div id=\\"idp_not_found_error\\" class=\\"aui-message aui-message-error closeable\\"><p>Sorry. We couldn\'t find your IdP. Please login with Bamboo credentials or choose your IdP </p></div>';

        var formInstruction;
        var userInputLabel;

        formInstruction = "Please submit your username to get redirected to IDP";
        userInputLabel = '<label accesskey="e" for="login-form-email" id="emaillabel" style="display: block;"><u>U</u>sername</label>';

        var html = '<div id="domain_mapping_note" class="aui-message aui-message-info">' + formInstruction + '</div>'
                + '<form id="domain-mapping-form" method="post" action="" name="domain-mapping-form" class="aui gdt">'
                + '<div class="field-group">' + userInputLabel
                + '<input class="text medium-field" id="login-form-email" name="os_email" type="text"/>'
                + '</div>'
                + '<div class="buttons-container" style="margin-left:0;margin-top: 0%;border: none;">';
            html+='<div class="buttons" style="margin-top: 0%;">';
            html+= '<button id="domain-mapping-login" class="aui aui-button aui-button-primary">Submit</button>'
                + '</div>' + '</div>' + '</form>';

            AJS.$(loginForm).hide();
            AJS.$(html).insertAfter(AJS.$(loginForm));
        if(response.autoRedirectToIDP===true){
            AJS.$("#back-to-login-form").remove();
        }
    }

    /* START Back to login form */
    AJS.$(document).on('click', "#back-to-login-form", function() {
        AJS.$("#domain_mapping_note").remove();
        AJS.$("#domain-mapping-form").remove();
        AJS.$("#idp_not_found_error").remove();
        AJS.$("#back-to-domain-form").remove();
        AJS.$(loginForm).show();
    });

    AJS.$(document).on('click', "#back-to-domain-form", function() {
        renderLoginPage();
    });
              /* END */

    /* START Process Domain Mapping */
    AJS.$(document).on('click', "#domain-mapping-login", function(e) {
        processDomainAndRedirect();
        e.preventDefault();
    });


    function processDomainAndRedirect() {
        var loginForm;
        loginForm=AJS.$("#loginForm");
        var email = AJS.$("#login-form-email").val();

        AJS.$
        .ajax({
            url : AJS.contextPath() + "/plugins/servlet/samlsso/verifydomain",
            data : {
                "email" : email,
                "application":"bamboo",
            },
            type : "GET",
            error : function() {
                notFoundHtml = useErrorTemplate ?  errorTemplate : '<div id="idp_not_found_error" class=\"aui-message aui-message-error closeable\"><p>Sorry. We couldn\'t find your IdP. Please login with Bamboo credentials or choose your IdP </p></div>';
                if (!AJS.$("#idp_not_found_error").length)
                    AJS.$(notFoundHtml).insertBefore(AJS.$("#domain-mapping-form"));
            },
            success : function(response) {
                var idpID = response.idpId;
                if (response.idpId) {
                    if(idpID==="loginPage"){
                        AJS.$("#domain_mapping_note").hide();
                        AJS.$("#domain-mapping-form").hide();
                        AJS.$("#loginForm").show();
                        AJS.$("#loginForm_os_username").val(email);
                        return;
                    }
                }else{
                     if(response.defaultRule ==="redirectUrl"){
                         window.location.href = response.RedirectURL;
                         return;
                     }else if(response.defaultRule ==="loginPage"){
                         AJS.$("#domain_mapping_note").hide();
                         AJS.$("#domain-mapping-form").hide();
                         AJS.$("#loginForm_os_username").val(email);
                         AJS.$("#loginForm").show();
                         return;
                     }
                     else idpID = response.defaultRule;
                }
                    if(idpID!=""){
                        var samlSSOURL= generateRedirectURL(response);
                        if (samlSSOURL.indexOf("return_to") > 0) {
                            samlSSOURL = samlSSOURL + '&idp=' + idpID;
                        } else {
                            samlSSOURL = samlSSOURL + '?idp=' + idpID;
                        }
                        //createCookie("saml_idp.key",response.idpId);
                        window.onbeforeunload = null;
                        window.location.href = samlSSOURL;
                        return;
                    }else{
                        AJS.$("#domain_mapping_note").hide();
                        AJS.$("#domain-mapping-form").hide();
                        AJS.$("#loginForm").show();
                        return;
                    }
                }
        });
    }

    function getCurrentUserName() {
        return AJS.params.remoteUser;
    }

    function generateRedirectURL(response) {
        var osDestination = getQueryParameterByName("os_destination");
        /* Crowd SAML Plugin's SSO endpoint */
        if(osDestination==null)
        {
            if (window.location.href.indexOf("/userlogin") > 0){
                osDestination=response.baseUrl;
            }
            else{
                osDestination= window.location.href;
            }
        }else{
            var pattern = /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;
            if (!pattern.test(osDestination)) {
                osDestination = response.baseUrl+osDestination;
            }
        }

        var samlSSOUrl = response.crowdDomainURL + '/plugins/servlet/saml/auth';

        if (!(!osDestination || /^\s*$/.test(osDestination)) && osDestination != "/") {
            samlSSOUrl += "?return_to=" + encodeURIComponent(osDestination);
        }

        if(samlSSOUrl.indexOf("return_to") < 0){
            samlSSOUrl += "?return_to=" + encodeURIComponent(response.baseUrl);
        }
        return samlSSOUrl;
    }

    function ReadCookie(cname) {
        var name = cname + "=";
        var decodedCookie = document.cookie;
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }


    /* TODO create new cookies */
    function createCookie(key, value) {
        var d = new Date();
        d.setTime(d.getTime() + (7 * 24 * 60 * 60 * 1000));
        var expires = "expires=" + d.toUTCString();
        document.cookie = key + "=" + value + ";" + expires + "path=/";
    }

    function deleteCookie(name) {
        document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:01 GMT;path=/;';
    };


})(AJS.$ || jQuery);