/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.servlet.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoHttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoHttpUtils.class);

    public static String sendGetRequest(String url) {
        try {
            LOGGER.debug("MoHttpUtils sendGetRequest Sending GET request to " + url);
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String data = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                httpClient.close();
                return data;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public static String sendPostRequest(String url, List<NameValuePair> data, String contentType, HashMap headers) {
        try {
            LOGGER.debug("HttpUtils sendPostRequest Sending POST request to " + url + " with payload " + data);
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            LOGGER.debug("httpClient : " + httpClient);
            LOGGER.debug("Hitting URL : " + url);
            HttpPost postRequest = new HttpPost(url);
            LOGGER.debug("Post Request : " + postRequest.toString());
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data);
            entity.setContentType(contentType);
            postRequest.setEntity((HttpEntity)entity);
            LOGGER.debug("Executing post request : " + postRequest.toString());
            return MoHttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            LOGGER.debug("Error in sending post request, " + e.toString());
            e.printStackTrace();
            return "Failed";
        }
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                LOGGER.debug("Response Entity found. Reading Response payload.");
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                LOGGER.debug("Response payload: " + status);
                httpClient.close();
                LOGGER.debug("Status" + status);
                return status;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.debug("Error in executing post request, " + e.toString());
            e.printStackTrace();
            return "Failed";
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        LOGGER.debug("Text before sanitization: " + text);
        text = Jsoup.clean(text, Safelist.basic());
        LOGGER.debug("Text after sanitization: " + text);
        return text;
    }

    public static boolean isCookieSet(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return true;
            }
        }
        return false;
    }
}

